# PowerShell script to send an alert email to every node warning them that
# the global authorizations table has changed.

# Before running this script, run the following PowerShell script to
# encrypt the logistic node administrator's password:

# Read-Host -AsSecureString | ConvertFrom-SecureString | Out-File -FilePath
# "C:\Users\logisticsrootname\Documents\PSCredential\credtext.txt"

# ----------------------------------------------------------------------

[CmdletBinding()] param(
     [Parameter(Position = 0)]
     [string]$RootEmailAddress,

     [Parameter(Position = 1)]
     [string]$AttachFileName
)
$EmailFrom = "logistics root's email address"
                
$ToRecipients = "$RootEmailAddress"
            
$EmailSubject = "Wildlife crime confederation alert" 
$EmailBody = "Global authorizations have changed, please update" +
" by running the attached SQL script." 
                
$SMTPserver= "SMTP server"

$EncryptedPasswordFile = "$home\Documents\PSCredential\credtext.txt"
$username="logisticsrootname" 
$password = Get-Content -Path $EncryptedPasswordFile | ConvertTo-SecureString
$credential =
New-Object System.Management.Automation.PSCredential($username, $password)

Send-MailMessage -ErrorAction Stop -from "$EmailFrom" -to $ToRecipients
-subject "$EmailSubject" -body "$EmailBody" -SmtpServer "$SMTPserver"
-Attachments "$AttachFileName" -Priority  "Normal"
-Credential $credential -Port 587 -UseSsl
