﻿use members;

/* Test of InsGen_() procedure. */

drop table if exists testtable;
create table testtable (
member int(20), prvlge varchar(20)
);

insert into testtable (member,prvlge) values
(5, 'select'),
(21, 'update'),
(5, 'delete');

DELIMITER $$

DROP PROCEDURE IF EXISTS InsGen_ $$
CREATE PROCEDURE InsGen_(in_db varchar(20),in_table varchar(20))
BEGIN

declare Whrs varchar(500);
declare Sels varchar(500);
declare Inserts varchar(2000);
declare tablename varchar(20);

set tablename=in_table;

# First, delete all rows in table.

select concat("delete all rows from ",in_table) as '';

# Comma separated column names - used for Select

select group_concat(
concat('concat(\'"\',','ifnull(',column_name,','''')',',\'"\')'))
INTO @Sels from information_schema.columns where table_schema=in_db and
table_name=tablename;

# Comma separated column names - used for Group By

select group_concat('`',column_name,'`') INTO @Whrs
from information_schema.columns where table_schema=in_db and
table_name=tablename;

#Main Select Statement for fetching comma separated table values

set @Inserts=concat("select concat('insert into ", in_db,".",tablename,"
values(',concat_ws(',',",@Sels,"),');') from ", in_db,".",tablename,"
group by ",@Whrs,";");

PREPARE Inserts FROM @Inserts;
EXECUTE Inserts;

END $$

DELIMITER ;

call InsGen_('members', 'testtable');
