/* Define the political-ecological database.

   SQL language notes:

   1. Derby does not have a "drop database"
   command so to replace an existing database, you need to remove its
   directory with the command-line command:
       rmdir /s /q polecol
   
   2. "load data" is a MySQL command that Derby does not recognize.
      Instead, one could use "call syscs_util.syscal_import_table"

   3. SQL Server uses "identity(1,1)" whereas MySQL uses "auto_increment"

   4. SQL Server has no "engine=InnoDB"

   Strategy:
 
   1. Have Storyparse write files of everything needed to build the
      database.

   2. This method will read these files and build the database and/or
      execute queries against it.

   Definitions of database tables:

   1. Storyutils.findactpttrn_() searches within a sentence for
      a matching combination of m-word verb, direct object phrase, and
      (optionally) a prepositional phrase.  Hence, each such n-gram will
      be attached to a particular sentence.  But findactpttrn_() is called
      twice because there may be more than one action in a sentence.
      Hence, there is a many-to-many relationship between sentences and
      noun phrases.  A junction table is needed.  This applies to m-word
      verbs, direct object phrases, and prepositional phrases.
   
   2. Noun phrases refer to archetypal actors and targets.

   3. If an m-word verb does not match any EMAT m-word verb,
      assign it to ematvrbid=1 which is the EMAT m-word verb "no_match".
      This applies to direct object phrases, and prepositional phrases also.

/* ---------------- EMAT definitions tables. ------------------ */

DROP DATABASE IF EXISTS pedb;
CREATE DATABASE pedb;
USE pedb;

create table emat (
   ematid varchar(10) not null primary key,
   action varchar(80)
-- );
) engine=InnoDB;

create table ematvrb (
   vrbuid int not null auto_increment primary key,
   ematid varchar(10) not null,
   ematvrbid int not null,
   ematvrb varchar(80),
   foreign key (ematid) references emat (ematid) on delete cascade
-- );
) engine=InnoDB;

create table ematvrbemat (
   ematid varchar(10) not null,
   vrbuid int not null,
   constraint ematvrbemat_pk primary key (ematid, vrbuid),
   foreign key (ematid) references emat (ematid) on delete no action,
   foreign key (vrbuid) references ematvrb (vrbuid) on delete cascade
-- );
) engine=InnoDB;

create table ematdoph (
   dophuid int not null auto_increment primary key,
   ematid varchar(10) not null,
   ematdophid int not null,
   ematdoph varchar(80),
   foreign key (ematid) references emat (ematid) on delete cascade
-- );
) engine=InnoDB;

create table ematdophemat (
   ematid varchar(10) not null,
   dophuid int not null,
   constraint ematdophemat_pk primary key (ematid, dophuid),
   foreign key (ematid) references emat (ematid) on delete no action,
   foreign key (dophuid) references ematdoph (dophuid) on delete cascade
-- );
) engine=InnoDB;

create table ematpph (
   pphuid int not null auto_increment primary key,
   ematid varchar(10) not null,
   ematpphid int not null,
   ematpph varchar(80),
   foreign key (ematid) references emat (ematid) on delete cascade
-- );
) engine=InnoDB;

create table ematpphemat (
   ematid varchar(10) not null, pphuid int not null,
   constraint ematpphemat_pk primary key (ematid, pphuid),
   foreign key (ematid) references emat (ematid) on delete no action,
   foreign key (pphuid) references ematpph (pphuid) on delete cascade
-- );
) engine=InnoDB;

/* ---------------- Observed actions tables. -------------------- */
 
create table story (
   storyid int not null auto_increment primary key,
   storydate float not null,
   source varchar(40),
   country varchar(40) not null
-- );
) engine=InnoDB;

create table sen (
   storyid integer not null,
   senid int not null auto_increment primary key,
   foreign key (storyid) references story (storyid) on delete cascade
-- );
) engine=InnoDB;

create table nph (
   nphid int not null auto_increment primary key,
   nph varchar(10)
-- );
) engine=InnoDB;

create table nphsen (
   nphid int not null,
   senid int not null,
   constraint nphsen_pk primary key (nphid, senid),
   foreign key (nphid) references nph (nphid) on delete no action,
   foreign key (senid) references sen (senid) on delete cascade
-- );
) engine=InnoDB;

create table mwvrb (
   senvrbid int not null auto_increment primary key,
   vrbuid int not null default 1,
   ematvrbid int not null default 1,
   mwvrb varchar(10),
   foreign key (vrbuid) references ematvrb (vrbuid) on delete cascade
-- );
) engine=InnoDB;

create table mwvrbsen (
   senvrbid int not null,
   senid int not null,
   constraint mwvrbsen_pk primary key (senvrbid, senid),
   foreign key (senvrbid) references mwvrb (senvrbid) on delete no action,
   foreign key (senid) references sen (senid) on delete cascade
-- );
) engine=InnoDB;

create table doph (
   sendophid int not null auto_increment primary key,
   dophuid int not null default 1,
   ematdophid int not null default 1,
   doph varchar(10),
   foreign key (dophuid) references ematdoph (dophuid) on delete cascade
-- );
) engine=InnoDB;

create table dophsen (
   sendophid int not null,
   senid int not null,
   constraint dophsen_pk primary key (sendophid, senid),
   foreign key (sendophid) references doph (sendophid) on delete no action,
   foreign key (senid) references sen (senid) on delete cascade
-- );
) engine=InnoDB;

create table pph (
senpphid int not null auto_increment primary key,
   pphuid int not null default 1,
   ematpphid int not null default 1,
   pph varchar(10),
   foreign key (pphuid) references ematpph (pphuid) on delete cascade
-- );
) engine=InnoDB;

create table pphsen (
   senpphid int not null,
   senid int not null,
   constraint pphsen_pk primary key (senpphid, senid),
   foreign key (senpphid) references pph (senpphid) on delete no action,
   foreign key (senid) references sen (senid) on delete cascade
-- );
) engine=InnoDB;

create table ecodatref (
   senid int not null,
   ematid varchar(10) not null,
   constraint ecodatref_pk primary key (ematid, senid),
   foreign key (ematid) references emat (ematid) on delete no action,
   foreign key (senid) references sen (senid) on delete cascade
-- );
) engine=InnoDB;
