/* Create on the logistics node, the database of confederation member
   authorizations to the confederation's federated intelligence database.
   Note that confederation members are granted privileges in this database
   although members would not need to access this database for any reason.
   Rather, making members "users" of this database allows other GLAD
   maintenance SQL Scripts to modify them as required by confederation
   database nodes. */

DROP DATABASE IF EXISTS members;
CREATE DATABASE members;
USE members;

create table if not exists member_information (
   memberID bigint unsigned not null default 0,
   name     varchar(18) not null default 'no name',
   country  varchar(15) not null default 'no country',
   email    varchar(30) not null default 'not known',
   primary key(memberID)
) engine=InnoDB;

create table if not exists node_information (
   nodeID bigint unsigned not null default 0,
   nodename     varchar(18) not null default 'no name',
   nodecountry  varchar(15) not null default 'no country',
   nodeemail    varchar(30) not null default 'not known',
   primary key(nodeID)
) engine=InnoDB;

create table if not exists privileges_information (
   privilegeID int unsigned not null default 0,
   privilegename varchar(18) not null default 'none',
   primary key(privilegeID)
) engine=InnoDB;

/* Junction table: node=0 is the member's global authorization.*/

create table if not exists member_authorizations (
   memberID bigint unsigned,
   nodeID bigint unsigned,
   privilegeID int unsigned,
   constraint c1 primary key (memberID, nodeID, privilegeID),
   foreign key (memberID) references member_information (memberID),
   foreign key (nodeID) references node_information (nodeID),
   foreign key (privilegeID) references privileges_information (privilegeID)
) engine=InnoDB;

/* -------------------- Insert data into database ----------------------- */

use members;
insert into member_information
   (memberID, name, country, email) values
   (01, 'Jay Lee',    'USA',    'jay@organization1.com'),
   (09, 'Jeff Lee',   'UK',     'jlee@organization2.com'),
   (51, 'George Lee', 'France', 'gl@organization3.com');

insert into node_information
   (nodeID, nodename, nodecountry, nodeemail) values
   (01, 'Interpol',   'France', 'dbmanager@interpol.com'),
   (02, 'State Dept', 'USA',    'dbmanager@biostate.gov');

insert into privileges_information
   (privilegeID, privilegename) values
   (1, 'select'),
   (2, 'insert');

insert into member_authorizations 
   (memberID, nodeID, privilegeID) values
   (01, 01, 1),
   (01, 02, 1),
   (01, 01, 2),
   (01, 02, 2),
   (09, 01, 1),
   (09, 02, 1),
   (51, 01, 1),
   (51, 02, 1),
   (51, 01, 2),
   (51, 02, 2);

select * from member_information;
select * from node_information;
select * from privileges_information;
select * from member_authorizations;

/* Create accounts. */

drop user if exists 'Jay Lee';
create user 'Jay Lee'
   identified by 'passwrd1';
grant select, insert, delete
   on *.*
   to 'Jay Lee';

drop user if exists 'Jeff Lee';
create user 'Jeff Lee'
   identified by 'passwrd2';
grant select, insert, delete
   on *.*
   to 'Jeff Lee';

drop user if exists 'George Lee';
create user 'George Lee'
   identified by 'passwrd3';
grant select, insert, delete
   on *.*
   to 'George Lee';

/* Print user privileges. */

show grants for 'Jay Lee';
show grants for 'Jeff Lee';
show grants for 'George Lee';
