import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;

public class Weather extends Application {
   private static final String API_KEY = "YOUR_API_KEY";
   private static final String API_URL = "http://api.openweathermap.org/data/2.5/weather?q=London&appid=" + API_KEY;

  @Override
  public void start(Stage primaryStage) throws Exception {
     VBox root = new VBox();
     Label weatherLabel = new Label("Fetching weather…");
     root.getChildren().add(weatherLabel);
     Scene scene = new Scene(root, 400, 300);
     fetchWeatherData(weatherLabel);
     primaryStage.setTitle("Weather Dashboard");
     primaryStage.setScene(scene);
     primaryStage.show();
  }

  private void fetchWeatherData(Label weatherLabel) {
     new Thread(() -> {
     try {
        HttpURLConnection connection = (HttpURLConnection) new URL(API_URL).openConnection();
        connection.setRequestMethod("GET");
        InputStreamReader reader = new InputStreamReader(connection.getInputStream());
        StringBuilder response = new StringBuilder();
        int data;
        while ((data = reader.read()) != -1) {
           response.append((char) data);
        }

        reader.close();

        JSONObject json = new JSONObject(response.toString());
        String weather = json.getJSONArray("weather").getJSONObject(0).getString("description");
        double temperature = json.getJSONObject("main").getDouble("temp") - 273.15;
        weatherLabel.setText(String.format("Weather: %s, Temperature: %.2f°C", weather, temperature));
     } catch (Exception e) {
         e.printStackTrace();
       }
     }).start();
 }

  public static void main(String[] args) {
     launch(args);
  }
}
