import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.*;
import org.json.JSONObject;
import org.json.JSONArray;

public class Tdash extends Application {
private static final String API_KEY = "YOUR_API_KEY";
private static final String API_URL1 =
   "https://modis.ornl.gov/rst/api/v1/products";
private static final String API_URL2 =
   "https://modis.ornl.gov/rst/api/v1/MCD15A2H/dates?latitude=23.70&longitude=-80.96";
private static final String API_URL3 =
   "https://modis.ornl.gov/rst/api/v1/MCD15A2H/subset?latitude=23.70&longitude=-80.96&startDate=A2024169&endDate=A2024169&kmAboveBelow=1&kmLeftRight=1";
String leafindexdesc;

@Override
public void start(Stage primaryStage) throws Exception {
VBox root = new VBox();
Label tigerLabel = new Label("Fetching ORNL Leaf Index…");
root.getChildren().add(tigerLabel);
Scene scene = new Scene(root, 800, 400);
fetchTigerData(tigerLabel);
primaryStage.setTitle("Leaf Index Dashboard");
primaryStage.setScene(scene);
primaryStage.show();
}

private void fetchTigerData(Label tigerLabel) {
new Thread(() -> {
try {
   URL urlobj1 = new URI(API_URL1).toURL();
   HttpURLConnection connection1 = (HttpURLConnection) urlobj1.openConnection();
   connection1.setRequestMethod("GET");
   InputStreamReader reader1 = new InputStreamReader(
      connection1.getInputStream());
   StringBuilder response1 = new StringBuilder();
   int data1;
   while ((data1 = reader1.read()) != -1) {
      response1.append((char) data1);
   }
   reader1.close();

   URL urlobj2 = new URI(API_URL2).toURL();
   HttpURLConnection connection2 = (HttpURLConnection) urlobj2.openConnection();
   connection2.setRequestMethod("GET");
   InputStreamReader reader2 = new InputStreamReader(
      connection2.getInputStream());
   StringBuilder response2 = new StringBuilder();
   int data2;
   while ((data2 = reader2.read()) != -1) {
      response2.append((char) data2);
   }
   reader2.close();

   URL urlobj3 = new URI(API_URL3).toURL();
   HttpURLConnection connection3 = (HttpURLConnection) urlobj3.openConnection();
   connection3.setRequestMethod("GET");
   InputStreamReader reader3 = new InputStreamReader(
      connection3.getInputStream());
   StringBuilder response3 = new StringBuilder();
   int data3;
   while ((data3 = reader3.read()) != -1) {
      response3.append((char) data3);
   }
   reader3.close();
/*
product": "MCD15A2H",
            "description": "MODIS/Terra+Aqua Leaf Area Index/FPAR (LAI/FPAR)  8-Day L4 Global 500 m SIN Grid",
            "frequency": "8-Day",
            "resolution_meters": 500
*/
// Process the returned JSON data.

   JSONObject json1 = new JSONObject(response1.toString());
   JSONArray entries1 = json1.getJSONArray("products");
   for (int i = 0; i < entries1.length(); i++) {
      JSONObject entry1 = entries1.getJSONObject(i);
      String product = entry1.getString("product");
      if (product.equals("MCD15A2H")) {
         leafindexdesc = entry1.getString("description");
      }
   }

   JSONObject json3 = new JSONObject(response3.toString());
   String leafvalues = json3.toString(4);

// Run a new thread to display the processed data.

   Runnable task = () -> {
      Platform.runLater(() -> {
         //tigerLabel.setText(String.format("Description: %s",leafindexdesc));
         tigerLabel.setText(leafvalues);
      });
   };
   Thread thread = new Thread(task);
   thread.setDaemon(true);
   thread.start();

} catch (Exception e) {
   e.printStackTrace();
}
}).start();
}

public static void main(String[] args) {launch(args);}
}
