import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.text.*;
import javafx.scene.layout.*;
import javafx.scene.paint.*;
import javafx.scene.shape.*;
import javafx.scene.Scene;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.AreaChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.FlowPane;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.stage.Stage;

public class Rdash extends Application {
final int WINDOW_SIZE = 25;

String employtime[] = new String[50];
String poachtime[] = new String[50];
String abundtime[] = new String[50];

Integer abund[][] = new Integer[30][50];

Double nmemploy[][] = new Double[3][50];
Double nmpoach[][] = new Double[3][50];

final CategoryAxis xnmemploy = new CategoryAxis();
final NumberAxis ynmemploy = new NumberAxis();
final LineChart<String, Number> nmemploychart =
   new LineChart<>(xnmemploy, ynmemploy);
XYChart.Series<String, Number> nmemployupseries = new XYChart.Series<>();
XYChart.Series<String, Number> nmemployseries = new XYChart.Series<>();
XYChart.Series<String, Number> nmemploylowseries = new XYChart.Series<>();
private ScheduledExecutorService nmemployschedserv;

final CategoryAxis xnmpoach = new CategoryAxis();
final NumberAxis ynmpoach = new NumberAxis();
final LineChart<String, Number> nmpoachchart =
   new LineChart<>(xnmpoach, ynmpoach);
XYChart.Series<String, Number> nmpoachupseries = new XYChart.Series<>();
XYChart.Series<String, Number> nmpoachseries = new XYChart.Series<>();
XYChart.Series<String, Number> nmpoachlowseries = new XYChart.Series<>();
private ScheduledExecutorService nmpoachschedserv;

final CategoryAxis xabund = new CategoryAxis();
final NumberAxis yabund = new NumberAxis();
final LineChart<String, Number> abundchart =
   new LineChart<>(xabund, yabund);
XYChart.Series<String, Number> abundseries1 = new XYChart.Series<>();
XYChart.Series<String, Number> abundseries2 = new XYChart.Series<>();
XYChart.Series<String, Number> abundseries3 = new XYChart.Series<>();
XYChart.Series<String, Number> abundseries4 = new XYChart.Series<>();
XYChart.Series<String, Number> abundseries5 = new XYChart.Series<>();
XYChart.Series<String, Number> abundseries6 = new XYChart.Series<>();
XYChart.Series<String, Number> abundseries7 = new XYChart.Series<>();
XYChart.Series<String, Number> abundseries8 = new XYChart.Series<>();
XYChart.Series<String, Number> abundseries9 = new XYChart.Series<>();
private ScheduledExecutorService abundschedserv;

public static void main(String[] args) { launch(args); }

// ---------------------------------------------------------------------

@Override
public void start(Stage primaryStage) throws Exception {

primaryStage.setTitle("Elegant Furniture's Rhino Conservation Project");

// Legend.

/*
Text legendtext = new
   Text("                                Top and middle charts: upper veracity limit, reported value, lower veracity limit.");
legendtext.setFont(Font.font("Helvetica", 15));
legendtext.setFill(Color.GREEN);
//legendtext.setX(50);
*/

// Audit information note.

Text audittext = new
   Text("                                Audit information is available at https://elegantfurniture.com/rhino/audit/");
audittext.setFont(Font.font("Helvetica", 15));
audittext.setFill(Color.GREEN);

FlowPane pane = new FlowPane(Orientation.VERTICAL);
pane.getChildren().add(topchart_());
pane.getChildren().add(middlechart_());
pane.getChildren().add(bottomchart_());
//pane.getChildren().add(legendtext);
pane.getChildren().add(audittext);

/* Setup the scene.  The file "colors.css" contains special color that
   keep AreaChart from shading the area from the x-axis up to the lower
   chart.  This is apparently why the thin lines of color appear at the
   beginning and end of the band. */
 
Scene scene = new Scene(pane, 1200, 950); // was 900, 700
primaryStage.setScene(scene);
//scene.getStylesheets().add("/colors.css");

// Show the stage.

primaryStage.show();

// Setup a scheduled executors to periodically put data into the charts.

nmemployschedserv = Executors.newSingleThreadScheduledExecutor();
nmpoachschedserv = Executors.newSingleThreadScheduledExecutor();
abundschedserv = Executors.newSingleThreadScheduledExecutor();

// ************** Number of Employees. ********************

TimerTask employtask = new TimerTask() {
@Override
public void run() {

int i = 0, nmpts = 0;

FileReader fin = null;
Scanner src = null;

try {
fin = new FileReader("employ.dat");
src = new Scanner(fin);
} catch (IOException e) {
}

while (src.hasNext()) {
   if (src.hasNextDouble()) {
      nmemploy[0][nmpts] = src.nextDouble();
      nmemploy[2][nmpts] = src.nextDouble();
      nmemploy[1][nmpts] = .5 * (nmemploy[0][nmpts] + nmemploy[2][nmpts]);
      ++nmpts;

   } else {
      employtime[nmpts] = src.next();
   }
}
try {
fin.close();
src.close();
} catch (IOException e) {
}
final int nmptsf = nmpts;

Platform.runLater(new Runnable() {
@Override
public void run() {
XYChart.Data<String, Number> empdata;
for (int i = 0; i < nmptsf; ++i) {
   empdata = new XYChart.Data<>(employtime[i],nmemploy[0][i]);
   nmemployupseries.getData().add(empdata);

   empdata = new XYChart.Data<>(employtime[i],nmemploy[1][i]);
   nmemployseries.getData().add(empdata);

   empdata = new XYChart.Data<>(employtime[i],nmemploy[2][i]);
   nmemploylowseries.getData().add(empdata);
}
}
});
};
};

// Update every 90 days.

nmemployschedserv.scheduleAtFixedRate(employtask, 0, 90,
   TimeUnit.DAYS);
//2-second update interval for testing.
//nmemployschedserv.scheduleAtFixedRate(employtask, 0, 2,
//TimeUnit.SECONDS);
// Also valid: MILLISECONDS, MINUTES, HOURS, DAYS

// ******************** Number poached. ********************

TimerTask poachtask = new TimerTask() {
@Override
public void run() {

int i = 0, nmpts = 0;

FileReader fin = null;
Scanner src = null;

try {
fin = new FileReader("poach.dat");
src = new Scanner(fin);
} catch (IOException e) {
}

while (src.hasNext()) {
   if (src.hasNextDouble()) {
      nmpoach[2][nmpts] = src.nextDouble();
      nmpoach[0][nmpts] = src.nextDouble();
      nmpoach[1][nmpts] = .5 * (nmpoach[0][nmpts] + nmpoach[2][nmpts]);
      ++nmpts;

   } else {
      poachtime[nmpts] = src.next();
   }
}
try {
fin.close();
src.close();
} catch (IOException e) {
}
final int nmptsf = nmpts;

Platform.runLater(new Runnable() {
@Override
public void run() {
XYChart.Data<String, Number> poachdata;
for (int i = 0; i < nmptsf; ++i) {
   poachdata = new XYChart.Data<>(poachtime[i],nmpoach[0][i]);
   nmpoachupseries.getData().add(poachdata);

   poachdata = new XYChart.Data<>(poachtime[i],nmpoach[1][i]);
   nmpoachseries.getData().add(poachdata);

   poachdata = new XYChart.Data<>(poachtime[i],nmpoach[2][i]);
   nmpoachlowseries.getData().add(poachdata);
}
}
});
};
};
nmpoachschedserv.scheduleAtFixedRate(poachtask, 0, 2,
   TimeUnit.DAYS);

// ********************* Abundance. ****************************

TimerTask abundtask = new TimerTask() {
@Override
public void run() {

int j = 0, nmpts = 0;

FileReader fin = null;
Scanner src = null;

try {
fin = new FileReader("abund.dat");
src = new Scanner(fin);
} catch (IOException e) {
}

while (src.hasNext()) {
   if (src.hasNextInt()) {
      abund[j][nmpts - 1] = src.nextInt();
      ++j;

   } else {
      abundtime[nmpts] = src.next();
      ++nmpts;
      j = 0;
   }
}
try {
fin.close();
src.close();
} catch (IOException e) {
}
final int nmptsf = nmpts;

Platform.runLater(new Runnable() {
@Override
public void run() {
XYChart.Data<String, Number> datapt;
for (int i = 0; i < nmptsf; ++i) {
   datapt = new XYChart.Data<>(abundtime[i],abund[0][i]);
   abundseries1.getData().add(datapt);

   datapt = new XYChart.Data<>(abundtime[i],abund[1][i]);
   abundseries2.getData().add(datapt);

   datapt = new XYChart.Data<>(abundtime[i],abund[2][i]);
   abundseries3.getData().add(datapt);

   datapt = new XYChart.Data<>(abundtime[i],abund[3][i]);
   abundseries4.getData().add(datapt);

   datapt = new XYChart.Data<>(abundtime[i],abund[4][i]);
   abundseries5.getData().add(datapt);

   datapt = new XYChart.Data<>(abundtime[i],abund[5][i]);
   abundseries6.getData().add(datapt);

   datapt = new XYChart.Data<>(abundtime[i],abund[6][i]);
   abundseries7.getData().add(datapt);

   datapt = new XYChart.Data<>(abundtime[i],abund[7][i]);
   abundseries8.getData().add(datapt);

   datapt = new XYChart.Data<>(abundtime[i],abund[8][i]);
   abundseries9.getData().add(datapt);
}
}
});
};
};
abundschedserv.scheduleAtFixedRate(abundtask, 0, 2,
   TimeUnit.DAYS);
} // End of start method.

// ---------------------------------------------------------------------

public LineChart<String, Number> topchart_() {

// Define axes.
    
xnmemploy.setLabel("");
xnmemploy.setAnimated(false);
ynmemploy.setLabel(" ");
ynmemploy.setAnimated(false);

/* Create a line chart with two axes.  Default legend at bottom does not
   work possibly because of pane stacking. */

nmemploychart.setTitle(
   "Number of Employees Recruited and Transferred from Rhino Environs");
nmemploychart.setAnimated(false);
nmemploychart.setPrefSize(1200, 295);
nmemploychart.setCreateSymbols(false);
nmemploychart.getYAxis().lookup(".axis-label")
    .setStyle("-fx-label-padding: -5 0 0 0;");

// Define a series to display data.

nmemployupseries.setName("Upper veracity limit");
nmemployseries.setName("Reported value");
nmemploylowseries.setName("Lower veracity limit");

// Add series to chart.
    
nmemploychart.getData().add(nmemployupseries);
nmemploychart.getData().add(nmemployseries);
nmemploychart.getData().add(nmemploylowseries);
return nmemploychart;
}

// ---------------------------------------------------------------------

public LineChart<String, Number> middlechart_() {

// Define axes.
    
xnmpoach.setLabel("");
xnmpoach.setAnimated(false);
ynmpoach.setLabel(" ");
ynmpoach.setAnimated(false);

// Create a line chart with two axis.

nmpoachchart.setTitle("Number of Rhinos Poached in South Africa");
nmpoachchart.setAnimated(false);
nmpoachchart.setPrefSize(1200, 295);
nmpoachchart.setCreateSymbols(false);
nmpoachchart.getYAxis().lookup(".axis-label")
    .setStyle("-fx-label-padding: -10 0 0 0;");

// Define a series to display data.

nmpoachupseries.setName("Upper veracity limit");
nmpoachseries.setName("Reported value");
nmpoachlowseries.setName("Lower veracity limit");

// Add series to chart.
    
nmpoachchart.getData().add(nmpoachupseries);
nmpoachchart.getData().add(nmpoachseries);
nmpoachchart.getData().add(nmpoachlowseries);
return nmpoachchart;
}

// ---------------------------------------------------------------------

public LineChart<String, Number> bottomchart_() {

// Define axes.
    
xabund.setLabel("Month&Year");
xabund.setAnimated(false);
yabund.setLabel("");
yabund.setAnimated(false);

// Create a line chart with two axis.

abundchart.setTitle("Nine Runs of the Stochastic Model of South African Rhino Abundance");
abundchart.setAnimated(false);
abundchart.setPrefSize(1200, 295);
abundchart.setCreateSymbols(false);

// Define a series to display data.

//abundseries1.setName("Abundance Series");

// Add series to chart.
    
abundchart.getData().add(abundseries1);
abundchart.getData().add(abundseries2);
abundchart.getData().add(abundseries3);
abundchart.getData().add(abundseries4);
abundchart.getData().add(abundseries5);
abundchart.getData().add(abundseries6);
abundchart.getData().add(abundseries7);
abundchart.getData().add(abundseries8);
abundchart.getData().add(abundseries9);
return abundchart;
}


// -------------------------------------------------------------------

@Override
public void stop() throws Exception {
super.stop();
nmemployschedserv.shutdownNow();
nmpoachschedserv.shutdownNow();
abundschedserv.shutdownNow();
}
}
