static void computeShortestPaths(int n, int[][] adj, int[][] dists,
   int[][] nPaths) {

/* Computes matrix of distances and #s of shortest paths between any 2
   vertices. 

   n: size of matrix/graph
   adj: adjacency matrix of graph
   dists: n x n matrix to set up with distances (return value)
   nPaths: n x n matrix to set up with shortest paths (return value)
 
   From blaisemath (http://code.google.com/p/blaisemath/source)
*/

int[][] curAdj = new int[n][n];
int i, j, k, nFound, power = 1;

for (i = 0; i < n; i++) {
   dists[i][i] = 0;
   nPaths[i][i] = 1;
   for (j = 0; j < n; j++) {
      if (i == j) {
         continue;
      }
      curAdj[i][j] = adj[i][j];
      if (adj[i][j] == 0) {
         dists[i][j] = nPaths[i][j] = -1;

      } else {
         dists[i][j] = nPaths[i][j] = 1;
      }
   }
}

nFound = -1;
while (nFound != 0) {
   nFound = 0;
   
   // curAdj = Matrices.matrixProduct(curAdj, adj);

   for (i = 0; i < n; i++) {
      for (j = 0; j < n; j++) {
	 dumvec[j] = 0.;
         for (k = 0; k < n; ++k) {
            dumvec[j] += curAdj[i][k] * adj[k][j];
	 }
      }
      for (j = 0; j < n; j++) {
         curAdj[i][j] = dumvec[j];
      }
   }

   power++;
   for (i = 0; i < n; i++) {
      for (j = 0; j < n; j++) {
         if (i == j) {
            continue;
	 }
	 if (dists[i][j] == -1 && curAdj[i][j] != 0) {
	    dists[i][j] = power;
	    nPaths[i][j] = curAdj[i][j];
	    nFound++;
	 }
      }
   }
}
}

// ---------------------------------------------------------------

static double computeBetweenness(int n, int[][] dists, int[][] nPaths,
   int v0) {

/* Computes the betweenness of a specified vertex.
 
   n: size of matrix/graph
   dists: the matrix of distances between vertices
   nPaths: the matrix of # of shortest paths between any two vertices
   v0: the index of the node whose betweenness is to be computed
   directed: whether the graph for the computation is directed or not
   returns the betweenness of the vertex
*/

int i, j;

double result = 0.0;

for (i = 0; i < n; i++) {
   for (j = 0; j < n; j++) {
      if (i == j) {
         continue;
    
      } else if ((i == v0 || j == v0) && dists[i][j] != -1) {
         result++;
    
      } else if (dists[i][v0] != -1 && dists[v0][j] != -1 &&
                 dists[i][j] != -1 &&
	         dists[i][v0] + dists[v0][j] == dists[i][j]) {
         result += nPaths[i][v0] * nPaths[v0][j] / (double) nPaths[i][j];
      }
   }
}

return result;
}
}
