class Wlstrend extends Surf {
static int k, t, ier;

static double wcos = 0., wsin = 0.;

static double x[] = new double[NMWRPAR];

// ----------------------------------------------------------------------

static int wlstrend_(int ifirst, double cpar[][], boolean parcount) {
 
/* Computes a linear or nonlinear generalized least squares regression
   estimate of trend at the center of the moving cylinder.

   *** Note, declaring c and cstore after nmtrendpars has been computed
       SHOULD work in java but causes memory problems.

   itrend = 4: intercept parameter only
   itrend = 5: first-order model in x, y, t
   itrend = 6: second-order model in x, y, first-order in t. */

int i, i1, j, k, l, cvstrct, retval = 0, cend = 0, nmsum, nmfall, nmwintr,
   nmsprng, seasval, stnm, stnmi, stnmj;

double sse, xcenter = 0., ycenter = 0., coscof, sincof, ampltde, phase,
   resmean, sfstat, obs, sum, tcord = 0., rnd, sumn, flln, wntn, sprn,
   summn, fllmn, wntmn, sprmn;

double y[] = new double[nd];
double resiid[] = new double[nd];
double vsse[] = new double[NUMVAR];
double vssy[] = new double[NUMVAR];

if ((itrend != 4 && itrend != 5 && itrend != 6) && !nonlin) {
   iderr_("wlstrend: itrend not right");
}

// Zero cholesky matrix.

for (i = 0; i < nd; ++i) {
   for (j = 0; j < nd; ++j) {
      s[i][j] = 0.;
   }
}

/* Form data vector y from the cylinder's observations.  This separate
   vector is needed because "wlsqrs_" modifies the data vector that it
   is given. */
 
for (i = 0; i < nd; ++i) {
   y[i] = vardat_obs[i];
}

if (ifirst == 1) {

   /* On first stage, form the identity covariance matrix and zero-out
      the season counters. */

   for (i = 0; i < nd; ++i) {
      s[i][i] = 1.;
   }
   nmsum = 0;
   nmfall = 0;
   nmwintr = 0;
   nmsprng = 0;

   if (!nonlin) {

      // Figure out number of parameters.

      coeffname[0] = "intercept";
      nmpars[0] = 1;
      if (spatial && !temporal) {
         if (itrend >= 5 && nmquantvar == 0) {
	    coeffname[1] = "x";
	    coeffname[2] = "y";
            nmpars[0] += 2;
	    if (itrend == 6) {
	       coeffname[3] = "x2";
	       coeffname[4] = "y2";
	       coeffname[5] = "xy";
	       nmpars[0] += 3;
            }
         }

      } else if (!spatial && temporal) {
	 if (itrend >= 5) {
	    coeffname[1] = "time";
	    ++nmpars[0];
	 }
	 if (itrend == 6) {
	    coeffname[2] = "time2";
	    ++nmpars[0];
         }

      } else if (spatial && temporal) {
         if (itrend >= 5 && nmquantvar == 0) {
	    coeffname[1] = "x";
	    coeffname[2] = "y";
            nmpars[0] += 2;
	    if (itrend == 6) {
	       coeffname[3] = "x2";
	       coeffname[4] = "y2";
	       coeffname[5] = "xy";
               nmpars[0] += 3;
	    }
         }
	 coeffname[nmpars[0]] = "time";
	 nmpars[0] += 1;
	 if (itrend == 6) {
	    coeffname[nmpars[0]] = "time2";
	    nmpars[0] += 1;
         }
         nmpars[0] += (nmquantvar * quantvarmodel);
      }

      if (seasclc) {
         nmpars[0] += 3;
	 coeffname[nmpars[0] - 3] = "winter";
	 coeffname[nmpars[0] - 2] = "spring";
	 coeffname[nmpars[0] - 1] = "summer";
      }
      for (i = 0; i < nmqualvar; ++i) {
	 for (j = 0; j < nmquallvl[i]; ++j) {
	    coeffname[nmpars[0] + j] = "qualvarlevel_" + (j + 1);
	 }
	 nmpars[0] += nmquallvl[i] - 1;
      }

      // Compute total number of parameters.

      nmtrendpars = nmpars[0];
      for (i = 2; i <= parm_mvar; ++i) {
         nmpars[i - 1] = nmpars[0];
         nmtrendpars += nmpars[i - 1];
      }
      if (nmtrendpars > NMWRPAR) {
         iderr_("wlstrend: nmtrendpars= " + nmtrendpars + " NMWRPAR= " +
            NMWRPAR);
      }
      if (nd - nmtrendpars < 3 && nmstmixcntr == 0) {
         iderr_("wlstrend: nd= " + nd + " nmtrendpars= " + nmtrendpars +
            " nd-nmtrendpars<3");
      }

      // Return if just counting the number of parameters.

      if (parcount) {
	 return 0;
      }

      /* Create and fill design matrix and design matrix store.  First,
	 zero the matrix.  nmtrendpars needed to calculated before these
	 matrices could be declared. */

      // double c[][] = new double[nd][nmtrendpars];
      // double cstore[][] = new double[nd][nmtrendpars];
      for (i = 0; i < nd; ++i) {
         for (j = 0; j < nmtrendpars; j++) {
	    c[i][j] = 0.;
	 }
      }

      // Fill each row.

      for (i = 0; i < nd; ++i) {
         stnm = idtostnm[vardat_vrble[i] - 1];

         // Figure out what column to begin in.

         cend = 0;
         for (j = 1; j < stnm; ++j) {
	    cend += nmpars[j];
         }

	 if (spatial) {

            // Find centered x, y and design matrix column.

            xcenter = vardat_x[i] - xmean;
            ycenter = vardat_y[i] - ymean;
	 }

         if (temporal) {
	    tcord = vardat_t[i];
         }

         // Load design matrix row.

         c[i][cend] = 1.;

         if (itrend > 4 && spatial) {
            cend += 2;
            c[i][cend - 1] = xcenter;
            c[i][cend] = ycenter;
         }

         if (itrend > 5 && spatial) {
	    cend += 3;
            c[i][cend - 2] = xcenter * xcenter;
            c[i][cend - 1] = ycenter * ycenter;
            c[i][cend] = xcenter * ycenter;
         }

         // Optionally add covariate column(s).

         if (quantvarmodel > 0) {
	    for (i1 = 0; i1 < nmquantvar; ++i1) {
	       ++cend;
	       c[i][cend] = vardat_quantval[i][i1];
	       if (quantvarmodel == 2) {

		  // Quadratic term.

	          ++cend;
	          c[i][cend] =
		     vardat_quantval[i][i1] * vardat_quantval[i][i1];
	       }
	    }
         }

         if (temporal) {
            ++cend;
            c[i][cend] = tcord;
            if (itrend == 6) {
	       ++cend;
               c[i][cend] = tcord * tcord;
	    }
            if (seasclc) {

               /* Sinusoidal seasonality model.
               cend += 2;
               c[i][cend - 1] = cos(2. * Math.PI * tcord * .25);
               c[i][cend] = sin(2. * Math.PI * tcord * .25); */

               // Simple 4-level ANOVA seasonality model.

               cend += 3;
               seasval = getseas_(tcord);
               if (seasval == 1) { // Winter.
	          ++nmwintr;
                  c[i][cend - 2] = 1.;
                  c[i][cend - 1] = 0.;
                  c[i][cend] = 0.;

               } else if (seasval == 2) { // Spring.
	          ++nmsprng;
                  c[i][cend - 2] = 0.;
                  c[i][cend - 1] = 1.;
                  c[i][cend] = 0.;

               } else if (seasval == 3) { // Summer.
	          ++nmsum;
                  c[i][cend - 2] = 0.;
                  c[i][cend - 1] = 0.;
                  c[i][cend] = 1.;

               } else if (seasval == 4) { // Fall.
	          ++nmfall;
                  c[i][cend - 2] = -1.;
                  c[i][cend - 1] = -1.;
                  c[i][cend] = -1.;
               }
            } // End of seasonality condition.
         } // End of temporal condition.

         // Add qualitative variables.

	 for (j = 1; j <= nmqualvar; ++j) {
	    if (dat2_qualval[i][j - 1] < nmquallvl[j - 1]) {
	       c[i][cend + dat2_qualval[i][j - 1]] = 1.;
            
	    } else {
	       for (k = 1; k < nmquallvl[j - 1]; ++k) {
		  c[i][cend + k] = -1.;
	       }
	    }
	    cend += nmquallvl[j - 1] - 1;
	 }
      } // End of data loop.

      // Save the linear model's design matrix.

      for (i = 0; i < nd; ++i) {
         for (j = 0; j < nmtrendpars; ++j) {
	    cstore[i][j] = c[i][j];
	 }
      }

   } else if (nonlin) {

      // Determine the number of nonlinear model parameters.

      iderr_("wlstrend: nonlinear model not implemented.");
      // nmtrendpars = a function that is the nonlinear model for all
      // variables so that interaction terms are included in the count.

      for (i = 0; i < parm_mvar; ++i) {
	 nmpars[i] = 0;
      }

      if (nmtrendpars > NMWRPAR) {
	 iderr_("wlstrend: nmtrendpars too big");
      }
   }

} else if (ifirst > 1 && !nonlin) {

   // For a linear model, reload design matrix from cstore.

   for (i = 0; i < nd; ++i) {
      for (j = 0; j < nmtrendpars; ++j) {
         c[i][j] = cstore[i][j];
      }
   }

   /* Form correlated error covariance matrix in "form_a" for second
      iteration. */
 
   for (i = 0; i < nd; ++i) {
      for (j = 0; j <= i; ++j) {

         // Find covariance structure to be used.

	 stnmi = idtostnm[vardat_vrble[i] - 1];
	 stnmj = idtostnm[vardat_vrble[j] - 1];
	 if (vardat_vrble[i] == vardat_vrble[j]) {
             cvstrct = stnmi;
	 
         } else {
            cvstrct = crossmap[stnmi - 1][stnmj - 1];
         }

	 // Assign covariance and fill in upper half.

	 form_a[i][j] = Covmodl.covmodl_(i, j, vardat_x[i], vardat_y[i],
	    vardat_t[i], vardat_x[j], vardat_y[j], vardat_t[j], cvstrct);

         if (i != j) {
	    form_a[j][i] = form_a[i][j];
	 }
      }

      // Check for exact singularity.

      if (i > 0) {
	 exactsg_(form_a, i, "wlstrend");
      }
   }

   /* Form lower triangular matrix from form_a and incidentally check for a
      valid covariance matrix. */

   if (Choles.choles_(form_a, s, 1, nd, false) < 0.) {
      Covmodl.covprt_(1);
      iderr_("wlstrend: Cholesky decomposition of form_a failed");
   }
}

// Estimate the linear or nonlinear model.

k = nmtrendpars; 
if (!nonlin) {
   Wlsqrs.wlsqrs_(y, c, s, nd, nmtrendpars, x);

} else if (nonlin) {
   /*
   // On second stage, initial values are the first stage values.

   if (ifirst == 1) {

      // Initial values.

      x[0] = 1. / grdvar_datmn;
      for (i = 1; i < nmtrendpars; ++i) x[i] = 0.;

      if (spatial && temporal) {
         sumn = 0.;
	 flln = 0.;
	 wntn = 0.;
	 sprn = 0.;
	 summn = 0.;
	 fllmn = 0.;
	 wntmn = 0.;
	 sprmn = 0.;
         for (i = 0; i < nd; ++i) {
            if (Math.IEEEremainder(vardat[i].t - 2., 4.) < 1.e-5) {
               sumn += 1.;
               summn += vardat_dat[i];

            } else if (Math.IEEEremainder(vardat_t[i] - 3., 4.) < 1.e-5) {
               flln += 1.;
               fllmn += vardat_dat[i];

            } else if (Math.IEEEremainder(vardat_t[i] - 4., 4.) < 1.e-5) {
               wntn += 1.;
               wntmn += vardat_dat[i];

            } else if (Math.IEEEremainder(vardat_t[i] - 5., 4.) < 1.e-5) {
               sprn += 1.;
               sprmn += vardat_dat[i];
            }
	    summn /= sumn;
	    fllmn /= flln;
	    wntmn /= wntn;
	    sprmn /= sprn;

	    // Summer.

	    x[7] = (summn - grdvar_datmn);

	    // Fall.

	    x[8] = (fllmn - grdvar_datmn);

	    // Winter.

	    x[9] = (wntmn - grdvar_datmn);
         }
         if (parm_mvar == 2) {
            if (quantvarmodel == 0) {
	       x[6] = 1.;
            
	    } else if (quantvarmodel == 1) {
	       x[7] = 1.;
	    }
         }
      }
   }
   dfpmin_(nmtrendpars, x, &ier, ifirst, 1, false);
   */
}

// Process error returns.

if (ier == 1) {
   Covmodl.covprt_(1);
   iderr_("wlstrend: ier=1");
}

if (!nonlin && k != nmtrendpars) {
   iderr_("wlstrend: k= " + k + " nmtrendpars= " + nmtrendpars + " nd= " +
      nd + " X is less than full rank");
}

/* Find covariance matrix of the parameter vector.
covpar_(nd, nmtrendpars, c, s, cpar); */

// Store regression parameters.

k = 0;
for (i = 0; i < parm_mvar; ++i) {
   for (j = 0; j < nmpars[i]; ++j) {
      if (Double.isNaN(x[j + k])) {
         printf_("wlstrend: parameter=NaN, setting to zero");
         x[j + k] = 0.;
      }
      grdvar_rparm[i][j] = x[j + k];
   }
   k += nmpars[i];
}

/* Find trend at each observation location, and then the predicted
   residuals.  Replace vardat data. */

if (ifirst == 2) {
   fleopen_(NMFILES - 1, "restrend1.dat",'w');
}

for (i = 0; i < nd; ++i) {
   stnm = idtostnm[vardat_vrble[i] - 1];
   vardat_trend[i] = Trendeval.trendfcn_(0, true, i, vardat_x[i],
      vardat_y[i], vardat_t[i], vardat_quantval[i], vardat_qualval[i],
      stnm);

   vardat_dat[i] = vardat_obs[i] - vardat_trend[i];

   // Plot residual versus trend.

   if (ifirst == 2) {
      fprintf_(NMFILES - 1, vardat_vrble[i] + " " + vardat_obs[i] +
         " " + vardat_trend[i] + " " + vardat_dat[i]);
   }
}

if (ifirst == 2) {
   fclose_(NMFILES - 1, 'w');
}

/* Find R^2 and the residual's mean for the entire data vector and
   for each variable. */
 
rnd = (double) nd;
sse = 0.;
resmean = 0.;
for (i = 0; i < NUMVAR; ++i) {
   vsse[i] = 0.;
   vssy[i] = 0.;
}
for (i = 0; i < nd; ++i) {
   stnm = idtostnm[vardat_vrble[i] - 1];
   resmean += vardat_dat[i];
   sse += vardat_dat[i] * vardat_dat[i];
   obs = vardat_obs[i];

   vsse[stnm - 1] += vardat_dat[i] * vardat_dat[i];
   vssy[stnm - 1] += obs * obs;
}
resmean /= rnd;

if (grdvar_datssy > 0.) {
   r2 = 1. - (sse / grdvar_datssy);

} else {
   r2 = 0.;
}

/* If r2 is negative, use data mean for beta_0 and set all other parameters
   to zero (all beta_0's are set the the overall data mean). */

if (r2 < 0.) {
   for (i = 0; i < parm_mvar; ++i) {
      grdvar_rparm[i][0] = grdvar_datmn;

      for (j = 1; j < nmpars[i]; ++j) {
         grdvar_rparm[i][j] = 0.; 
      }
   }

   for (i = 0; i < nd; ++i) {
      stnm = idtostnm[vardat_vrble[i] - 1];
      vardat_trend[i] = Trendeval.trendfcn_(0, true, i, vardat_x[i],
         vardat_y[i], vardat_t[i], vardat_quantval[i], vardat_qualval[i],
	 stnm);
      vardat_dat[i] = vardat_obs[i] - vardat_trend[i];
   }
}

sfstat = 1.;

/* Find amplitude and phase.
if (temporal) {
   for (i = 0; i < nmtrendpars; ++i) {
      fprintf(fp3,"coeff(%d)= %lf\n",i,x[i]); 
   }

   if (seasclc) {
      coscof = x[?];
      sincof = x[?];
      ampltde = Math.sqrt(coscof*coscof + sincof*sincof);
      if (coscof >= 0.) {
	 phase = atan2(sincof,coscof);
      
      } else if (coscof < 0.) {
	 phase = atan2(sincof,coscof) + Math.PI; 
      }
      fprintf(fp3,"amplitude= %lf phase= %lf\n",ampltde,phase);
   }
}
*/

return 0;
}

// ------------------------------------------------------------------------

static int getseas_(double t) {

/* Returns season index that time t corresponds to.  Assumes that the Time
   variable counts the number of seasons since winter, 1978. 
   Winter = 1, Spring = 2, Summer = 3, Fall = 4. */

int nmyrs, intgrt;

intgrt = (int) t;
nmyrs = intgrt / 4;

return (1 + intgrt - 4 * nmyrs);
}

// ------------------------------------------------------------------------

static double sdiff_(double t1, double t2) {

// Computes difference between seasons.

int absdiff;

absdiff = Math.abs(getseas_(t1) - getseas_(t2));

if (absdiff == 1 || absdiff == 3) {
   return 1.;

} else if (absdiff == 2) {
   return 2.;
}

return 0.;
}
}
