public class WTSnetupdate extends SNA {

static boolean initialize = true;

static int netactsflenm = 7, nmwtslevels = 5;

static int ndegrptoidnm[] = new int[TNMIDS];

// ---------------------------------------------------------------------

static void updatenet_() {

/* Updates the wildlife trafficking syndicate (WTS) network at time t.
   Called from Intridutils.postaction_().

   A social network is a static data structure.  Measures are computed
   that describe aspects of this structure but the network itself does
   not perform any activities.  Because agents (here, ID submodels) simulate
   actions, associating submodels with players allows these players to
   receive inputs, communicate with other players, and post outputs.
   Doing so allows a history of simulated network activities to be
   generated.

   A submodel is an aggregated simulation model of group decision
   making where it assumed that one anonymous member of group actually
   implements an output action.  Hence, there is a need to select
   an individual from a group to be the author of the output action that
   the group-level submodel has computed.

                  Tasks performed by this method

   1. For each output action posted by a WTS submodel at this time point,
      select a player from the WTS network who is at the same level as
      this WTS submodel.  Then associate the following triad with this
      player.

                  (time, input action, output action)

                  Player selection procedure

      a. If a player is named in an output action, use that player.

      b. If the action is location-specific, randomly choose a player
         from that location.

      c. If the output action is not named and is not location-specific,
         randomly select a player from the submodel's level, e.g., if
         a trafficker submodel needs to post an action, randomly select
         a trafficker-level player.

   2. Add these simulated WTS network activities to the file 
      that holds the simulated network's activities history.

   Note: Data on player-to-player phone calls could be added to the
         actions history used to fit the simulator.  But this could be
         a large amount of data, and each communication would need to be
         timestamped.  If this were done, a communication action would be
         recognized and there would be no need to select players because
         they would be known.  Currently, this type of data is contained
         in the data set used to fit the WTS network alone.
*/


String chosenplayer = "none";

int i, idnm = idnmbrm1 + 1, playerlevel = 0;

if (initialize) {

   /* On the first call to this method, read-in the network and open the
      network activities file. */

   nmnodes = SNAutils.readnetwork_(linksfle);

   fleopen_(netactsflenm, "wtsnetworkacts.dat", 'w');

   // Map WTS submodels to network node group numbers.

   for (i = 1; i <= nmids; ++i) {
      if (idname[i - 1].indexOf("poachers") >= 0) {
         ndegrptoidnm[0] = i;

      } else if (idname[i - 1].indexOf("runners") >= 0) {
         ndegrptoidnm[1] = i;

      } else if (idname[i - 1].indexOf("middle") >= 0) {
         ndegrptoidnm[2] = i;

      } else if (idname[i - 1].indexOf("traffickers") >= 0) {
         ndegrptoidnm[3] = i;

      } else if (idname[i - 1].indexOf("retailers") >= 0) {
         ndegrptoidnm[4] = i;
      }
   }
 
   initialize = false;
}

// Check if this actor is a WTS submodel.  If so, find its WTS level.

for (i = 1; i <= nmwtslevels; ++i) {
   if (idnm == ndegrptoidnm[i - 1]) {
      playerlevel = i;
      break;
   }
}
if (playerlevel == 0) {
   return;
}

/* Select a player from the WTS network to be the author of this output
   action (make random??). */

for (i = 0; i < nmnodes; ++i) {
   if (playerlevel == prednodegroup[i]) {
      chosenplayer = allid[i];
      break;
   }
}

/* Write this player-activity information to the history file.  Specifically,
   write: (time, player, input action, output action). */

fprintf_(netactsflenm, fdble_(Intridslve.actions_time[0], 7, 2) + " " +
   chosenplayer + " " + Intridutils.inaction + " " +
   Intridslve.actions_action[0]);
}
}
