class Updateprbs extends Setacts {
static double oldarray[][][][] = new double[TNMVALS][TNMVALS][TNMVALS]
					   [TNMVALS];

// ----------------------------------------------------------------------

static void updateprbs_() {

/* Updates the conditional distributions of nodes influenced by the
   input action node. */

String shrtlbl;

int i, j, k, finndenm = 0, econrndenm = 0, milrndenm = 0, milndenm = 0,
   sbjctndenm = 0, pchactndenm = 0, preschgndenm = 0, kenpchgndenm = 0,
   tanpchgndenm = 0, ugapchgndenm = 0, hpndenm = 0, cpndenm = 0,
   apgndenm = 0, inacrpndenm = 0, pastryszendenm = 0, vblcombndenm = 0,
   smilfrcndenm = 0, seconchgndenm = 0, smilrchgndenm = 0, nmvals = 0,
   ngh1 = 0, ngh2 = 0, ngh3 = 0, nmvalngh1 = 0, nmvalngh2 = 0,
   nmvalngh3 = 0, actnindx = 0, sbjctindx = 0, actorindx = 0;

double val = 0.;

// First, find affected node numbers.

for (i = 0; i < nmnds; ++i) {
   shrtlbl = grph_label[idnmbrm1][i];
   if (shrtlbl.equals("FIN")) {
      finndenm = i + 1;

   } else if (shrtlbl.equals("ECONCHG") || shrtlbl.equals("LVECHG")) {
      econrndenm = i + 1;

   } else if (shrtlbl.equals("MILRCHG")) {
      milrndenm = i + 1;

   } else if (shrtlbl.equals("MILFRC")) {
      milndenm = i + 1;

   } else if (shrtlbl.equals("INS")) {
      sbjctndenm = i + 1;

   } else if (shrtlbl.equals("PCHACT")) {
      pchactndenm = i + 1;

   } else if (shrtlbl.equals("PRESCHG")) {
      preschgndenm = i + 1;

   } else if (shrtlbl.equals("KENPCHG")) {
      kenpchgndenm = i + 1;

   } else if (shrtlbl.equals("TANPCHG")) {
      tanpchgndenm = i + 1;

   } else if (shrtlbl.equals("UGAPCHG")) {
      ugapchgndenm = i + 1;

   } else if (shrtlbl.equals("HP")) {
      hpndenm = i + 1;

   } else if (shrtlbl.equals("CP")) {
      cpndenm = i + 1;

   } else if (shrtlbl.equals("INACRP")) {
      inacrpndenm = i + 1;

   } else if (shrtlbl.equals("APG")) {
      apgndenm = i + 1;

   } else if (shrtlbl.equals("PASTRYSZE")) {
      pastryszendenm = i + 1;

   } else if (shrtlbl.equals("VBLCOMB")) {
      vblcombndenm = i + 1;

   } else if (shrtlbl.equals("SMILFRC")) {
      smilfrcndenm = i + 1;

   } else if (shrtlbl.equals("SECONCHG")) {
      seconchgndenm = i + 1;

   } else if (shrtlbl.equals("SMILRCHG")) {
      smilrchgndenm = i + 1;
   }
}

// Check that at least one of these nodes was found.

if (finndenm == 0 && econrndenm == 0 && milrndenm == 0 &&
    milndenm == 0 && sbjctndenm == 0 && vblcombndenm == 0 &&
    smilfrcndenm == 0 && seconchgndenm == 0 && smilrchgndenm == 0) {

   printf_("updateprbs: idname= " + thisidname + " finndenm= " + finndenm
      + " econrndenm= " + econrndenm + " milrndenm= " + milrndenm +
      "\nmilndenm= " + milndenm + " sbjctndenm= " + sbjctndenm);
   iderr_("updateprbs: these node number(s) not found.");
}

// Update the "condprb" array.

if (finndenm > 0) {

   // Delayed Effect node.

   createarray_(finndenm, oldnminactns, 1);

   // Loop over all parameterized actions.

   for (i = 0; i < nmaddedinactns; ++i) {
      actnindx = inactnindex[i];
      sbjctindx = subjectnm[i];

      if (fin[actnindx - 1]) {
         val = 2.;

      } else {
         val = 1.;
      }

      /*
      printf_("updateprbs: nminactns= " + nminactns + " nmvalngh1= " +
	 nmvalngh1 + " i= " + i + " val= " + val);
      */

      Readnet.condprb[idnmbrm1][finndenm - 1][0][i + oldnminactns][0][0][0]
                     [0][0][0] = val; 
   }
}

if (milndenm > 0) {

   // Use of Military Force node.

   createarray_(milndenm, oldnminactns, 1);

   // Loop over all parameterized actions.

   for (i = 0; i < nmaddedinactns; ++i) {
      actnindx = inactnindex[i];
      sbjctindx = subjectnm[i];

      if (milact[actnindx - 1]) {
         val = 2.;

      } else {
         val = 1.;
      }
      Readnet.condprb[idnmbrm1][milndenm - 1][0][i + oldnminactns][0][0][0]
		     [0][0][0] = val; 
   }
}

if (econrndenm > 0 && !phenom_class.equals("NGO")) {
   
   // Economic Resources Change node.

   createarray_(econrndenm, oldnminactns, 3);

   // Loop over all parameterized actions.

   for (i = 0; i < nmaddedinactns; ++i) {
      actnindx = inactnindex[i];
      sbjctindx = subjectnm[i];

      // Load conditional values into "condprb" array.

      for (j = 0; j < nmvalngh2; ++j) {
         for (k = 0; k < nmvalngh3; ++k) {
  
	    if (phenom_class.equals("president") ||
		phenom_class.equals("EPA")) {
	       if (nodelbls[idnmbrm1][finndenm - 1][j + 1].equals(
                      "present") && nodelbls[idnmbrm1][sbjctndenm - 1]
                                            [k + 1].equals(phenom_class)) {
                  val = econrchg[actnindx - 1][sbjctindx - 1];

	       } else {
	          val = 3.;
               }

	    } else if (phenom_class.equals("RR")) {
               if (!nodelbls[idnmbrm1][hpndenm - 1][k + 1].equals("none")) {
		  val = econrchg[actnindx - 1][sbjctindx - 1];

	       } else {
		  val = 3.0;
	       }

	    } else if (phenom_class.equals("pastoralists")) {
               if (!nodelbls[idnmbrm1][cpndenm - 1][k + 1].equals("none")) {
		  val = econrchg[actnindx - 1][sbjctindx - 1];

	       } else {
		  val = 3.0;
	       }

	    }

	    Readnet.condprb[idnmbrm1][econrndenm - 1] [0][i + oldnminactns]
			   [j][k][0][0][0][0] = val; 
         }
      }
   }
}

if (milrndenm > 0) {

   // Militaristic Resources Change node.

   createarray_(milrndenm, oldnminactns, 3);

   // Loop over all parameterized actions.

   for (i = 0; i < nmaddedinactns; ++i) {
      actnindx = inactnindex[i];
      sbjctindx = subjectnm[i];

      // Load conditional values into "condprb" array.

      for (j = 0; j < nmvalngh2; ++j) {
         for (k = 0; k < nmvalngh3; ++k) {
  
            if (nodelbls[idnmbrm1][finndenm - 1][j + 1].equals("present") &&
	        nodelbls[idnmbrm1][sbjctndenm - 1][k + 1].equals(
                   phenom_class)) {
               val = milrchg[actnindx - 1][sbjctindx - 1];

            } else {
	       val = 3.;
            }
	    Readnet.condprb[idnmbrm1][milrndenm - 1] [0][i + oldnminactns]
			   [j][k][0][0][0][0] = val; 
         }
      }
   }
}

if (pchactndenm > 0) {

   // Input action's deterministic poaching characteristic node.

   createarray_(pchactndenm, oldnminactns, 2);

   // Loop over all parameterized actions.

   for (i = 0; i < nmaddedinactns; ++i) {
      actnindx = inactnindex[i];
      sbjctindx = subjectnm[i];

      // Load conditional values into "condprb" array.

      for (j = 0; j < nmvalngh2; ++j) {
         if (nodelbls[idnmbrm1][finndenm - 1][j + 1].equals("present")) {
            val = econrchg[actnindx - 1][sbjctindx - 1];
            if (val > 2.) val = 2.;

         } else {
            val = 1.;
         }
         Readnet.condprb[idnmbrm1][pchactndenm - 1][0][i + oldnminactns]
			[j][0][0][0][0][0] = val;
      }
   }
}

if (preschgndenm > 0) {

   /* President's Attitude Change node.  This is a deterministically
      discrete variable that takes on the values "decreased,"
      "no_change," and "increased." */

   createarray_(preschgndenm, oldnminactns, 1);

   // Loop over all parameterized actions.

   for (i = 0; i < nmaddedinactns; ++i) {
      actnindx = inactnindex[i];
      sbjctindx = subjectnm[i];

      // Load conditional value into "condprb" array.

      val = milrchg[actnindx - 1][sbjctindx - 1];

      // Convert to a 3-value scale.

      if (val <= 2.) {
	 val = 1.;
      
      } else if (Math.abs(val - 3.) < 1.e-6) {
	 val = 2.;

      } else {
	 val = 3.;
      }
      Readnet.condprb[idnmbrm1][preschgndenm - 1][0][i + oldnminactns]
		     [0][0][0][0][0][0] = val;
   }
}

if (kenpchgndenm > 0) {

   /* Kenya president's Attitude Change node.  This is a
      deterministically discrete variable that takes on the values
      "decreased," "no_change," and "increased." */

   createarray_(kenpchgndenm, oldnminactns, 1);

   // Loop over all parameterized actions.

   for (i = 0; i < nmaddedinactns; ++i) {
      actnindx = inactnindex[i];
      sbjctindx = subjectnm[i];

      // Load conditional value into "condprb" array.

      val = milrchg[actnindx - 1][sbjctindx - 1];
      Readnet.condprb[idnmbrm1][kenpchgndenm - 1][0][i + oldnminactns]
		     [0][0][0][0][0][0] = val;
   }
}

if (tanpchgndenm > 0) {

   /* Tanzania president's Attitude Change node.  This is a
      deterministically discrete variable that takes on the values
      "decreased," "no_change," and "increased." */

   createarray_(tanpchgndenm, oldnminactns, 1);

   // Loop over all parameterized actions.

   for (i = 0; i < nmaddedinactns; ++i) {
      actnindx = inactnindex[i];
      sbjctindx = subjectnm[i];
   
      // Load conditional value into "condprb" array.

      val = milrchg[actnindx - 1][sbjctindx - 1];
      Readnet.condprb[idnmbrm1][tanpchgndenm - 1][0][i + oldnminactns]
		     [0][0][0][0][0][0] = val;
   }
}

if (ugapchgndenm > 0) {

   /* Uganda president's Attitude Change node.  This is a deterministically
      discrete variable that takes on the value "decreased," "no_change,"
      and "increased." */

   createarray_(ugapchgndenm, oldnminactns, 1);

   // Loop over all parameterized actions.

   for (i = 0; i < nmaddedinactns; ++i) {
      actnindx = inactnindex[i];
      sbjctindx = subjectnm[i];

      // Load conditional value into "condprb" array.

      val = milrchg[actnindx - 1][sbjctindx - 1];
      Readnet.condprb[idnmbrm1][ugapchgndenm - 1][0][i + oldnminactns]
		     [0][0][0][0][0][0] = val;
   }
}

if (apgndenm > 0) {

   /* Avoid Prosecution Goal node.  This is a discrete r.v. that takes
      on the values "not_satisfied" and "satisfied." */

   createarray_(apgndenm, oldnminactns, 2);

   // Loop over all parameterized actions.

   for (i = 0; i < nmaddedinactns; ++i) {
      actnindx = inactnindex[i];
      sbjctindx = subjectnm[i];

      // Load conditional value into "condprb" array.

      for (j = 0; j < nmvalngh2; ++j) {
         if (nodelbls[idnmbrm1][inacrpndenm - 1][j].equals("more")) {
            val = milrchg[actnindx - 1][sbjctindx - 1];

         } else {
	    val = 3.;
         }
         Readnet.condprb[idnmbrm1][apgndenm - 1][0][i + oldnminactns]
			[j][0][0][0][0][0] = .9 - .2 * (val - 1.);
      }
   }
}

if (pastryszendenm > 0) {

   /* Pastoralist's Territory Size.  This is a discrete r.v. that takes
      on the values "inadequate" and "adequate." */
   
   createarray_(pastryszendenm, oldnminactns, 2);

   // Loop over all parameterized actions.

   for (i = 0; i < nmaddedinactns; ++i) {
      actnindx = inactnindex[i];
      sbjctindx = subjectnm[i];

      // Load conditional values into "condprb" array.

      for (j = 0; j < nmvalngh2; ++j) {
         if (nodelbls[idnmbrm1][finndenm - 1][j + 1].equals("present")) {
            val = econrchg[actnindx - 1][sbjctindx - 1];
      
         } else {
            val = 3.;
         }
         Readnet.condprb[idnmbrm1][pastryszendenm - 1][0][i + oldnminactns]
			[j][0][0][0][0][0] = .9 - .2 * (val - 1.);

         Readnet.condprb[idnmbrm1][pastryszendenm - 1][1][i + oldnminactns]
			[j][0][0][0][0][0]
            = 1. - Readnet.condprb[idnmbrm1][pastryszendenm - 1][0]
				  [i + oldnminactns][j][0][0][0][0][0];
      }
   }
}

// Output action processing.

if (vblcombndenm > 0) {

   // Viable Combination node

   createarray_(vblcombndenm, oldnmoutactns, 2);

   // Loop over all parameterized actions.

   for (i = 0; i < nmaddedoutactns; ++i) {
      actnindx = outactnindex[i];
      actorindx = actornm[i];

      // Load conditional values into "condprb" array.

      for (j = 0; j < nmvalngh2; ++j) {
         val = 1.;
         Readnet.condprb[idnmbrm1][vblcombndenm - 1][0][i + oldnmoutactns]
			[j][0][0][0][0][0] = val;
      }
   }
}

if (smilfrcndenm > 0) {

   // Scenario Military Force node

   createarray_(smilfrcndenm, oldnmoutactns, 1);

   // Loop over all parameterized actions.

   for (i = 0; i < nmaddedoutactns; ++i) {
      actnindx = outactnindex[i];
      actorindx = actornm[i];

      if (milact[actnindx - 1]) {
         val = 2.;

      } else {
         val = 1.;
      }
      Readnet.condprb[idnmbrm1][smilfrcndenm - 1][0][i + oldnmoutactns]
		     [0][0][0][0][0][0] = val; 
   }
}

if (seconchgndenm > 0) {

   // Scenario Economic Resources Change node

   createarray_(seconchgndenm, oldnmoutactns, 1);

   // Loop over all parameterized actions.

   for (i = 0; i < nmaddedoutactns; ++i) {
      actnindx = outactnindex[i];
      actorindx = actornm[i];
      val = econrchg[actnindx - 1][actorindx - 1];
      Readnet.condprb[idnmbrm1][seconchgndenm - 1][0][i + oldnmoutactns]
		     [0][0][0][0][0][0] = val; 
   }
}

if (smilrchgndenm > 0) {

   // Scenario Military Resources Change node

   createarray_(smilrchgndenm, oldnmoutactns, 2);

   // Loop over all parameterized actions.

   for (i = 0; i < nmaddedoutactns; ++i) {
      actnindx = outactnindex[i];
      actorindx = actornm[i];

      // Load conditional values into "condprb" array.

      for (j = 0; j < nmvalngh2; ++j) {
         val = milrchg[actnindx - 1][actorindx - 1];
         Readnet.condprb[idnmbrm1][smilrchgndenm - 1][0][i + oldnmoutactns]
			[j][0][0][0][0][0] = val;
      }
   }
}
}

// ---------------------------------------------------------------------

static void createarray_(int nodenm, int oldnmngh1vals, int nmparents) {

// Stores old values in "condprb" array and then creates a new one.

int i, i1, j, k;

nmvals = nodenghs[idnmbrm1][nodenm - 1][0];
ngh1 = nodenghs[idnmbrm1][nodenm - 1][2];
nmvalngh1 = nodenghs[idnmbrm1][ngh1 - 1][0];

if (nmparents >= 2) {
   ngh2 = nodenghs[idnmbrm1][nodenm - 1][3];
   nmvalngh2 = nodenghs[idnmbrm1][ngh2 - 1][0];

   if (nmparents == 3) {
      ngh3 = nodenghs[idnmbrm1][nodenm - 1][4];
      nmvalngh3 = nodenghs[idnmbrm1][ngh3 - 1][0];

   } else {
      nmvalngh3 = 1;
   }

} else {
   nmvalngh2 = 1;
   nmvalngh3 = 1;
}

// Store old array.

for (i = 0; i < nmvals; ++i) {
   for (j = 0; j < oldnmngh1vals; ++j) {
      for (k = 0; k < nmvalngh2; ++k) {
         for (i1 = 0; i1 < nmvalngh3; ++i1) {
	    oldarray[i][j][k][i1] = condprb[idnmbrm1][nodenm - 1]
					   [i][j][k][i1][0][0][0][0];
         }
      }
   }
}

// Create the "condprb" array component.

/*
printf_("updateprbs: nmvals= " + nmvals + " nmvalngh1= " +
   nmvalngh1 + " nmvalngh2= " + nmvalngh2 + " nmvalngh3= " + nmvalngh3);
*/

Readnet.condprb[idnmbrm1][nodenm - 1] =
   new double[nmvals][nmvalngh1][nmvalngh2][nmvalngh3][1][1][1][2];

// Load old array into the new one.

for (i = 0; i < nmvals; ++i) {
   for (j = 0; j < oldnmngh1vals; ++j) {
      for (k = 0; k < nmvalngh2; ++k) {
         for (i1 = 0; i1 < nmvalngh3; ++i1) {
	    condprb[idnmbrm1][nodenm - 1][i][j][k][i1][0][0][0][0] =
	       oldarray[i][j][k][i1];
         }
      }
   }
}
}
}
