class Idsort extends Surf {
static boolean giveup = false;
static int l, u, rp, pl, msh = SORTSZE, sp = 0, size = 0;
static int save1[] = new int[SORTSZE];
static int save2[] = new int[SORTSZE];
static int save3[] = new int[SORTSZE];
static int saver[] = new int[SORTSZE];

// ----------------------------------------------------------------------

static int idsort_(double t[], int indx[], int lower, int upper) {
 
/* Quick sort routine, sorts t in ascending order and places the new indx
   in indx.  Adapted from J. L. Wagener, FORTRAN77 Principles of Programming,
   p. 241.  For routine ``stack,'' the last argument is for the direction of
   the stack operation, 1 means push, 2 means pop. */

int i, nmloops = 0;

// Bounds check: u - l <= SORTSZE, the stack size.

if (upper - lower > SORTSZE) {
   iderr_("idsort: u= " + upper + " l= " + lower + " u-l= " +
      (upper - lower) + "array too big.");
}

l = lower;
u = upper;
size = upper - lower + 1;

rp = 3;
pl = 0;
stack_(1);
if (giveup) {
   return 1;
}

l10: for (;;) {
   if (u > l) {
      if (partit_(t, indx) == 1) {
	 return 1;
      }
      rp = 1;
      stack_(1);
      if (giveup) {
	 return 1;
      }
      u = pl - 1;
      continue l10;
   }
   for (;;) {
      stack_(2);
      if (giveup) {
	 return 1;
      }
      ++nmloops;

      if (rp == 1) {
         rp = 2;
         stack_(1);
         if (giveup) {
	    return 1;
	 }
         l = pl + 1;
	 continue l10;

      } else if (rp == 2) {
	 continue;

      } else {
	 break l10;
      }
   }
}
if (rp != 3) {
   iderr_("rp not 3 in idsort_()");
}

return 0;
}

// -------------------------------------------------------------------

static int partit_(double t[], int indx[]) {

// Partitions t and indx based on t.
 
int j, itemp;
double temp;

j = l + 1;
pl = u;

for (;;) {

   for (;;) {
      if (j > u) {
	 return 1;
      }
      if (t[j-1] > t[l-1] || j >= pl) {
	 break;
      }
      ++j;
   }

   for (;;) {
      if (pl < l) {
	 return 1;
      }
      if (t[pl-1] <= t[l-1]) {
	 break;
      }
      --pl;
   }

   if (pl <= j) {
      break;
   }
   temp = t[j-1];
   itemp = indx[j-1];

   t[j-1] = t[pl-1];
   indx[j-1] = indx[pl-1];

   t[pl-1] = temp;
   indx[pl-1] = itemp;
   ++j;
   --pl;
   if (j > u || pl < l) {
      return 1;
   }
}

temp = t[l-1];
itemp = indx[l-1];

t[l-1] = t[pl-1];
indx[l-1] = indx[pl-1];

t[pl-1] = temp;
indx[pl-1] = itemp;

return 0;
}

// -------------------------------------------------------------------

static void stack_(int call) {

/* msh must be less than the declared dimension of save1, etc..
   call = 1 means push, call = 2 means pop */

//  push entry point.
 
if (call == 1) {
   ++sp;
   if (sp > msh) {
      giveup = true;
      iderr_("idsort: sp= " + sp + " msh= " + msh + " size= " + size +
	 ", stack overflow.");
      return;
   }
   save1[sp-1] = l;
   save2[sp-1] = u;
   save3[sp-1] = pl;
   saver[sp-1] = rp;
   return;
}
 
// pop entry point.
 
else if (call == 2) {
   l=save1[sp-1];
   u=save2[sp-1];
   pl=save3[sp-1];
   rp=saver[sp-1];
   --sp;
}
}

// ---------------------------------------------------------------------

static void secsort_() {

// Sorts the dat2 structure primarily by time and secondarily by x.

int i, i1, l, u, inti;
int indx[] = new int[SORTSZE];
int vsrt[] = new int[SORTSZE];
double xsrt[] = new double[SORTSZE];
double ysrt[] = new double[SORTSZE];
double tsrt[] = new double[SORTSZE];
double datsrt[] = new double[SORTSZE];
double quantsrt[][] = new double[SORTSZE][NMQUANT];
int qualsrt[][] = new int[SORTSZE][NMQUAL];

// First sort by time.

for (i = 0; i < nmecoobsttl; ++i) {
   xsrt[i] = dat2_x[i];
   ysrt[i] = dat2_y[i];
   tsrt[i] = dat2_t[i];
   vsrt[i] = dat2_vrble[1][i];
   for (i1 = 0; i1 < nmquantvar; ++i1) {
      quantsrt[i][i1] = dat2_quantval[i][i1];
   }
   for (i1 = 0; i1 < nmqualvar; ++i1) {
      qualsrt[i][i1] = dat2_qualval[i][i1];
   }
   datsrt[i] = dat2_dat[i];
   indx[i] = i;
}

idsort_(tsrt, indx, 1, nmecoobsttl);

for (i = 0; i < nmecoobsttl; ++i) {
   inti = indx[i];
   dat2_x[i] = xsrt[inti];
   dat2_y[i] = ysrt[inti];
   dat2_t[i] = tsrt[i];
   dat2_vrble[1][i] = vsrt[inti];
   for (i1 = 0; i1 < nmquantvar; ++i1) {
      dat2_quantval[i][i1] = quantsrt[inti][i1];
   }
   for (i1 = 0; i1 < nmqualvar; ++i1) {
      dat2_qualval[i][i1] = qualsrt[inti][i1];
   }
   dat2_dat[i] = datsrt[inti];
}

// Secondary sort by x coordinate.

l = 1;
u = 1;
for (;;) {

   // Search for a change in the time value.

   do {
      ++u;
      if (u > nmecoobsttl) {
         break;
      }
   } while(dat2_t[u-1] - dat2_t[u-2] < .0001);
   --u;

   // Now sort this subset of dat2 that have the same time value.

   for (i = l - 1; i < u; ++i) {
      xsrt[i] = dat2_x[i];
      ysrt[i] = dat2_y[i];
      tsrt[i] = dat2_t[i];
      vsrt[i] = dat2_vrble[1][i];
      for (i1 = 0; i1 < nmquantvar; ++i1) {
         quantsrt[i][i1] = dat2_quantval[i][i1];
      }
      for (i1 = 0; i1 < nmqualvar; ++i1) {
	 qualsrt[i][i1] = dat2_qualval[i][i1];
      }
      datsrt[i] = dat2_dat[i];
      indx[i] = i;
   }
   idsort_(xsrt, indx, l, u);

   for (i = l - 1; i < u; ++i) {
      inti = indx[i];
      dat2_x[i] = xsrt[i];
      dat2_y[i] = ysrt[inti];
      dat2_t[i] = tsrt[inti];
      dat2_vrble[1][i] = vsrt[inti];
      for (i1 = 0; i1 < nmquantvar; ++i1) {
         dat2_quantval[i][i1] = quantsrt[inti][i1];
      }
      for (i1 = 0; i1 < nmqualvar; ++i1) {
         dat2_qualval[i][i1] = qualsrt[inti][i1];
      }
      dat2_dat[i] = datsrt[inti];
   }
   if (u == nmecoobsttl) {
      break;
   
   } else if (u > nmecoobsttl) {
      iderr_("nmecoobsttl= " + nmecoobsttl + " mistake in secsort_().");
   }
   ++u;
   l = u;
}
}
}
