class Stwrite extends Predict {
static double empcorr[][] = new double[2][2];

// -------------------------------------------------------------------

static void stwrite_(int jrow, int jcol, int jtime, double xcord,
   double ycord, double tmecord, int option, boolean estonly) {
 
// Calculates relative error and writes output files.

int i, j, k, vrble = 0, ndenm = 0;

double relerr = 0., stdres = 0., ciwidth = 0., thres, datum = 0.,
   mdlcorr, obsval = 0., stderr = 0., kernel, krnlsum, denom, residl = 0.;

String esttype;

/* Define contamination threshold, write flag for the second output file,
   and kernel component start and end indices. */

thres = 3.91;
if (wflag) {
   wflag2 = true;
}

// Write estimation in 80 column format.
 
if (wflag) {
   if (icrval == 1 && !estonly) {
      obsval = dat2_dat[idatcr - 1];
      ndenm = lomapnms[dat2_vrble[1][idatcr - 1] - 1];
      fprintf_(1, "Observed value= " + fdble_(obsval, 5, 3) +
         " on variable " + nodelbls[idnmbrm1][ndenm - 1][0]);
   }
   fprintf_(1, "row= " + jrow + " col= " + jcol + " xcord= " +
      fdble_(xcord, 8, 3) + " ycord= " + fdble_(ycord, 8, 3) +
      " tmecord= " + fdble_(tmecord, 8, 3) + " iblank= " + iblank);
   strng= " cond= " + fdble_(cond, 10, 3) + " nd= " + nd;
   for (i = 0; i < parm_mvar; ++i) {
      strng += " v(" + lomapnms[i] + ")c= " + nmcylobs[i];
   }
   fprintf_(1, strng);
}

/* For a bivariate analysis, compute empirical and model-based zero
   spatio-temporal lag correlations. */

if (parm_mvar == 2 && iblank == 0) {
   if (temporal && gama_nc[0][0][kmaxt][2] > 0) {
      empcorr[0][0] = gama_g[0][0][kmaxt][2];
   
   } else if (gama_nc[0][0][0][2] > 0) {
      empcorr[0][0] = gama_g[0][0][0][2];

   } else {
      empcorr[0][0] = 0.;
   }

   if (varmod_smplvr[0] > 1.e-10 && varmod_smplvr[1] > 1.e-10) {
      empcorr[0][0] /= Math.sqrt(varmod_smplvr[0]) *
		       Math.sqrt(varmod_smplvr[1]);

      if (spatial && !temporal) {
	 empcorr[1][0] = gama_g[1][0][0][2] /
            Math.sqrt(varmod_smplvr[0]) * Math.sqrt(varmod_smplvr[1]);
	 if (empcorr[1][0] < -1.e10) empcorr[1][0] = 0.;
      }
      if (spatial && temporal) {
	 empcorr[1][0] = gama_g[1][0][kmaxt][2] /
            Math.sqrt(varmod_smplvr[0]) * Math.sqrt(varmod_smplvr[1]);
	 empcorr[0][1] = gama_g[0][0][kmaxt + 1][2] /
            Math.sqrt(varmod_smplvr[0]) * Math.sqrt(varmod_smplvr[1]);

	 if (empcorr[1][0] < -1.e10) {
	    empcorr[1][0] = 0.;
	 }
	 if (empcorr[0][1] < -1.e10) {
	    empcorr[0][1] = 0.;
	 }
      }

   } else {
      empcorr[0][0] = 0.;
   }
   mdlcorr = Covmodl.sttnrycov_(0., 0., 3) /
             (Math.sqrt(Covmodl.sttnrycov_(0., 0., 1)) *
              Math.sqrt(Covmodl.sttnrycov_(0., 0., 2)));

} else {
   empcorr[0][0] = 0.;
   mdlcorr = empcorr[0][0];
}

/* Write estimated variogram model(s) and optionally, trend model
   parameters. */

if (wflag) {
   if (Estimate.local) {
      fprintf_(1, "Covariogram matrix estimation ifail= " + varmod_ifail);
      for (i = 0; i < parm_mvar; ++i) {
         fprintf_(1, "Var. " + (i + 1) + ": Smplvr= " +
            fdble_(varmod_smplvr[i], 9, 4) +
	    " Cylinder radius= " + fdble_(varmod_radius[i], 9, 4));
      }
      if (parm_mvar == 2) {
         fprintf_(1, "sample corr_12(slag=0,tlag=0)= " +
            fdble_(empcorr[0][0], 9, 4) + " model corr_12(0,0)= " +
	    fdble_(mdlcorr, 9, 4));

	 /*
         if (spatial && !temporal) {
	    fprintf_(1, "empcorr(slag=1,tlag=0)= " +
               fdble_(empcorr[1][0], 9, 4));
         }

         if (spatial && temporal) {
	    fprintf_(1, "empcorr(slag=1,tlag=0)= " +
               fdble_(empcorr[1][0], 9, 4) + " empcorr(0,1)= " +
	       fdble_(empcorr[0][1], 9, 4));
         }
         */
      }
   }

   fprintf_(1, " Fitted Covariogram Matrix Model(s)" + "\n   " +
      "Model         Nugget   Sill   Spatial Range    Temporal Range");
   for (i = krnlstart; i <= krnlend; ++i) {
      if (i > 0) {
         fprintf_(1, "Kernel " + i); 
      }
      for (j = 0; j < nmmdls; ++j) {
         fprintf_(1, Vargrm.vnames[j] + " cov " +
            fdble_(varmod_nugget[i][j], 9, 4) + " " +
	    fdble_(varmod_sill[i][j], 9, 4) + " " +
            fdble_(varmod_range[i][0][j], 9, 4) + "      " +
            fdble_(varmod_range[i][1][j], 9, 4));

         if (lngmem && j < parm_mvar) {
	    fprintf_(1, "Var " + (j + 1) +
               ": lma= " + fdble_(varmod_lma[j], 9, 4) +
	       " lmb= " + fdble_(varmod_lmb[j], 9, 4) +
               " lmc= " + fdble_(varmod_lmc[j], 9, 4) +
	       " lmax/c(0)= " + fdble_(varmod_lma[j] /
               (varmod_nugget[0][j] + varmod_sill[0][j] +
                varmod_lma[j]), 9, 4));
	 }

         if (j >= parm_mvar && varmod_model[nmmdls - 1] == 3) {
            fprintf_(1, "Odd:             " +
               fdble_(varmod_oddnug[0][j], 9, 4) +
               "    " + fdble_(varmod_oddsill[0][j], 9, 4) +
               "               " + fdble_(varmod_oddrnge[0][j], 9, 4));
         }
      }
   }

   if (covnonstatmdl == 1) {
      fprintf_(1, "nonstat0,1,2: " +
         fdble_(varmod_nonstat[0], 9, 4) + " " +
         fdble_(varmod_nonstat[1], 9, 4) + " " +
         fdble_(varmod_nonstat[2], 9, 4));
   }

   // Trend parameter printing.

   if (itrend > 0 && itrend < 11) {
      fprintf_(1,"\n----------------------------------------------" +
         "\n  Trend Coefficient     Estimated Value");
      for (i = 0; i < parm_mvar; ++i) {
         for (j = 0; j < nmpars[i]; ++j) {
            fprintf_(1, " " + fstrng_(coeffname[j], 14) + "   " +
	       fdble_(grdvar_rparm[i][j], 9, 4));
	 }
      }

   } else if (itrend == 11) {
      fprintf_(1,"\n----------------------------------------------" +
         "trend= " + fdble_(trend[0], 9, 4) +
         " minimum fp= " + fdble_(fpmin, 9, 4));
      if (frstfit) {
         fprintf_(1, "Trend Parameter number    Estimated Value");
         for (i = 0; i < nmpars[0] - 6; ++i) {
            fprintf_(1, i + " " + fdble_(grdvar_rparm[0][i], 9, 4));
         }
	 frstfit = false;
      }
   }
}

// Return if only estimating model parameters.

if (estonly) {
   return;
}

// If prediction was successful, write result.

if (iblank == 0) {

   // Figure out prediction type.

   esttype = "Krg_est";
   if (parm_mvar > 1) {
      esttype = "Cokrg_est";
   }

   /* Calculate coefficient of variation (relative error) and standardized
      residual.  Print these along with prediction and prediction variance.
   */

   if (itrend != 3) {
      if (wflag) {
	 fprintf_(1, "-- Variable  Prediction  Error_Variance " +
                             " Rel_Error  Std_Residual  Residual --");
      }
      for (j = 0; j < parm_mvar; ++j) {
         if (krgvar[j] > 0. && prdest[j] > 0.) {
            stderr = Math.sqrt(krgvar[j]);
            relerr = stderr / prdest[j];
            stdres = (obsval - prdest[j]) / stderr;
            residl = obsval - prdest[j];

         } else {
            relerr = 0.;
            stdres = 0.;
         }
         if (wflag) {
            if (j == 0) {
               fprintf_(1, Vargrm.vnames[j] +
                  " " + fdble_(prdest[j], 9, 4) +
	          " " + fdble_(krgvar[j], 10, 5) +
	          " " + fdble_(relerr, 9, 4) +
	          " " + fdble_(stdres, 9, 4) +
		  " " + fdble_(residl, 9, 4));
           
            } else {
               fprintf_(1, Vargrm.vnames[j] +
                  " " + fdble_(prdest[j], 9, 4) +
	          " " + fdble_(krgvar[j], 10, 5) +
	          " " + fdble_(relerr, 9, 4));
            }
         }
      }

   } else if (wflag) {
      fprintf_(1, "lnest= " + fdble_(prdest[spacetime_surfvar - 1], 9, 4) +
         " lnkrgvar= " + fdble_(krgvar[spacetime_surfvar - 1], 9, 4) +
         " lnlower= " + fdble_(lower[spacetime_surfvar - 1], 9, 4) +
         " lnupper= " + fdble_(upper[spacetime_surfvar - 1], 9, 4));
   }

   if (icrval == 0) {
      ciwidth = upper[spacetime_surfvar- 1] - lower[spacetime_surfvar - 1];

   } else {
      ciwidth = 0.;
   }

   // Sum cylinder radii.

   bdry_meanrad[0] += varmod_radius[0];

   /* Search for min and max of cylinder radius, estimate, kriging variance,
      relative error, ci width, cylinder radius, nugget, and sill. */

   if (varmod_radius[0] < bdry_minrad[0]) bdry_minrad[0] = varmod_radius[0];
   if (varmod_radius[0] > bdry_maxrad[0]) bdry_maxrad[0] = varmod_radius[0];

   if (prdest[0] <= bdry_predmin[0]) {
      bdry_predmin[0] = prdest[0];
   }
   if (prdest[0] > bdry_predmax[0]) {
      bdry_predmax[0] = prdest[0];
   }
   if (krgvar[0] <= bdry_kvarmin[0]) {
      bdry_kvarmin[0] = krgvar[0];
   }
   if (krgvar[0] > bdry_kvarmax[0]) {
      bdry_kvarmax[0] = krgvar[0];
   }
   if (relerr <= bdry_cvmin[0]) bdry_cvmin[0] = relerr;
   if (relerr > bdry_cvmax[0]) bdry_cvmax[0] = relerr;

   if (ciwidth <= bdry_cimin[0]) bdry_cimin[0] = ciwidth;
   if (ciwidth > bdry_cimin[0]) bdry_cimax[0] = ciwidth;

   if (grdvar_nug[jrow - 1][jcol - 1][0][0] < bdry_nugmin[0]) {
      bdry_nugmin[0] = grdvar_nug[jrow - 1][jcol - 1][0][0];
   }

   if (grdvar_nug[jrow - 1][jcol - 1][0][0] > bdry_nugmax[0]) {
      bdry_nugmax[0] = grdvar_nug[jrow - 1][jcol - 1][0][0];
   }

   if (grdvar_sill[jrow - 1][jcol - 1][0][0] < bdry_sillmin[0]) {
      bdry_sillmin[0] = grdvar_sill[jrow - 1][jcol - 1][0][0];
   }

   if (grdvar_sill[jrow - 1][jcol - 1][0][0] > bdry_sillmax[0]) {
      bdry_sillmax[0] = grdvar_sill[jrow - 1][jcol - 1][0][0];
   }

} else if (iblank != 0) {

   // If estimation was unsuccessful, set zeroes.

   relerr = 0.;
   ciwidth = 0.;
}

if (wflag) {

   // Space to separate estimates.

   fprintf_(1, " ");
}

// Write intermediate file of kriging prediction and standard error estimates.
 
if (icrval != 1) {
   fprintf_(5, xcord + " " + ycord + " " + iblank + " " +
      prdest[spacetime_surfvar - 1] + " " +  krgvar[spacetime_surfvar - 1] +
      " " + relerr + " " + ciwidth);

} else if (icrval == 1) {
   ndenm = dat2_vrble[1][idatcr - 1];
   fprintf_(5, dat2_vrble[1][idatcr - 1] + " " + xcord + " " + ycord + " " +
      iblank + " " + obsval + " " + prdest[ndenm - 1] + " " +
      krgvar[ndenm - 1] + " " + relerr + " " + ciwidth);
}

if (wflag2) {

   // Write second output file.

   if (icrval != 1) {
      datum = 0.;
      vrble = 1;

   } else if (icrval == 1) {
      datum = obsval;
      vrble = dat2_vrble[1][idatcr - 1];
   }

   if (!temporal) {
      fprintf_(6, vrble + " " + xcord + " " + ycord + " " + tmecord);
      fprintf_(6, datum + " " + prdest[vrble - 1] + " " +
         Math.sqrt(krgvar[vrble - 1]) + " " +
	 varmod_nugget[0][0] + " " + varmod_sill[0][0] + " " +
	 varmod_range[0][0][0]);

   } else if (temporal) {
      fprintf_(6, vrble + " " + xcord + " " + ycord + " " + tmecord);
      fprintf_(6, datum + " " + prdest[vrble - 1] + " " +
         Math.sqrt(krgvar[vrble - 1]) + " " +
         varmod_nugget[0][0] + " " + varmod_sill[0][0] + " " +
         varmod_range[0][0][0] + " " + varmod_range[0][1][0] + " " +
         varmod_nugget[0][1] + " " + varmod_sill[0][1] + " " +
         varmod_range[0][0][1] + " " + varmod_range[0][1][1]);
         // + condmean + " " + condvar + " 0.");
         // 1. - cump_((thres - condmean) / Math.sqrt(condvar)));
   }
}

// Store this grid point's location and estimated parameters.

grdvar_x[jrow - 1][jcol - 1][jtime - 1] = xcord;
grdvar_y[jrow - 1][jcol - 1][jtime - 1] = ycord;
grdvar_t[jrow - 1][jcol - 1][jtime - 1] = tmecord;
grdvar_iblank[jrow - 1][jcol - 1][jtime - 1] = iblank;
grdvar_krgvar[jrow - 1][jcol - 1][jtime - 1] = krgvar[0];

for (j = 0; j < parm_mvar; ++j) {
   grdvar_trend[jrow - 1][jcol - 1][jtime - 1][j] = trend[j];
   grdvar_est[jrow - 1][jcol - 1][jtime - 1][j] = prdest[j];
}

for (j = 0; j < nmmdls; ++j) {
      grdvar_nug[jrow - 1][jcol - 1][jtime - 1][j] = varmod_nugget[0][j];
      grdvar_sill[jrow - 1][jcol - 1][jtime - 1][j] = varmod_sill[0][j];
      grdvar_rnge[jrow - 1][jcol - 1][jtime - 1][0][j] =
	 varmod_range[0][0][j];
      grdvar_rnge[jrow - 1][jcol - 1][jtime - 1][1][j] =
	 varmod_range[0][1][j];
}

// Return if doing cross-validation.

if (icrval == 1) {
   return;
}

/* Surface plot calculations and storage.

   temporal, mvar=1: grdvar_nug[0] contains (beta_t * t) / trend.

   mvar == 2: grdvar_nug[0] contains empcorr,
	      grdrvar_sill[0] contain mdlcorr. */

if (option == 0 && iblank == 0) {
   if (temporal && parm_mvar == 1) {
      if (grdvar_trend[jrow - 1][jcol - 1][jtime - 1][0] < 1.e-6) {
	 grdvar_nug[jrow - 1][jcol - 1][jtime - 1][0] = 0.;

      } else {
         grdvar_nug[jrow - 1][jcol - 1][jtime - 1][0] =
	    grdvar_rparm[0][6] * tmecord /
	    grdvar_trend[jrow - 1][jcol - 1][jtime - 1][0];
      }

   } else if (parm_mvar == 2) {
      grdvar_nug[jrow - 1][jcol - 1][jtime - 1][0] = empcorr[0][0];
      if (nmstmixcntr == 0) {
         grdvar_sill[jrow - 1][jcol - 1][jtime - 1][0] = mdlcorr;

      } else {
         krnlsum = 0.;
         mdlcorr = 0.;
         for (j = 1; j <= nmstmixcntr; ++j) {
            kernel = Trendeval.mixkernel_(j, xcord, ycord, tmecord);
            krnlsum += kernel;
      
            for (i = 0; i < nmmdls; ++i) {
               varmod_nugget[0][i] = varmod_nugget[j][i];
               varmod_sill[0][i] = varmod_sill[j][i];
               varmod_range[0][0][i] = varmod_range[j][0][i];
               varmod_range[0][1][i] = varmod_range[j][1][i];
            }
            denom = Math.sqrt(Covmodl.sttnrycov_(0., 0., 1) *
                              Covmodl.sttnrycov_(0., 0., 2));
            if (denom > 0.) {
               mdlcorr += kernel * Covmodl.sttnrycov_(0., 0., 3) /
                                           denom;
            }
         }
         mdlcorr /= krnlsum;
         grdvar_sill[jrow-1][jcol-1][jtime-1][0] = mdlcorr;
      }
   }
}

/* Find V_c, V_m, and V_r (for Coen van Tooren) for this point.
if (option == 2) {
   prdest[0] = grdvar_trend[jrow - 1][jcol - 1][jtime - 1][0];
}
grdvar_vm = 0.;
grdvar_vr = 0.;
if (iblank == 0 && condvar > 1.e-30) {
   if (prdest[lomapnms[0] - 1] > thres) {
      grdvar_vm[jrow - 1][jcol - 1][jtime - 1] =
	 cump_((thres - condmean) / Math.sqrt(condvar));

   } else {
      grdvar_vr[jrow - 1][jcol - 1][jtime - 1] =
	 1. - cump_((thres - condmean) / Math.sqrt(condvar));
   }
}
*/

}
}
