import java.util.*;
import java.io.*;

// ----------------------------------------------------------------------

public class Storyutils extends Storyparse {

static boolean acquiredemat = false, createnew = false, endstudent = false;

static String ematfle;

static String wordvec[] = new String[NMWRDS];
static String commonword[] = {"the", "a", "of", "is", "by", "to", "be",
                              "from", "and", "have", "in", "that", "on",
			      "with", "as", "at", "inside"};

static String irrelevantword[] = {"content", "copyright", "stylesheet",
                                  "subscribe", "subscription", "login",
				  "header", "sidebar", "wrapper", "label",
                                  "navigation", "class", "column", "http:",
                                  "republish", "div"};

static String conjugform[] = new String[3];

static int nmwords, nmcommonwords = 17, nmirrelevantwords = 15,
   checkstorynm = 0;

// --------------------------------------------------------------------

static void readematfle_() {

// Reads the EMAT file.

String strng1, dumstrng;

int i;

if (acquiredemat) {
   return;
}

fleopen_(2, ematfle, 'r');

// Skip over header comments.

do {
   strng1 = fgetstrng_(2);

   if (!fle_ready_(2)) {
      iderr_("readematfle: hit EOF reading EMAT file.");
   }
} while (!strng1.equals("Begin_EMAT_Codes"));

/* Read EMAT codes and codes that indicate sets of archetypal actors
   and subjects. */

while (fle_ready_(2) && !checkeof_(2)) {
   strng1 = fgetstrng_(2);
   if (strng1.equals("begincomment")) {
      while (!strng1.equals("endcomment")) {
         strng1 = fgetstrng_(2);
	 if (!fle_ready_(2)) {
            iderr_("readematfle: hit EOF reading actions database file.");
         }
      }
      strng1 = fgetstrng_(2);
   }
   emataction[nmematcodes] = strng1;
   ematcode[nmematcodes] = fgetstrng_(2);

   archactorscode[nmematcodes] = fgetstrng_(2);
   archsubjectscode[nmematcodes] = fgetstrng_(2);

   // Trim front and back whitespace and convert to lowercase.

   dumstrng = emataction[nmematcodes].toLowerCase();
   emataction[nmematcodes] = dumstrng.trim();

   // Get rid of "[...]" substrings.

   dumstrng = emataction[nmematcodes].replaceAll("\\[.*?\\]","");
   emataction[nmematcodes] = dumstrng;

   if (emataction[nmematcodes].length() < 3) {
      iderr_("readematfle: nmematcodes= " + nmematcodes + " action= " +
         emataction[nmematcodes]);
   }

   dumstrng = ematcode[nmematcodes].toLowerCase();
   ematcode[nmematcodes] = dumstrng.trim();

   ++nmematcodes;
   if (nmematcodes >= MAXNMEMAT) {
      iderr_("readematfle: MAXNMEMAT exceeded");
   }
}
fclose_(2, 'r');

/* Interpret archetypal actor and subject sets.  Set action plotting
   symbols. */

for (i = 0; i < nmematcodes; ++i) {

   // Actors.
   
   if (archactorscode[i].equals("A")) {
      archetypal_actor[i][0] = "president";
      nmarchactors[i] = 1;
      actorplotsymbol[i] = 'p';

   } else if (archactorscode[i].equals("B")) {
      archetypal_actor[i][0] = "EPA";
      nmarchactors[i] = 1;
      actorplotsymbol[i] = 'a';

   } else if (archactorscode[i].equals("C")) {
      archetypal_actor[i][0] = "president";
      archetypal_actor[i][1] = "EPA";
      nmarchactors[i] = 2;
      actorplotsymbol[i] = 'a';

   } else if (archactorscode[i].equals("D")) {
      archetypal_actor[i][0] = "NGO";
      nmarchactors[i] = 1;
      actorplotsymbol[i] = 'n';

   } else if (archactorscode[i].equals("E")) {
      archetypal_actor[i][0] = "EPA";
      archetypal_actor[i][1] = "NGO";
      nmarchactors[i] = 2;
      actorplotsymbol[i] = 'n';

   } else if (archactorscode[i].equals("F")) {
      archetypal_actor[i][0] = "rural_residents";
      nmarchactors[i] = 1;
      actorplotsymbol[i] = 'r';

   } else if (archactorscode[i].equals("G")) {
      archetypal_actor[i][0] = "pastoralists";
      nmarchactors[i] = 1;
      actorplotsymbol[i] = 's';

   } else if (archactorscode[i].equals("H")) {
      archetypal_actor[i][0] = "rural_residents";
      archetypal_actor[i][1] = "pastoralists";
      nmarchactors[i] = 2;
      actorplotsymbol[i] = 's';

   } else if (archactorscode[i].equals("I")) {
      archetypal_actor[i][0] = "tourists";
      nmarchactors[i] = 1;
      actorplotsymbol[i] = 't';

   } else if (archactorscode[i].equals("J")) {
      archetypal_actor[i][0] = "developer";
      archetypal_actor[i][1] = "NGO";
      nmarchactors[i] = 2;
      actorplotsymbol[i] = 'd';

   } else if (archactorscode[i].equals("K")) {
      archetypal_actor[i][0] = "ecosystem";
      nmarchactors[i] = 1;
      actorplotsymbol[i] = 'e';

   } else if (archactorscode[i].equals("L")) {
      archetypal_actor[i][0] = "legislature";
      nmarchactors[i] = 1;
      actorplotsymbol[i] = 'l';

   } else if (archactorscode[i].equals("M")) {
      archetypal_actor[i][0] = "judicial";
      nmarchactors[i] = 1;
      actorplotsymbol[i] = 'j';

   } else if (archactorscode[i].equals("N")) {
      archetypal_actor[i][0] = "none";
      nmarchactors[i] = 1;
      actorplotsymbol[i] = 'u';

   } else {
      iderr_("readematfle: unrecognized archactor code= " +
         archactorscode[i]);
   }

   // Subjects.
  
   if (archsubjectscode[i].equals("A")) {
      archetypal_subject[i][0] = "president";
      nmarchsubjects[i] = 1;

   } else if (archsubjectscode[i].equals("B")) {
      archetypal_subject[i][0] = "EPA";
      nmarchsubjects[i] = 1;

   } else if (archsubjectscode[i].equals("C")) {
      archetypal_subject[i][0] = "president";
      archetypal_subject[i][1] = "EPA";
      nmarchsubjects[i] = 2;

   } else if (archsubjectscode[i].equals("D")) {
      archetypal_subject[i][0] = "NGO";
      nmarchsubjects[i] = 1;

   } else if (archsubjectscode[i].equals("E")) {
      archetypal_subject[i][0] = "EPA";
      archetypal_subject[i][1] = "NGO";
      nmarchsubjects[i] = 2;

   } else if (archsubjectscode[i].equals("F")) {
      archetypal_subject[i][0] = "rural_residents";
      nmarchsubjects[i] = 1;

   } else if (archsubjectscode[i].equals("G")) {
      archetypal_subject[i][0] = "pastoralists";
      nmarchsubjects[i] = 1;

   } else if (archsubjectscode[i].equals("H")) {
      archetypal_subject[i][0] = "rural_residents";
      archetypal_subject[i][1] = "pastoralists";
      nmarchsubjects[i] = 2;

   } else if (archsubjectscode[i].equals("I")) {
      archetypal_subject[i][0] = "tourists";
      nmarchsubjects[i] = 1;

   } else if (archsubjectscode[i].equals("J")) {
      archetypal_subject[i][0] = "developer";
      archetypal_subject[i][1] = "NGO";
      nmarchsubjects[i] = 2;

   } else if (archsubjectscode[i].equals("K")) {
      archetypal_subject[i][0] = "ecosystem";
      nmarchsubjects[i] = 1;

   } else if (archsubjectscode[i].equals("L")) {
      archetypal_subject[i][0] = "legislature";
      nmarchsubjects[i] = 1;

   } else if (archsubjectscode[i].equals("N")) {
      archetypal_subject[i][0] = "none";
      nmarchsubjects[i] = 1;

   } else {
      iderr_("readematfle: unrecognized archsubject code= " +
         archsubjectscode[i]);
   }
}
acquiredemat = true;
printf_("Finished reading EMAT file.");
}

// -----------------------------------------------------------------

static int readgrpsinfo_(int flenm) {

// Reads group information.

String strng1, strng2, archetype;

int nmvernacgrps = 0;

// Open the input file.

fleopen_(flenm, Groupdata.grpsinfofle, 'r');

do {
   strng1 = fgetstrng_(flenm);
   if (strng1.equals("begincomment")) {
      while (!strng1.equals("endcomment") && fle_ready_(flenm)) {
         strng1 = fgetstrng_(flenm);
      }
   
   } else if (strng1.equals("beginarchetype")) {
      archetype = fgetstrng_(flenm);
      do {

         // Assign archetype.

         grparchetype[nmvernacgrps] = archetype;

	 /* Read the full phrase and temporarily turn off "space"
	    termination of a string */
	 
         // streamTokenizer[flenm - 1].wordChars(' ', ' ');
         vernacgrp[nmvernacgrps] = fgetline_(flenm);

	 if (vernacgrp[nmvernacgrps].length() < 2) {
            continue;
	 }

         // streamTokenizer[flenm - 1].whitespaceChars(' ', ' ');

	 if (vernacgrp[nmvernacgrps].equals("endarchetype")) {
            break;
         }

	 /* "replace" is used here because "strngsub" does not work
	    correctly (apparently) if either the "from" or "to" String
	    consists of only the "space" character. */
	 
         strng1 = vernacgrp[nmvernacgrps].replace(' ', '_');
	 vernacgrp[nmvernacgrps] = strng1;

         // Trim front and back whitespace and convert to lowercase.

         strng1 = vernacgrp[nmvernacgrps].toLowerCase();
         vernacgrp[nmvernacgrps] = strng1.trim();
	 vernacgrp[nmvernacgrps] = vernacgrp[nmvernacgrps].replaceAll(
            "_wildlife_conservancy", "");

	 // Read acronym.

         acronym[nmvernacgrps] = fgetstrng_(flenm);

         // Trim front and back whitespace and convert to lowercase.

         strng1 = acronym[nmvernacgrps].toLowerCase();
         acronym[nmvernacgrps] = strng1.trim();

	 // Read IntIDs model name.

	 modelname[nmvernacgrps] = fgetstrng_(flenm);

         ++nmvernacgrps;
      } while (fle_ready_(flenm));
   }
} while (fle_ready_(flenm));
fclose_(flenm, 'r');
return nmvernacgrps;
}

// --------------------------------------------------------------------

static void readparsedematacts_() {

// Reads file of parsed EMAT actions.

boolean verbproblem = false;

String lastematphrase;

int i, j, k, nmwrds = 0, nmconjugated = 0;

fleopen_(3, parsedematactsfle, 'r');

lastematphrase = "none read yet";
i = 0;
for (;;) {
   ematactphrase[i] = fgetline_(3);
   j = Grouputils.getematcodeindex_(ematactphrase[i], matchthrshld);

   if (j == 0) {
      iderr_("readparsedematacts: lastematphrase:\n" + lastematphrase +
         " No emat ID for: " + ematactphrase[i]);

   } else {
      lastematphrase = ematactphrase[i];
   }

   ematid[i] = ematcode[j - 1];

   // Read m-word verb equivalence set.
   
   j = 0;
   for (;;) {
      String ngram[] = fgetline_(3).split(" ");
      if (ngram[0].indexOf("__endset__") >= 0) {
         break;
      }
      nmwrds = Math.min(ngram.length, 10);

      if (nmwrds < 1) {
         verbproblem = true;
         printf_("readparsedematacts: nmverbwords=0, phrase= " +
            ematactphrase[i]);
      }

      for (k = 0; k < nmwrds; ++k) {
         ematmwverb[i][j][k] = ngram[k];
      }
      mwverbnmwrds[i][j] = nmwrds;

      /* Check for a regular verb.  If found, add the rest of its
         conjugated forms to the equivalence set. */

      if (nmwrds == 1) {
         nmconjugated = Textutils.conjugate_(ematmwverb[i][j][0],
                                             conjugform);
         if (nmconjugated == 3) {
            for (k = 0; k < 3; ++k) {
               ++j;
               ematmwverb[i][j][0] = conjugform[k];
               mwverbnmwrds[i][j] = 1;
            }
         }
      }

      ++j;
      if (j > 500) {
         iderr_("readparsedematacts: lastematphrase= " + lastematphrase +
            " verb search j > 500.");
      }
   }
   nmmwverbs[i] = j;

   // Read direct object phrase equivalence set.
   
   j = 0;
   for (;;) {
      String ngram[] = fgetline_(3).split(" ");
      if (ngram[0].indexOf("__endset__") >= 0) {
         break;
      }
      nmwrds = Math.min(ngram.length, 10);
      for (k = 0; k < nmwrds; ++k) {
         ematdirobj[i][j][k] = ngram[k];
      }
      dirobjnmwrds[i][j] = nmwrds;
      ++j;

      if (j > 500) {
         iderr_("readparsedematacts: lastematphrase= " + lastematphrase +
            " direct search j > 500.");
      }
   }
   nmdirobjs[i] = j;

   // Read prepositional phrase equivalence set.
   
   j = 0;
   for (;;) {
      String ngram[] = fgetline_(3).split(" ");
      if (ngram[0].indexOf("-----") >= 0 || !fle_ready_(3)) {
         break;
      }
      nmwrds = Math.min(ngram.length, 10);
      for (k = 0; k < nmwrds; ++k) {
         ematprepobj[i][j][k] = ngram[k];
      }
      prepobjnmwrds[i][j] = nmwrds;
      ++j;

      if (j > 500) {
         iderr_("readparsedematacts: lastematphrase= " + lastematphrase +
            " prep search j > 500.");
      }
   }
   nmprepobjs[i] = j;

   ++i;

   if (!fle_ready_(3)) {
      break;
   }
}
fclose_(3, 'r');
printf_("readparsedematacts: i= " + i + " nmematcodes= " + nmematcodes);

if (verbproblem) {
   iderr_("readparsedematacts: verbproblem");
}
}

// -----------------------------------------------------------------

static void writeparsedematacts_() {

// Writes the parsed EMAT actions file.

int i, j, k, l;

fleopen_(3, "updatedparsedacts.dat", 'w');
EMATloop: for (i = 0; i < nmematcodes; ++i) {

   fprintf_(3, "--------------------------------------------------" +
      "\n" + emataction[i]);

   // See if this action has been parsed in the previous version of this file.

   for (j = 0; j < nmematcodes; ++j) {
      if (ematactphrase[j] == null) {
         break;
      }
      if (ematactphrase[j].equals(emataction[i])) {

         // Write these equivalence sets to the output file.

         for (k = 0; k < nmmwverbs[j]; ++k) {
            strng = ematmwverb[j][k][0];
            for (l = 1; l < mwverbnmwrds[j][k]; ++l) {
               strng += " " + ematmwverb[j][k][l];
            }
            fprintf_(3, strng);
         }
         fprintf_(3, "__endset__");

         for (k = 0; k < nmdirobjs[j]; ++k) {
            strng = ematdirobj[j][k][0];
            for (l = 1; l < dirobjnmwrds[j][k]; ++l) {
               strng += " " + ematdirobj[j][k][l];
            }
            fprintf_(3, strng);
         }
         fprintf_(3, "__endset__");

         for (k = 0; k < nmprepobjs[j]; ++k) {
            strng = ematprepobj[j][k][0];
            for (l = 1; l < prepobjnmwrds[j][k]; ++l) {
               strng += " " + ematprepobj[j][k][l];
            }
            fprintf_(3, strng);
         }

         continue EMATloop;
      } 
   }

   // Write a template for this un-parsed action.

   fprintf_(3,"__endset__" + "\n__endset__");
}

fclose_(3, 'w');
}

// -----------------------------------------------------------------

static void readstory_(int flenm, int articleid) {

/* Reads story into "sentence" and "textsentence" arrays.  This is
   accomplished as follows.  Each word is read and checked for the
   presence of a "." character.  If found, a sentence is declared
   and stored.

   ***NOTE: replace all non-ascii characters in the story file before
   running this method.  One way to do this is with the vim command
   
                   :g/[^\x00-\x7F]/s// /g
*/

boolean wordisnm = false, oldword1isnm = false, oldword2isnm = false,
   endofsentence = false, ratchet2 = false;

String strng, oldword1 = "none", oldword2 = "none", word = "none";

int i, j, k, l = 0;

double dbleval, year;

Double tempval;

// Initialize counters.

nmwords = 0;
nmsentences = 0;
nmtextsentences = 0;
for (i = 0; i < NMSENS; ++i) {
   nmsenwrds[i] = 0;
   nmtextsenwrds[i] = 0;
}
endstudent = false;

do {

   // Only read-in a sentence if it is from an article.

   if (articleid == 0) {
      break;
   }

   oldword2 = oldword1;
   oldword1 = word;

   oldword2isnm = oldword1isnm;
   oldword1isnm = wordisnm;
   
   // Check for the date being a pure integer.
   
   if (oldword2.equals("First") && oldword1.equals("published")) {
      word = Integer.toString(fgetint_(flenm));

   } else {
      word = fgetstrng_(flenm);
      if (!isString) {
         wordisnm = true;

      } else {
         wordisnm = false;
      }
   }

   if (word.equals("beginarticle")) {
      streamTokenizer[flenm - 1].pushBack();
      break;
   }

   // Just consume story if number-of-sentences limit has been reached.

   if (nmsentences == NMSENS) {
      continue;
   }

   /* Catch substrings that contain "." before they falsely cause an
      end-of-sentence. */

   if (word.equals("Jan.") ||
       word.equals("Feb.") ||
       word.equals("Mar.") ||
       word.equals("Apr.") ||
       word.equals("Jun.") ||
       word.equals("Jul.") ||
       word.equals("Aug.") ||
       word.equals("Sept.") ||
       word.equals("Oct.") ||
       word.equals("Nov.") ||
       word.equals("Dec.")) {
      word = strngsub_(word, ".", "");
   }

   // Clean up the word.
   
   word = word.trim();
   word = strngsub_(word, ",", " ");

   // Contiguous spaces does not make a word.

   if (word.equals(" ") || word.equals("  ") || word.equals("   ")) {
      continue;
   }

   // Now, check for end-of-sentence.

   ratchet2 = false;
   if (word.indexOf(".") == (word.length() - 1) ||
       word.indexOf("?", 0) >= 0 ||
       word.indexOf("!", 0) >= 0) {
      word = strngsub_(word, ".", "");
      word = strngsub_(word, "?", "");
      word = strngsub_(word, "!", "");
      endofsentence = true;

   } else if (oldword1.length() > 0 && word.length() > 0) {
      if (oldword2isnm && !wordisnm &&
          Character.isUpperCase(oldword1.charAt(0)) &&
          !Character.isUpperCase(word.charAt(0))) {
         ratchet2 = true;
         endofsentence = true;
      }
   }

   // Special processing for student-written documents.
   
   if (tutor) {
      
      // Terminator for reading multiple documents from a file.

      if (word.equals("enddocument")) {
         return;
   
      } else if (word.equals("endstudent")) {
         endstudent = true;
         return;
      }

      // Word frequencies for author detection.

      Textutils.wordfreqs_(word, createnew);

      if (nmwords < NMWRDS) {
         wordvec[nmwords] = word;
         ++nmwords;
      }
   }

   // Don't load a lone double quote.

   if (word.equals("\"")) {
      continue;
   }

   // Add word to current sentence.
 
   if (nmsenwrds[nmsentences] < NMWRDS) {
      sentence[nmsentences][nmsenwrds[nmsentences]] = word;
      ++nmsenwrds[nmsentences];
   }

   if (endofsentence) {
      endofsentence = false;

      if (ratchet2) {
	 sentence[nmsentences + 1][0] = oldword1;
	 sentence[nmsentences + 1][1] = word; 
	 nmsenwrds[nmsentences + 1] = 2;

	 nmsenwrds[nmsentences] = Math.max(0, (nmsenwrds[nmsentences] - 2));
      }

      if ((nmsentences + 2) < NMSENS && nmsenwrds[nmsentences] > 3) {
         ++nmsentences;
      }
   }
} while (!checkeof_(flenm));

if (articleid > 0 && nmsentences > NMSENS) {
   iderr_("readstory: nmsentences>NMSENS");
}

// Now, read the text into the text sentence array.

for (i = 0; i < nmsentences; ++i) {
   if (checktext_(sentence[i], nmsenwrds[i])) {
      nmtextsenwrds[nmtextsentences] = nmsenwrds[i];
      for (j = 0; j < nmtextsenwrds[nmtextsentences]; ++j) {
         textsentence[nmtextsentences][j] = sentence[i][j];
      }
      ++nmtextsentences;
      
   }
}

/*
// First, split the big text string into sentence strings.
String senarray[] = articletext.split("\\.");
l = 0;
for (i = 0; i < senarray.length; ++i) {
   String textsen[] = senarray[i].split(" ");
   if (textsen.length < 3) {
      continue;
   }
   k = 0;
   for (j = 0; j < textsen.length; ++j) {
      if (textsen[j].endsWith("\r")) {
         textsen[j] = textsen[j].substring(0, textsen[j].length() - 1);
      }
      if (textsen[j] != null && textsen[j].length() > 0) {
         textsentence[l][k] = textsen[j];
	 ++k;
      }
   }
   nmtextsenwrds[l] = k;
   if (nmtextsenwrds[l] >= 3) {
      ++l;
   }
}
nmtextsentences = l;
*/

}

// ----------------------------------------------------------------------

static boolean checktext_(String sentence[], int nmwords) {

/* Checks a sentence for common words to see if it contains story text.
   But also checks for words indicating a non-story section of the
   webpage.  Are article titles often being included as text? */

int i, j, nminsen = 0, nmirrlvnt = 0;

double irrtowrds = 0.;

for (i = 0; i < nmwords; ++i) {
   for (j = 0; j < nmcommonwords; ++j) {
      if (sentence[i].equals(commonword[j])) {
         ++nminsen;
      }
   }
   for (j = 0; j < nmirrelevantwords; ++j) {
      if (sentence[i].equals(irrelevantword[j])) {
         ++nmirrlvnt;
      }
   }
}

irrtowrds = ((double) nmirrlvnt) / (1. + ((double) nmwords));

if (nminsen >= 3 && irrtowrds <= .9) {
   /*
   printf_("checktext: nmwords= " + nmwords + " nminsen= " + nminsen +
      " irrtowrds= " + irrtowrds);
   */

   return true;
}
return false;
}

// ----------------------------------------------------------------------

static String ctryspec_(String group, String maincountry) {

// Replace any generic group name with the country-specific name.

String specgroup = "none";

specgroup = group;

if (group.equals("president")) {
   if (maincountry.equals("Kenya")) {
      specgroup = "Kenya_president";

   } else if (maincountry.equals("Tanzania")) {
      specgroup = "Tanzania_president";

   } else if (maincountry.equals("Uganda")) {
      specgroup = "Uganda_president";
   }

} else if (group.equals("EPA")) {
   if (maincountry.equals("Kenya")) {
      specgroup = "kenepa";

   } else if (maincountry.equals("Tanzania")) {
      specgroup = "TMTNR";

   } else if (maincountry.equals("Uganda")) {
      specgroup = "UWA";
   }
   
} else if (group.equals("rural_residents")) {
   if (maincountry.equals("Kenya")) {
      specgroup = "kenrr";

   } else if (maincountry.equals("Tanzania")) {
      specgroup = "TRR";

   } else if (maincountry.equals("Uganda")) {
      specgroup = "URR";
   }

} else if (group.equals("pastoralists")) {
   if (maincountry.equals("Kenya")) {
      specgroup = "Kenya_pastoralists";

   } else if (maincountry.equals("Tanzania")) {
      specgroup = "Tanzania_pastoralists";

   } else if (maincountry.equals("Uganda")) {
      specgroup = "Uganda_pastoralists";
   }
}
return specgroup;
}

// -----------------------------------------------------------------

static void writestory_(boolean file, int articleid, int nmacts,
   String act[]) {

// Writes a story to a file. */

String phrase = "none";

int i, j;

++checkstorynm;
if (file) {
   fprintf_(checkflenm, "\n" + checkstorynm + ". " +
      " ---------------------- articleid= " + articleid +
      " ----- nmacts= " + nmacts + " --------------------");
}

for (i = 0; i < nmacts; ++i) {
   if (file) {
      fprintf_(checkflenm, act[i]);

   } else {
      printf_(act[i]);
   }
}

for (i = 0; i < Math.min(nmtextsentences, 50); ++i) {
   phrase = "\n" + textsentence[i][0];
   for (j = 1; j < nmtextsenwrds[i]; ++j) {
      phrase += " " + textsentence[i][j];
   }
   if (file) {
      fprintf_(checkflenm, phrase);

   } else {
      printf_(phrase);
   }
}
}

// ----------------------------------------------------------------------

static void actionsimilarities_() {

/* Compute the maximum similarity between m-word verb equivalence sets for
   all pairs of EMAT actions. */

int i, j;

for (i = 1; i <= nmematcodes; ++i) {
   for (j = 1; j <= nmematcodes; ++j) {
      if (i != j) {
         actionsimilarity[i - 1][j - 1] = maxsimilarity_(i, j);

      } else {
         actionsimilarity[i - 1][j - 1] = 1.;
 
      }
   }
}
}

// ----------------------------------------------------------------------

static double maxsimilarity_(int acti, int actj) {

/* Compute the maximum similarity between the m-word verb equivalence set
   of action i and that of action j.*/

int i, j;

double sim = 0., maxsim = 0.;

for (i = 0; i < nmmwverbs[acti - 1]; ++i) {
   for (j = 0; j < nmmwverbs[actj - 1]; ++j) {

      if (mwverbnmwrds[acti - 1][i] < 1 || mwverbnmwrds[actj - 1][j] < 1) {

         iderr_("maxsimilarity: nmwrdsacti= " + mwverbnmwrds[acti - 1][i] +
            " nmwrdsactj= " + mwverbnmwrds[actj - 1][j] + " acti= " + acti +
            " actj= " + actj);
      }

      sim = Textutils.similar_(ematmwverb[acti - 1][i],
                               mwverbnmwrds[acti - 1][i],
                               ematmwverb[actj - 1][j],
                               mwverbnmwrds[actj - 1][j]);
      if (sim > maxsim) {
         maxsim = sim;
      }
   }
}
return maxsim;
}
}
