import java.util.*;
import java.io.*;

public class Storyfind extends Storyparse {

// -------------------------------------------------------------------

static void findgroups_(int threadnm, int nmsentences, int articleid) {

// Search for groups.
	 
boolean newgrp = true, newrgn = true,
   newctry = true, oldaction = true, iscoastweek = false, iadded = false;

String savephrase = "none", phrase;

int i, j, k, l, m, n, maxk = 0, nmjmp = 0, nmwrds, nmgrps = 0, grpnm = -1,
   rgnk = -1, ctryk = -1;

double sscore, maxscore;
for (i = 0; i < nmsentences; ++i) {
   for (j = 0; j < nmsenwrds[i]; ++j) {
      for (nmwrds = 1; nmwrds <= 4; ++nmwrds) {
	 if (j + nmwrds - 1 >= nmsenwrds[i]) {
	    break;
	 }
         phrase = sentence[i][j];
         for (k = 1; k < nmwrds; ++k) {
            phrase += "_" + sentence[i][j + k];
	 }

	 phrase = phrase.replaceAll("_Wildlife_Conservancy", "");
         maxscore = 0.;
         for (k = 0; k < nmvernacgrps; ++k) {
            if (grparchetype[k].equals("news_organization")) {
               continue;
            }

	    sscore = 0.;
	    if (phrase != null) {
               sscore = Textutils.levenshtein_(phrase, vernacgrp[k]);

	    } else {
               printf_("findgroups: threadnm= " + threadnm + " i= " + i);
	    }

            if (sscore > maxscore) {
               maxscore = sscore;
               maxk = k;
	       savephrase = phrase;
	       nmjmp = nmwrds;
            }
	 }

         if (maxscore > .9) {

	    // Check if this group has already been noticed.

	    newgrp = true;
            for (k = 0; k < nmgrps; ++k) {
               if (vernacgrp[maxk] == group[k][0]) {
                  newgrp = false;
		  grpnm = k;
	          break;
	       }
	    }
	    if (newgrp) {
               group[nmgrps][0] = vernacgrp[maxk];
               grparche[nmgrps] = grparchetype[maxk];
	       groupsen[nmgrps][0] = i + 1;
	       ++nmofmentions[nmgrps];
	       grpnm = nmgrps;
               ++nmgrps;

	       /*
	       printf_("readfields: phrase= " + phrase + ", group= " +
                  group[nmgrps - 1][0]);
	       */
	    }

            j += nmjmp - 1;

	    // Check for a first-level alias of this group.

	    if (j + 2 < nmsenwrds[i]) {
               if (sentence[i][j + 1].equals("grantee")) {
                  ++nmaliases[grpnm];
                  group[grpnm][nmaliases[grpnm]] = sentence[i][j + 2];
	          groupsen[grpnm][nmofmentions[grpnm]] = i + 1;
	          ++nmofmentions[grpnm];
	       }
            }
	    break;
	 }

	 if (nmwrds > 1) {
            continue;
	 }

	 // Check for the "I" alias of an alias.

         GRPLOOP: for (k = 0; k < nmgrps; ++k) {
            for (l = 0; l < nmaliases[k]; ++l) {
	       if (sentence[i][j].equals(group[k][l + 1])) {
	          for (m = 0; m < nmsenwrds[i]; ++m) {
                     if (sentence[i][m].equals("I")) {

			/*
		        printf_("alias I for group= " + group[k][0]);
			printf_("word1= " + sentence[i][0] +
				" wordn= " + sentence[i][nmsenwrds[i] - 1]);
                        */

			// Add this alias if not done so already.

			iadded = false;
			for (n = 0; n < nmaliases[k]; ++n) {
		           if (group[k][n + 1].equals("I")) {
			      iadded = true;
			   }
			}
			if (!iadded) {
			   ++nmaliases[k];
			   group[k][nmaliases[k]] = "I";
			}

			// Note the mention of this group in this sentence.
			
	                groupsen[k][nmofmentions[k]] = i + 1;
	                ++nmofmentions[k];
			break GRPLOOP;
		     }
		  }
	       }
	    }
	 }
      }
   }
}

if (nmgrps == 0) {
   nogroup = true;
   ++nmnogroup;

   return;
}
}

// ---------------------------------------------------------------------

static void findactions_(int threadnm, int nmtextsentences, int articleid) {

/* Search for actions in two ways over each phrase of the story.  The
   first way is by direct comparison of a phrase with an EMAT action.
   The second way is to construct an action by testing for a pre-determined
   set of words. */

String phrase;

boolean oldaction = true;

int i, j, k, l, m, n, maxk = 0, nmjmp = 0, nmwrds;

double sscore, maxscore;

nmactions = 0;
SENSLPACT: for (i = 0; i < nmtextsentences; ++i) {
   actyear[nmactions] = -1;

   /* First, search for actions with the action-string--to--EMAT-code
      matching method, "getematcodeindex_." */

   phrase = textsentence[i][1];
   for (k = 2; k < Math.min(6, nmtextsenwrds[i]); ++k) {
      phrase += "_" + sentence[i][k];
   }
   k = Grouputils.getematcodeindex_(phrase, matchthrshld);

   if (k > 0) {
	    
      // See if this action has already been noticed.

      for (l = 0; l < nmactions; ++l) {
         if (k == ematindx[l]) {
            printf_("findactions: already noticed");
	    continue SENSLPACT;
         }
      }

      action[nmactions] = Intridslve.emataction[k - 1];
      ematindx[nmactions] = k;
      actsen[nmactions] = i + 1;

      printf_("findactions: " + " phrase= " + phrase +
         "\n   emat action= " + action[nmactions]);

      ++nmactions;

   } else {
   
      // Try to find an action through matching parts-of-speech.

      Storyaction.findActionPattern_(i, true);
   }
}

if (nmactions == 0) {
   noaction = true;
   ++nmnoaction;

   return;
}
}

// ----------------------------------------------------------------------

static void findregions_(int threadnm, int nmsentences, int articleid) {

// Search for regions and associated countries.

String trialplace, backupcountry = null;

boolean newrgn = true, newctry = true;

int i, j, k, maxk = 0, maxctryk = -1, nmjmp = 0, nmwrds, rgnk = -1,
   ctryk = -1;

double sscore = 0., ctryscore = 0., maxscore, maxctryscore;

trialplace = null;
try {
for (i = 0; i < nmsentences; ++i) {
   for (j = 0; j < nmsenwrds[i]; ++j) {
      for (nmwrds = 5; nmwrds >= 1; --nmwrds) {
	 if (j + nmwrds - 1 >= nmsenwrds[i]) {
	    continue;
	 }
         trialplace = sentence[i][j];
         for (k = 1; k < nmwrds; ++k) {
            trialplace += "_" + sentence[i][j + k];
	 }
         if (trialplace == null) {
            iderr_("findregions: trialplace=null, threadnm= " +
               threadnm + " i= " + i);
         }

         /* Search for a region and/or country.  Note that this routine
            wastefully adds multiple versions of the same region name. */

	 nmjmp = -1;
         maxscore = 0.;
         maxctryscore = 0.;
         for (k = 0; k < nmallregions; ++k) {
            sscore = Textutils.levenshtein_(trialplace, ctryrgn[k][1]);
            ctryscore = Textutils.levenshtein_(trialplace, ctryrgn[k][0]);

            if (sscore > maxscore) {
               maxscore = sscore;
               maxk = k;
            }

            if (ctryscore > maxctryscore) {
               maxctryscore = ctryscore;
               maxctryk = k;
            }
         }

         // If a region has been found, store the number of words to jump.

         if (maxscore > .90) {
            nmjmp = nmwrds;
         }

         // If a country has been found, store it as a backup.
         
         if (maxctryscore > .90) {
            backupcountry = ctryrgn[maxctryk][0];
         }

         // If no region has been found, go to the next check-string length.
        
	 if (nmjmp == -1) {
            continue;
	 }

         // Check if this region has already been noticed.

         newrgn = true;
         for (k = 0; k < nmregionsttl; ++k) {
            if (ctryrgn[maxk][1].equals(region[k])) {
               newrgn = false;
               rgnk = k;
	       break;
	    }
	 }
	 if (newrgn) {
            region[nmregionsttl] = ctryrgn[maxk][1];
	    rgnsen[nmregionsttl][0] = i + 1;
	    ++nmrgnmentions[nmregionsttl];
            ++nmregionsttl;

	 } else {
	    rgnsen[rgnk][nmrgnmentions[rgnk]] = i + 1;
	    ++nmrgnmentions[rgnk];
         }

	 // Check if this country has already been noticed.

	 newctry = true;
         for (k = 0; k < nmcountriesttl; ++k) {
            if (ctryrgn[maxk][0].equals(country[k])) {
               newctry = false;
	       ctryk = k;
	       break;
            }
         }
         if (newctry && nmcountriesttl < NMRGNS) {
            country[nmcountriesttl] = ctryrgn[maxk][0];
            ctrysen[nmcountriesttl][0] = i + 1;
            ++nmctrymentions[nmcountriesttl];
            ++nmcountriesttl;

         } else if (!newctry) {
            ctrysen[ctryk][nmctrymentions[ctryk]] = i + 1;
            ++nmctrymentions[ctryk];
         }

         j += nmjmp - 1;
         break;
      }
   }
}
} catch (Exception e) {
   iderr_("in findregions");
}

// Use the backup country if it has been found and is necessary.

if (nmcountriesttl == 0 && backupcountry != null) {
   country[0] = backupcountry;
   nmcountriesttl = 1;

   // Pick a region that contains the word "Park."

   for (i = 0; i < nmallregions; ++i) {
      if (ctryrgn[i][1].indexOf("Park") >= 0) {
         region[0] = ctryrgn[i][1];
         rgnsen[0][0] = -1;
         nmrgnmentions[0] = 1;
         nmregionsttl = 1;
         break;
      }
   }
}

if (nmcountriesttl == 0) {
   nocountry = true;
   ++nmnocountry;

   return;

} else {
   maincountry = country[0];
}

if (maincountry.equals("none")) {
   iderr_("findregions: maincountry= none");
}
}
}
