class Storyaction extends Storyparse {

static String shortphrase[] = new String[10];

/* Arrays to store a story's ("strd") noun phrases (nph), multi-word verbs
   (mwvrb), direct object phrases (ddoph), and prepositional phrases
   (pph). */

static String strdnph[] = new String[MAXNMSTRD];
static String strdmwvrb[] = new String[MAXNMSTRD];
static String strddoph[] = new String[MAXNMSTRD];
static String strdpph[] = new String[MAXNMSTRD];

static int nmstrdnphs = 0, nmstrdmwvrbs = 0, nmstrddophs = 0, nmstrdpphs = 0;

// -----------------------------------------------------------------

static boolean findActionPattern_(int sen, boolean storecmpnts) {

/* Find an action pattern in the collection of text sentences.  Many
   EMAT actions are of the form:
   verb + verb's-direct-object + preposition + object-of-preposition
   The last two components are typically referred to collectively as
   a "prepositional phrase."
   In "learnmode," sentences are found to have actions that are not
   found to have actions when "learnmode" is off.  This is necessary
   so that sentences that achieve the learning threshold but not the
   action-match threshold are written to the "learnsens.txt" file.
*/

boolean test = true, searchsuccess = false, foundmatch = false,
   learnsen = false;

String yearstrng = "none", observedemataction = "none", senstrng = "none";

int i, besti = 0, j, k, mwverbaction, objaction, pphaction;

double simval = 0., verbsimval = 0., objsimval = 0., pphsimval = 0.,
   maxobjscore = 0., maxpphscore = 0., bestvrbval = 0., bestobjval = 0.,
   bestpphval = 0., simscore = 0., maxsimscore = 0.;

Double tempval;

// Initialize sentence components counters.

nmstrdnphs = 0;
nmstrdmwvrbs = 0;
nmstrddophs = 0;
nmstrdpphs = 0;

// Return if sentence is too short.

if (nmtextsenwrds[sen] < 3) {

   return false;
}

// First, find an m-word verb.

mwverbaction = 0;
maxsimscore = 0.;
for (i = 1; i <= nmematcodes; ++i) {
   verbsimval = 0.;
   for (j = 0; j < nmtextsenwrds[sen]; ++j) {
      simval = findmwverb_(sen, j, i);
      if (simval > verbsimval) {
         verbsimval = simval;
      }
   }
 
   // Keep track of the best-fitting m-word verb.

   if (verbsimval > matchthrshld && verbsimval > maxsimscore) {
      maxsimscore = verbsimval;
      observedemataction = ematactphrase[i - 1];
      mwverbaction = i;
   }
}

if (!learnmode && maxsimscore < matchthrshld) {
   printf_("findactpttrn: no m-word verb match, returning.");

   return false; 
}

// Now, search for the multi-word verb's direct object phrase.

maxobjscore = 0.;
objaction = 0;
for (i = 1; i <= nmematcodes; ++i) {
   if (actionsimilarity[i - 1][mwverbaction - 1] < matchthrshld) {
      continue;
   }
   objsimval = 0.;
   for (j = 0; j < nmtextsenwrds[sen]; ++j) {
      simval = finddirobj_(sen, j, i);
      if (simval > objsimval) {
         objsimval = simval;
      }
   }

   // Keep track of the best-fitting direct object phrase.

   if (objsimval > matchthrshld && objsimval > maxobjscore) {
      maxobjscore = objsimval;
      objaction = i;
   }
}

// Search for a prepositional phrase.

maxpphscore = 0.;
pphaction = 0;
for (i = 1; i <= nmematcodes; ++i) {
   if (actionsimilarity[i - 1][mwverbaction - 1] < matchthrshld) {
      continue;
   }
   pphsimval = 0.;
   for (j = 0; j < nmtextsenwrds[sen]; ++j) {
      simval = findprepobj_(sen, j, i);
      if (simval > pphsimval) {
         pphsimval = simval;
      }
   }
   
   // Keep track of the best-fitting prepositional phrase.

   if (pphsimval > matchthrshld && pphsimval > maxpphscore) {
      maxpphscore = pphsimval;
      pphaction = i;
   }
}

if (objaction == 0 && pphaction == 0) {
   foundmatch = false;

} else {
   foundmatch = true;
}

// Count the nmber of learning sentences and write them to a file.

if (learnmode && !foundmatch && maxsimscore > learnthrshld) {
   ++nmlearn;
   if (nmtextsenwrds[sen] < 50) {
      senstrng = sen + " " + textsentence[sen][0];
      for (k = 1; k < nmtextsenwrds[sen]; ++k) {
         senstrng += " " + textsentence[sen][k];
      }
      fprintf_(learnflenm, "\n" + senstrng + "\n" + observedemataction);
   }
   if (nmlearn == 500) {
      iderr_("findactpttrn: nmlearn hit its limit.");
   }
}

if (!foundmatch) {
   printf_("findactpttrn: no direct or prep. for EMAT phrase= " +
      observedemataction + ", returning.");

   return false;
}

// Prefer an EMAT action that has a prepositional phrase match.

if (maxpphscore > matchthrshld && pphaction > 0) {
   observedemataction = ematactphrase[pphaction - 1];
   
} else if (maxobjscore >= matchthrshld) {
   observedemataction = ematactphrase[objaction - 1];

} else if (maxpphscore > 0. && pphaction == 0) {
   printf_("findactpttrn: maxobjscore= " + maxobjscore +
      " maxpphscore= " + maxpphscore + "objaction= " + objaction +
      " pphaction= " + pphaction);
   foundmatch = false;

} else {
   foundmatch = false;
}

if (!foundmatch) {
   printf_("findactpttrn: 2nd foundmatch=false, returning.");

   return false;
}

besti = Grouputils.getematcodeindex_(observedemataction, matchthrshld);

// Write any components to the database-creation array.

if (storecmpnts && (nmstrdnphs > 0 || nmstrdmwvrbs > 0 ||
    nmstrddophs > 0 || nmstrdpphs > 0)) {

   senstrng = textsentence[sen][0];
   for (k = 1; k < nmtextsenwrds[sen]; ++k) {
      senstrng += " " + textsentence[sen][k];
   }

   dbentity[dbentitysize] = nmstrdnphs + " " + nmstrdmwvrbs + " " +
      nmstrddophs + " " + nmstrdpphs + " " +
      fdble_(bestvrbval, 5, 3) + " " + fdble_(bestobjval, 5, 3) + " " +
      fdble_(bestpphval, 5, 3);
   ++dbentitysize;

   for (k = 0; k < nmstrdnphs; ++k) {
      dbentity[dbentitysize] = strdnph[k];
      ++dbentitysize;
   }

   for (k = 0; k < nmstrdmwvrbs; ++k) {
      dbentity[dbentitysize] = strdmwvrb[k];
      ++dbentitysize;
   }

   for (k = 0; k < nmstrddophs; ++k) {
      dbentity[dbentitysize] = strddoph[k];
      ++dbentitysize;
   }

   for (k = 0; k < nmstrdpphs; ++k) {
      dbentity[dbentitysize] = strdpph[k];
      ++dbentitysize;
   }
}
printf_("findactpttrn: dbentitysize= " + dbentitysize);

// See if this action has already been noticed.

for (j = 0; j < nmactions; ++j) {
   if (besti == ematindx[j]) {
      printf_("findactpttrn: besti= " + besti +
         " already noticed, returning.");

      return true;
   }
}

// Store the action's index, string, and sentence number.

ematindx[nmactions] = besti;
action[nmactions] = Intridslve.emataction[besti - 1];
actsen[nmactions] = sen + 1;

// Search this sentence for an action year.  If found, abbreviate it.

actyear[nmactions] = -1.;
for (i = 0; i < nmtextsenwrds[sen]; ++i) {
   yearstrng = textsentence[sen][i];
   try {
   tempval = Double.valueOf(yearstrng);
   actyear[nmactions] = tempval.doubleValue();
   } catch (Exception e) {
   yearstrng = "none";
   actyear[nmactions] = -1;
   }
   if (1900. < actyear[nmactions] && actyear[nmactions] < 2000.) {
      actyear[nmactions] -= 1900.;

   } else if (2000. <= actyear[nmactions]) {
      actyear[nmactions] -= 2000.;

   } else {
      actyear[nmactions] = -1.;
   }
}
++nmactions;
printf_("findactpttrn: nmactions= " + nmactions + " returning.");

return true;
}

// ---------------------------------------------------------------------

static double finddirobj_(int sen, int senpos, int actpttrn) {

// Search for a direct object phrase.

boolean unique = false;

String ematdoph = "none";

int i, j, k, minnmwrds, maxnmwrds;

double simval = 0., maxsimval = 0.;

for (i = 1; i <= 5; ++i) {
   if (senpos + i - 1 >= nmtextsenwrds[sen]) {
      break;
   }
   dirobjphrase[0] = Textutils.replacenumeric_(textsentence[sen][senpos]);
   for (j = 1; j < i; ++j) {
      dirobjphrase[j] =
         Textutils.replacenumeric_(textsentence[sen][senpos + j]);
   }

   for (j = 0; j < nmdirobjs[actpttrn - 1]; ++j) {

      simval = Textutils.similar_(dirobjphrase, i,
                  ematdirobj[actpttrn - 1][j], dirobjnmwrds[actpttrn - 1][j]);

      if (simval > maxsimval) {
	 maxsimval = simval;
         strddoph[nmstrddophs] = dirobjphrase[0];
         for (k = 1; k < i; ++k) {
            strddoph[nmstrddophs] += " " + dirobjphrase[k];
         } 
         ematdoph = ematdirobj[actpttrn - 1][j][0];
         for (k = 1; k < dirobjnmwrds[actpttrn - 1][j]; ++k) {
            ematdoph += " " + ematdirobj[actpttrn - 1][j][k];
         }
      }
   }
}

/* Store only those direct object phrases that have high similarity to
   some EMAT action's direct object phrase equivalence set member. */

if (maxsimval > matchthrshld) {
   unique = true;
   for (k = 0; k < nmstrddophs; ++k) {
      if (strddoph[nmstrddophs].equals(strddoph[k])) {
         unique = false;
         break;
      }
   }
   if (unique && nmstrddophs < MAXNMSTRD - 1) {
      ++nmstrddophs;
   }
}
return maxsimval;
}

// ---------------------------------------------------------------------

static double findmwverb_(int sen, int senpos, int actpttrn) {

// Search for action pattern's multi-word verb.

boolean unique = false;

int i, j, k;

double simval = 0., maxsimval = 0.;

for (i = 1; i <= 5; ++i) {
   if (senpos + i - 1 >= nmtextsenwrds[sen]) {
      break;
   }
   mwordverb[0] = textsentence[sen][senpos];
   for (j = 1; j < i; ++j) {
      mwordverb[j] = textsentence[sen][senpos + j];
   }

   for (j = 0; j < nmmwverbs[actpttrn - 1]; ++j) {
      simval = Textutils.similar_(mwordverb, i,
                  ematmwverb[actpttrn - 1][j], mwverbnmwrds[actpttrn - 1][j]);

      if (simval > maxsimval) {
         maxsimval = simval; 
         strdmwvrb[nmstrdmwvrbs] = mwordverb[0];
         for (k = 1; k < i; ++k) {
            strdmwvrb[nmstrdmwvrbs] += " " + mwordverb[k];
         }
      }
   }
}

/* Store only those m-word verbs that have high similarity to some
   EMAT action's m-word verb equivalence set member. */

if (maxsimval > matchthrshld) {
   unique = true;
   for (k = 0; k < nmstrdmwvrbs; ++k) {
      if (strdmwvrb[nmstrdmwvrbs].equals(strdmwvrb[k])) {
         unique = false;
         break;
      }
   }
   if (unique && nmstrdmwvrbs < MAXNMSTRD - 1) {
      ++nmstrdmwvrbs;
   }
}
return (maxsimval);
}

// ---------------------------------------------------------------------

static double findprepobj_(int sen, int senpos, int actpttrn) {

/* Search for action pattern's object of the preposition, i.e., an
   prepositional phrase. */

boolean unique = false;

int i, j, k;

double simval = 0., maxsimval = 0.;

if (nmprepobjs[actpttrn - 1] == 0) {
   return (0.);
}

for (i = 1; i <= 5; ++i) {
   if (senpos + i - 1 >= nmtextsenwrds[sen]) {
      break;
   }
   prepobjphrase[0] = Textutils.replacenumeric_(textsentence[sen][senpos]);
   for (j = 1; j < i; ++j) {
      prepobjphrase[j] =
         Textutils.replacenumeric_(textsentence[sen][senpos + j]);
   }

   for (j = 0; j < nmprepobjs[actpttrn - 1]; ++j) {
      simval = Textutils.similar_(prepobjphrase, i,
                  ematprepobj[actpttrn - 1][j],
                  prepobjnmwrds[actpttrn - 1][j]);

      if (simval > maxsimval) {
         maxsimval = simval;
         strdpph[nmstrdpphs] = prepobjphrase[0];
         for (k = 1; k < i; ++k) {
            strdpph[nmstrdpphs] += " " + prepobjphrase[k];
         }
      }
   }
}

/* Store only those prepositional phrases that have high similarity to
   some EMAT action's prepositional phrase equivalence set member. */

if (maxsimval > matchthrshld) {
   unique = true;
   for (k = 0; k < nmstrdpphs; ++k) {
      if (strdpph[nmstrdpphs].equals(strdpph[k])) {
         unique = false;
         break;
      }
   }
   if (unique && nmstrdpphs < MAXNMSTRD - 1) {
      ++nmstrdpphs;
   }
}
return (maxsimval);
}

// ------------------------------------------------------------------

static void storyaction_(int articleid) {

/* For each action, first sort out which groups are actors and which are
   subjects.  Then, write the action to a database file. */

String actrstrng = "none", sbjctstrng = "none", ctrystrng = "none",
   rgnstrng = "none";

int i, j, k, l, mindist = 10000, dist = 10000, nmgrps = 0,
   nmcountries = 0, nmregions = 0, groupj = -1;

double actregdist = 0.;

nmstoryactions = 0;
ACTNSLP: for (i = 0; i < nmactions; ++i) {
   //printf_("storyaction: ematindx= " + ematindx[i]);

   /* Determine the actor or actors of this action from the set of
      detected groups.  Also, determine the action's subject or
      subjects from this same set of groups.  Do this as follows.

      1. Each EMAT action has a typical actor and a typical subject.
         Check these.
   
      2. In many stories, the actor is usually mentioned explicitly but
         not the subject.  Use the EMAT subject to infer a subject if
	 one is not mentioned in the story.

      3. If a group is mentioned in the same sentence as the action,
         use that group as the actor. */

   mindist = 1000;
   groupj = -1;
   for (j = 0; j < nmgrps; ++j) {
      for (k = 0; k < nmarchactors[ematindx[i] - 1]; ++k) {
         if (!grparche[j].equals(archetypal_actor[ematindx[i] - 1][k])) {
            continue;
	 }
	 for (l = 0; l < nmofmentions[j]; ++l) {
            dist = Math.abs(actsen[i] - groupsen[j][l]);
	    if (dist < mindist) {
               mindist = dist;
	       groupj = j; 
	    }
	 }
      }
   }

   if (groupj == -1) {
      printf_("storyaction: no actor found," +
         " using action's archetypal actor");
      actor[i][nmactors[i]] = archetypal_actor[ematindx[i] - 1][0];

   } else {
      actor[i][nmactors[i]] = group[groupj][0];
   }

   // Form actor(s) string.
	    
   if (nmactors[i] == 0) {
      actrstrng = Storyutils.ctryspec_(
		     actor[i][nmactors[i]], maincountry);

   } else {
      actrstrng += " " + Storyutils.ctryspec_(
		            actor[i][nmactors[i]], maincountry);
   }
   actrstrng = actrstrng.replaceAll("none_found_yet", "");
   ++nmactors[i];

   // Find subjects.
      
   mindist = 1000;
   for (j = 0; j < nmgrps; ++j) {
      for (k = 0; k < nmarchsubjects[ematindx[i] - 1]; ++k) {
         if (!grparche[j].equals(
             archetypal_subject[ematindx[i] - 1][k])) {
	    continue;
	 }
	 for (l = 0; l < nmofmentions[j]; ++l) {
            dist = Math.abs(actsen[i] - groupsen[j][l]);
	    if (dist < mindist) {
               mindist = dist;
	       groupj = j; 
	    }
	 }
      }
   }

   /* Use this closest subject only if it is within 2 sentences of
      the action.  Otherwise, use the archetypal subject. */

   if (mindist < 3) {
      subject[i][nmsubjects[i]] = group[groupj][0];

   } else {
      subject[i][nmsubjects[i]] = archetypal_subject[ematindx[i] - 1][0];
   }

   // Form subject(s) string.
	       
   if (nmsubjects[i] == 0) {
      sbjctstrng = Storyutils.ctryspec_(
		      subject[i][nmsubjects[i]], maincountry);

   } else {
      sbjctstrng += " " + Storyutils.ctryspec_(
		      subject[i][nmsubjects[i]], maincountry);
   }
   sbjctstrng = sbjctstrng.replaceAll("none_found_yet", "");
   ++nmsubjects[i];

   /* If no subject has been found, use the action's first archetypal
      subject. */

   if (nmsubjects[i] == 0) {
      subject[i][0] = archetypal_subject[ematindx[i] - 1][0];
      nmsubjects[i] = 1;
      sbjctstrng = subject[i][0];
   }

   // Build country and region strings.

   nmcountries = 0;
   CTRYLOOP: for (j = 0; j < nmcountriesttl; ++j) {
      if (country[j].equals("none")) {
         country[j] = maincountry;
      }
      for (k = 0; k < nmctrymentions[j]; ++k) {
         if (Math.abs(actsen[i] - ctrysen[j][k]) < 6) {
            if (nmcountries == 0) {
               ctrystrng = country[j];
	
            } else {
               ctrystrng += " " + country[j];
            }
	    ++nmcountries;
	    continue CTRYLOOP;
	 }
      }
   }

   /* Find all regions from the list of regions found previously
      by "findregions_" that are within some number of sentences of
      action sentence. */
   
   nmregions = 0;
   for (j = 0; j < nmregionsttl; ++j) {

      // A backup country and region pair was found in findregions_().

      if (rgnsen[0][0] == -1) {
         ctrystrng = country[0];
         nmcountries = 1;
         actreg[0] = region[0];
         ardist[0] = 0.;
         nmregions = 1;
         break;
      }

      for (k = 0; k < nmrgnmentions[j]; ++k) {
         actregdist = (double) Math.abs(actsen[i] - rgnsen[j][k]);
         if (actregdist < 60.) {
            actreg[nmregions] = region[j];
	    ardist[nmregions] = actregdist;
	    ++nmregions;
	    break;
         }
      }
   }

   if (nmregions == 0) {
      printf_("storyaction: no region found");
      noregion = true;
   }
   printf_("storyaction: nmcountries= " + nmcountries + " nmregions= " +
      nmregions);

   /* Sort these regions by their distance to the action sentence.
      Use only the closest region if it is in the same sentence
      as the action.  Otherwise, use the closest 2 regions. */

   if (nmregions > 0) {
      for (j = 1; j <= nmregions; ++j) {
         index[j - 1] = j;
      }
      Idsort.idsort_(ardist, index, 1, nmregions);
      rgnstrng = actreg[index[0] - 1];
      if (ardist[index[0] - 1] < 1.e-6) {
         nmregions = 1;

      } else if (nmregions > 1) {
         rgnstrng += " " + actreg[index[1] - 1];
         nmregions = 2;
      } 
   } 

   /* If no countries were found but at least one region was found,
      use the first region's country. */

   if (nmcountries == 0 && nmregions > 0) {
      ctrystrng = country[0];
      nmcountries = 1;

   } else if (nmcountries == 0 && nmregions == 0) {
      printf_("storyaction: action= " + (i + 1) +
         " no country and no region, continuing");
      Storyutils.writestory_(false, articleid, nmstoryactions,
         storyaction_action);

      continue ACTNSLP;
   }

   // Use story date for action date if no action date was found.

   if (actyear[i] < 0. || actyear[i] >= storyyear) {
      actmonth[i] = storymonth;
      actday[i] = storyday;
      actyear[i] = storyyear;

      if (actyear[i] < 0.) {
         printf_("storyaction: actyear= " + actyear[i] + " continuing");
         continue ACTNSLP;
      }
   }

   if (actmonth[i] == 0) {
      actmonth[i] = 1;
   }

   if (actday[i] == 0) {
      actday[i] = 1;
   }

   /*  An action's format is:

       1  action identifier 
       2  article identifier number
       3  story date 
       4  source of story 
       5  number of actors 
       6  list of actors 
       7  number of subjects 
       8  list of subjects 
       9  action phrase 
      10  number of countries subjected to action 
      11  list of countries 
      12  number of regions 
      13  list of regions 
      14  date of action 

   (old code)

   ++actionid;
   rawaction_actionid[nmrawactions] = actionid;
   rawaction_month[nmrawactions] = storymonth;
   rawaction_day[nmrawactions] = storyday;
   rawaction_year[nmrawactions] = ((int) storyyear);
   rawaction_nmactors[nmrawactions] = nmactors[i];
   rawaction_actrstrng[nmrawactions] = actrstrng;
   rawaction_nmsubjects[nmrawactions] = nmsubjects[i];
   rawaction_sbjctstrng[nmrawactions] = sbjctstrng;
   rawaction_action[nmrawactions] = action[i];
   rawaction_nmcountries[nmrawactions] = nmcountries;
   rawaction_ctrystrng[nmrawactions] = ctrystrng;
   rawaction_nmregions[nmrawactions] = nmregions;
   rawaction_rgnstrng[nmrawactions] = rgnstrng;
   rawaction_actmonth[nmrawactions] = actmonth[i];
   rawaction_actday[nmrawactions] = actday[i];
   rawaction_actyear[nmrawactions] = ((int) actyear[i]);
   ++nmrawactions;
   */

   storyaction_month[nmstoryactions] = storymonth;
   storyaction_day[nmstoryactions] = storyday;
   storyaction_year[nmstoryactions] = ((int) storyyear);
   storyaction_nmactors[nmstoryactions] = nmactors[i];
   storyaction_actrstrng[nmstoryactions] = actrstrng;
   storyaction_nmsubjects[nmstoryactions] = nmsubjects[i];
   storyaction_sbjctstrng[nmstoryactions] = sbjctstrng;

   storyaction_action[nmstoryactions] = action[i];

   storyaction_nmcountries[nmstoryactions] = nmcountries;
   storyaction_ctrystrng[nmstoryactions] = ctrystrng;
   storyaction_nmregions[nmstoryactions] = nmregions;
   storyaction_rgnstrng[nmstoryactions] = rgnstrng;
   storyaction_actmonth[nmstoryactions] = actmonth[i];
   storyaction_actday[nmstoryactions] = actday[i];
   storyaction_actyear[nmstoryactions] = ((int) actyear[i]);

   ++nmstoryactions;
   printf_("storyaction: nmstoryactions= " + nmstoryactions +
      " action= " + action[i]);
}
}
}
