import java.util.*;
public class Ssens extends CA {

static String parmname[] = new String[15];

static int i;

static double parmval = -1.;

static double refval[] = new double[15];
static double parmin[] = new double[15];
static double parmax[] = new double[15];
static double lowval[] = new double[15];
static double highval[] = new double[15];

// --------------------------------------------------------------------

public static void ssens_() {

// Performs a sustainability-focused sensitivity analysis.

int j, k, l, nmtrys = 0;

double step, pextinct = -1., minpextinct = 1.;

// Traders ABM parameters.

parmname[0] = "ra";
refval[0] = .4;
parmin[0] = .2;
parmax[0] = .6;

parmname[1] = "reserveprice";
refval[1] = 60000.;
parmin[1] = 50000.;
parmax[1] = 70000.;

parmname[2] = "maxcap";
refval[2] = 35.;
parmin[2] = 30.;
parmax[2] = 40.;

// Rhino abundance IBM parameters.

parmname[3] = "le";
refval[3] = 38. * 52.;
parmin[3] = 32. * 52.; // was 32
parmax[3] = 42. * 52.; // was 42

parmname[4] = "ma";
refval[4] = 4. * 52.;
parmin[4] = 3.5 * 52.;
parmax[4] = 4.5 * 52.;

parmname[5] = "intercalv";
refval[5] = 2.5 * 52.; // was 2.5
parmin[5] = 2.5 * 52.; // was 2.5
parmax[5] = 5. * 52.;

parmname[6] = "wfi";
refval[6] = 140. * 1000.;
parmin[6] = 120. * 1000.;
parmax[6] = 160. * 1000.;

parmname[7] = "meb";
refval[7] = 5.;
parmin[7] = 4.5;
parmax[7] = 5.5;

parmname[8] = "meaneb";
refval[8] = 4.;
parmin[8] = 3.5;
parmax[8] = 4.5;

parmname[9] = "jeb";
refval[9] = 3.;
parmin[9] = 2.5;
parmax[9] = 3.5;

cacalc = false;
Beliefs.loadconsdst = false;
HIBMutils.riskfle = "dum.plt";
for (i = 8; i < 10; ++i) { // was 0, 10
   printf_("\n--------- Parameter= " + parmname[i] + " ------------");
   lowval[i] = refval[i];
   highval[i] = refval[i];
   step = (parmax[i] - parmin[i]) / 4.05; // was 6.1
   minpextinct = 1.;
   OUTLOOP: for (j = 0; j <= 2; ++j) { // was 3
      for (k = 0; k < 2; ++k) {

	 // Find parameter value to assess model sensitivity at.
	 
	 if (k == 0) {
            lowval[i] -= step;
            parmval = lowval[i];
            if (parmval < parmin[i]) {
               fclose_(5, 'w');
               fclose_(8, 'w');
               continue;
	    }

	 } else {
	    highval[i] += step;
            parmval = highval[i];
            if (parmval > parmax[i]) {
               fclose_(5, 'w');
               fclose_(8, 'w');
               continue;
	    }
	 }
         // parmval = 3.4938;

	 nmtrys = 0;
         do {

	    // Initialize random number generator

            for (l = 0; l <= nmthreads; ++l) {
               Rndm.rndm1_(l, 1);
            }

            // Setup call to "intridslve_."

            Intridslve.intridslve_(true, false);

	    // Solve for actions history.

            Intridslve.intridslve_(false, false);

            // Compute extinction risk in the year 2045.
 
            pextinct = HIBMutils.computerisk_(2045.); // was 2045
            printf_("parmval= " + parmval + " pextinct= " +
               fdble_(pextinct, 5, 3));
	    ++nmtrys;
         } while (pextinct < .15 && nmtrys < 10);

	 if (pextinct < minpextinct) {
            minpextinct = pextinct;
	 }
      }
   }
   printf_("minimum pextinct= " + minpextinct);
}
}

// --------------------------------------------------------------------

public static void resetparm_() {

// Reset the ith parameter.

int l;

if (parmname[i].equals("ra")) {
   Econcalcs.ra = parmval;

} else if (parmname[i].equals("reserveprice")) {
   Econcalcs.reserveprice = parmval;

} else if (parmname[i].equals("maxcap")) {
   Econcalcs.trader_maxcap[0] = parmval;
   Econcalcs.trader_maxcap[1] = parmval;

} else if (parmname[i].equals("le")) {
   HIBMcalcs.le[0] = (int) Math.round(parmval);

} else if (parmname[i].equals("ma")) {
   for (l = 0; l < HIBMcalcs.ttlnmpatches; ++l) {
      HIBMcalcs.ma[0][0][l][0] = (int) Math.round(parmval);
   }

} else if (parmname[i].equals("intercalv")) {
   for (l = 0; l < HIBMcalcs.ttlnmpatches; ++l) {
      HIBMcalcs.intercalv[0][0][l][0] = (int) Math.round(parmval);
   }

} else if (parmname[i].equals("wfi")) {
   HIBMcalcs.wfi[0] = parmval;

} else if (parmname[i].equals("meb")) {
   HIBMcalcs.meb[0] = parmval;

} else if (parmname[i].equals("meaneb")) {

   // Enforce constraint.
	 
   if (HIBMcalcs.meaneb[0] > 0. && HIBMcalcs.meb[0] > 0. &&
      HIBMcalcs.meaneb[0] < HIBMcalcs.meb[0]) {
      HIBMcalcs.meaneb[0] = parmval;

   } else {
      printf_("resetparm: meaneb constraint violation, using ref. value");
   }

} else if (parmname[i].equals("jeb")) {
   HIBMcalcs.jeb[0] = parmval;
}
}
}
