class Srfgrd extends Pltsurf {
static int iblank[] = new int[COLLIM];
static int goodres[] = new int[NUMVAR];
static double zrow[] = new double[COLLIM];
static double varrow[] = new double[COLLIM];
static double xcord[] = new double[COLLIM];
static double ycord[] = new double[COLLIM];
static double cofvar[] = new double[COLLIM];
static double ciwidth[] = new double[COLLIM];
static double relres[] = new double[NUMVAR];
static double resmean[] = new double[NUMVAR];
static double datmean[] = new double[NUMVAR];
static double ressqr[] = new double[NUMVAR];
static double resstd[] = new double[NUMVAR];
static double rootmse[] = new double[NUMVAR];
static double kermean[] = new double[NUMVAR];
static double stderrmean[] = new double[NUMVAR];
static double resids[][] = new double[DATSZE][NUMVAR];
static double stdresids[][] = new double[DATSZE][NUMVAR];
static double pstderrs[][] = new double[DATSZE][NUMVAR];
static double pbias[] = new double[NUMVAR];
static double sebias[] = new double[NUMVAR];
static double relrmse[] = new double[NUMVAR];
static double trimfrac[] = new double[NUMVAR];
static double maxvec[] = new double[NUMVAR];
static double ltocmn[] = new double[NUMVAR];
static double minval[] = new double[6];
static double maxval[] = new double[6];

// -------------------------------------------------------------------

static void srfgrd_(boolean wflag) {

/* Writes surface files.  If doing kriging, these consist of prediction,
   estimated standard deviation, and relative interpolation error grid
   (*.sgd) files. */

String head;
int i, j, k, nmbstd, vrble, cvstrct, resfle = 7;
double obsrvd, resid, nmres, krgvar, stdres;

// Open scratch file of kriging predictions.

fleopen_(5, "kest.tmp", 'r');
 
if (icrval == 1) {

   if (wflag) {

      // Write standardized residual file.

      printf_("srfgrd: opening standardized residuals file");
      fleopen_(resfle, "stdres.plt", 'w');
   }

   nmbstd = 0;
   for (i = 0; i < parm_mvar; ++i) {
      goodres[i] = 0;
      datmean[i] = 0.;
      kermean[i] = 0.;
      stderrmean[i] = 0.;
      relres[i] = 0.;
      resmean[i] = 0.;
      ressqr[i] = 0.;
      ltocmn[i] = 0.;
   }

   /* Read a cross-validation estimates and write residual and
      standardized residual file. */

   while (checkeof_(5) != true) {
      vrble = fgetint_(5);
      xcord[0] = fgetdble_(5);
      ycord[0] = fgetdble_(5);
      iblank[0] = fgetint_(5);
      obsrvd = fgetdble_(5);
      zrow[0] = fgetdble_(5);
      varrow[0] = fgetdble_(5);
      cofvar[0] = fgetdble_(5);
      ciwidth[0] = fgetdble_(5);

      // Calculate residual(s).

      if (iblank[0] == 0) {
         if (varrow[0] <= 0.) {
            printf_("srfgrd: var= " + varrow[0]);
	    continue;
         }
	 krgvar = varrow[0];
         resid = obsrvd - zrow[0];
	 stdres = resid / Math.sqrt(krgvar);
         datmean[vrble - 1] += obsrvd;
         if (obsrvd != 0.) relres[vrble - 1] += resid / obsrvd;

         ressqr[vrble - 1] += resid * resid;
	 kermean[vrble - 1] += krgvar;

         /* Store both the residual, standardized residual, and the
            prediction standard error. */

         resids[goodres[vrble - 1]][vrble - 1] = resid;
         stdresids[goodres[vrble - 1]][vrble - 1] = stdres;
         pstderrs[goodres[vrble - 1]][vrble - 1] = Math.sqrt(krgvar);

	 if (lngmem) {

            // Collect long memory statistics.

            ltocmn[vrble - 1] += varmod_lma[vrble - 1] /
               (varmod_nugget[0][vrble - 1] +
                varmod_sill[0][vrble - 1] +
                varmod_lma[vrble - 1]);
         }

         if (wflag) {
	    fprintf_(resfle, vrble + " " + fdble_(xcord[0], 5, 3) + " " +
               fdble_(ycord[0], 5, 3) + " " + resid + " " +
               Math.sqrt(krgvar) + " " + stdres);
         }

	 ++goodres[vrble - 1];
      } // End of iblank = 0 conditional.
   } // End of read "while" statement.
   fprintf_(1, "Number of extreme residuals=        " + nmbstd);

   // Compute summary statistics.

   for (i = 0; i < parm_mvar; ++i) trimfrac[i] = 0.;
   Summry.summry_(false, 1, goodres, parm_mvar, trimfrac, stdresids,
      resmean, sebias, maxvec);
   Summry.summry_(false, 1, goodres, parm_mvar, trimfrac, resids,
      resmean, resstd, maxvec);

   for (i = 0; i < parm_mvar; ++i) {
      if (goodres[i] > 0) {
	 nmres = (double) goodres[i];

         datmean[i] /= nmres;
         relres[i] /= nmres;

         kermean[i] /= nmres;
	 if (lngmem) ltocmn[i] /= nmres;
         resmse[i] = ressqr[i] / nmres;
         rootmse[i] = Math.sqrt(resmse[i]);
         pbias[i] = resmean[i] / datmean[i];
         relrmse[i] = rootmse[i] / datmean[i];
         sebias[i] = sebias[i] - 1.;
         if (wflag) {
	    fprintf_(1, "\nVariable " + lomapnms[i] +
              "\nNumber of residuals               =  " + goodres[i] +
              "\nData Mean                         =  " + datmean[i] +
              "\nResidual Mean                     =  " + resmean[i] +
              "\nResidual Mean / Data Mean         =  " + pbias[i] +
              "\nAverage Relative Residual         =  " + relres[i] +
              "\nt-statistic                       =  " +
                 (resmean[i] / (resstd[i] / Math.sqrt(nmres))) +
              "\nResidual Mean-Squared-Error (MSE) = " + resmse[i] +
              "\nRoot Mean Squared Error (RMSE)    = " + rootmse[i] +
              "\nRelative RMSE                     = " + relrmse[i] +
              "\nMean Kriging Variance             = " + kermean[i] +
              "\nMean Kriging Variance / MSE       = " +
                 (kermean[i] / resmse[i]) +
              "\nMean Standard Error               = " + stderrmean[i] +
              "\nRoot Mean Krig. Var. / RMSE       = " +
                 (Math.sqrt(kermean[i]) / rootmse[i]) +
              "\nse_bias                           =  " + sebias[i]);

            if (lngmem) fprintf_(1, 
              "\nMean lma / c(0)=                 " + ltocmn[i]);
         }

      } else {
	 if (wflag) fprintf_(1, "goodres(" + lomapnms[i] +
                       ")=0, no statistics possible.");
      }
   }

   if (wflag) {
      fclose_(resfle, 'w');
   }

   return;
}

// Write grid files.

fleopen_(7, "est.sgd", 'w');
fleopen_(8, "std.sgd", 'w');
fleopen_(9, "cofvar.sgd", 'w');
fleopen_(10, "nug.sgd", 'w');
fleopen_(11, "sill.sgd", 'w');

for (i=0; i < 5; ++i) minval[i] = 1.e30;
for (i=0; i < 5; ++i) maxval[i] = -1.e30;

// Write grid type, nmrows, nmcols, mins, maxs.

fprintf_(7, gphtitl[0] + "\n" + gphtitl[1]);
fprintf_(7, spacetime_grdtyp + " " + spacetime_nmrows + " " +
   spacetime_nmcols + " " + spacetime_xmin + " " + spacetime_xmax + " " +
   spacetime_ymin + " " + spacetime_ymax + " " +
   bdry_predmin[0] + " " + bdry_predmax[0]);

fprintf_(8, gphtitl[0] + "\n" + gphtitl[1]);
fprintf_(8, spacetime_grdtyp + " " + spacetime_nmrows + " " +
   spacetime_nmcols + " " + spacetime_xmin + " " + spacetime_xmax + " " +
   spacetime_ymin + " " + spacetime_ymax + " " +
   Math.sqrt(bdry_kvarmin[0]) + " " + Math. sqrt(bdry_kvarmax[0]));

fprintf_(9, gphtitl[0] + "\n" + gphtitl[1]);
fprintf_(9, spacetime_grdtyp + " " + spacetime_nmrows + " " +
   spacetime_nmcols + " " + spacetime_xmin + " " + spacetime_xmax + " " +
   spacetime_ymin + " " + spacetime_ymax + " " +
   bdry_cvmin[0] + " " + bdry_cvmax[0]);

fprintf_(10, gphtitl[0] + "\n" + gphtitl[1]);
fprintf_(10, spacetime_grdtyp + " " + spacetime_nmrows + " " +
   spacetime_nmcols + " " + spacetime_xmin + " " + spacetime_xmax + " " +
   spacetime_ymin + " " + spacetime_ymax + " " +
   bdry_nugmin[0] + " " + bdry_nugmax[0]);

fprintf_(11, gphtitl[0] + "\n" + gphtitl[1]);
fprintf_(11, spacetime_grdtyp + " " + spacetime_nmrows + " " +
   spacetime_nmcols + " " + spacetime_xmin + " " + spacetime_xmax + " " +
   spacetime_ymin + " " + spacetime_ymax + " " +
   bdry_sillmin[0] + " " + bdry_sillmax[0]);

// Creat grid files a row at a time.

for (j = 0; j < spacetime_nmrows; ++j) {

   // Get entire row of estimates.

   for (i = 0; i < spacetime_nmcols; ++i) {
      xcord[i] = fgetdble_(5);
      ycord[i] = fgetdble_(5);
      iblank[i] = fgetint_(5);
      zrow[i] = fgetdble_(5);
      varrow[i] = fgetdble_(5);
      cofvar[i] = fgetdble_(5);
      ciwidth[i] = fgetdble_(5);

      // First, check for outside of boundary values.

      if (iblank[i] == 1) {
         zrow[i] = 0.;
         varrow[i] = 0.;
         cofvar[i] = 0.;
         grdvar_nug[j][i][0][0] = 0.;
         grdvar_sill[j][i][0][0] = 0.;
      }
   }

   /* Write grid files (these are similar to those that SAS will accept
      in its "proc contour" routine). */

   for (i = 0; i < spacetime_nmcols; ++i) {
      fprintf_(7, xcord[i] + " " + ycord[i] + " " + zrow[i] +
         " " + iblank[i]);
      
      if (varrow[i] > 0.) varrow[i] = Math.sqrt(varrow[i]);
      fprintf_(8, xcord[i] + " " + ycord[i] + " " + varrow[i] +
         " " + iblank[i]);

      fprintf_(9, xcord[i] + " " + ycord[i] + " " + cofvar[i] +
         " " + iblank[i]);
      
      fprintf_(10, xcord[i] + " " + ycord[i] + " " + grdvar_nug[j][i][0][0] +
         " " + iblank[i]);
      
      fprintf_(11, xcord[i] + " " + ycord[i] + " " + grdvar_sill[j][i][0][0] +
         " " + iblank[i]);
   }
}

// Close files.

fclose_(5, 'r');
fclose_(7, 'w');
fclose_(8, 'w');
fclose_(9, 'w');
fclose_(10, 'w');
fclose_(11, 'w');
}
}
