public class SimAnnealUtils extends SimAnnealContin {

static double cu[] = new double[OPTSIZE];
static double cwidth[] = new double[OPTSIZE];

// --------------------------------------------------------------------

public static void newStepLength_(int optimizer, boolean initial) {

/* Computes a new step length for each variable, and the run's chain length.
   Let unifmedian be the median value of the randomly generated probability.
   For the uniform distribution, this is 0.5.
*/

int i;

double unifmedian = .5, dumlength = 0., medianstepi;

if (initial) {

   /* Initialize the step length "varying criterion," step lengths,
      and the chain length.  The chain length is the number of points
      reachable in one move.  Here, a move is along a single dimension.
      To compute it, assume the median is returned by the
      uniform random number generator and then multiplied against 1/50th of
      the largest bounds-width to get a median step length.  Then,
      the chain length is the number of these median steps along the
      widest set of bound constraints. */

   chainlngth = 1;
   for (i = 0; i < n; ++i) {
      cwidth[i] = h[i] - g[i];
      cu[i] = 1.0; // was 1.01
      steplength[i] = (h[i] - g[i]) / 10.; // was 50, 100
      medianstepi = unifmedian * steplength[i];
      dumlength = (int) ((h[i] - g[i]) / medianstepi);
      if (dumlength > chainlngth) {
         chainlngth = dumlength;
      }
   }

   // Speed-up experiment.

   chainlngth = 10; // was 1

} else {

   /* Compute new step lengths using equations from Corana et al. (1987,
      p. 267). */

   for (i = 0; i < n; ++i) {
      if (nu[optimizer][i] > .6 * contin_rns) {

         // Make step longer.

         steplength[i] *= 1. + cu[i] *
            ((nu[optimizer][i] / contin_rns) - 0.6) / 0.4;

	 if (steplength[i] > .2 * cwidth[i]) {
	    steplength[i] = .2 *cwidth[i];
	 }

      } else if (nu[optimizer][i] < .4 * contin_rns) {
	  
         // Make step shorter.

         steplength[i] /= 1. + cu[i] *
            (0.4 - (nu[optimizer][i] / contin_rns)) / 0.4;
      }

      // Don't let the step length get too small.

      if (steplength[i] < .01 * cwidth[i]) {
         steplength[i] = .01 * cwidth[i];
      }
   }
}

return;
}

// --------------------------------------------------------------------

public static void storeSol_(double x[], double xtrial[]) {

// Store the "xtrial" solution.

int i;

for (i = 0; i < n; ++i) {
   x[i] = xtrial[i];
}
}

// --------------------------------------------------------------------

public static void storeMin_(double xstoremin[]) {

// Store minimum solution.

int i, j;

for (i = 0; i < n; ++i) {
   xmin[i] = xstoremin[i];
}
}

// --------------------------------------------------------------------

public static void storeMax_(double x[]) {

// Store maximum solution.

int i, j;

for (i = 0; i < n; ++i) {
   xmax[i] = x[i];
}
}

// ---------------------------------------------------------------------

public static void loadMin_(double xloadmin[]) {

// Load the stored minimum solution.

int i;

for (i = 0; i < n; ++i) {
   xloadmin[i] = xmin[i];
}
}

// ---------------------------------------------------------------------

public static double updateGamma_(double t, double sold[]) {
 
// For a PACSA run, update the inter-optimizer coupling term, gamma.

int i;

double gamma;

largestsold = sold[0];
for (i = 1; i < nmperformers; ++i) {
   if (largestsold < sold[i]) {
      largestsold = sold[i];
   }
}

gamma = 0.;
for (i = 0; i < nmperformers; ++i) {
   gamma += Math.exp((sold[i] - largestsold) / t);
}

return gamma;
}
}
