import java.rmi.RemoteException;
import java.util.*;
import java.util.concurrent.TimeUnit;

import org.openspaces.core.GigaSpace;
import org.openspaces.core.GigaSpaceConfigurer;
import org.openspaces.core.space.EmbeddedSpaceConfigurer;
import org.openspaces.core.space.SpaceProxyConfigurer;

import java.util.Arrays;
import java.util.Properties;

// ------------------------------------------------------------------------

public class SimAnnealContin extends Optimiz {

static boolean terminate = false;

static int contin_ns;

static int index[] = new int[10];
static int nmaccpt[] = new int[10];

static double chainlngth, smin, oldsmin = 1.e30, smax, contin_rns,
   largestsold = 0., globalsearchthres;

static long begintime = 0, soltime = 0, solwaittime;

static double x[][] = new double[10][OPTSIZE];
static double xtrial[][] = new double[10][OPTSIZE];
static double xsorted[][] = new double[10][OPTSIZE];
static double xmin[] = new double[OPTSIZE];
static double xmax[] = new double[OPTSIZE];
static double xfeas[] = new double[OPTSIZE];
static double inarry[] = new double[OPTSIZE];
static double delarry[] = new double[OPTSIZE];
static double steplength[] = new double[OPTSIZE];
static double nu[][] = new double[10][OPTSIZE];
static double t[] = new double[10];
static double told[] = new double[10];
static double sold[] = new double[10];
static double snew[] = new double[10];
static double avescr[] = new double[10];
static double avescrold[] = new double[10];
static double scrstdev[] = new double[10];
static double nmgood[] = new double[10];
static double accpt[] = new double[10];
static double cnvstat[] = new double[10];

// -----------------------------------------------------------------------

public static int simAnnealContin_(double inoutx[], double estop) {

/* Uses simulated annealing to solve a mathematical programming problem
   that has a black box objective function and continuously-valued
   variables that are bound-constrained by MINIMIZING the objective
   function.  The cooling schedule and stopping criterion is the
   finite-time approximation (chapter 4) in "Simulated Annealing and
   Boltzmann Machines" by E. Aarts and J. Korst, Wiley, 1989.  Set the
   initial temperature in the call to this method.

   The length of each inner loop's Markov chain is equal to the size of
   the neighborhood (p. 65).  Because each dimension's (variable's)
   step length is recomputed every pass through the outer loop, this chain
   length is recomputed also.  The step length computation is due to
   Corana et al. (1987).  These authors also recommend "contin_ns" be
   set to 20.  See SimAnnealUtils.java for "contin_rns" in action.

   This algorithm can handle noisy objective functions using a method
   developed by Bouttier and Gavra (2019).

   This algorithm can use multiple compute nodes to reduce its wall-clock
   solution time using a new method developed herein called Multiple
   Periodic Exchange (MPE) -- a scheme similar to the class of parallel
   Simulated Annealing algorithms dubbed {\em periodic exchange schemes}
   by Lee and Lee (1996).

    Lee, S-Y. and Lee, K.G. (1996), Synchronous and asynchronous parallel
    simulated annealing with multiple Markov Chains. IIE Transactions on
    Parallel and Distributed Systems 7.
    
    The algorithm is:
    1. Within the classic SA Inner Loop, run m performers asynchronously
       over two chains, i.e., two iterations of SA's outer loop.
    2. Check for convergence.  If not converged, continue to step 3.
    3. Sort these m solutions by their objective function value.
    4. Reinitialize  m/2 of the optimzers at the first sorted
       solution, and the remaining at the second sorted solution.
    5. Run the performers over two more chains.
    6. Go to step 2.

    Because Hooke uses a different convergence criterion, set "estop" for Simulated
    Annealing to about one-tenth the value set for Hooke.

    If the algorithm converges prematurely, try increasing "chainlngth" in
    SimAnnealUtils.java.
 
    If a global search threshold is not desired, set this input parameter to -1.0.
*/

boolean test = false, feasibleexists = false, allvars = true, finished = false;

int i, i2, j, k, l, hindex, nmiter, maxiter = 10000, nmready = 0, nmnoimprove = 0,
   tempval = -1, val1 = -1, val2 = -1, nmcompleted, maxaccptl = 0, newsamplesize;

double tinitial, rchainlngth, delta = 2.0, // was 2.0
   scrinitial, denom, stochtime0 = 1.0, stochtime = 1.0,
   gamma = 1., accptprobfcn = 0., maxaccptval = 0., globalsearchval = 0.;

Opttask task[] = new Opttask[50];

// Quit if n is out of range.

if (n <= 0) {
   iderr_("simAnnealContin: n= " + n);
}
if (n > OPTSIZE) {
   iderr_("simAnnealContin: n= " + n + " > OPTSIZE= " + OPTSIZE);
}

// Optionally, find a GigaSpace.

if (space_in_use && gspace == null) {

   // Get a new Space object.

   gspace = new GigaSpaceConfigurer(new SpaceProxyConfigurer(
      spacename)).defaultTakeTimeout(spacetakewaittime).gigaSpace(); 

   if (gspace == null ) {
      iderr_("simannealContin: gspace=null");
   }

   try {
   TimeUnit.SECONDS.sleep(shortwaittime);
   } catch (java.lang.InterruptedException ie) {
   System.out.println(ie);
   } 

   // Loop until at least all performers have started.

   MsgEntry msgTmpl = new MsgEntry();
   MsgEntry msg = new MsgEntry();
   for (i = 0; i < 50; ++i) {

      // Wait a bit before checking for a "ready" message.

      try {
      TimeUnit.SECONDS.sleep(10L);
      } catch (java.lang.InterruptedException ie) {
      System.out.println(ie);
      } 

      msg = (MsgEntry) gspace.take(msgTmpl);

      if (msg == null) {
         continue;

      } else if (msg.message.equals("ready")) {
         ++nmready;
      }
      printf_("simAnnealContin: ready-msg=" + msg.message + " nmready= " + nmready);
      if (nmready == nmperformers) {
         break;
      }
   }

   if (nmready < 1) {
      Hooke.terminateClients_(gspace);
      iderr_("simAnnealContin: nmready= " + nmready + " no clients, terminating.");
   }
}

// Transfer the input x vector to the array of performer x-vectors.

for (i = 0; i < nmperformers; ++i) {
   for (j = 0; j < n; ++j) {
      x[i][j] = inoutx[j];
   }
}

// Compute the first score value and find score-evaluation wall clock time.

begintime = System.currentTimeMillis();
snew[0] = scoreEval_(x[0]);
soltime = System.currentTimeMillis();
soltime = ((soltime - begintime) / 1000) + 1;
solwaittime = (long) (1.2 * ((double) soltime));

// Store the initial score value.

scrinitial = snew[0];
printf_("simAnnealContin: scrinitial= " + scrinitial);

/* Set the number of continuous variable evaluations, the initial step
   length and the fixed chainlngth. */

contin_ns = 3; // Should be at least 20, was 60.
contin_rns = contin_ns;
SimAnnealUtils.newStepLength_(0, true);

if (test) {
 
   // Open solution history file.

   fleopen_(10, "simhist.plt", 'w');
}

rchainlngth = (double) chainlngth;
printf_("simAnnealContin: rchainlngth= " + rchainlngth +
   " Convergence epsilon= " + estop + " soltime= " + soltime + " seconds.");

/* Find starting temperature value.  Do this by solving for t for a probability of 0.5
   under a 5% increase in the score due to a bad move. */

sold[0] = snew[0];
t[0] = Math.abs((0.05 * sold[0]) / Math.log(.5));

printf_("simAnnealContin: sold= " + sold[0] +
        "\n   initial starting temperature= " + t[0]);

/* Find initial control parameter t defined to be the value for which the
   percentage of moves accepted is between 85 and 100.  In PACSA, this
   task is run on the impresario node only. */

for (j = 0; j < 10; ++j) { // was 50
   nmaccpt[0] = 0;
   avescr[0] = 0.;
   scrstdev[0] = 0.;
   sold[0] = 1.e30;
   nmgood[0] = 0.;

   for (i = 0; i < chainlngth; ++i) {
      move_(n, x[0], xtrial[0]);
      snew[0] = scoreEval_(xtrial[0]);
            
      /* Terminate if the maximum number of objective function evaluations
         has been exceeded. */

      if (funevals > maxnmf) {
         printf_("simAnnealContin: initialization loop, funevals= " +
            funevals + " > maxnmf, returning.");
         terminate = true;
	 
	 return 1;
      }

      /* Terminate if this randomly chosen solution produces a worse function
         value. */

      if (5. * scrinitial < snew[0]) {
         printf_("simAnnealContin: scrinitial= " + scrinitial + " first snew= " +
            snew[0] + " returning.");
      }

      nmgood[0] += 1.;

      /* Aarts and Korst solution acceptance decision using only the
         impresario node.  Always accept solutions that are smaller
         than sold.  Accept other solutions with probability
         exp(-(snew - sold) / t). */

      if ((t[0] * Math.log(Rndm.rndm1_(0, 0))) < (sold[0] - snew[0])) {
         SimAnnealUtils.storeSol_(x[0], xtrial[0]);
         sold[0] = snew[0];
         ++nmaccpt[0];
      }

      // Build the score's average and standard deviation.

      avescr[0] += sold[0];
      scrstdev[0] += sold[0] * sold[0];
   } // End of chainlngth loop.

   accpt[0] = ((double) nmaccpt[0]) / nmgood[0];
   avescr[0] /= nmgood[0];

   if (nmgood[0] > 1.) {
      scrstdev[0] = Math.sqrt((scrstdev[0] -
                      (nmgood[0] * avescr[0] * avescr[0])) / (nmgood[0] - 1.));

   } else {
      scrstdev[0] = 0.;
   }

   printf_("simAnnealContin: initialization loop j= " + j + " nmgood= " + nmgood[0] +
      "\n   tinitial= " + fdble_(t[0], 8, 4) + " avescr= " + fdble_(avescr[0], 8, 4) +
      "\n   scrstdev= " + fdble_(scrstdev[0], 8, 4) + " accpt= " + fdble_(accpt[0], 8, 4));

   // Adjust t accordingly.

   if (accpt[0] < .7) {
      t[0] *= 1.2;
   
   } else if (accpt[0] > .9) {
      t[0] /= 1.5;
   }

   if (accpt[0] >= .80 && accpt[0] <= .99) {
      break;
   }
} // End of initialization-attempts loop.

printf_("simAnnealContin: end of initialization loop, t0= " + t[0] +
   " accpt0= " + accpt[0] + "\n   funevals= " + funevals);

/* Outer loop of simulated annealing.  delta is the distance parameter
   and estop is the convergence criterion parameter (pp. 63-64). */

nmiter = 1;
smin = 1.e30;
smax = -1.e30;
sold[0] = scoreEval_(x[0]);

// Store the best-so-far solution.

printf_("simAnnealContin: starting sold= " + sold[0]);
SimAnnealUtils.storeMin_(x[0]);

for (i = 1; i < nmperformers; ++i) {
   t[i] = t[0];
   for (j = 0; j < n; ++j) {
      x[i][j] = x[0][j];
   }
   sold[i] = sold[0];
}

//gamma = SimAnnealUtils.updateGamma_(t, sold);

// -------------------- Outer Loop. ------------------------------

for (;;) {
   printf_("Iteration Performer  t    avescr    scrstdev   accpt    evals" +
      "    cnvstat");
   
   for (l = 0; l < nmperformers; ++l) {
      avescr[l] = 0.;
      scrstdev[l] = 0.;
      nmaccpt[l] = 0;
      nmgood[l] = 0.;
   }

   // ------------------- Inner loop. ----------------------------

   for (i = 0; i < chainlngth; ++i) {

      for (l = 0; l < nmperformers; ++l) {
         for (j = 0; j < n; ++j) {
            nu[l][j] = 0.;
         }
      }

      for (j = 0; j < contin_ns; ++j) {
         for (hindex = 0; hindex < 1; ++hindex) {

            // Performers evaluate the score function at their given points.

            for (l = 0; l < nmperformers; ++l) {
               if (!space_in_use) {

                  // Generate a move and calculate the score function value.

                  //move_(hindex, x[l], xtrial[l]);
                  move_(n, x[l], xtrial[l]);
                  snew[l] = scoreEval_(xtrial[l]);

               } else {
                  move_(n, x[l], xtrial[l]);
	          task[l] = new Opttask((l + 1), n, nmids, false,
                     stochsamplesize, xtrial[l],
                     CA.nmobsactns, CA.jackknifedeleted,
	             Intridslve.nminoutpairs);

	          if (task[l] == null) {
                     Hooke.terminateClients_(gspace);
                     iderr_("simAnnealContin: task " + l + " =null");
                  }
                  gspace.write(task[l]);
               }
               nmgood[l] += 1.;
            } // End of loop over performers.
           
            // Performers return their evaluations.

            if (space_in_use) {
               ResultEntry template = new ResultEntry();
               nmcompleted = 0;
	       while (true) {
                  ResultEntry result = new ResultEntry();
	          result = gspace.take(template, spacetakewaittime);
                  if (result != null) {
                     if (Optresult.class.isInstance(result)) {
                        Optresult hj = (Optresult) result;

                        i2 = hj.i.intValue();

                        /* Get the objective function value computed by
                           this task. */

                        snew[i2 - 1] = hj.retfval.doubleValue();
                        ++nmcompleted;
                     }
                  }
		  if (nmcompleted == nmperformers) {
		     break;
		  }
               }

	    } else {
               nmcompleted = nmperformers;
            }

	    // Update number of objective function evaluations.

            funevals += (stochsamplesize * nmcompleted);
            if (funevals > maxnmf) {
               printf_("simAnnealContin: inner loop, funevals= " +
                  funevals + " > maxnmf, returning.");
               terminate = true;
            }

            // Keep smallest and largest solutions.
            
            for (l = 0; l < nmperformers; ++l) {
               if (snew[l] < smin) {
	          smin = snew[l];
	          SimAnnealUtils.storeMin_(xtrial[l]);

                } else if (snew[l] > smax) {
	          smax = snew[l];
	          SimAnnealUtils.storeMax_(xtrial[l]);
               }
            } // End of performer loop.

	    if (terminate) {
               SimAnnealUtils.loadMin_(inoutx);

               return 1;
	    }

            // Solution acceptance decisions.

            for (l = 0; l < nmperformers; ++l) {
      
               /* Always accept if sold > snew.  Otherwise, accept with
                  probability exp(-(snew - sold) / t). */

               if ((t[l] * Math.log(Rndm.rndm1_(0, 0))) <
                   (sold[l] - snew[l])) {
                   SimAnnealUtils.storeSol_(x[l], xtrial[l]);
                  sold[l] = snew[l];

		  if (allvars) {
                     for (k = 0; k < n; ++k) {
                        nu[l][k] += 1.;
                     }

		  } else {
                     nu[l][hindex] += 1.;
		  }

                  ++nmaccpt[l];
               }

               /* Compute average score and the standard deviation of
                  score values. */
               
               avescr[l] += sold[l];
               scrstdev[l] += sold[l] * sold[l];
            }
         } // End of loop over the n variables (hindex).
      } // End of loop over the contin_ns sets of variable-loops (j). 
   
      // Compute a new vector of step lengths.

      for (l = 0; l < nmperformers; ++l) {
         SimAnnealUtils.newStepLength_(l, false);
      }
   } // End of inner loop over the chain (i).

   /* Find the acceptance ratio, the average score, and the score standard
      deviation. */

   maxaccptval = -1.0;
   maxaccptl = 0;
   for (l = 0; l < nmperformers; ++l) {
      accpt[l] = ((double) nmaccpt[l]) / nmgood[l];
      avescr[l] /= nmgood[l];
      scrstdev[l] = (scrstdev[l] - (nmgood[l] * avescr[l] * avescr[l])) /
                    (nmgood[l] - 1.);
      if (scrstdev[l] > 1.e-6) {
         scrstdev[l] = Math.sqrt(scrstdev[l]);
      }

      // Print statistics for the first chain.

      if (nmiter == 1) {
         printf_("--------------- nmiter=1 ------------------------" +
            "\nPerformer t  avescr   scrstdev   accpt    funevals");
         printf_((l + 1) + "  " + fdble_(t[l], 8, 4) + "  " +
            fdble_(avescr[l], 8, 4) + "  " + fdble_(scrstdev[l], 8, 4) +
            "  " + fdble_(accpt[l], 8, 4) + "  " + funevals +
            "\n--------------------------------------------------\n");
      }

      if (nmiter < 2) {
         continue;
      }

      // Compute largest convergence measure across all performers.

      if (t[l] < told[l]) {
         cnvstat[l] = (avescr[l] - avescrold[l]) / (t[l] - told[l]);
         cnvstat[l] *= t[l] / scrinitial;

      } else {
         cnvstat[l] = (avescrold[l] - avescr[l]) / scrinitial;
      }
      cnvstat[l] = Math.abs(cnvstat[l]);


      printf_(nmiter + " " + (l + 1) + "           " + fdble_(t[l], 10, 8) +
         "  " + fdble_(avescr[l], 8, 4) + "  " + fdble_(scrstdev[l], 10, 8) +
         "  " + fdble_(accpt[l], 8, 4) + "  " + funevals + "  " +
         fdble_(cnvstat[l], 10, 8));

      if (maxaccptval < accpt[l]) {
         maxaccptval = accpt[l];
	 maxaccptl = l;
      }
   } // End of loop over performers.
      
   /* Terminate search if (a) if the maximum acceptance rate is zero, or
      (b) smin has not improved in three iterations. */

   if (accpt[maxaccptl] < 1.e-6 || nmnoimprove == 3) {
      printf_("simAnnealContin: maxaccptl= " + maxaccptl +
         " maxaccptval= " + maxaccptval +
	 "\n   nmnoimprove= " + nmnoimprove + ", terminating search.");
      terminate = true;
   }

   if (Math.abs(smin - oldsmin) < 1.e-6) {
      ++nmnoimprove;
   }

   printf_("simAnnealContin: smin= " + smin + " oldsmin= " + oldsmin);

   oldsmin = smin;
   
   // Store the minimum score function found so far in the output vector.

   SimAnnealUtils.loadMin_(inoutx);

   /* Compute the fraction reduction measure for the global search task.
      SA tries to minimize the objective function so a positive reduction
      will be (scrinitial - smin) divided by the absolute value of
      scrinitial.  Thus: */

   globalsearchval = (scrinitial - smin) / Math.abs(scrinitial);

   if (nmiter > 2) {

      /* Convergence test: After first iteration, test for convergence, p. 64:

              (t/avescrinitial) * d(avescr)/dt < estop. */
      
      for (l = 0; l < nmperformers; ++l) {
         if (0. < cnvstat[l] && cnvstat[l] < estop) {
            finished = true;
            printf_("\nsimAnnealContin: Converged! performer= " + 1 +
               "  " + " cnvstat = " + cnvstat[l] + " funevals= " + funevals);
         }
      }

      if (nmiter > maxiter || terminate) {
         finished = true;
         printf_("simAnnealcontin: nmiter= " + nmiter + " terminate= " + terminate +
	    "\n   funevals= " + funevals +
            " current best solution is printed.");

      } else if (globalsearchval > globalsearchthres) {
	 finished = true;
         printf_("simAnnealContin: globalsearchval= " + globalsearchval +
	    "\n   funevals= " + funevals + " returning.");
      }
   }

   if (finished) {
      if (test) {
         fclose_(10, 'w');
      }

      return 0;
   }

   /* If the standard deviation is not zero, decrement t[l] ("temperature"),
      the control parameter (p. 63). */

   for (l = 0; l < nmperformers; ++l) {
      told[l] = t[l];
      avescrold[l] = avescr[l];

      if (scrstdev[l] > 1.e-6) {
         denom = 1. + (t[l] * Math.log(1. + delta)) / (3. * scrstdev[l]);
         t[l] /= denom;
      }
      if (t[l] < 0.) {
         Hooke.terminateClients_(gspace);
         iderr_("simAnnealContin: t= " + t[l]);
      }
   }

   /* The objective function is stochastic.  Here, the "time" variable
      in Bouttier and Gavra (2019) is linear in the
      number of passes through the outer loop up to the addition of
      Exponential(1) noise (see Bouttier and Gavra, p. 8).  These authors
      also assume a function for stochsamplesize = n_time = f(time).  Here,
      this function is: f(time) = (time / time_0) n_0. */ 

   if (stochobjfcn) {
      stochtime += (1.0 + Rndm.gamdev_(0, 1., 1.));

      newsamplesize = (int) ((stochtime / stochtime0) *
         ((double) stochsamplesize));
      printf_("simAnnealContin: stochtime= " + stochtime + " newsamplesize= " +
         newsamplesize);
      //stochsamplesize = newsamplesize;

      /* NOTE: At this point in the code, the Bouttier and Gavra
         algorithm has the temperature decreased by some function of
         time such as t = 1/time.  But doing so ignores the standard
         deviation of the objective function from the inner loop.  Hence,
         here, the Aarts and Korst algorithm is used to decrement
         temperature just as is the case when the objective function is
         deterministic. */
   }

   /* At the end of each chain (starting with the 3rd chain), exchange
      information across multiple performers. */

   if (nmiter > 2 && nmperformers > 1) {
      
      // Sort solutions by their objective function value.
      
      for (i = 0; i < nmperformers; ++i) {
         index[i] = i + 1;
      }
      Idsort.idsort_(sold, index, 1, nmperformers);
      for (i = 0; i < nmperformers; ++i) {
         for (j = 0; j < n; ++j) {
            xsorted[i][j] = x[index[i] - 1][j];
         }
      }

      /* Reinitialize performers alternatively to either the first
         or the second sorted solution. */

      val1 = 0;
      val2 = 1;
      tempval = -1;
      for (i = 0; i < nmperformers; ++i) {
         for (j = 0; j < n; ++j) {
            //x[i][j] = xsorted[val1][j];
            x[i][j] = xmin[j];
         }
         tempval = val1;
         //val1 = val2;
         val2 = tempval;
      }
   }

   ++nmiter;
} // End of outer loop.
}

// --------------------------------------------------------------------

public static void move_(int hindex, double x[], double xtrial[]) {

// Calculate a new state, "xtrial" from the old state, "x".

int i, ibegin = 0, iend = 0, itercounter = 0;

if (hindex == n) {

   // Move on all variables.

   ibegin = 0;
   iend = n;

} else {
   
   // Move on the h^th variable only.  See Corana et al. (1987, p. 266).

   ibegin = hindex;
   iend = hindex + 1;
}

for (i = ibegin; i < iend; ++i) {
   itercounter = 0;
   do {
      xtrial[i] = x[i] + (2. * Rndm.rndm1_(0, 0) - 1.) * steplength[i]; 
      ++itercounter;
   } while (itercounter < 50 && (xtrial[i] < g[i] || h[i] < xtrial[i]));

   if (xtrial[i] < g[i]) {
      xtrial[i] = g[i];
   }
   if (h[i] < xtrial[i]) {
      xtrial[i] = h[i];
   }
}
}

// ----------------------------------------------------------------------

public static double scoreEval_(double x[]) {

int i;

long begintime = 0, objfsoltime = 0;

double retval = 0.;

// Evaluate the score function and return its value.

for (i = 0; i < stochsamplesize; ++i) {
   retval += -objf_(x);
}
retval /= ((double) stochsamplesize);

funevals += stochsamplesize;

printf_("scoreEval: retval= " + retval + " funevals= " + funevals + " sol:");
/*
for (i = 0; i < n; ++i) {
   printf_("     " + i + "    " + x[i]);
}
*/

return retval;
}
}
