import java.io.*;
import java.lang.reflect.*;
import java.util.*;

/** A class with naively implemented Shell sorting algorithms */
public class ShellSort {
/** collects arguments or lines, has them sorted, outputs lines */
  public static void main (String args []) {
    try {
      if (sort(args) != null && args.length > 0)	// sort arguments
	for (int n = 0; n < args.length; ++ n)
	  System.out.println(args[n]);
      else {						// sort lines
	Vector v = new Vector();
	BufferedReader in =
			new BufferedReader(new InputStreamReader(System.in));
	String line;
	while ((line = in.readLine()) != null)
	  v.addElement(line);
	for (Enumeration e = sort(v).elements(); e.hasMoreElements(); )
	  System.out.println(e.nextElement());
      }
    } catch(Exception e) {
      System.err.println(e);
    }
  }
/** performs Shell sort, based on K&R */
  public static Vector sort (Vector v) {
    if (v != null)
      for (int gap = v.size()/2; gap > 0; gap /= 2)
	for (int i = gap; i < v.size(); ++ i)
	  for (int j = i-gap; j >= 0; j -= gap) {
	    String a = (String)v.elementAt(j);
	    String b = (String)v.elementAt(j+gap);
	    if (a.compareTo(b) > 0) {
	      v.setElementAt(b, j);
	      v.setElementAt(a, j+gap);
	    } else
	      break;
	  }
    return v;
  }
/** performs Shell sort, based on K&R */
  public static Object sort (Object v) throws NoSuchMethodException,
			InvocationTargetException, IllegalAccessException {
    final int len;
    if (v != null && v.getClass().isArray()
					&& (len = Array.getLength(v)) > 1) {
      Class elts = Array.get(v, 0).getClass();
      Method cmp = elts.getMethod("compareTo", new Class[] { elts });
      for (int gap = len/2; gap > 0; gap /= 2)
	for (int i = gap; i < len; ++ i)
	  for (int j = i-gap; j >= 0; j -= gap) {
	    Object a = Array.get(v, j);
	    Object b = Array.get(v, j+gap);
	    if (((Integer)cmp.invoke(a, new Object[] { b })).intValue() > 0) {
	      Array.set(v, j, b);
	      Array.set(v, j+gap, a);
	    } else
	      break;
	}
    }
    return v;
  }
}
