public class SMSutils extends SMScalcs {

static String pathlabel[] = new String[NMTHRDS * SIMSZE];

static int iter = 0;

static double solprb = 0., mnd = 0., snd = 0.;

static double stplngth[] = new double[NMSTEPS];
static double netdisplcmnt[] = new double[NMSTEPS];
static double moment[] = new double[4];
static double pathdens[] = new double[NMTHRDS * SIMSZE];
static double pathmetric[][] = new double[NMTHRDS * SIMSZE][5];
static double xval[] = new double[NMTHRDS * SIMSZE];
static double yval[] = new double[NMTHRDS * SIMSZE];

//-----------------------------------------------------------------

public static double fmin_(int thrd, double x1, double x2) {

/* An approximation x to the point where f attains a minimum on
   the interval (a,b) is determined.  From Numerical Recipes.
 
   input..
 
   x1    left endpoint of initial interval
   x2    right endpoint of initial interval
   f     function subprogram which evaluates f(x) for any x
   in the interval (x1, x2)
   tol   desired length of the interval of uncertainty of the
         final result (.ge.0.)
 
   output..
 
   fmin  abcissa approximating the point where  f  attains a
   minimum
*/ 

int itermax = 1000;

double a, b, c = 0., d = 0., e = 0., min1, min2, fa, fb, fc, p, q, r, s,
   tol1, xm, tol = 1.e-6, eps = 1.e-10;

/* Test function range.
x1 = 1.;
x2 = 3.;
*/

a = x1;
b = x2;
fa = f_(thrd, a);
fb = f_(thrd, b);
fc = fb;

for (iter = 1; iter <= itermax; ++iter) {
   if (fb * fc > 0.) {
      c = a;
      fc = fa;
      e = d = b - a;
   }
   if (Math.abs(fc) < Math.abs(fb)) {
      a = b;
      b = c;
      c = a;
      fa = fb;
      fb = fc;
      fc = fa;
   }
   tol1 = 2. * eps * Math.abs(b) + .5 * tol;
   xm = .5 * (c - b);
   if (Math.abs(xm) <= tol1 || fb == 0.) {
      solprb = fb;
      return b;
   }
   if (Math.abs(e) >= tol1 && Math.abs(fa) > Math.abs(fb)) {
      s = fb / fa;
      if (a == c) {
         p = 2. * xm * s;
	 q = 1. - s;
      
      } else {
         q = fa / fc;
	 r = fb / fc;
	 p = s * (2. * xm * q * (q - r) - (b - a) * ( r - 1.));
         q = (q - 1.) * (r - 1.) * (s - 1.);
      }
      if (p > 0.) q = -q;
      p = Math.abs(p);
      min1 = 3. * xm * q - Math.abs(tol1 * q);
      min2 = Math.abs(e * q);
      if (2. * p < (min1 < min2 ? min1 : min2)) {
         e = d;
	 d = p / q;
      
      } else {
         d = xm;
	 e = d;
      }

   } else {
      d = xm;
      e = d;
   }
   a = b;
   fa = fb;
   if (Math.abs(d) > tol1) {
      b += d;

   } else {
      b += (xm > 0. ? Math.abs(tol1) : -Math.abs(tol1));
   }
   fb = f_(thrd, b);
}
return -1.;
}

// ----------------------------------------------------------------

static double f_(int thrd, double x) {

double fval;

/* Find the CDF value at this x-value by integrating the density
   function from 0 degrees up to "x."  Then, subtract this value
   from the uniformly-generated probability. */

/* Test function ("little wicket") -- should return a zero at 2.0945514815
fval = x * (x * x - 2.) - 5.;
if (true) return fval;
*/

fval = SMScalcs.adquad_(thrd, 0., x) / SMScalcs.hdcnstnt[thrd];
fval = SMScalcs.hdunifprb[thrd] - fval;
return fval;
}

//-----------------------------------------------------------------

static double pathdissim_(int szepth1, double path1[][], int szepth2,
   double path2[][]) {

// Computes the Marti et al. (2009) dissimilarity between paths 1 and 2.

int i, j;

double mindist, dist, sumpth1 = 0., sumpth2 = 0., dissim;

/*
sumpth1 = Clstr.dist_(2, path1[szepth1 - 1], path2[szepth2 - 1]);
sumpth2 = Math.abs(straightness_(szepth1, path1) -
	           straightness_(szepth2, path2));
sumpth1 = Math.abs(path1[szepth1 - 1][0] - path2[szepth2 - 1][0]);
if (true) {
   return (sumpth1 + sumpth2);
}
*/

for (i = 0; i < szepth1; ++i) {
   mindist = 1.e6;
   for (j = 0; j < szepth2; ++j) {
      dist = Clstr.dist_(2, path1[i], path2[j]);
      if (dist < mindist) {
         mindist = dist;
      }
   }
   sumpth1 += mindist;
}

for (i = 0; i < szepth2; ++i) {
   mindist = 1.e6;
   for (j = 0; j < szepth1; ++j) {
      dist = Clstr.dist_(2, path2[i], path1[j]);
      if (dist < mindist) {
         mindist = dist;
      }
   }
   sumpth2 += mindist;
}

dissim = .5 * (sumpth1 / ((double) szepth1) + sumpth2 / ((double) szepth2));

dissim += Math.abs(straightness_(szepth1, path1) -
	           straightness_(szepth2, path2));

return dissim;
}
	
//-----------------------------------------------------------------

static void plotpaths_() {

/* Plot observed and simulated paths.  gnuplot needs two blank lines
   to start a new path. */

int i, j, k, l, nmpaths = 0;

nmpaths = nmloops / nmthreads;

printf_("plotpaths: nmpaths per thread= " + nmpaths + " nmsteps= " +
   nmsteps[1]);

//fprintf_(pathplotflenm, "Kruger NP" + "\nSimulated Crocodile Paths");
for (i = 1; i <= nmthreads; ++i) {
   for (j = 0; j < nmanimals; ++j) {
      for (k = 0; k < nmpaths; ++k) {

      /* Print this line if file is to be read by convrt_().
      fprintf_(pathplotflenm, nmsteps[thrd] + " c" + j + " " + 1);
      */

         for (l = 0; l < nmsteps[i]; ++l) {
            fprintf_(pathplotflenm, path[i][k][j][l][0] + " " +
               path[i][k][j][l][1]);
         }
         if (i < nmthreads || j < nmanimals - 1 || k < nmpaths - 1) {
            fprintf_(pathplotflenm, " " + "\n ");
         }
      }
   }
}
fclose_(pathplotflenm, 'w');

fleopen_(pathplotflenm, "obscrocpaths.plt", 'w');
//fprintf_(pathplotflenm, "Kruger NP" + "\nObserved Crocodile Paths");
for (j = 0; j < nmanimals; ++j) {

   /* Print this line if file is to be read by convrt_().
   fprintf_(pathplotflenm, nmsteps[thrd] + " c" + j + " " + 1); */

   for (i = 0; i < nmobssteps[j]; ++i) {
      fprintf_(pathplotflenm, obspath[j][i][0] + " " +
         obspath[j][i][1]);
   }
   if (j < nmanimals - 1) {
      fprintf_(pathplotflenm, " " + "\n ");
   }
}
fclose_(pathplotflenm, 'w');
}

//-----------------------------------------------------------------

static void pathmetrics_() {

/* Computes all path metrics for a set of simulated paths and a
   sample of observed paths. */

int i, j, k, l = 0, nmthrdloops = Beliefs.nmloops / nmthreads;

printf_("pathmetrics: nmloops= " + nmloops + " nmsteps0= " + nmsteps[0]);

for (i = 0; i < nmanimals; ++i) {
   pathlabel[l] = "OBS" + (i + 1);

   pathdens[l] = Densest.densest5_(nmloops, nmsteps, i, path,
		   nmobssteps[i], obspath[i]);

   pathmetric[l][0] = straightness_(nmobssteps[i], obspath[i]);
   pathmetric[l][1] = sinuosity_(nmobssteps[i], obspath[i]);
   pathmetric[l][2] = pathrange_(nmobssteps[i], obspath[i]);
   netdisplcmnt_(nmobssteps[i], obspath[i]);
   pathmetric[l][3] = mnd;
   pathmetric[l][4] = snd;
   index[0][l] = l;
   ++l;

   for (j = 1; j <= nmthreads; ++j) {
      for (k = 0; k < nmthrdloops; ++k) {
         pathlabel[l] = "s" + (i + 1);
   
         pathdens[l] = Densest.densest5_(nmloops, nmsteps, i, path,
		          nmsteps[j], path[j][k][i]);

         pathmetric[l][0] = straightness_(nmsteps[j], path[j][k][i]);
         pathmetric[l][1] = sinuosity_(nmsteps[j], path[j][k][i]);
         pathmetric[l][2] = pathrange_(nmsteps[j], path[j][k][i]);
         netdisplcmnt_(nmsteps[j], path[j][k][i]);
         pathmetric[l][3] = mnd;
         pathmetric[l][4] = snd;
         index[0][l] = l;
         ++l;
      }
   }
}

// Sort paths by their density.

Idsort.shellsort_(pathdens, index[0], l);

// Write them to a file in this order.

fleopen_(pathplotflenm, "pathmetrics.dat", 'w');
fprintf_(pathplotflenm, "PATHLABEL ST SL R MND SND");
for (i = 0; i < l; ++i) {
   fprintf_(pathplotflenm, pathlabel[index[0][i]] + " " +
      fdble_(pathmetric[index[0][i]][0], 8, 5) + " " +
      fdble_(pathmetric[index[0][i]][1], 8, 5) + " " +
      fdble_(pathmetric[index[0][i]][2], 8, 5) + " " +
      fdble_(pathmetric[index[0][i]][3], 8, 5) + " " +
      fdble_(pathmetric[index[0][i]][4], 8, 5));
}
fclose_(pathplotflenm, 'w');
}

//-----------------------------------------------------------------

static double straightness_(int sze, double path[][]) {

// Computes the straightness of "path."

int i;

double lngth = 0., retval;

// Compute path length.

for (i = 0; i < sze - 1; ++i) {
   lngth += Clstr.dist_(2, path[i + 1], path[i]);
}

retval = Clstr.dist_(2,path[sze - 1], path[0]) / lngth;
return retval;
}

//-----------------------------------------------------------------

static double sinuosity_(int sze, double path[][]) {

/* Computes the sinuosity of "path."  Note that there are only
   sze - 2 turns in a path of size "sze." */

int i, nmsteps = 0;

double p = 0., c = 0., s = 0., b = 0., vec1x = 0., vec1y = 0.,
   vec2x = 0., vec2y = 0., costa = 0., sval = 0., retval;

// Compute step length mean, and coefficient of variation.

nmsteps = sze - 1;
for (i = 0; i < nmsteps; ++i) {
   stplngth[i] = Clstr.dist_(2, path[i + 1], path[i]);
   p += stplngth[i];
}
p /= ((double) nmsteps);
b = Summry.coefvar_(nmsteps, stplngth);

/* Compute the mean cosine and mean sine of the turning angle.
   Find the cosine with
  
   cos(ta) = (v1' * v2) / (lngth(v1) * lngth(v2))

   after translating the first step to the base of the second step. */

nmsteps = 0;
for (i = 0; i < sze - 2; ++i) {
   vec1x = path[i + 1][0] - path[i][0];
   vec1y = path[i + 1][1] - path[i][1];

   vec2x = path[i + 2][0] - path[i + 1][0];
   vec2y = path[i + 2][1] - path[i + 1][1];

   if (stplngth[i] > 0. && stplngth[i + 1] > 0.) {
      costa = (vec1x * vec2x + vec1y * vec2y) / (stplngth[i] * stplngth[i + 1]);
      c += costa;
      sval = Math.sin(Math.acos(costa));
      s += sval;
      ++nmsteps;
   }
}
c /= ((double) nmsteps);
s /= ((double) nmsteps);

// printf_("sinuosity: c= " + c + " s= " + s);

retval = 1. - c;
retval = (1. - c * c - s * s) / (retval * retval + s * s);
retval = 2. * Math.sqrt(p * (retval + b * b));

return retval;
}

//-----------------------------------------------------------------

static double pathrange_(int sze, double path[][]) {

// Computes the overall range of "path."

int i, j;

double displcmnt = 0., retval = 0.;

for (i = 0; i < sze; ++i) {
   for (j = 0; j < i; ++j) {
      displcmnt = Clstr.dist_(2, path[i], path[j]);
      if (displcmnt > retval) {
         retval = displcmnt;
      }
   }
}
return retval;
}

//-----------------------------------------------------------------

static void netdisplcmnt_(int sze, double path[][]) {

/* Computes the mean and standard deviation of the path's net
   displacement. */

int i;

for (i = 1; i < sze; ++i) {
   netdisplcmnt[i - 1] = Clstr.dist_(2, path[0], path[i]);
}
Summry.moments_(true, (sze - 1), netdisplcmnt, moment);
mnd = moment[0];
snd = moment[1];
}

//-----------------------------------------------------------------

static void medianloc_() {

// Computes the median location of each animal at the end of their path.

int i, j, k, l, nmpaths ;

double xmedian = 0., ymedian = 0.;

nmpaths = nmloops / nmthreads;

fleopen_(6, "predlocs.dat", 'w');
for (i = 0; i < nmanimals; ++i) {
   l = 0;
   for (j = 1; j <= nmthreads; ++j) {
      for (k = 0; k < nmpaths; ++k) {
         xval[l] = path[j][k][i][nmsteps[j] - 1][0];
         yval[l] = path[j][k][i][nmsteps[j] - 1][1];

	 // printf_("medianloc: xval= " + xval[l] + " yval= " + yval[l]);

	 ++l;
      }
   }
   xmedian = Loadpar.median_(l, xval);
   ymedian = Loadpar.median_(l, yval);

   fprintf_(6, (i + 1) + " " + xmedian + " " + ymedian);
}
fclose_(6, 'w');
}
}
