import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.applet.*;

/*
class Run_id extends Applet implements ActionListener {

// Applet console for ID.

static TextArea ta;
TextField tf;

// -----------------------------------------------------------------------

void init() {
tf = new TextField(60);
tf.addActionListener(this);
add(tf);
ta = new TextArea(20, 60);
add(ta);
Id idobj = new Id();
}

// -----------------------------------------------------------------------

void actionPerformed (ActionEvent ae) {
String strng;

strng = ae.getActionCommand(); // Get input from command line.
ta.append(strng + "\n");       // Echo input.
tf.setText("");                // Blank-out command line.

// Process command.

idobj.id_(strng);
}
}
*/

// --------------------------------------------------------------------

// public class Run_id extends Dialog {
public class Run_id {

// Application console for ID.

// Utility constants. 

static final int NMFILES = 11; // Maximum number of files.
static final int MAX_SHIFT = 12; // Used in fdble_().

/* File I/O declarations for methods fleopen_(), fprintf_(), scanf_(), and
   fclose_(). */

static String strng;
static boolean usedflenm[] = new boolean[NMFILES];
static String flename[] = new String[NMFILES];
static FileInputStream fleInputStream[] = new FileInputStream[NMFILES];
static InputStreamReader inputStreamReader[] = new InputStreamReader[NMFILES];
static BufferedReader bufferedReader[] = new BufferedReader[NMFILES];
static StreamTokenizer streamTokenizer[] = new StreamTokenizer[NMFILES];
static FileOutputStream fleOutputStream[] = new FileOutputStream[NMFILES];
static PrintWriter printWriter[] = new PrintWriter[NMFILES];
static InputStreamReader isr;
static BufferedReader br;
static DataInputStream binarystream[] = new DataInputStream[NMFILES];
static DataOutputStream binoutstream[] = new DataOutputStream[NMFILES];

// --------------------------------------------------------------------

public Run_id() {
}

// -------------------- Utility methods. ------------------------------

static double sign_(double x1, double x2) {

// Replaces the f77 function, SIGN.

if (x2 >= 0.) return Math.abs(x1);
else return -Math.abs(x1);
}

// --------------------------------------------------------------------

static String strngsub_(String original, String from, String to) {

/* Replaces "from" with "to" in the string "original."  From "JAVA for
   Students," by D. Bell and M. Parr, p. 292. */

String leftBit, rightBit;
int startSearch = 0, place, nmloops = 0;

place = original.indexOf(from);
if (from.length() != 0) {
   while (place >= startSearch) {
      leftBit = original.substring(0, place);
      rightBit = original.substring(place + from.length(),
				    original.length());
      original = leftBit + to + rightBit;
      startSearch = leftBit.length() + to.length();
      place = original.indexOf(from);

      ++nmloops;
      if (nmloops == 1000) {
	 printf_("strngsub: nmloops=1000, from= " + from + " to= " + to);
         break;
      }
   }

} else {
   printf_("strngsub: original= " + original + " from= " + from +
      " to= " + to + "\n   from length= " + from.length());
}

return original;
}

// ---------------------------------------------------------------------

static String fdble_(double testNum, int width, int precision) {

/* Formats real numbers.  From "JAVA: Introduction to Programming" by
   T. Knowlton. */

boolean negative = false;

String workString;

int decimalShift = 0, numWidth = 0, presentLoc, stringWidth, numlead = 0;

double inNum = testNum;
Long tempLong;

// Check for NaN, Infinity.

if (Double.isNaN(testNum)) {
   return " NaN";
}

if (Double.isInfinite(testNum)) {
   return " Infinity";
}

if( inNum < 0. ) {
   negative = true;
   inNum *= -1;
}

if( inNum != 0. ) {
   while(inNum < 1.0e12) {
        inNum = inNum * 10.;
        decimalShift++;
   }
   if (decimalShift > MAX_SHIFT) {
      numlead = decimalShift - MAX_SHIFT;
      decimalShift = MAX_SHIFT;
   }
   if (numlead > 9) {
      // printf_("fdble: numlead= " + numlead);
      workString = " " + testNum;
      return ".000000000";
   }

   tempLong = Long.valueOf((long) inNum);
   workString = new String ( tempLong.toString() ); 

// fprintf_(4,"testNum= " + testNum + " numlead= " + numlead);

   if (numlead == 0) {
      workString = workString + "000000000000";
   }
   else if (numlead == 1) workString = "0" + workString + "00000000000";
   else if (numlead == 2) workString = "00" + workString + "0000000000";
   else if (numlead == 3) workString = "000" + workString + "000000000";
   else if (numlead == 4) workString = "0000" + workString + "00000000";
   else if (numlead == 5) workString = "00000" + workString + "0000000";
   else if (numlead == 6) workString = "000000" + workString + "000000";
   else if (numlead == 7) workString = "0000000" + workString + "00000";
   else if (numlead == 8) workString = "00000000" + workString + "0000";
   else if (numlead == 9) workString = "000000000" + workString + "000";

} else {
   workString = new String( "0000000000000000000000000" );
   decimalShift = MAX_SHIFT;
}

StringBuffer StringBuf = new StringBuffer("");
presentLoc = MAX_SHIFT - decimalShift + precision;

while( precision > 0) {
   StringBuf.append( workString.charAt( presentLoc ) );
   presentLoc--;  numWidth++;  precision--;
}

StringBuf.append( '.' );
numWidth++;

if( ( testNum < 1 ) && ( testNum > 0 ) ) {
   StringBuf.append( '0' );
   numWidth++;
}

while( presentLoc >= 0 ) {
   StringBuf.append( workString.charAt( presentLoc ) );
   numWidth++;
   presentLoc--;
}

if( negative ) {
   StringBuf.append( '-' );
   numWidth++;
}
                
while( numWidth < width ) {
   StringBuf.append( ' ' );
   numWidth++;
}

stringWidth = StringBuf.length();
StringBuffer newStringBuf = new StringBuffer("");

while( stringWidth-- > 0 ) {
   newStringBuf.append( StringBuf.charAt( stringWidth ) );
}

return newStringBuf.toString();
}

// ---------------------------------------------------------------------

static String fint_(int val, int width) {

// Formats integer numbers.

String workString;

workString = Integer.toString(val);

return fstrng_(workString, width);
}

// --------------------------------------------------------------------

static String scanf_() {
try {

// Read a line from the console

strng = br.readLine();
}
catch (Exception e) {
printf_("Exception in scanf= " + e);
}

return strng;
}

// -------------------------------------------------------------------

static void printf_(String strng) {

// Write a line to the applet screen or console.

// ta.append(strng + "\n");
System.out.println(strng);
}

// -------------------------------------------------------------------

static String fstrng_(String strng, int flength) {

// Right justifies strng.

String space = " ", tstrng;
int slngth = 0, i;

if (strng == null) return " none";
tstrng = strng.trim();

// Print only the first "flength" characters of the string.

if (flength < tstrng.length()) {
   tstrng = tstrng.substring(0, flength);
}

slngth = flength - tstrng.length();
for (i = 0; i < slngth; ++i) space += " ";

return (space + tstrng);
}

// -------------------------------------------------------------------

                         // File I/O methods.

static boolean fleexists_(String flenme) {

// Checks for the existence of "flenme."

File f = new File (flenme);
if (f.exists()) {
   return true;
}

return false;
}

// -----------------------------------------------------------------------

static int fleopen_(int flenm, String strng, char ftype) {

// File opener.  First, check if this file number is being used.

int i;

if (usedflenm[flenm - 1]) {
   for (i = 0; i < NMFILES; ++i) {
      printf_("usedflenm(" + (i + 1) + ")= " + usedflenm[i] +
         " flename= " + flename[i]);
   }
   printf_("fleopen: failed to open file name= " + strng + " because ");
   iderr_("fleopen: file number " + flenm + " in use.");

} else {
   usedflenm[flenm - 1] = true;
}

// "none" means no file name was read.

if (strng.equals("none")) {
   iderr_("fleopen: flenm= " + flenm + " file name= " + strng);
}

flename[flenm - 1] = strng;
try {
   if (ftype == 'r') {
      fleInputStream[flenm - 1] = new FileInputStream(strng);
      binarystream[flenm - 1] =
	 new DataInputStream(fleInputStream[flenm - 1]);
      inputStreamReader[flenm - 1] =
	 new InputStreamReader(fleInputStream[flenm - 1]);
      bufferedReader[flenm - 1] =
	 new BufferedReader(inputStreamReader[flenm - 1]);
      streamTokenizer[flenm - 1] =
	 new StreamTokenizer(bufferedReader[flenm - 1]);
      streamTokenizer[flenm - 1].wordChars('-', '-');
      streamTokenizer[flenm - 1].wordChars('_', '_');
      streamTokenizer[flenm - 1].wordChars(',', ',');
      streamTokenizer[flenm - 1].wordChars(':', ':');
      streamTokenizer[flenm - 1].wordChars('%', '%');
      streamTokenizer[flenm - 1].wordChars('!', '!');
      streamTokenizer[flenm - 1].wordChars('[', '[');
      streamTokenizer[flenm - 1].wordChars(']', ']');
      streamTokenizer[flenm - 1].wordChars('/', '/');
      streamTokenizer[flenm - 1].wordChars('.', '.');
      streamTokenizer[flenm - 1].whitespaceChars('(', '(');
      streamTokenizer[flenm - 1].whitespaceChars(')', ')');
      streamTokenizer[flenm - 1].parseNumbers();

   } else {
      fleOutputStream[flenm - 1] = new FileOutputStream(strng);
      binoutstream[flenm - 1] =
	 new DataOutputStream(fleOutputStream[flenm - 1]);
      printWriter[flenm - 1] =
	 new PrintWriter(fleOutputStream[flenm - 1]);
   }
}
catch(IOException e) {
   iderr_("fleopen: error: flenm= " + flenm + " flename= " + strng +
      " ftype= " + ftype);
   // e.printStackTrace();
   return 1;
}

return 0;
}

// -----------------------------------------------------------------------

static double fgetdble_(int flenm) {

/* Read a double precision real number from a file.
   Bug: if a exponential-like notation follows a real number, this
   routine will erroneously read a scientific notation number.  If
   this is not intended, place a letter following the "e" or "E" before
   the next integer.  Example:

   a1 2.68
   e1 7.4

   will be read as "a1" 26.8 7.4  -- if however, the intention was to
   read a string and then a number on each record, this is incorrect.
   To fix this example, change the above to:

   a1 2.68
   ec1 7.4
   
   Use "checkbuffeof" on files read by "fgetdble_" and "fgetint,"
   i.e., utilities that use BufferedReader only.  Otherwise, use
   "checkeof" on files read by streamTokenizer utilities.  Mixing these
   methods can cause files to be incorrectly read.  In the future,
   streamTokenizer based file reading should be phased out and replaced
   with BufferedReader I/O. */

char chrry[] = new char[10];

String lstrng, tststrng, tststrng2, tststrng3;

StringReader sr;

int c = 0, token = 0, exponent = 0;

double mantissa = 0., retval = 0.;

StringBuilder sb = new StringBuilder();

// First, skip leading whitespace characters.

while (fle_ready_(flenm)) {
   try {
   bufferedReader[flenm - 1].mark(1);
   c = bufferedReader[flenm - 1].read();
   }
   catch (Exception e) {
   printf_("Error 1 in fgetdble_()");
   e.printStackTrace();
   }
   if ((c >= '0' && c <= '9') || c == '.' || c == '+' || c == '-') {
      sb.append((char) c);
      break;
   }
}

// Now, read number.

while (fle_ready_(flenm)) {
   try {
   bufferedReader[flenm - 1].mark(1);
   c = bufferedReader[flenm - 1].read();
   }
   catch (Exception e) {
   printf_("Error 2 in fgetdble_()");
   e.printStackTrace();
   }
   if (c >= '0' && c <= '9' || c == '.' || c == '-'|| c == 'e' ||
       c == 'E') {
      sb.append((char) c);

   } else {
      try {
      bufferedReader[flenm - 1].reset();
      }
      catch (Exception e) {
      printf_("Error 3 in fgetdble_()");
      e.printStackTrace();
      }
      break;
   }
}
lstrng = sb.toString();
try {
retval = Double.parseDouble(lstrng);
}
catch (Exception e) {
printf_("fgetdble: ID= " + Id.thisidname + " cannot parse c= " + c);
return 0.;
}
if (true) {
   return retval;
}

// Read mantissa.

try {
streamTokenizer[flenm - 1].nextToken();
}
catch (Exception e) {
printf_("Error 4 in fgetdble_()");
e.printStackTrace();
}

mantissa = streamTokenizer[flenm - 1].nval;

printf_("fgetdble: mantissa= " + mantissa);

/* Don't use pushBack.  Try to minimize the use of both StreamTokenizer
   and BufferedReader on the same input stream. */

// if (true) return mantissa;

// By reading another token, check if there is an exponent.

try {
token = streamTokenizer[flenm - 1].nextToken();
}
catch (Exception e) {
printf_("Error 5 in fgetdble_()");
e.printStackTrace();
}

printf_("fgetdble: token= " + token);

// Check if the string value is an exponent.  If not, push it back.

if (token == StreamTokenizer.TT_WORD) {
   tststrng = streamTokenizer[flenm - 1].sval;

   printf_("fgetdble: tststrng= " + tststrng);

   tststrng = tststrng.toLowerCase();

   sr = new StringReader(tststrng);
   try {
   sr.read(chrry);
   }
   catch (Exception e) {
   printf_("Error 6 in fgetdble_()= " + e);
   }

   printf_("fgetdble: mantissa= " + mantissa + " tststrng= " + tststrng +
      " chrry0= " + chrry[0]);

   if (tststrng.length() < 5 && chrry[0] == 'e' &&
       (chrry[1] == '-' || chrry[1] == '+' ||
        chrry[1] == '0' || chrry[1] == '1' || chrry[1] == '2' ||
        chrry[1] == '3' || chrry[1] == '4' || chrry[1] == '5' ||
        chrry[1] == '6' || chrry[1] == '7' || chrry[1] == '8' ||
        chrry[1] == '9')) {

      // Get exponent.
      // tststrng = "" + chrry[1] + chrry[2] + chrry[3];

      tststrng = tststrng.replace('e', ' ');
      try {
      exponent = Integer.parseInt(tststrng.trim());
      }
      catch (NumberFormatException nfe) {
      printf_("fgetdble: NumberFormatException: " +
         nfe.getMessage() + " exponent string= " + tststrng);
      }
   
   } else {
      streamTokenizer[flenm - 1].pushBack();
   }

} else {
   streamTokenizer[flenm - 1].pushBack();
}

if (exponent == 0) {
   retval = mantissa;

} else {
   retval = mantissa * Math.pow(10., exponent);
}
return retval;
}

// -----------------------------------------------------------------------

static double fgetdbleb_(int flenm) {

// Another way to read a real number from David Bailey at Berkeley.
// Read a double, even if it's in exponential notation.

String s = "none";

int idx, exponent;

double mantissa;

s = s.toLowerCase();
idx = s.indexOf('e');
if (idx >= 0) {
   mantissa = Double.valueOf(s.substring(0, idx)).doubleValue();
   exponent = Integer.parseInt(s.substring(idx + 1));

   return mantissa * Math.pow(10, (double)exponent);

} else {
   return Double.valueOf(s).doubleValue();
}
}

// ---------------------------------------------------------------------

static boolean fgetboolean_(int flenm) {

// Read a boolean entity from a file.

strng = fgetstrng_(flenm);
if (strng.equals("true")) {
   return true;

} else if (strng.equals("false")) {
   return false;

} else {
   iderr_("fgetboolean: text not true or false");
}

return false;
}

// ---------------------------------------------------------------------

static int fgetint_(int flenm) {

// Read an integer from a file.

/*
// Old way.
try {
streamTokenizer[flenm - 1].nextToken();
}
catch (Exception e) {
   printf_("Error in fgetint_()");
   e.printStackTrace();
}
return (int) streamTokenizer[flenm - 1].nval;
*/

char chrry[] = new char[10];

String lstrng, tststrng, tststrng2, tststrng3;

StringReader sr;

int c = 0, retval = 0;

StringBuilder sb = new StringBuilder();
StringBuilder sother = new StringBuilder();

// First, skip leading whitespace characters.
while (fle_ready_(flenm)) {
   try {
   bufferedReader[flenm - 1].mark(1);
   c = bufferedReader[flenm - 1].read();
   }
   catch (Exception e) {
   printf_("Error 1 in fgetint_()");
   e.printStackTrace();
   }
   if ((c >= '0' && c <= '9') || c == '+' || c == '-') {
      sb.append((char) c);
      break;

   } else {
      sother.append((char) c);

      /* If an unexpected comment is read, return a flag for the calling
         program to consume it. */

      if (sother.indexOf("begincomment") >= 0) {
         printf_("fgetint: sother= " + sother);
         return -1111111;
      }
   }
}

// Now, read number.

while (fle_ready_(flenm)) {
   try {
   bufferedReader[flenm - 1].mark(1);
   c = bufferedReader[flenm - 1].read();
   }
   catch (Exception e) {
   printf_("Error 1 in fgetint_()");
   e.printStackTrace();
   }
   if ((c >= '0' && c <= '9') || c == '+' || c == '-') {
      sb.append((char) c);

   } else {
      try {
      bufferedReader[flenm - 1].reset();
      }
      catch (Exception e) {
      printf_("Error 2 in fgetint_()");
      e.printStackTrace();
      }
      break;
   }
}
lstrng = sb.toString();

/* If an unexpected comment is read, return a flag for the calling
   program to consume it. */

if (lstrng.equals("begincomment")) {
   return -1111111;
}

try {
retval = Integer.parseInt(lstrng);
}
catch (Exception e) {
printf_("fgetint: ID= " + Id.thisidname + " cannot parse lstrng= " + lstrng);
}

return retval;
}

// ----------------------------------------------------------------------

static int fgetunsigned8int_(int flenm) {

// Read an unsigned 8-bit integer value from a file.

int retval = 0;

try {
   // retval = binarystream[flenm - 1].available();
   // iderr_("8int: retval= " + retval);
   retval = binarystream[flenm - 1].readUnsignedByte();
}
catch (Exception e) {
   e.printStackTrace();
   iderr_("Error in fgetunsigned8int_()");
}

return ((int) retval);
}
// ----------------------------------------------------------------------

static short fgetbinint_(int flenm) {

// Read a short binary integer value from a file.

short retval = 0;

try {
   retval = binarystream[flenm - 1].readShort();
}
catch (Exception e) {
   printf_("Error in fgetbinint_()");
   e.printStackTrace();
}

return retval;
}

// ----------------------------------------------------------------------

static double fgetbinflt_(int flenm) {

/* Read a binary single precision value from a file and return it
   in double precision. */

double retval = 0.;

try {
   retval = (float) binarystream[flenm - 1].readFloat();
}
catch (Exception e) {
   printf_("fgetbinflt: Exception");
   return 1.e200;
}

return retval;
}

// ----------------------------------------------------------------------

static void fwbinshrt_(int flenm, short val) {

/* Writes a short value to a file as a binary short value. */

try {
   binoutstream[flenm - 1].writeShort(val);
}
catch (Exception e) {
   printf_("Error in fwbinshort_()");
   e.printStackTrace();
}
}

// ----------------------------------------------------------------------

static void fwbinflt_(int flenm, double val) {

/* Writes a double precision value to a file as a binary single precision
   value. */

try {
   binoutstream[flenm - 1].writeFloat((float) val);
}
catch (Exception e) {
   printf_("Error in fwbinflt_()");
   e.printStackTrace();
}
}

// ----------------------------------------------------------------------

static String fgetline_(int flenm) {

/* Read an entire line from a file.  Note the "trim" check below is
   needed because this method leaves the carriage
   return-line feed in the file after it reads a line. */

int i = 0;

try {
for (i = 0; i < 50; ++i) {
   strng = bufferedReader[flenm - 1].readLine();
   if (strng == null) {
      continue;

   } else if (strng.trim().length() > 0) {
      break;
   }
}
}
catch (Exception e) {
   printf_("Error in fgetline_()");
   e.printStackTrace();
}

if (i == 50) {
   //iderr_("fgetline: 5 null lines in a row.");
   return ("null");
}

return strng.trim();
}

// ----------------------------------------------------------------------

static String fgetlinent_(int flenm) {

// Read an entire line from a file.  Do not trim.

try {
strng = bufferedReader[flenm - 1].readLine();
}
catch (Exception e) {
   printf_("Error in fgetlinent_()");
   e.printStackTrace();
}

if (strng != null) {
   return strng;

} else {
   printf_("fgetlinent: string=null");
   return strng;
}
}

// ----------------------------------------------------------------------

static String fgetstrng_(int flenm) {

// Read a string from a file.

String retval = " ";

int token, intval = 0;

double realval = 0.;

try {
token = streamTokenizer[flenm - 1].nextToken();
if (token == StreamTokenizer.TT_WORD) {
   Id.isString = true;
   retval = streamTokenizer[flenm - 1].sval;

} else if (token == StreamTokenizer.TT_NUMBER) {
   Id.isString = false;
   realval = (double) streamTokenizer[flenm - 1].nval;
   intval = (int) realval;
   if (Math.abs(realval - ((double) intval)) < 1.e-6) {
      retval = Integer.toString((int) realval);

   } else {
      retval = fdble_(realval, 5, 3);
   }

} else {
   Id.isString = true;
   retval = Character.toString((char) token);
}
}
catch (Exception e) {
   printf_("Error in fgetstrng_()");
   e.printStackTrace();
}

// printf_("fgetstrng: strng= " + retval);

return retval;
}

// ---------------------------------------------------------------------

static boolean fle_ready_(int flenm) {

// Checks if a file is ready.

try {
if (bufferedReader[flenm - 1].ready()) {
   return true;
}
}
catch (Exception e) {
   iderr_("fle_ready: io exception");
}

return false;
}

// ---------------------------------------------------------------------

static boolean checkeof_(int flenm) {

/* Check EOF of a character file.  Returns "true" if file pointer is at
   EOF. The "pushBack" statement can cause "fgetdble" and/or "fgetint"
   to misread columns.  All streamTokenizer use should eventually be
   replaced with bufferedReader I/O. */

boolean val = false;

try {
if (streamTokenizer[flenm - 1].nextToken() == StreamTokenizer.TT_EOF) {
   val = true;

} else {
   streamTokenizer[flenm - 1].pushBack();
   val = false;
}
}
catch (Exception e) {
iderr_("io exception in checkeof_()");
}
return val;
}

// ---------------------------------------------------------------------

static boolean checkbuffeof_(int flenm) {

/* Check EOF of a character file.  Returns "true" if file pointer is at
   EOF.  Use "checkbuffeof" on files read by "fgetdble_" and "fgetint,"
   i.e., utilities that use bufferedReader only.  Otherwise, use
   "checkeof" on files read by streamTokenizer utilities.
   In the future, streamTokenizer based file reading should be phased
   out and replaced with bufferedReader I/O. */

boolean val = false;

int firstc = 0, secondc = 0, thirdc = 0;

try {
bufferedReader[flenm - 1].mark(3);
firstc = bufferedReader[flenm - 1].read();
secondc = bufferedReader[flenm - 1].read();
thirdc = bufferedReader[flenm - 1].read();
}
catch (Exception e) {
printf_("checkbuffeof: exception 1");
e.printStackTrace();
}

/*
printf_("firstc= " + firstc + " secondc= " + secondc + " thirdc= " +
   thirdc);
*/

// DOS is CR (13) + LF (10), Unix is LF.
 
if (firstc == -1 ||
    (firstc == 10 && secondc == -1) ||
    (firstc == 13 && secondc == 10 && thirdc == -1)) {
   val = true;

} else {
   try {
   bufferedReader[flenm - 1].reset();
   }
   catch (Exception e) {
   printf_("checkbuffeof: exception 1");
   e.printStackTrace();
   iderr_("in checkbuffeof");
   }
}
return val;
}

// ----------------------------------------------------------------------

static void fprintf_(int flenm, String strng) {

// Write a string to a file.

printWriter[flenm - 1].println(strng);
printWriter[flenm - 1].flush();
}

// ----------------------------------------------------------------------

static void fclose_(int flenm, char ftype) {

if (!usedflenm[flenm - 1]) {
   return;
}

// Close a file.

try {
if (ftype == 'w') fleOutputStream[flenm - 1].close();
else fleInputStream[flenm - 1].close();
}
catch(IOException e) {
printf_("error in fclose");
e.printStackTrace();
}

// Free-up this file number.

usedflenm[flenm - 1] = false;
}

// ---------------------------------------------------------------------

static int ipow_(int x, int n) {

// Computes x^n from Knuth (1981), vol. 2, p. 442.

boolean odd;
int cpn, y = 1, z;

if (n < 0) {
   iderr_("ipow: negative n");

} else if (n == 0) {
   return 1;

} else if (n == 1) {
   return x;
}

cpn = n;
z = x;
for (;;) {
   if (2 * (cpn / 2) < cpn) odd = true;
   else odd = false;
   cpn /= 2;
   if (odd) {
      y *= z;
      if (cpn == 0) return y;
   }
   z *= z;
}
}

// -------------------------------------------------------------------------

static void cmplxmul_(double a, double b, double c, double d,
   double cmplxval[]) {

// Performs complex multiplication.

cmplxval[0] = a * c - b * d;
cmplxval[1] = a * d + b * c;
return;
}

// -----------------------------------------------------------------------

static void radixcon_(int g, int n, int b10, int bg[]) {

/* Converts the integer base-10 number, "b10" to a base-g number by
   placing the coefficients in the vector "bg." Algorithm is from
   Knuth (1981), Vol. 2, p. 302. */

int i, arg;

for (i = 0; i < n; ++i) {
   bg[i] = 0;
}

bg[0] = b10 % g;
arg = b10 / g;
for (i = 1; i < n; ++i) {
   if (arg == 0) {
      return;
   }
   bg[i] = arg % g;
   arg /= g;
}
if (arg > 0) {
   iderr_("arg>0 in radixcon");
}
}

// --------------------------------------------------------------------

static void iderr_(String strng) {

// Error routine for id.

double secs, mins;

Id.runtime += System.currentTimeMillis();
secs = ((double) Id.runtime) / 1000.;
mins = secs / 60.;

printf_("runtime= " + fdble_(secs, 5, 2) + " seconds, or " +
   fdble_(mins, 5, 2) + " minutes");

printf_(strng);

try {
isr.close();
}
catch (Exception e) {
printf_("isr.close failed");
}

System.exit(0);
}

// --------------------------------------------------------------------

public static void main(String Args[]) {

/* To run id as a standalone JAVA console program, command line
   arguments are:
   .id_flename, "standalone," impresarioip

   To run id as a Space impresario, command line arguments are:
   .id_flename, "impresario," impresarioip

   To run id as a Space client (worker), command line arguments are:
   .id_flename, "worker" or "client," clientip */

/*
Id.printf_("main: Args0= " + Args[0] + " Argsl= " + Args[1] + " Args2= " + Args[2]);
Id.iderr_("test termination");
*/

if (Args[1].equals("standalone")) {

   // Stand-alone mode.

   Id.space_in_use = false;
   Id idobj = new Id();
   idobj.id_(Args[0], "standalone", Args[2]);

} else if (Args[1].equals("impresario")) {

   // "impresario" mode.

   Id.space_in_use = true;

   // Store the IP address of the JavaSpace.

   Id.impresarioip = Args[2];

   Id idobj = new Id();
   idobj.id_(Args[0], "impresario", Args[2]);

} else if (Args[1].equals("worker") || Args[1].equals("client")) {

   // "worker" mode.  First, store the IP address of the Space.

   Id.impresarioip = Args[2];
   Id.space_in_use = true;
   Workerg.dowork_(Args[0]);

} else {
   Id.printf_("main: Args1 is not a valid option");
}
}
}
