class Routegen extends Interdict {

/* Generates potential interdiction patrol routes.  These routes will
   be squares because a square has only 3 waypts but has the highest
   ratio of area to perimeter of any rectangle.  Procedure:

   1. Start at the lower-left corner of the area to be defended.  Move
   into the area horizontally and vertically the amount of the rangers'
   sensor radius (r_sens) To locate the lower-left corner of the first
   route.  Layout the other 3 points so that each side has length
   "rtelngth" / 4 where "rtelngth" is the desired length of a route.

   2. Move horizontally to locate the next route's lower-left point
   so that it is horizontally separated from the right side of the
   first route by 2 * "r_sens."  Layout the other 3 points.

   3. After the first row of routes is laid out, start the first route
   in the second row of routes so that it is 2 * "r_sens" above the
   first row of routes.

   4. Continue constructing routes one row at a time until the top of
   the area to be defended is reached.
 
   Work directly with latitude-longitude coordinates.

   If any point of a route is outside the area's boundary, abandon that
   route.  Perimeter fence patrols run 24/365 and will eventually cover the
   abandoned region with a patrol.

   Store each route's center point as that will be the listening post's
   location for those nights that are too dark to allow the randomly
   selected route to be walked.
*/

static String head[] = new String[2];

static double latbdry[] = new double[200];
static double lngbdry[] = new double[200];

// -----------------------------------------------------------------------

static int routegen_(double solt) {

String recordorder = "none", bdryname = "none";

int i, j, nmbdpts = 0, nmrows, nmcols, frmt, nmrtes = 0, nminside = 0;

double r_sens = 100.,
   eastwestdist = 1500., northsouthdist = 1500., // was 2500
   rtelngth, latmn, latmx, lngmn, lngmx, latshift, lngshift, latdiff,
   lngdiff, latave, lngave, lat_degs_per_m,
   lng_degs_per_m, latmove, lngmove, latval, lngval, dstmin,
   waypt1_lat, waypt1_lng, waypt2_lat, waypt2_lng, waypt3_lat, waypt3_lng,
   waypt4_lat, waypt4_lng, latsign = 0., lngsign = 0.;

// Compute east-west and north-south route spacing.

latmn = Id.spacetime_latmn;
latmx = Id.spacetime_latmx;
lngmn = Id.spacetime_lngmn;
lngmx = Id.spacetime_lngmx;

latdiff = latmx - latmn;
lngdiff = lngmx - lngmn;
latave = .5 * (latmx + latmn);
lngave = .5 * (lngmx + lngmn);

lat_degs_per_m = latdiff / great_circle_dist_(latmn, lngave, latmx, lngave);
lng_degs_per_m = lngdiff / great_circle_dist_(latave, lngmn, latave, lngmx);

Run_id.printf_("routegen: lngmn= " + lngmn + " lngmx= " + lngmx + " latmn= " +
        latmn + " latmx= " + latmx +
	"\n   latdiff= " + latdiff + " lngdiff= " + lngdiff);

latmove = lat_degs_per_m * northsouthdist;
lngmove = lng_degs_per_m * eastwestdist;
latshift = lat_degs_per_m * (2. * r_sens + northsouthdist);
lngshift = lng_degs_per_m * (2. * r_sens + eastwestdist);
rtelngth = 2. * northsouthdist + 2. * eastwestdist;

// Read boundary file after opening routes file.

Run_id.fleopen_(3, latlngbdryflenme, 'r');
Run_id.fleopen_(4, genrtesflenme, 'w');

for (i = 0; i < 2; ++i) {
   head[i] = Run_id.fgetline_(3);
   Run_id.fprintf_(4, head[i]);
}
Run_id.fprintf_(4, "2 1. 1. lat-lng");

frmt = Run_id.fgetint_(3);
lngsign = Run_id.fgetdble_(3);
latsign = Run_id.fgetdble_(3);
recordorder = Run_id.fgetstrng_(3);

while (Run_id.checkeof_(3) != true) {

   // Read number of segment points and segment descriptor.

   nmbdpts = Run_id.fgetint_(3);
   bdryname = Run_id.fgetstrng_(3);

   for (i = 0; i < nmbdpts; ++i) {
      if (recordorder.equals("long_lat")) {
         lngbdry[i] = lngsign * Run_id.fgetdble_(3);
         latbdry[i] = latsign * Run_id.fgetdble_(3);

      } else {
         latbdry[i] = latsign * Run_id.fgetdble_(3);
         lngbdry[i] = lngsign * Run_id.fgetdble_(3);
      }
   }
}
Run_id.fclose_(3, 'r');

// Loop over rows and within rows, columns to build routes.

nmrows = ((int) (latdiff / latshift)) + 1;
nmcols = ((int) (lngdiff / lngshift)) + 1;

latval = latmn;
for (i = 0; i < nmrows; ++i) {
   lngval = lngmn;
   for (j = 0; j < nmcols; ++j) {
      nminside = 0;

      waypt1_lat = latval;
      waypt1_lng = lngval;
      dstmin = Surf.bdry_(nmbdpts, lngbdry, latbdry, waypt1_lng, waypt1_lat);
      if (dstmin > 0.) {
         ++nminside;
      }

      waypt2_lat = waypt1_lat;
      waypt2_lng = waypt1_lng + lngmove;
      dstmin = Surf.bdry_(nmbdpts, lngbdry, latbdry, waypt2_lng, waypt2_lat);
      if (dstmin > 0.) {
         ++nminside;
      }

      waypt3_lat = waypt2_lat + latmove;
      waypt3_lng = waypt2_lng;
      dstmin = Surf.bdry_(nmbdpts, lngbdry, latbdry, waypt3_lng, waypt3_lat);
      if (dstmin > 0.) {
         ++nminside;
      }

      waypt4_lat = waypt3_lat;
      waypt4_lng = waypt1_lng;
      dstmin = Surf.bdry_(nmbdpts, lngbdry, latbdry, waypt4_lng, waypt4_lat);
      if (dstmin > 0.) {
         ++nminside;
      }

      // Write this route to the output file.

      if (nminside == 4) {
         ++nmrtes;
         Run_id.fprintf_(4, "Interdiction_Route" + nmrtes +
            " 1 1 2016 0000 1 0" +
            "\n5 i" +
            "\n" + Run_id.fdble_(waypt1_lat, 9, 6) + " " +
	           Run_id.fdble_(waypt1_lng, 9, 6) +
            "\n" + Run_id.fdble_(waypt2_lat, 9, 6) + " " +
	           Run_id.fdble_(waypt2_lng, 9, 6) +
            "\n" + Run_id.fdble_(waypt3_lat, 9, 6) + " " +
	           Run_id.fdble_(waypt3_lng, 9, 6) +
            "\n" + Run_id.fdble_(waypt4_lat, 9, 6) + " " +
	           Run_id.fdble_(waypt4_lng, 9, 6) +
            "\n" + Run_id.fdble_(waypt1_lat, 9, 6) + " " +
	           Run_id.fdble_(waypt1_lng, 9, 6));
      }

      lngval += lngshift;
   }
   latval += latshift;
}
Run_id.fclose_(4, 'w');

Run_id.printf_("routegen: nmrtes= " + nmrtes);

return nmrtes;
}

// --------------------------------------------------------------------

static double great_circle_dist_(double lat1, double lon1, double lat2,
   double lon2) {

/* The earth's radius is in meters.
*/

double earthrad = 6371000., phi1, phi2, deltaphi, deltalambda, a, c, d;

phi1 = (Math.PI / 180.) * lat1;
phi2 = (Math.PI / 180.) * lat2;
deltaphi = (Math.PI / 180.) * (lat2 - lat1);
deltalambda = (Math.PI / 180.) * (lon2 - lon1);

a = Math.sin(deltaphi/2.) * Math.sin(deltaphi/2.) +
    Math.cos(phi1) * Math.cos(phi2) *
    Math.sin(deltalambda/2.) * Math.sin(deltalambda/2.);
c = 2. * Math.atan2(Math.sqrt(a), Math.sqrt(1. - a));
d = earthrad * c;

return (d);
}

// -------------------------------------------------------------------

static void gen_area_routes_(double solt) {

// Generates area-covering interdiction patrol routes.

intrrtetime[nmintrrtes] = solt;
intrrte[nmintrrtes][0][0] = .2;
intrrte[nmintrrtes][0][1] = .8;

intrrte[nmintrrtes][1][0] = .2;
intrrte[nmintrrtes][1][1] = .2;

intrrte[nmintrrtes][2][0] = .8;
intrrte[nmintrrtes][2][1] = .2;

intrrte[nmintrrtes][3][0] = .8;
intrrte[nmintrrtes][3][1] = .8;

intrrte[nmintrrtes][4][0] = .4;
intrrte[nmintrrtes][4][1] = .8;

intrrte[nmintrrtes][5][0] = .4;
intrrte[nmintrrtes][5][1] = .4;

intrrte[nmintrrtes][6][0] = .6;
intrrte[nmintrrtes][6][1] = .4;

intrrte[nmintrrtes][7][0] = .6;
intrrte[nmintrrtes][7][1] = .6;
nmintrrtepts[nmintrrtes] = 8;
++nmintrrtes;

intrrtetime[nmintrrtes] = solt;
intrrte[nmintrrtes][0][0] = .2;
intrrte[nmintrrtes][0][1] = .8;

intrrte[nmintrrtes][1][0] = .2;
intrrte[nmintrrtes][1][1] = .2;

intrrte[nmintrrtes][2][0] = .4;
intrrte[nmintrrtes][2][1] = .2;

intrrte[nmintrrtes][3][0] = .4;
intrrte[nmintrrtes][3][1] = .8;

intrrte[nmintrrtes][4][0] = .6;
intrrte[nmintrrtes][4][1] = .8;

intrrte[nmintrrtes][5][0] = .6;
intrrte[nmintrrtes][5][1] = .2;

intrrte[nmintrrtes][6][0] = .8;
intrrte[nmintrrtes][6][1] = .2;

intrrte[nmintrrtes][7][0] = .8;
intrrte[nmintrrtes][7][1] = .8;
nmintrrtepts[nmintrrtes] = 8;
++nmintrrtes;

intrrtetime[nmintrrtes] = solt;
intrrte[nmintrrtes][0][0] = .8;
intrrte[nmintrrtes][0][1] = .2;

intrrte[nmintrrtes][1][0] = .2;
intrrte[nmintrrtes][1][1] = .2;

intrrte[nmintrrtes][2][0] = .2;
intrrte[nmintrrtes][2][1] = .4;

intrrte[nmintrrtes][3][0] = .8;
intrrte[nmintrrtes][3][1] = .4;

intrrte[nmintrrtes][4][0] = .8;
intrrte[nmintrrtes][4][1] = .6;

intrrte[nmintrrtes][5][0] = .2;
intrrte[nmintrrtes][5][1] = .6;

intrrte[nmintrrtes][6][0] = .2;
intrrte[nmintrrtes][6][1] = .8;

intrrte[nmintrrtes][7][0] = .8;
intrrte[nmintrrtes][7][1] = .8;
nmintrrtepts[nmintrrtes] = 8;
++nmintrrtes;

intrrtetime[nmintrrtes] = solt;
intrrte[nmintrrtes][0][0] = .2;
intrrte[nmintrrtes][0][1] = .8;

intrrte[nmintrrtes][1][0] = .8;
intrrte[nmintrrtes][1][1] = .8;

intrrte[nmintrrtes][2][0] = .8;
intrrte[nmintrrtes][2][1] = .2;

intrrte[nmintrrtes][3][0] = .6;
intrrte[nmintrrtes][3][1] = .2;

intrrte[nmintrrtes][4][0] = .6;
intrrte[nmintrrtes][4][1] = .6;

intrrte[nmintrrtes][5][0] = .4;
intrrte[nmintrrtes][5][1] = .6;

intrrte[nmintrrtes][6][0] = .4;
intrrte[nmintrrtes][6][1] = .2;

intrrte[nmintrrtes][7][0] = .2;
intrrte[nmintrrtes][7][1] = .2;

intrrte[nmintrrtes][8][0] = .2;
intrrte[nmintrrtes][8][1] = .8;
nmintrrtepts[nmintrrtes] = 9;
++nmintrrtes;

intrrtetime[nmintrrtes] = solt;
intrrte[nmintrrtes][0][0] = .2;
intrrte[nmintrrtes][0][1] = .7;

intrrte[nmintrrtes][1][0] = .4;
intrrte[nmintrrtes][1][1] = .8;

intrrte[nmintrrtes][2][0] = .7;
intrrte[nmintrrtes][2][1] = .8;

intrrte[nmintrrtes][3][0] = .2;
intrrte[nmintrrtes][3][1] = .3;

intrrte[nmintrrtes][4][0] = .4;
intrrte[nmintrrtes][4][1] = .2;

intrrte[nmintrrtes][5][0] = .8;
intrrte[nmintrrtes][5][1] = .6;

intrrte[nmintrrtes][6][0] = .8;
intrrte[nmintrrtes][6][1] = .2;
nmintrrtepts[nmintrrtes] = 7;
++nmintrrtes;

intrrtetime[nmintrrtes] = solt;
intrrte[nmintrrtes][0][0] = .4;
intrrte[nmintrrtes][0][1] = .2;

intrrte[nmintrrtes][1][0] = .2;
intrrte[nmintrrtes][1][1] = .4;

intrrte[nmintrrtes][2][0] = .2;
intrrte[nmintrrtes][2][1] = .7;

intrrte[nmintrrtes][3][0] = .8;
intrrte[nmintrrtes][3][1] = .2;

intrrte[nmintrrtes][4][0] = .8;
intrrte[nmintrrtes][4][1] = .5;

intrrte[nmintrrtes][5][0] = .4;
intrrte[nmintrrtes][5][1] = .8;

intrrte[nmintrrtes][6][0] = .8;
intrrte[nmintrrtes][6][1] = .8;
nmintrrtepts[nmintrrtes] = 7;
++nmintrrtes;
}

// -------------------------------------------------------------------

static void gen_shadow_routes_(double solt) {

/* Generates m rhino-shadowing interdiction patrol routes.  Do this as
   follows:

   1. Randomly sample n rhinos from the list of live rhinos.  Let this
      sequence of rhino locations form a candidate interdiction patrol
      route.
   2. Compute the are of this route's convex hull.
   3. Repeat Steps 1 and 2 500 times and retain the shortest route that
      has a convex hull area that is at least 50\% of the convex hull
      formed by all of the rhinos in the patrol area.

   Note that this algorithm will generate very random (hard to predict)
   routes that are also fairly economical to walk. */

int i, j, k, l, nmhpts, n = 5, m = 3;

double targetarea, trialarea, xdiff, ydiff, minlngth, lngth;

// Feasibility checks.

if (nmrhino < 5) {
   Run_id.printf_("gen_shadow_routes: nmrhino= " + nmrhino + " returning");
   return;
}

if (nmrhino < n) {
   n = nmrhino;
}

/* First, find the area of the convex hull formed from all rhinos in the
   patrol region. */

nmhpts = Mcce.jarvis_(nmrhino, target[0], Mcce.hpoint);
for (i = 0; i < nmhpts; ++i) {
   Mcce.xval[i] = Mcce.hpoint[i][0];
   Mcce.yval[i] = Mcce.hpoint[i][1];
}
targetarea = .5 * Mcce.polyarea_(nmhpts - 1, Mcce.xval, Mcce.yval);

// Each route is the shortest over about 500 candidate routes.

for (i = 0; i < m; ++i) {
   minlngth = 1.e30;
   for (j = 0; j < 500; ++j) {

      // Randomly select n targets.

      for (k = 0; k < n; ++k) {
         l = Rndm.dscrtunif_(0, 1, nmrhino) - 1;
	 Mcce.point[k][0] = target[0][l][0];
	 Mcce.point[k][1] = target[0][l][1];
      }

      // Find the area of the convex hull formed by these n points.

      nmhpts = Mcce.jarvis_(n, Mcce.point, Mcce.hpoint);
      for (l = 0; l < nmhpts; ++l) {
         Mcce.xval[l] = Mcce.hpoint[l][0];
         Mcce.yval[l] = Mcce.hpoint[l][1];
      }
      trialarea = Mcce.polyarea_(nmhpts - 1, Mcce.xval, Mcce.yval);

      // Check if minimum area requirement is met.

      if (trialarea < targetarea) {
         continue;
      }

      // Compute this route's length.

      lngth = 0.;
      for (k = 0; k < n - 1; ++k) {
         xdiff = Mcce.point[k][0] - Mcce.point[k + 1][0];
         ydiff = Mcce.point[k][1] - Mcce.point[k + 1][1];
         lngth += Math.sqrt(xdiff * xdiff + ydiff * ydiff);
      }

      // Retain the shortest route.

      if (lngth < minlngth) {
         minlngth = lngth;
         for (k = 0; k < n; ++k) {
	    intrrte[nmintrrtes][k][0] = Mcce.point[k][0];
	    intrrte[nmintrrtes][k][1] = Mcce.point[k][1];
         }
      }
   }
   intrrtetime[nmintrrtes] = solt;
   ++nmintrrtes;
}
}
}
