import java.util.*;

public class Rndm extends Id {
static boolean loadseeds = false;

private static Random generator = new Random();
private static Random shufflegen = new Random();
private static int iset = 0;

static int m1[] = new int[NMTHRDS];
static int m2[] = new int[NMTHRDS];
static int m3[] = new int[NMTHRDS];
static int m4[] = new int[NMTHRDS];

static long seed[] = new long[NMTHRDS + 2];
static long a[] = new long[NMTHRDS + 2];

private static double gset, betaba_aold, betaba_bold, betaba_alpha,
   betaba_beta, betaba_gamma;

//-----------------------------------------------------------------

public static double rndm1_(int threadnm, int start) {

// Uniform(0, 1) deviate.

int i;

long val1, ratio;

double dev;

if (start == 1) {

   if (threadnm > nmthreads) {
      iderr_("rndm1: threadnm= " + threadnm);
   }

   // Load seed array.

   if (!loadseeds) {
      a[0] = 77777777777L;
      for (i = 0; i < nmthreads + 1; ++i) {
         val1 = a[0] * 314159269;
         ratio = val1 / 2147483647;
         a[0] = val1 - 2147483647 * ratio;
         seed[i] = a[0];

	 // These are for the Swain and Swain generator, below.

	 m1[i] = 32007779;
         m2[i] = 23717810;
         m3[i] = 52636370;
      }
      loadseeds = true;
   }

   // Initialize both random number generators.

   a[threadnm] = seed[threadnm];

} else if (start == 2) {

   // Initialize jackknife subsampling random number generator.

   a[nmthreads + 1] = 75757575757L;
}

val1 = a[threadnm] * 314159269;
ratio = val1 / 2147483647;
a[threadnm] = val1 - 2147483647 * ratio;
dev = ((double) a[threadnm]) / 2147483647.;

// a = Math.IEEEremainder(val1, val2);

return dev;
}

//-----------------------------------------------------------------

public static double rndm2_(int threadnm, int start) {

// Uniform(0, 1) deviate.

double dev;

if (start == 1) {
   generator.setSeed(77777777);
}

dev = generator.nextDouble();

/* Swain and Swain (1980) mostly-integer-operations generator.
m4[threadnm] = m1[threadnm] + m2[threadnm] + m3[threadnm];
if (m2[threadnm] < 50000000) {
   m4[threadnm] += 1357;
}
if (m4[threadnm] >= 100000000) {
   m4[threadnm] -= 100000000;
}
if (m4[threadnm] >= 100000000) {
   m4[threadnm] -= 100000000;
}
m1[threadnm] = m2[threadnm];
m2[threadnm] = m3[threadnm];
m3[threadnm] = m4[threadnm];
dev = ((double) m3[threadnm]) * .00000001;
*/

return dev;
}

//-----------------------------------------------------------------

public static int unifint_(int threadnm, int nmax) {

// Return a random integer on the interval [0, nmax).

//   return (generator.nextInt(nmax));

return ((int) (rndm1_(threadnm, 0) * ((double) nmax)));
}

//-----------------------------------------------------------------

public static double stdnrm_(int threadnm) {

// Box-Muller standard normal Random.

double v1, v2, r, fac, gasdev, vdum;

if (iset == 0) {
   do {
      /*
      v1 = 2. * rndm1_(threadnm, 0) - 1.;
      v2 = 2. * rndm1_(threadnm, 0) - 1.;
      */
      v1 = 2. * Math.random() - 1.;
      v2 = 2. * Math.random() - 1.;
      vdum = v2;
      v2 = v1;
      v1 = vdum;
      r = (v1 * v1) + (v2 * v2);
   } while (r > 1.);
   fac = Math.sqrt(-2. * Math.log(r) / r);
   gset = v1 * fac;
   gasdev = v2 * fac;
   iset = 1;

} else {
   gasdev = gset;
   iset = 0;
}

gasdev = generator.nextGaussian();

return gasdev;
}

// ----------------------------------------------------------------------

public static double gamdev_(int threadnm, double alpha, double beta) {

/* Generates a deviate from the Gamma(alpha,beta) distribution when
   the PDF is defined as:
   f(y) = beta^alpha y^(alpha-1) exp(-beta y) / Gamm(alpha)
   where Gamm(.) is the Gamma function and alpha and beta are both
   positive.  First, a deviate, x is generated from the Gamma(alpha, 1)
   distribution and then y = x / beta is returned.
   m is the largest integer <= alpha.

   Algorithm is from: Wallace, N. D. (1974), ``Computer Generation of
   Gamma Random Variates with Non-integral Shape Parameters,''
   Communications of the ACM, 17(12): 691-695.
 
   If alpha=1, this is the Exponential distribution with mean 1/beta
   and median ln(2)/beta.
*/

int i, j, m;

double check, x, y, b, q;
 
m = (int) Math.floor(alpha);
q = alpha - (double) m;
if (Math.abs(q) < 1.e-10) {
   x = 1.;
   for (i = 0; i < m; ++i) {
      x *= rndm1_(threadnm, 0);
   }

   return -Math.log(x) / beta;
}
if (alpha < 1.0) {
   b = betaj_(threadnm, alpha, 2. - alpha);
   y = -Math.log(rndm1_(threadnm, 0) * rndm1_(threadnm, 0));

   return b * y / beta;
}

j = 0;
do {
   ++j;
   x = 1.;
   if (rndm1_(threadnm, 0) <= q) {
      for (i = 0; i < m + 1; ++i) {
 x *= rndm1_(threadnm, 0);
      }

   } else {
      for (i = 0; i < m; ++i) {
 x *= rndm1_(threadnm, 0);
      }
   }
   x = -Math.log(x);
   if (alpha > 5.) {
      return x / beta;
   }

   check = Math.floor(x / ((double) m) - 1.) * q + 1.;
   check = Math.pow(x / (double) m, q) / check;
   if (j > 100) {
      iderr_("j big in gamdev_()");
   }
} while (rndm1_(threadnm, 0) > check);

return x / beta;
}

// ----------------------------------------------------------------

public static double beta_(int threadnm, double a, double b) {

if (a < 1. && b < 1.) {
   return betaj_(threadnm, a, b);

} else {
   return betaba_(threadnm, a, b);
}

}

// ----------------------------------------------------------------

public static double betaj_(int threadnm, double a, double bp1) {

/* Generates a Beta(a,b+1) deviate using the algorithm given in
   Wallace (1974) and based on the algorithm of Johnk (1964) (see above). */

int i;
double b, inva, invb, x, y;

b = bp1 - 1.;
if (a < 0.) {
   iderr_("a= " + a + " <0 in beta_");
}

if (b < 0.) {
   iderr_("bp1= " + bp1 + " b<0 in beta_");
}

// Only try 100 times so that an endless loop condition does not develop.

inva = 1. / a;
invb = 1. / b;
for (i = 1; i <= 100; ++i) {
   x = Math.pow(rndm1_(threadnm, 0), inva);
   y = Math.pow(rndm1_(threadnm, 0), invb);
   if (x + y <= 1.) {
      if (x <= 0.) {
 x = .00001;
      }

      if (1. <= x) {
 x = .99999;
      }

      return x;
   }
}

if (i >= 100) {
   iderr_("i= " + i + " in betaj_");
}

return a / (a + b);
}

// ----------------------------------------------------------------

public static double betaba_(int threadnm, double a, double b) {

/* Algorithm BA for Beta deviates, from Cheng, R. C. H. (1978),
   Communications of ACM, 21: 317. */

int i;
double alpha, beta, gamma, u1, u2, v, w = 0., log4 = Math.log(4.);

/* Initialization -- only needed if a and/or b have changed from last
   call. */

if (a != betaba_aold || b != betaba_bold) {
   betaba_alpha = a + b;
   if (Math.min(a, b) <= 1.) {
      betaba_beta = Math.max(1. / a, 1. / b);

   } else {
      betaba_beta = Math.sqrt((betaba_alpha - 2.) /
 (2. * a * b - betaba_alpha));
   }
   betaba_gamma = a + 1. / betaba_beta;
   betaba_aold = a;
   betaba_bold = b;
}

for (i = 1; i <= 200; ++i) {
   u1 = rndm1_(threadnm, 0);
   u2 = rndm1_(threadnm, 0);
   v = betaba_beta * Math.log(u1 / (1. - u1));
   w = a * Math.exp(v);
   if (betaba_alpha * Math.log(betaba_alpha / (b + w)) +
       betaba_gamma * v - log4 >= Math.log(u1 * u1 * u2)) {
      break;
   }
}

if (i >= 200) {
   iderr_("i >= 200 in betaba_");
}

return w / (b + w);
}

// -------------------------------------------------------------------

public static int geomdev_(int threadnm, double rho) {

/* Returns a deviate from the Geometric(rho) distribution (starting from
   1). */

int val;

val = 1;
do {
   if (Rndm.rndm1_(threadnm, 0) < rho) {
      return val;
   }
   ++val;
} while (val < 1000);
iderr_("val > 1000 in geomdev_()");

return 0;
}

// -------------------------------------------------------------------

public static int discrte_(int threadnm, double prob[]) {

// Returns a deviate from a tabulated discrete distribution.

int i, n;

double sum = 0., unif;

n = prob.length;

unif = rndm1_(threadnm, 0);
for (i = 0; i < n; ++i) {
   sum += prob[i];
   if (unif < sum) {
      return (i + 1);
   }
}
if (i == n) {
   iderr_("discrte: sum= " + sum);
}
return -1;
}

// -------------------------------------------------------------------

public static int dscrtunif_(int threadnm, int firstval, int endval) {

/* Returns a deviate from a discrete uniform distribution on the integers
   firstval, ..., endval. */

int i, retval = -1;

double unifprob, sum, unif;

if (firstval == endval) {
   return firstval;
}

unifprob = 1. / ((double) (endval - firstval + 1));

unif = rndm1_(threadnm, 0);

i = firstval;
sum = unifprob;
for (;;) {
   if (unif < sum) {
      retval = i;
      break;
   }
   ++i;
   sum += unifprob;
}

if (retval > endval) {
   iderr_("dscrtunif: firstval= " + firstval + " endval= " + endval);
}

return retval;
}

// ----------------------------------------------------------------------

public static void colsn_() {

/* performs the collision test on a random number generator giving
   numbers between 0 and 1. */

byte col[] = new byte[1048576];
int n, i, i1, k2, nmrl = 4, v, count;
double d = 2.;

fleopen_(5, "colsn.rlt", 'w');
fprintf_(5, "Collision Test");

n = ipow_(2, 14);
for (k2 = 1; k2 <= nmrl; ++k2) {
   for (i = 1; i <= 1048576; ++i) {
      col[i - 1] = 0;
   }

   // generate n vectors of length 20 and test for collisions

   count = 0;
   for (i = 1; i <= n; ++i) {
      v = 0;
      for (i1 = 1; i1 <= 20; ++i1) {
 v += ((int) (d * rndm1_(0, 0))) * ipow_(2, i1 - 1);
      }

      // test for collisions

      if (col[v] == 0) {
 col[v] = 1;
      
      } else {
 ++count;
      }
   }

   // write count

   fprintf_(5, "count= " + count);
}
fclose_(5, 'w');
iderr_("End of collision test");

}

// ----------------------------------------------------------------------

public static int[] shuffle_(int a, int b, int start) {

// Shuffles the integers from "a" to "b."

/* Use the following with Java 1.7
ThreadLocalRandom rgen = new ThreadLocalRandom();  // Random number generator
*/

if (start == 1) {
   shufflegen.setSeed(77777777);
}

int size = b-a+1;

int[] array = new int[size];
 
for(int i=0; i< size; ++i){
   array[i] = a+i;
}
 
for (int i=0; i<array.length; ++i) {
   int randomPosition = shufflegen.nextInt(array.length);
   int temp = array[i];
   array[i] = array[randomPosition];
   array[randomPosition] = temp;
}

return array;
}
}
