class Pursuit extends Interdict {

/* Interactive tool to support the pursuit of a poaching party.  The
   tool opens a window and waits for the pursuit team's commander to
   enter the coordinates of the poaching party.  The tool responds
   with a set of recommended locations that each member of the
   pursuit team should move to.  The tool issues a new set of
   recommended team-member coordinates every time the commander
   enters a new set of poacher coordinates. */

static boolean hornacquired = false;

static int d = 1, nmteam = 3, nmattrtepts, nmtmrtepts, beginrte = 0,
   endrte = 0, nmhornacquired = 0, nmcontacts = 0;

static double distp = .03, distr = .04, minsepdist, medapprehenddist = 0.;

static double predploc[] = new double[2];
static double oldploc[] = new double[2];
static double currploc[] = new double[2];
static double heading[] = new double[2];
static double temploc[][] = new double[10][2];
static double rcmnddtmloc[][] = new double[10][2];
static double currtmloc[][] = new double[10][2];
static double avetmloc[] = new double[2];
static double tmrte[][][] = new double[10][Id.NMRTES][2];
static double apprehenddist[] = new double[Id.NMRTES];

// ------------------------------------------------------------------

// static void Intrprstwind_();
// Copy GISwind.java to Intrprstwind.java
// and create a GUI interface.

// ------------------------------------------------------------------

static void pursuittest_() {

/* Tests the pursuit strategy tool with observed or simulated attacker
   routes. */

int i, nmpursuits;

if (nmteam > 10) {
   Id.iderr_("pursuittest: nmteam= " + nmteam);
}

// Read target locations.

Id.fleopen_(7, obstargetflenme, 'r');
Id.fgetline_(7);
Id.fgetline_(7);
Id.fgetint_(7);
Id.fgetstrng_(7);
do {
   targettime[nmtargets] = Id.fgetdble_(7);
   target[0][nmtargets][0] = Id.fgetdble_(7);
   target[0][nmtargets][1] = Id.fgetdble_(7);
   ++nmtargets;
} while (!Id.checkeof_(7));
Id.fclose_(7, 'r');
Id.printf_("pursuit: nmtargets= " + nmtargets);

// Read observed attacker routes.

nmsveattrtes = Interdictutils.readroutes_(attrtesflenme, "a", nmsveattrtepts,
               sveattrte, sveattrtetime);

nmpursuits = Math.min(endrte, nmsveattrtes);

// Set sensor ranges to both be 1000 meters.

map_unit_per_meter = 9.96097447e-6;
attackersensrange = 1000. * map_unit_per_meter;
defendersensrange = 1000. * map_unit_per_meter;

/* Set the maximum distance a poacher or ranger can walk during a
   planning interval. */

distp = attackersensrange;
distr = defendersensrange;
Id.printf_("pursuittest: distp= " + distp + " distr= " + distr);

// Simulated attacker route.
// pursuitsim_(0, 30);

// Conduct a pursuit over attacker route(s).

for (i = beginrte; i <= nmpursuits; ++i) {
   pursuitsim_(i, nmsveattrtepts[i - 1]);
}
medapprehenddist = Loadpar.median_(nmpursuits, apprehenddist);
medapprehenddist /= (1000. * map_unit_per_meter);
Id.printf_("pursuittest: nmpursuits= " + nmpursuits + " nmhornacquired= " +
   nmhornacquired + " nmcontacts= " + nmcontacts +
   "\n   medapprehenddist= " + Id.fdble_(medapprehenddist, 6, 3) + " km");
}

// ------------------------------------------------------------------

static void pursuitsim_(int rtenm, int nmattrtepts) {

int i, j, k, l;

double dist, mindist = 1.e30;

Id.printf_("pursuitsim: beginning attacker route " + rtenm +
   " number of points= " + nmattrtepts);

// Initialize encirclement constant and number of team route points.

d = 1;
nmtmrtepts = 0;

// Route 0 is simulated.

if (rtenm == 0) {
   attrte[0][0][0] = .51;
   attrte[0][0][1] = .30;
   currploc[0] = attrte[0][0][0];
   currploc[1] = attrte[0][0][1];

   for (i = 0; i < nmattrtepts; ++i) {

      /* Generate a new location for the poaching party.  This party
         heads north for a few kilometers, poaches a rhino, head
         north a few more kilometers, and then abruptly turns west
         and heads straight for the border. */
   
      if (currploc[1] < .6) {
         heading[0] = 0.;
         heading[1] = 1.;

      } else {
         heading[0] = -1.;
         heading[1] = 0.;
      }

      for (j = 0; j < 2; ++j) {
         attrte[0][i][j] = currploc[j];
         currploc[j] = currploc[j] + distp * heading[j];
         currploc[j] += .1 * distp * Rndm.stdnrm_(0);
      }
   }

} else {
   for (i = 0; i < nmattrtepts; ++i) {
      attrte[0][i][0] = sveattrte[rtenm - 1][i][0];
      attrte[0][i][1] = sveattrte[rtenm - 1][i][1];
      attrtetime[0] = sveattrtetime[rtenm - 1];
   }
   currploc[0] = attrte[0][0][0];
   currploc[1] = attrte[0][0][1];
}

// Insert team at the first point on the attackers' route.

for (i = 0; i < nmteam; ++i) {
   currtmloc[i][0] = currploc[0] + .01 * Rndm.stdnrm_(0);
   currtmloc[i][1] = currploc[1] + .01 * Rndm.stdnrm_(0);
}

// Loop over attacker route points.

for (i = 0; i < nmattrtepts; ++i) {

   oldploc[0] = currploc[0];
   oldploc[1] = currploc[1];

   currploc[0] = attrte[0][i][0];
   currploc[1] = attrte[0][i][1];

   Id.printf_("\npursuitsim: beginning attrtept= " + (i + 1) +
      " currpx= " + Id.fdble_(currploc[0], 7, 4) + " currpy= " +
      Id.fdble_(currploc[1], 7, 4));

   // Check if poaching party escaped.

   if (currploc[0] < 0. || currploc[0] > 1. ||
       currploc[1] < 0. || currploc[1] > 1.) {
      Id.printf_("pursuitsim: poaching party escaped.");
      break;
   }

   /* If a rhino is near the line connecting the poachers' last
      location and their new location, execute a poaching event by
      setting the "hornacquired" variable to "true." */

   mindist = 1.e30;
   for (j = 0; j < nmtargets; ++j) {
      if (attrtetime[0] > targettime[j]) {
         continue;
      }

      dist = Interdictutils.distptline_(target[0][j], oldploc, currploc);
      if (dist < mindist) {
         mindist = dist;
      }
   }
   if (mindist < attackersensrange && !hornacquired) {
      hornacquired = true;
      Id.printf_("horn acquired");
   }

   // ----- Compute pursuit team's recommended locations. -------

   teammove_();

   /* Team members are only partially successful at reaching their
      recommended locations.  If contact is achieved, quit. */

   mindist = 1.e30;
   avetmloc[0] = 0.;
   avetmloc[1] = 0.;
   for (j = 0; j < nmteam; ++j) {
      for (k = 0; k < 2; ++k) {
         tmrte[j][nmtmrtepts][k] = currtmloc[j][k];
	 for (l = 0; l < 100; ++l) {
            currtmloc[j][k] = rcmnddtmloc[j][k] + .01 * Rndm.stdnrm_(0);
	    if (g[k] < currtmloc[j][k] && currtmloc[j][k] < h[k]) {
               break;
	    }
	 }
	 if (l == 100) {
            Id.iderr_("pursuitsim: l=100");
	 }
	 avetmloc[k] += currtmloc[j][k];
      }
      dist = Clstr.dist_(2, currploc, currtmloc[j]);
      if (dist < mindist) {
         mindist = dist;
      }
   }
   ++nmtmrtepts;
   avetmloc[0] /= (double) nmteam;
   avetmloc[1] /= (double) nmteam;

   if (mindist < .5 * defendersensrange) {
      ++nmcontacts;
      Id.printf_("pursuitsim: contact achieved.");
      break;
   }

   // Compute a new value for the encirclement constant.

   ++d;
   minsepdist = defendersensrange / Math.pow(2., d);

}
if (hornacquired) {
   ++nmhornacquired;
}
apprehenddist[rtenm - 1] = mindist;

if (rtenm > 0) {
   return;
}

// Write all routes to a plotting file.

Id.fleopen_(7, "pursuit.bln", 'w');
Id.fprintf_(7,"Rhino Poaching.  Attacker Evasion/Poaching\n" +
		  "Route and Routes Taken by Pursuit Team Members");
Id.fprintf_(7,"5 Frame 1\n0. 0.\n1. 0.\n1. 1.\n0. 1.\n0. 0.");

strng = "At";
Id.fprintf_(7, nmattrtepts + " " + strng + " 0");
for (j = 0; j < nmattrtepts; ++j) {
   Id.fprintf_(7, Id.fdble_(attrte[0][j][0], 5, 2) + " " +
      Id.fdble_(attrte[0][j][1], 5, 2));
}

for (i = 0; i < nmteam; ++i) {
   strng = "TM" + Integer.toString(i + 1);
   Id.fprintf_(7, nmtmrtepts + " " + strng + " 0");
   for (j = 0; j < nmtmrtepts; ++j) {
      Id.fprintf_(7, Id.fdble_(tmrte[i][j][0], 5, 2) + " " +
		   Id.fdble_(tmrte[i][j][1], 5, 2));
   }
}
Id.fclose_(7, 'w');
}

// -------------------------------------------------------------

static void teammove_() {

/* First predict the poachers' next location, and then compute the
   locations that pursuit team members should move to. */

int i, j, k, n, nmimplicit;

// ------ Predict next location of the poaching party. ---------

n = 2;
nmimplicit = 1;

// Set initial solution and explicit constraints (bounds).

for (i = 0; i < n; ++i) {
   boxx[i] = oldploc[i];
   g[i] = .0;
   h[i] = 1.;
}

/* Specify limits on the constraint: maximum possible distance that
   poachers can walk during the time interval. */

Optimiz.gimplicit[0] = .0;
Optimiz.himplicit[0] = distp;

// Dummy "vartype" values.

for (i = 0; i < n; ++i) {
   Pxp.vartype[i] = "Determ_Contin";
   Pxp.nodename[i] = "Interdict";
}

// Find a new location that maximizes the poachers' utility function.

Id.printf_("\nteammove: beginning poacher optimization");
Optimiz.optimiz_(n, nmimplicit, boxx, g, h, 8);
if (Optimiz.endopt) {
   Id.iderr_("teammove: endopt=true");
}

for (i = 0; i < n; ++i) {
   predploc[i] = boxx[i];
}

// --- Compute recommended locations for team-members to move to. ---

n = 2 * nmteam;
nmimplicit = 1;

k = 0;
for (i = 0; i < nmteam; ++i) {
   for (j = 0; j < 2; ++j) {
      boxx[k] = currtmloc[i][j];
      g[k] = 0.;
      h[k] = 1.;
      ++k;
   }
} 

/* Specify limits on the constraint: maximum possible distance that
   any team member can walk during the specified time interval. */

Optimiz.gimplicit[0] = 0.;
Optimiz.himplicit[0] = distr;

// Dummy "vartype" values.

for (i = 0; i < n; ++i) {
   Pxp.vartype[i] = "Determ_Contin";
   Pxp.nodename[i] = "Interdict";
}

// Find new locations for team members to walk to.

Id.printf_("\nteammove: beginning team optimization");
Optimiz.optimiz_(n, nmimplicit, boxx, g, h, 9);
if (Optimiz.endopt) {
   Id.iderr_("team-member-move: endopt2=true");
}

/* Place these locations in the "recommended team member locations"
   array. */

Id.printf_("teammove: Member   xloc   yloc");
k = 0;
for (i = 0; i < nmteam; ++i) {
   for (j = 0; j < 2; ++j) {
      rcmnddtmloc[i][j] = boxx[k];
      ++k;
   }
   Id.printf_("            " + (i + 1) + "   " +
      Id.fdble_(rcmnddtmloc[i][0], 5, 3) + "  " +
      Id.fdble_(rcmnddtmloc[i][1], 5, 3));
}

/* Write "nmteam" .gpx files that will be transmitted via BaseStation
   to team members. */

// ??
}

// -------------------------------------------------------------------

static double poacherobjf_(int n, double x[]) {

// The poaching party's utility function.

int i;

double dist, mindist, retval;

// First, find the distance to the closest team member.

mindist = 1.e30;
for (i = 0; i < nmteam; ++i) {
   dist = Clstr.dist_(2, x, currtmloc[i]);
   if (dist < mindist) {
      mindist = dist;
   }
}

retval = mindist;

if (hornacquired) {
   return (retval);
}

retval /= 3.;

// Next, find the distance to the closest living rhino.

mindist = 1.e30;
for (i = 0; i < nmtargets; ++i) {
   if (attrtetime[0] < targettime[i]) {
      continue;
   }

   dist = Clstr.dist_(2, x, target[0][i]);
   if (dist < mindist) {
      mindist = dist;
   }
}
retval += 2. * mindist / 3.;
return (retval);
}

// -------------------------------------------------------

static double poachercnstrnt_(double x[]) {

/* Computes the constraint on the poachers' utility function. */

double dist;

dist = Clstr.dist_(2, x, oldploc);
return (dist);
}

// -------------------------------------------------------

static double teamobjf_(int n, double x[]) {

// The pursuit team's utility function.

int i, j, k;

double dist, avedist, mindist, maxdist, currminsepdist, retval;

/* First, find the average, smallest, and biggest distance between
   the poaching party and a team member. */

avedist = 0.;
mindist = 0.;
maxdist = 0.;
k = 0;
for (i = 0; i < n; ++i) {
   for (j = 0; j < 2; ++j) {
      temploc[i][j] = x[k];
      ++k;
   }
   dist = Clstr.dist_(2, predploc, temploc[i]);
   avedist += dist;
   if (dist < mindist) {
      mindist = dist;
   }
   if (maxdist < dist) {
      maxdist = dist;
   }
}
avedist /= (double) n;

/* Next, find the minimum separation distance between any two team
   members. */

currminsepdist = 1.e30;
for (i = 1; i < n; ++i) {
   for (j = 0; j < i; ++j) {
      dist = Clstr.dist_(2, temploc[i], temploc[j]);
      if (dist < currminsepdist) {
         currminsepdist = dist;
      }
   }
}

/* Now, form the objective function which is the weighted sum of
   (a) the average distance between the poaching party and a team
       member,
   (b) the difference between
        (i) the poaching party - team member separation distance of
            the furthest team member from the poacher party, and
       (ii) the separation distance of the closest team member from
            the poaching party.
   (c) the absolute difference between the minimum inter-team member
       separation distance and the desired minimum inter-team member
       separation distance. */

retval = .50 * avedist + .30 * (maxdist - mindist) +
         .20 * Math.abs(currminsepdist - minsepdist);
return (-retval);
}

// -----------------------------------------------------------

static double teamcnstrnt_(int n, double x[]) {

/* Computes the constraints on the team's utility function. */

int i, j, k = 0;

double maxdist = 0., dist;

/* For each team member, check the maximum walking distance
   constraint. */

for (i = 0; i < n; ++i) {
   for (j = 0; j < 2; ++j) {
      temploc[i][j] = x[k];
      ++k;
   }
   dist = Clstr.dist_(2, currtmloc[i], temploc[i]);
   if (maxdist < dist) {
      maxdist = dist;
   }
}
return (maxdist);
}
}
