import java.util.*;
public class Psens extends Intridslve {

static String id[] = new String[TNMIDS];
static String ndenames[][] = new String[TNMIDS][TNMNDS];
static String title1[] = new String[TNMIDS + MAXNMECO];
static String title2[] = new String[TNMIDS + MAXNMECO];
static String xtitle[] = new String[TNMIDS + MAXNMECO];
static String ytitle[] = new String[TNMIDS + MAXNMECO];
static String legendlbl[] = new String[TNMIDS + MAXNMECO];

static int nmsensids, nmmc;

static int nmndes[] = new int[TNMIDS];
// static int actfreq[][][] = new int[TNMIDS][MAXTIMES][TNMVALS];
static int actfreq[][][] = new int[1][1][1];
static int sumfreq[][] = new int[TNMVALS][MAXTIMES];
static int modalfreq[][] = new int[TNMVALS][MAXTIMES];
static int modalact[][] = new int[TNMIDS][MAXTIMES];
static int hypact[][] = new int[TNMIDS][MAXTIMES];
static int nmline[] = new int[TNMIDS + MAXNMECO];
static int linetype[] = new int[TNMIDS + MAXNMECO];
static int n[] = new int[TNMIDS + MAXNMECO];
static int beginpar[] = new int[TNMIDS];
static int begincnstrnt[] = new int[TNMIDS];

static double y[][][] = new double[TNMIDS + MAXNMECO][1][MAXTIMES];
static double x[][] = new double[TNMIDS + MAXNMECO][MAXTIMES];
static double beta[] = new double[OPTSIZE];
static double lower[] = new double[OPTSIZE];
static double upper[] = new double[OPTSIZE];
// static double ecosysvals[][][] = new double[SIMSZE][MAXNMECO][MAXTIMES];
static double ecosysvals[][][] = new double[1][1][1];
static double ecomean[][] = new double[MAXNMECO][MAXTIMES];
static double ecostd[][] = new double[MAXNMECO][MAXTIMES];
static double ecosens[][] = new double[MAXNMECO][MAXTIMES];
// static double grpsens[][] = new double[TNMIDS][MAXTIMES];
static double grpsens[][] = new double[1][1];
static double xmins[] = new double[TNMIDS + MAXNMECO];
static double xmaxs[] = new double[TNMIDS + MAXNMECO];
static double ymins[] = new double[TNMIDS + MAXNMECO];
static double ymaxs[] = new double[TNMIDS + MAXNMECO];

// -----------------------------------------------------------------------

public static void psens_() {

/* Performs sensitivity analysis (SA) of an IntIDs model using Monte
   Carlo sampling.

Steps:
1. Create a parameter vector of all parameters of the IDs that constitute
   the IntIDs model.
2. Sample from a multidimensional uniform distribution on this collective
   parameter space bounded by the boundaries given in the hypothesis
   parameter file.
3. Compute the solution history under this sampled vector and store the
   action history.
4. Iterate steps 2 and 3 m times.
5. Use stored action histories to compute S_i(t) for each group and S_j(t)
   for each ecosystem node over the time interval.
6. Plot S_i(t) and S_j(t) as a function of time.
*/

int i, j, k, l, nmpar = 0, nmcnstrnt = 0, actval = 0;

// Initialize IntIDs model.

intridslve_(true, false);

/* Create a parameter vector of all parameters of the IDs that constitute
   the IntIDs model. */

for (i = 0; i < nmsensids; ++i) {

   // Get ID number.

   for (l = 0; l < nmids; ++l) {
      if (idname[l].equals(id[i])) {
	 thisidname = id[i];
	 Getmodl.getmodl_(6, idfle[l]);
	 break;
      }
   }

   // Set to "on" parameters associated with the given nodes.

   for (j = 0; j < nmnds; ++j) {
      varinfo_parest[l][j] = false;
   }
   for (j = 0; j < nmndes[i]; ++j) {
      k = Getmodlutils.getndnm_(ndenames[i][j]);
      varinfo_parest[l][k - 1] = true;
   }

   // Read these parameters into the parameter vector.

   beginpar[i] = nmpar;
   begincnstrnt[i] = nmcnstrnt;
   Pxp.pxp_(0, beta, lower, upper, 1, beginpar[i], begincnstrnt[i],
      false);
   nmpar += Pxp.xi - beginpar[i];
   nmcnstrnt += Pxp.ci - begincnstrnt[i];
}

fprintf_(1, "Number of parameters to be perturbed: " + nmpar +
	    "\nNumber of Monte Carlo realizations: " + nmmc);

// Monte Carlo sampling loop.

if (nmmc < 2) {
   iderr_("psens: nmmc= " + nmmc);
}
for (i = 0; i <= nmmc; ++i) {

   /* The zero^th realization is the hypothesis parameter values.
      Otherwise, sample from the parameter vector's multidimensional
      uniform distribution. */

   if (i > 0) {
      for (j = 0; j < nmpar; ++j) {
         beta[j] = lower[j] + Rndm.rndm1_(0, 0) * (upper[j] - lower[j]);
      }
   }

   /* Compute the IntIDs model solution history under this sampled vector
      and store the action history. */

   iderr_("psens: need to place beta into condprb");
   intridslve_(false, false);

   // Keep track of action frequencies and ecosystem node values history.

   for (j = 0; j < nmmdltimes; ++j) {
      for (k = 0; k < nmids - 1; ++k) {
	 actval = CA.actnshstry_mdlactn[k][j][0];
	 if (actval > 0) {

	    // Update counters and array only if an action was executed.

	    if (i > 0) {
	       ++actfreq[k][j][actval - 1];
	    
	    } else {
	       hypact[k][j] = actval;
	    }
	 }
	 actval = 0;
      }

      /* Currently, only the first region is used.  Future improvements
	 will use each region. */

      for (k = 0; k < nmecosysnds; ++k) {
	 ecosysvals[i][j][k] = CA.actnshstry_mdlecoval[0][j][k];
      }
   }
}

/* Use these stored action histories to compute S_i(t) for each group
   and S_j(t) for each ecosystem node over the time interval.  First,
   find group modal actions and ecosystem node means and variances at
   each time point. */

for (i = 0; i < nmmdltimes; ++i) {
   for (j = 0; j < nmids - 1; ++j) {
      sumfreq[j][i] = 0;
      for (k = 0; k < nmoutacts[j]; ++k) {
         if (modalfreq[j][i] < actfreq[j][i][k]) {
	    modalfreq[j][i] = actfreq[j][i][k];
	    modalact[j][i] = k + 1;
         }
         sumfreq[j][i] += actfreq[j][i][k];
      }

      // Compute this group's SA measure for this time point.

      if (sumfreq[j][i] > 0) {
         grpsens[j][i] = ((double) modalfreq[j][i]) /
			  (double) sumfreq[j][i];

      } else {
	 printf_("psens: j= " + j + " i= " + i + " sumfreq= 0");
	 grpsens[j][i] = 1.;
      }

      if (modalact[j][i] != hypact[j][i]) {
	 grpsens[j][i] -= 2. * grpsens[j][i];
      }
      title2[j] = idname[j];
   }

   // Ecosystem nodes.

   for (k = 0; k < nmecosysnds; ++k) {
      ecomean[k][i] = 0.;
      ecostd[k][i] = 0.;
      for (l = 1; l <= nmmc; ++l) {
	 ecomean[k][i] += ecosysvals[l][k][i];
      }
      ecomean[k][i] /= (double) nmmc;
      for (l = 1; l <= nmmc; ++l) {
	 ecostd[k][i] += Math.pow(ecosysvals[l][k][i] - ecomean[k][i], 2);
      }
      ecostd[k][i] /= (double) (nmmc - 1);
      ecostd[k][i] = Math.sqrt(ecostd[k][i]);

      // Compute this ecosystem node's SA at this time point.

      if (ecomean[k][i] > 1.e-5) {
	 ecosens[k][i] = ecomean[k][i] / (ecomean[k][i] + ecostd[k][i]);

      } else {
	 ecosens[k][i] = 1.e-5 / (1.e-5 + ecostd[k][i]);
      }
      title2[(nmids - 1) + k] = econdelbls[k];
   }
}

// Print the sensitivity measures.

fprintf_(1," Group ID Sensitivity Measures" +
   "\n Time " + idname[0] + " " + idname[1] + " " + idname[2] + " " +
   idname[3]);
for (i = 0; i < nmmdltimes; ++i) {
   fprintf_(1, tmept[i] + "   " + grpsens[0][i] + "   " + grpsens[1][i] +
      "   " + grpsens[2][i] + "   " + grpsens[3][i]);
}

fprintf_(1, "\n             Ecosystem Node Sensitivity Measures" +
   "\n Time  " + econdelbls[0] + "   " + econdelbls[1]);
for (i = 0; i < nmmdltimes; ++i) {
   fprintf_(1, tmept[i] + "   " + ecosens[0][i] + "   " + ecosens[1][i]);
}

// Plot the sensitivity measures.

title1[0] = "Sensitivity_Analysis";
for (i = 0; i < (nmids - 1) + nmecosysnds; ++i) {
   nmline[i] = 1;
   n[i] = nmmdltimes;
   legendlbl[i] = null;
   linetype[i] = 3;

   if (i > 0) {
      title1[i] = null;
   }

   for (j = 0; j < nmmdltimes; ++j) {
      x[i][j] = tmept[j];
   }

   xmins[i] = tmept[0];
   xmaxs[i] = tmept[nmmdltimes - 1];
   xtitle[i] = "Time_in_years";
   ytitle[i] = "IS_t";
}

for (i = 0; i < nmmdltimes; ++i) {
   for (j = 0; j < nmids - 1; ++j) {
      y[j][0][i] = grpsens[j][i];
      ymins[j] = -1.;
      ymaxs[j] = 1.;
   }

   for (j = 0; j < nmecosysnds; ++j) {
      y[(nmids - 1) + j][0][i] = ecosens[j][i];
      ymins[(nmids - 1) + j] = 0.;
      ymaxs[(nmids - 1) + j] = 1.5;
   }
}

Plotutils.multplt_((nmids - 1) + nmecosysnds, 1, nmline, n, x, y, false,
   xmins, xmaxs, ymins, ymaxs, title1, title2, xtitle, ytitle, legendlbl,
   linetype);
}

// ----------------------------------------------------------------------

public static void getparms_(int dirxtn, double x[], double g[],
   double h[], boolean cnstrntsonly) {

// Place perturbed parameter values into the ID's "condprb" array.

boolean retval = false;

int i, j, k, l;

// printf_("getparms: id= " + idname[idnmbrm1] + " nmsensids= " + nmsensids);
for (i = 0; i < nmsensids; ++i) {

   /* If this ID has nodes in the SA or CA, read their values from the SA
      parameter vector. */

   if (idname[idnmbrm1].equals(id[i])) {

      // Read-in this ID's parameters to the ID parameter array.

      Pxp.pxp_(dirxtn, x, g, h, 2, beginpar[i], begincnstrnt[i],
         cnstrntsonly);
   }
}
}
}
