class Promote extends Matchpairs {

/* Promotes and demotes conditional distributions in an effort to match
   observed out-combinations.  For full documentation, see
   Matchpairsdoc.java. */

// ---------------------------------------------------------------------

static boolean findandpromote_(boolean restore) {

/* Finds conditional distributions that conditioned by the in-out
   pair or are positively associated with the terminal node and promotes
   them.  Assumes last node in the ID is the single terminal node. */

String nodeshrtname = "none";

int i, j;

/* Initialize restore array counter and second level conditioning node
   counter. */

nmcondnds = Intridslve.nmcondndes[idnmbrm1];
nmsignalnodes = subnet_nmsignalnodes[idnmbrm1][0];
strindx = 0;

if (!restore) {
   nml2cndnds = 0;

} else if (newobsoutcomb) {

   // Put back the old optimal out-combination.

   mdlinoutpair[idnmbrm1][nmincombs[idnmbrm1] - 1][nmcondnds - 2] =
      (double) oldoptactn;

   mdlinoutpair[idnmbrm1][nmincombs[idnmbrm1] - 1][nmcondnds - 1] =
      (double) oldopttrgt;
}

// Loop over Scenario subnetwork nodes only.

PATHLOOP: for (i = subnet_endnode[idnmbrm1][0] + 1; i < nmnds; ++i) {

   // Don't promote conditioning node distributions.

   for (j = 0; j < nmcondnds; ++j) {
      if (i == condnodes[idnmbrm1][j]) {
	 continue PATHLOOP;
      }
   }

   // Don't promote certain types of nodes.

   nodeshrtname = grph_label[idnmbrm1][i - 1];
   if (nodeshrtname.equals("FIN") ||
       nodeshrtname.equals("SMILFRC")) {
      continue;
   }

   // Promote and demote distributions on this node.

   promotedemote_(restore, i);
}

// printf_("findandpromote: restore= " + restore + " strindx= " + strindx);

return true;
}

// ---------------------------------------------------------------------

static void promotedemote_(boolean restore, int nodenm) {

/* Promote (make more likely) and demote (make less likely) the
   appropriate distributions that define "nodenm." */

boolean flag = false, promote = false;

int i, j, j1, j2, j3, j4, j5, j6, k;

nmvals = nodenghs[idnmbrm1][nodenm - 1][0];

// Get number of values of each parent.

for (i = 0; i < 6; ++i) {
   prnt[i] = nodenghs[idnmbrm1][nodenm - 1][i + 2];
   if (prnt[i] > 0) {
      nmvalngh[i] = nodenghs[idnmbrm1][prnt[i] - 1][0];

   } else {
      nmvalngh[i] = 1;
   }
}

/* Promote or demote only distributions that have a parent that is one
   of the conditioning nodes, second-level conditioning nodes, or one
   of the signal nodes.  Do this by setting "flag" to "true" and then
   skipping any promote-demote adjustment after all distributions have
   been stored.  This way, distributions are correctly restored no matter
   what the value of "nml2cndnds" is. */

flag = false;
LOOP1: for (i = 0; i < 6; ++i) {

   if (prnt[i] == 0) {
      continue;

   } else if (varinfo_signalnode[idnmbrm1][0][prnt[i] - 1]) {
      flag = true;
      break;
   }

   for (j = 0; j < nmcondnds + nml2cndnds; ++j) {
      if (prnt[i] == condnodes[idnmbrm1][j]) {
         flag = true;
         break LOOP1;
      }
   }
}

for (j1 = 1; j1 <= nmvalngh[0]; ++j1) {
   for (j2 = 1; j2 <= nmvalngh[1]; ++j2) {
      for (j3 = 1 ; j3 <= nmvalngh[2]; ++j3) {
         for (j4 = 1; j4 <= nmvalngh[3]; ++j4) {
	    for (j5 = 1; j5 <= nmvalngh[4]; ++j5) {
               for (j6 = 1; j6 <= nmvalngh[5]; ++j6) {
                  iprntval[0] = j1;
                  iprntval[1] = j2;
                  iprntval[2] = j3;
                  iprntval[3] = j4;
                  iprntval[4] = j5;
                  iprntval[5] = j6;
                  for (i = 0; i < 6; ++i) {
		     prntval[i] = (double) iprntval[i];
		  }

		  if (!restore) {

		     // Store this distribution.

		     for (i = 0; i < nmvals; ++i) {
                        strparval[strindx] =
			   Readnet.condprb[idnmbrm1][nodenm - 1][i]
					  [iprntval[0] - 1]
					  [iprntval[1] - 1]
				          [iprntval[2] - 1]
					  [iprntval[3] - 1]
	                                  [iprntval[4] - 1]
					  [iprntval[5] - 1][1];
		        ++strindx;
                        if (strindx == NMSTORED) {
                           iderr_("promotedemote: strindx= " + NMSTORED);
                        }
		     }

		  } else {

		     // Restore this distribution.

		     for (i = 0; i < nmvals; ++i) {
		        Readnet.condprb[idnmbrm1][nodenm - 1][i]
			               [iprntval[0] - 1][iprntval[1] - 1]
			               [iprntval[2] - 1][iprntval[3] - 1]
	                               [iprntval[4] - 1][iprntval[5] - 1][1]
                           = strparval[strindx];
                        ++strindx;
                     }
                  }

                  /* If !restore and "flag" is "false," just store these
		     distributions. */
		     
		  if (restore || !flag) {
                     continue;
                  }

		  /* Promote only distributions for which a parent is
		     set to either a conditioning value of the in-out
		     pair, or to the value of a signal node.  Otherwise,
		     demote it. */

                  promote = false;
		  LOOP2: for (k = 0; k < 6; ++k) {

                     /* First, check for parents being either
		        conditioning nodes or second-level nodes. */

                     for (j = 0; j < nmcondnds + nml2cndnds; ++j) {
                        if (condnodes[idnmbrm1][j] == prnt[k] &&
	                    Math.abs(condvals[j] - prntval[k]) < 1.e-6) {
			   promote = true;
			   break LOOP2;
                        }
                     }

		     // Next, check for parents being signal nodes.

                     for (j = 0; j < nmsignalnodes; ++j) {
                        if (subnet_signalnodenm[idnmbrm1][0][j] ==
			    prnt[k]) {
			   promote = true;
			   break LOOP2;
                        }
		     }
                  }

		  // Change this distribution.

		  if (!flag || restore) {
		     iderr_("promotedemote: very bad ID= " + thisidname +
			" nodenm= " + nodenm);
                  }

		  changeval_(nodenm, promote); 
               }
            }
         }
      }
   }
}
}

// ---------------------------------------------------------------------

static void changeval_(int nodenm, boolean promote) {

// Prepares a conditional distribution to be changed.

boolean newcondnode = false;

int i;

double chgdval = 0., prbsum = 0.;

/*
printf_("changeval: nodenm= " + nodenm + " promote= " + promote +
   "\n prnt1nm= " + prnt[0] + " prnt1val= " + iprntval[0] +
   "\n prnt2nm= " + prnt[1] + " prnt2val= " + iprntval[1] +
   "\n prnt3nm= " + prnt[2] + " prnt3val= " + iprntval[2] +
   "\n prnt4nm= " + prnt[3] + " prnt4val= " + iprntval[3] +
   "\n prnt5nm= " + prnt[4] + " prnt5val= " + iprntval[4] +
   "\n prnt6nm= " + prnt[5] + " prnt6val= " + iprntval[5] +
   "\n disttype= " + varinfo_dist[idnmbrm1][nodenm - 1]);
*/

if (varinfo_dist[idnmbrm1][nodenm - 1].equals("Determ_Discrete")) {
   if (promote) {
      chgdval = Readnet.condprb[idnmbrm1][nodenm - 1][0]
                               [iprntval[0] - 1][iprntval[1] - 1]
			       [iprntval[2] - 1][iprntval[3] - 1]
	                       [iprntval[4] - 1][iprntval[5] - 1][1];
      chgdval = Math.min((chgdval + 1.), ((double) nmvals));

      /* Store this node and value for second-level conditional
         distribution promotion.  First, check if this node has
         already been entered as a second level conditioning node,
         there are already 2 second level conditioning nodes, or
         the candidate node is in the Situation subnetwork.
	    
         Since second-level nodes are children of a direct-change
         node, these second-level nodes will be changed once the
         "findandpromote_" reaches them. */

      newcondnode = true;
      for (i = 0; i < nml2cndnds; ++i) {
         if (nodenm == condnodes[idnmbrm1][nmcondnds + i] ||
            nml2cndnds >= 2 || nodenm <= subnet_endnode[idnmbrm1][0]) {
            newcondnode = false;
	    break;
	 }
      }

      if (newcondnode) {
         condnodes[idnmbrm1][nmcondnds + nml2cndnds] = nodenm;
         condvals[nmcondnds + nml2cndnds] = chgdval;
         ++nml2cndnds;
      }

   } else {
      if (!newobsoutcomb) {
         chgdval = 2.0;
   
      } else {
	 chgdval = Readnet.condprb[idnmbrm1][nodenm - 1][0]
				  [iprntval[0] - 1][iprntval[1] - 1]
				  [iprntval[2] - 1][iprntval[3] - 1]
                                  [iprntval[4] - 1][iprntval[5] - 1][1];

      }
   }

   Readnet.condprb[idnmbrm1][nodenm - 1][0][iprntval[0] - 1]
      [iprntval[1] - 1][iprntval[2] - 1][iprntval[3] - 1]
      [iprntval[4] - 1][iprntval[5] - 1][1] = chgdval;

} else if (varinfo_dist[idnmbrm1][nodenm - 1].equals("Discrete")) {

   // Shift distribution.

   shiftdist_(promote, nodenm);
}
}

// ---------------------------------------------------------------------

static void shiftdist_(boolean promote, int nodenm) {

/* Shift a discrete distribution.
   "promote" is true: shift right
   "promote" is false: shift left.

   For nodes other than chosen-target nodes, assumes that the last value
   of a node is the desired value. */

int i, j, nmtoreduce = 0;

double prbsum;

// Get distribution.

for (i = 0; i < nmvals; ++i) {
   prbval[i] = Readnet.condprb[idnmbrm1][nodenm - 1][i][iprntval[0] - 1]
         [iprntval[1] - 1][iprntval[2] - 1][iprntval[3] - 1]
	 [iprntval[4] - 1][iprntval[5] - 1][1];
}

if (!nodelbls[idnmbrm1][nodenm - 1][0].equals("Chosen_Target")) {
      
   // Not a "Chosen_Target" node.  First, determine shift point.

   if (nmvals == 1) {
      iderr_("shiftdist: nmvals= " + nmvals);

   } else if (nmvals == 2) {
      nmtoreduce = 1;

   } else if (nmvals == 3 || nmvals == 4) {
      nmtoreduce = 2;

   } else if (nmvals == 5) {
      nmtoreduce = 3;

   } else {
      iderr_("shiftdist: nmvals= " + nmvals + " > 5");
   }

   // Remove some probability mass.

   prbsum = 0.;
   for (i = 0; i < nmtoreduce; ++i) {
      if (promote) {
         j = i;

      } else {
         j = nmvals - 1 - i;
      }

      // Get all probability mass that is to be shifted.

      prbsum += .1 * prbval[j];
      prbval[j] -= .1 * prbval[j];

      if (prbval[j] <= 0.) {
	 printf_("shiftdist: prbval(" + (j + 1) + ")= " + prbval[j] +
	   " no shift, returning.");

	 return;
      }
   }

   // Add-back probability mass.

   for (i = nmtoreduce; i < nmvals; ++i) {
      if (promote) {
         j = i;

      } else {
         j = nmvals - 1 - i;
      }

      prbval[j] += prbsum / (double) (nmvals - nmtoreduce);

      if (prbval[j] >= 1.) {
	 printf_("shiftdist: prbval(" + (j + 1) + ")= " + prbval[j] +
	   " no shift, returning.");

	 return;
      }
   }

} else {

   // Chosen_Target node: make observed target the most likely value.

   if (obstrgtnm < 1 || nmvals < obstrgtnm) {
      iderr_("shiftdist: obstrgtnm= " + obstrgtnm);
   }

   if (promote) {
      for (i = 0; i < nmvals; ++i) {
	 prbval[i] = .3 / (double) (nmvals - 1);
      }
      prbval[obstrgtnm - 1] = .7;

   } else {

      // Leave the chosen-target distributions of unobserved actions alone.
   }
}

// Reload "condprb" with this shifted distribution.

for (i = 0; i < nmvals; ++i) {
   Readnet.condprb[idnmbrm1][nodenm - 1][i][iprntval[0] - 1]
         [iprntval[1] - 1][iprntval[2] - 1][iprntval[3] - 1]
	 [iprntval[4] - 1][iprntval[5] - 1][1] = prbval[i];
}
}
}
