class Predict extends Surf {
static boolean wflag, wflag2, krgvcalc, modelisfit = false;

static int ktrend, vsave;

static int ipvt[] = new int[WLSSZE];
static int qualval[] = new int[NMQUAL];
static int oldndmn[] = new int[NUMVAR];

static double cond, condmean, condvar;

static double xtemp[][] = new double[WLSSZE][NUMVAR];
static double prdest[] = new double[TNMNDS];
static double lower[] = new double[NUMVAR];
static double upper[] = new double[NUMVAR];
static double krgvar[] = new double[TNMNDS];
static double trend[] = new double[NUMVAR];
static double orgsill[][] = new double[NUMMDLS][NUMCNTR + 1];
static double orgodd[][] = new double[NUMMDLS][NUMCNTR + 1];
static double quantval[] = new double[NMQUANT];

// ------------------------------------------------------------------

static void predict_(int threadnm, int option, int jrow, int jcol,
   double xcord, double ycord, double tmecord) {

// Computes a prediction.

int i, j, retval = 0, ndsve, cntrstrt = 0, l, cntr, cvstrct, stnm;

double eveninc, oddinc;

// Initialize the write flag and the kriging-variance-only-calculation flag.

if (option <= 0) {
   wflag = true;

} else {
   wflag = false;
}
krgvcalc = false;

// Define global row and column indices.

gcol = jcol;
grow = jrow;
if (icrval == 1 && wflag) {
   printf_("predict: beginning cross-val prediction " + idatcr);
}

// Save within-cylinder sample sizes.

for (i = 0; i < parm_mvar; ++i) {
   oldndmn[i] = ndmin[i];
}

if (option < 2) {

   // If point is out of boundary, call assign and return.

   if (iblank == 1) {
      assign_(jrow, jcol, jtime, xcord, ycord, tmecord, option);
      return;
   }

   /* Under cross-validation, set prediction location's observation
      to "missing."  */

   if (icrval == 1) {
      vsave = dat2_vrble[1][idatcr - 1];
      dat2_vrble[1][idatcr - 1] = -1;
   }

   if (icrval == 1 || (icrval == 0 && !modelisfit)) {

      /* Cross-validation or a global model under grid-prediction that
         has not been previously fitted. First, load "vardat" structure. */

      if (Estimate.local || (!Estimate.local && !modelisfit)) {
         Mvsrch.mvsrch_(option, xcord, ycord, tmecord);
      }

      /* Next, call "estimate_" to fit the trend model with either
	 2-stage, generalized least squares (2SGLS) or Minimum Distance.
	 Optionally, also fit the covariogram matrix model. */

      if (!modelisfit) {
         retval = Estimate.estimate_(option, xcord, ycord, tmecord);

      } else {
         retval = 0;

         // Compute the MVN residuals (Z vector in Haas (2000) notation).

         for (i = 0; i < nd; i++) {
	    stnm = idtostnm[vardat_vrble[i] - 1];

            // Nonmixture or mixture trend model.

            if (nmstmixcntr == 0) {
               vardat_trend[i] = Trendeval.trendfcn_(0, true, i, vardat_x[i],
                  vardat_y[i], vardat_t[i], vardat_quantval[i],
		  vardat_qualval[i], stnm);

            } else {
               vardat_trend[i] = 0.;
               for (j = 0; j < nmstmixcntr; ++j) {
	          vardat_trend[i] +=
                     Mdobjf.krnlwghts[j][i] * Trendeval.trendfcn_(j + 1,
                        true, i, vardat_x[i], vardat_y[i], vardat_t[i],
	                vardat_quantval[i], vardat_qualval[i], stnm);
               }
            }

            if (vardat_trend[i] == -1.e30) {
               iderr_("estimate: trend= -infinity");
            }

            if (trnsfrm) {

               // Transform to the gaussian.

               vardat_dat[i] = Trnsfrm.gaus_(stnm,
                               (vardat_obs[i] - vardat_trend[i]));

            } else {
               vardat_dat[i] = vardat_obs[i] - vardat_trend[i];
            }
         }
      }

      // Process error returns.

      if (retval == 1) {
         fprintf_(1, "predict: blank=4, estimate_=1");
         iblank = 4;
         assign_(jrow, jcol, jtime, xcord, ycord, tmecord, option);
         return;

      } else if (retval == 2) {
         iblank = 5;
         assign_(jrow, jcol, jtime, xcord, ycord, tmecord, option);
         return;

      } else if (retval == 3) {
         iderr_("predict: estimate retval=3");
      }

      // Set flag that indicates the global model has been estimated.

      if (nmstmixcntr > 0) {
         if (icrval != 1 && !client) {
	    modelisfit = true;
	 }
      }
   }

   if (itest) {
      printf_("Cylinder n= " + nd + " xcord= " + xcord + " ycord= " +
	 ycord);
   }

} else if (option == 2) {

   // Sites are being added or deleted, use variogram stored in grdvar array.

   if (nmstmixcntr > 0) {
      iderr_("predict: bad options");

   } else if (nmstmixcntr == 0) {
      varmod_nugget[0][0] = grdvar_nug[grow - 1][jcol - 1][jtime - 1][0];
      varmod_sill[0][0] =  grdvar_sill[grow - 1][jcol - 1][jtime - 1][0];
      varmod_range[0][0][0] =
         grdvar_rnge[grow - 1][jcol - 1][jtime - 1][0][0];
      varmod_range[0][1][0] =
	 grdvar_rnge[grow - 1][jcol - 1][jtime - 1][1][0];
      varmod_radius[0] = grdvar_radius;

      /* Call routine to find old plus new sites within the cylinder of the
         same radius as before sites were added.  The size of the kriging
         system will increase, essentially guaranteeing a reduction in
         the mean kriging variance. */

      Mvsrch.mvsrch_(option, xcord, ycord, tmecord);

      /* Find the kriging variance with existing AND new sites, do not
         compute an estimate, use the one stored in grdvar. */

      krgvcalc = true;
   }

} else if (option == 3) {
   retval = Estimate.estimate_(option, xcord, ycord, tmecord);
   if (retval == 1 || retval == 2) {
      iderr_("predict: option= 3 and estimate= " + retval);
   }
}

if (iblank == 2 || iblank == 3) {
   assign_(jrow, jcol, jtime, xcord, ycord, tmecord, option);
   return;
}

// Return if only model parameters are being estimated.

if (spacetime_option == 6) {
   Stwrite.stwrite_(jrow, jcol, jtime, xcord, ycord, tmecord, option, true);
   return;
}

// --------------------- Prediction Computation ------------------------

if (nmstmixcntr > 0) {

   // For a kernel global model, use only local sites for prediction.

   Estimate.local = true;
   Mvsrch.mvsrch_(option, xcord, ycord, tmecord);
   Estimate.local = false;

   if (!trnsfrm) {

      /* If no transformation, compute residuals and place in vardat_dat.
         This is necessary because the residuals are are not computed
         in "krgest_" and the call to "mvsrch_" above, loaded raw data
         into vardat_dat.  On the other hand, if (trnsfrm), the residuals
         are computed inside "mcpredict_." */

      for (i = 0; i < nd; ++i) {
	 stnm = idtostnm[vardat_vrble[i] - 1];
         Trendeval.mixtrend_(true, 0, vardat_x[i], vardat_y[i],
            vardat_t[i], vardat_quantval[i], vardat_qualval[i],
            stnm, trend);
         vardat_trend[i] = trend[stnm - 1];
         vardat_dat[i] = vardat_obs[i] - vardat_trend[i];
      }
   }
}

if (!trnsfrm) {

   /* No transformation.  Compute linear predictor (residual cokriging).
      First, form "A" matrix and solve kriging system.  At each step, check
      for ill-conditioned matrix and/or equivalently, negative kriging
      variance. */

   iblank = Krg.krgsys_(xcord, ycord, tmecord);

   if (iblank != 0) {
      iderr_("predict: krgsys return= " + iblank);
   }

   // Solve (co)kriging system.

   iblank = Eqslv.eqslvu_();

   if (iblank != 0) {
      iderr_("predict: eqslvu return= " + iblank);
   } 

   /* Compute kriging predictions and 95% C.I. width (var) from the kriging
      variance. */
 
   iblank = Krg.krgest_(threadnm, xcord, ycord, tmecord);

   if (iblank != 0) {
      iderr_("predict: krgest return= " + iblank);
   } 

} else {

/*
grdvar_rparm[0][0] = 1.;
grdvar_rparm[1][0] = 1.;
varmod_nugget[0][0] = 0.0001;
varmod_sill[0][0] = 1.;
varmod_range[0][0][0] = 1.0; // was 1.5
varmod_range[0][1][0] = 0.;
varmod_nugget[0][1] = 0.0001;
varmod_sill[0][1] = 1.;
varmod_range[0][0][1] = 1.0;
varmod_range[0][1][1] = 0.;
varmod_nugget[0][2] = 0.00001;
varmod_sill[0][2] = .7;
varmod_range[0][0][2] = .9;
varmod_range[0][1][2] = 0.;
*/

   /* Transformation.

      First, approximate the conditional expected value with Monte Carlo. */

   if (parm_mvar == 1) {
      Mcpredict.mcpredict_(true, xcord, ycord, tmecord, prdest);

   } else {

      // Initialize GLOMAP component counter.

      if (nmstmixcntr == 0) {
	 cntrstrt = 0;
      
      } else {
	 cntrstrt = 1;
      }

      for (i = 1; i < parm_mvar; ++i) {
         for (j = 0; j < i; ++j) {
            cvstrct = crossmap[i][j];
	    for (cntr = cntrstrt; cntr <= nmstmixcntr; ++cntr) {
               orgsill[cvstrct - 1][cntr] =
                  varmod_sill[cntr][cvstrct - 1];
               orgodd[cvstrct - 1][cntr] =
                  varmod_oddsill[cntr][cvstrct - 1];
	    }
         }
      }
      for (l = 0; l < 11; ++l) {
         if (Mcpredict.mcpredict_(true, xcord, ycord, tmecord,
	    prdest) == 0) {
	    break;
         }
         for (i = 1; i < parm_mvar; ++i) {
            for (j = 0; j < i; ++j) {
               cvstrct = crossmap[i][j];
	       for (cntr = cntrstrt; cntr <= nmstmixcntr; ++cntr) {
		  varmod_nugget[cntr][cvstrct - 1] = 0.;
                  varmod_sill[cntr][cvstrct - 1] -=
                     orgsill[cvstrct - 1][cntr] / 10.;
		  varmod_sill[cntr][cvstrct - 1] =
		     Math.max(varmod_sill[cntr][cvstrct - 1], 0.);

                  varmod_oddsill[cntr][cvstrct - 1] -=
                     orgodd[cvstrct - 1][cntr] / 10.;
		  varmod_oddsill[cntr][cvstrct - 1] =
		     Math.max(varmod_oddsill[cntr][cvstrct - 1], 0.);
	       }
            }
         }
      }
      if (l >= 11) {
         Covmodl.covprt_(1);
         iderr_("predict: mcpredict loop, l= " + l);
      }
   }

   // Monte Carlo approximation of the standard error of prediction.

   if (parm_mvar == 1 && iblank == 0) {
      retval = Mcpredict.mcstderr_(xcord, ycord, tmecord, krgvar);
      if (retval != 0) {
	 iderr_("predict: stderr= " + retval);
      }

   } else if (parm_mvar > 1 && iblank == 0) {
      for (i = 1; i < parm_mvar; ++i) {
         for (j = 0; j < i; ++j) {
            cvstrct = crossmap[i][j];
	    for (cntr = cntrstrt; cntr <= nmstmixcntr; ++cntr) {
               orgsill[cvstrct - 1][cntr] =
                  varmod_sill[cntr][cvstrct - 1];
               orgodd[cvstrct - 1][cntr] =
                  varmod_oddsill[cntr][cvstrct - 1];
	    }
         }
      }
      for (l = 0; l < 11; ++l) {
         if (Mcpredict.mcstderr_(xcord, ycord, tmecord, krgvar) == 0) {
	    break;
	 }
         for (i = 1; i < parm_mvar; ++i) {
            for (j = 0; j < i; ++j) {
               cvstrct = crossmap[i][j];
	       for (cntr = cntrstrt; cntr <= nmstmixcntr; ++cntr) {
		  varmod_nugget[cntr][cvstrct - 1] = 0.;
                  varmod_sill[cntr][cvstrct - 1] -=
                     orgsill[cvstrct - 1][cntr] / 10.;
		  varmod_sill[cntr][cvstrct - 1] =
		     Math.max(varmod_sill[cntr][cvstrct - 1], 0.);

                  varmod_oddsill[cntr][cvstrct - 1] -=
                     orgodd[cvstrct - 1][cntr] / 10.;
		  varmod_oddsill[cntr][cvstrct - 1] =
		     Math.max(varmod_oddsill[cntr][cvstrct - 1], 0.);
	       }
            }
         }
      }
      if (l >= 11) {
         Covmodl.covprt_(1);
         iderr_("predict: mcstderr fix-up loop, l= " + l);
      }
   }
}

// Assign default values.

assign_(jrow, jcol, jtime, xcord, ycord, tmecord, option);
}

// ---------------------------------------------------------------------

static void assign_(int jrow, int jcol, int jtime, double xcord,
   double ycord, double tmecord, int option) {

/* Set blanking values, use last good estimate if kriging failed due to
   point search, matrix condition, or high variance. */
 
if (iblank == 0) {
   ++nmest;

} else if (iblank == 1 || iblank == 4) {
   cond = 0.;

} else if (iblank == 5) {
   ++nmest;
   cond = 0.;
}

// If cross-validating, turn observation back on.

if (icrval == 1) {
   dat2_vrble[1][idatcr - 1] = vsave;
}

// Write to output file.

Stwrite.stwrite_(jrow, jcol, jtime, xcord, ycord, tmecord, option, false);
// iderr_("in assign");

}
}
