import java.sql.*;
import org.apache.derby.jdbc.EmbeddedDriver;
import java.util.*;

public class PolEcolDB extends Storyparse {
static String dbname = "none", command1 = "none", command2 = "none",
   command3 = "none", command4 = "none", query = "none";
static final int NMSENCHARS = 10 * NMWRDS;

// ------------------------------------------------------------------

public static void runDB_() {

PolEcolDB e = new PolEcolDB();
e.maintainDB_();
}

// ------------------------------------------------------------------

public void maintainDB_() {

/* Define the political-ecological database.  Note that Derby does
   not have a "drop database"
   command so to replace an existing database, you need to remove its
   directory with the command-line command:
       rmdir /s /q polecol
   Also, "load data" is a MySQL command that derby does not recognize.
   Instead, one could use "call syscs_util.syscal_import_table"
 
   1. Have Storyparse write files of everything needed to build the
      database.

   2. This method will read these files and build the database and/or
      execute queries to it.
*/

Connection conn = null;

PreparedStatement psemat, psematvrb, psematdoph, psematpph,
   psematvrbemat, psematdophemat, psematpphemat,
   psstory, pssen, psnph, psnphsen, psmwvrb, psmwvrbsen,
   psdoph, psdophsen, pspph, pspphsen;

Statement stmt;

ResultSet rs = null;

Properties props;

String dbloc, newdb, dumstrng, dumstrng1, dumstrng2, dumstrng3, updt,
   emattable, ematvrbtable, ematvrbemattable,
   ematdophtable, ematdophemattable,
   ematpphtable, ematpphemattable,
   storytable, sentable,
   nphtable, nphsentable,
   mwvrbtable, mwvrbsentable,
   dophtable, dophsentable,
   pphtable, pphsentable;

String uniquevrb[] = new String[NMWRDS];
String uniquedoph[] = new String[NMWRDS];
String uniquepph[] = new String[NMWRDS];

int i, j, k, storyid = 0, nmsens, senid = 0, nmnphs = 0, nmmwvrbs = 0,
   nmdophs = 0, nmpphs = 0, storysen = 0, dumint = 0, nmwrds = 0,
   nmuniquevrb = 0, nmuniquedoph = 0, nmuniquepph = 0, ematvrbid = 0,
   ematdophid = 0, ematpphid = 0, vrbuid = 1, dophuid = 1, pphuid = 1,
   nmrscols = 0, dumid1 = 0, dumid2 = 0;

double dumdate = 0., bestvrbval = 0., bestobjval = 0., bestpphval = 0.,
   simscore = 0.;

dbloc = "jdbc:derby:" + dbname;

if (dboption.equals("build")) {
   newdb = "true";
   printf_("maintainDB: drop database with rmdir /s /q polecol\n" +
      "   Do this by running dbrun.bat");

} else {
   newdb = "false";
}

props = new Properties();
props.put("create", newdb);

/* Definitions of database tables.
   Note 1: Storyaction.findactpttrn_() searches within a sentence for
   a matching combination of m-word verb, direct object phrase, and
   (optionally) a prepositional phrase.  Hence, each such n-gram will
   be attached to a particular sentence.  But findactpttrn_() is called
   twice because there may be more than one action in a sentence.
   Hence, there is a many-to-many relationship between sentences and
   noun phrases.  A junction table is needed.  This applies to m-word
   verbs, direct object phrases, and prepositional phrases.
   
   Note 2: Noun phrases refer to archetypal actors and targets.

   Note 3: If an m-word verb does not match any EMAT m-word verb,
   assign it to ematvrbid=1 which is the EMAT m-word verb "no_match".
   This applies to direct object phrases, and prepositional phrases also. */

// ---------------- EMAT definitions tables. ------------------

emattable = "create table emat ("
   + "ematid varchar(10) not null primary key, action varchar(80))";

ematvrbtable = "create table ematvrb ("
   + "vrbuid int not null generated always as identity (start with 1, "
   + "increment by 1) primary key, ematid varchar(10) not null, "
   + "ematvrbid int not null, ematvrb varchar(80), "
   + "foreign key (ematid) references emat (ematid) on delete cascade)";

ematvrbemattable = "create table ematvrbemat ("
   + "ematid varchar(10) not null, vrbuid int not null, "
   + "constraint ematvrbemat_pk primary key (ematid, vrbuid), "
   + "foreign key (ematid) references emat (ematid) on delete no action, "
   + "foreign key (vrbuid) references ematvrb (vrbuid) "
   + "on delete cascade)";

ematdophtable = "create table ematdoph ("
   + "dophuid int not null generated always as identity (start with 1, "
   + "increment by 1) primary key, ematid varchar(10) not null, "
   + "ematdophid int not null, ematdoph varchar(80), "
   + "foreign key (ematid) references emat (ematid) on delete cascade)";

ematdophemattable = "create table ematdophemat ("
   + "ematid varchar(10) not null, dophuid int not null, "
   + "constraint ematdophemat_pk primary key (ematid, dophuid), "
   + "foreign key (ematid) references emat (ematid) on delete no action, "
   + "foreign key (dophuid) references ematdoph (dophuid) "
   + "on delete cascade)";

ematpphtable = "create table ematpph ("
   + "pphuid int not null generated always as identity (start with 1, "
   + "increment by 1) primary key, ematid varchar(10) not null, "
   + "ematpphid int not null, ematpph varchar(80), "
   + "foreign key (ematid) references emat (ematid) on delete cascade)";

ematpphemattable = "create table ematpphemat ("
   + "ematid varchar(10) not null, pphuid int not null, "
   + "constraint ematpphemat_pk primary key (ematid, pphuid), "
   + "foreign key (ematid) references emat (ematid) on delete no action, "
   + "foreign key (pphuid) references ematpph (pphuid) "
   + "on delete cascade)";

// ---------------- Observed actions tables. --------------------
 
storytable = "create table story ("
   + "storyid int not null generated always as identity (start with 1, "
   + "increment by 1) primary key, storydate float not null, "
   + "source varchar(40), country varchar(40) not null)";

sentable = "create table sen ("
   + "storyid integer not null, "
   + "senid int not null generated always as identity (start with 1, "
   + "increment by 1) primary key, "
   + "foreign key (storyid) references story (storyid) on delete cascade)";

nphtable = "create table nph ("
   + "nphid int not null generated always as identity (start with 1, "
   + "increment by 1) primary key, nph varchar(" + NMSENCHARS + "))";

nphsentable = "create table nphsen ("
   + "nphid int not null, senid int not null, "
   + "constraint nphsen_pk primary key (nphid, senid), "
   + "foreign key (nphid) references nph (nphid) on delete no action, "
   + "foreign key (senid) references sen (senid) on delete cascade)";

mwvrbtable = "create table mwvrb ("
   + "senvrbid int not null generated always as identity (start with 1, "
   + "increment by 1) primary key, vrbuid int not null default 1, "
   + "ematvrbid int not null default 1, mwvrb varchar(" + NMSENCHARS + "), "
   + "foreign key (vrbuid) references ematvrb (vrbuid) "
   + "on delete cascade)";

mwvrbsentable = "create table mwvrbsen ("
   + "senvrbid int not null, senid int not null, "
   + "constraint mwvrbsen_pk primary key (senvrbid, senid), "
   + "foreign key (senvrbid) references mwvrb (senvrbid) on delete no action, "
   + "foreign key (senid) references sen (senid) on delete cascade)";

dophtable = "create table doph ("
   + "sendophid int not null generated always as identity (start with 1, "
   + "increment by 1) primary key, dophuid int not null default 1, "
   + "ematdophid int not null default 1, doph varchar(" + NMSENCHARS + "), "
   + "foreign key (dophuid) references ematdoph (dophuid) "
   + "on delete cascade)";

dophsentable = "create table dophsen ("
   + "sendophid int not null, senid int not null, "
   + "constraint dophsen_pk primary key (sendophid, senid), "
   + "foreign key (sendophid) references doph (sendophid) on delete no action, "
   + "foreign key (senid) references sen (senid) on delete cascade)";

pphtable = "create table pph ("
   + "senpphid int not null generated always as identity (start with 1, "
   + "increment by 1) primary key, pphuid int not null default 1, "
   + "ematpphid int not null default 1, pph varchar(" + NMSENCHARS + "), "
   + "foreign key (pphuid) references ematpph (pphuid) "
   + "on delete cascade)";

pphsentable = "create table pphsen ("
   + "senpphid int not null, senid int not null, "
   + "constraint pphsen_pk primary key (senpphid, senid), "
   + "foreign key (senpphid) references pph (senpphid) on delete no action, "
   + "foreign key (senid) references sen (senid) on delete cascade)";

// Create or open the database.

try {
Driver derbyEmbeddedDriver = new EmbeddedDriver();
DriverManager.registerDriver(derbyEmbeddedDriver);
conn = DriverManager.getConnection(dbloc, props);
conn.setAutoCommit(false);
stmt = conn.createStatement();

if (newdb.equals("true")) {
   stmt.execute(emattable);
   stmt.execute(ematvrbtable);
   stmt.execute(ematvrbemattable);
   stmt.execute(ematdophtable);
   stmt.execute(ematdophemattable);
   stmt.execute(ematpphtable);
   stmt.execute(ematpphemattable);

   stmt.execute(storytable);
   stmt.execute(sentable);
   stmt.execute(nphtable);
   stmt.execute(nphsentable);
   stmt.execute(mwvrbtable);
   stmt.execute(mwvrbsentable);
   stmt.execute(dophtable);
   stmt.execute(dophsentable);
   stmt.execute(pphtable);
   stmt.execute(pphsentable);
}

// Read the EMAT and load its actions table.

Storyutils.readematfle_();
printf_("maintainDB: nmematcodes= " + nmematcodes);

psemat = conn.prepareStatement(
   "insert into emat (ematid, action) values(?, ?)");
for (i = 0; i < nmematcodes; ++i) {

   /*
   printf_("maintainDB: ematcode= " + ematcode[i] + " emataction= " +
      emataction[i]);
   */

   psemat.setString(1, ematcode[i]);
   psemat.setString(2, emataction[i]);
   psemat.executeUpdate();
}

/* Read file of parsed EMAT entries and load associated tables.  This
   file contains parsed EMAT actions.  This is
   NOT a data file of observed actions.  The name of this file, stored in
   "parsedematactsfle" is read in the "EMAT_file" section of Getmodl.java.
   The name of the file of parsed stories (observed actions), stored in
   "parsedstoriesfle" has been read in the "rdbms" section of Getmodl.java. */

Storyutils.readparsedematacts_();
printf_("maintainDB: nmematcodes= " + nmematcodes);

psematvrb = conn.prepareStatement(
   "insert into ematvrb (ematid, ematvrbid, ematvrb) values(?, ?, ?)");
psematvrbemat = conn.prepareStatement(
   "insert into ematvrbemat (ematid, vrbuid) values(?, ?)");

psematdoph = conn.prepareStatement(
   "insert into ematdoph (ematid, ematdophid, ematdoph) values(?, ?, ?)");
psematdophemat = conn.prepareStatement(
   "insert into ematdophemat (ematid, dophuid) values(?, ?)");

psematpph = conn.prepareStatement(
   "insert into ematpph (ematid, ematpphid, ematpph) values(?, ?, ?)");
psematpphemat = conn.prepareStatement(
   "insert into ematpphemat (ematid, pphuid) values(?, ?)");

for (i = 0; i < nmematcodes; ++i) {

   // Load EMAT verb tables.

   for (j = 0; j < nmmwverbs[i]; ++j) {
      nmwrds = mwverbnmwrds[i][j];
      dumstrng = ematmwverb[i][j][0];
      for (k = 1; k < nmwrds; ++k) {
         dumstrng += " " + ematmwverb[i][j][k];
      }
      psematvrb.setString(1, ematid[i]);

      // Assign an ID value to each unique m-word verb.

      ematvrbid = 0;
      for (k = 0; k < nmuniquevrb; ++k) {
         if (dumstrng.equals(uniquevrb[k])) {
            ematvrbid = k + 1;
	    break;
	 }
      }
      if (ematvrbid == 0) {
         uniquevrb[nmuniquevrb] = dumstrng;
	 ++nmuniquevrb;
	 ematvrbid = nmuniquevrb;
      }

      psematvrb.setString(2, Integer.toString(ematvrbid));
      psematvrb.setString(3, dumstrng);
      psematvrb.executeUpdate();

      // Load emat verb-to-emat junction table.

      psematvrbemat.setString(1, ematid[i]);
      psematvrbemat.setString(2, Integer.toString(vrbuid));
      psematvrbemat.executeUpdate();

      ++vrbuid;
   }

   // Load EMAT direct object phrase tables.
   
   for (j = 0; j < nmdirobjs[i]; ++j) {
      nmwrds = dirobjnmwrds[i][j];
      dumstrng = ematdirobj[i][j][0];
      for (k = 1; k < nmwrds; ++k) {
         dumstrng += " " + ematdirobj[i][j][k];
      }
      psematdoph.setString(1, ematid[i]);

      // Assign an ID value to each unique direct object phrase (doph).

      ematdophid = 0;
      for (k = 0; k < nmuniquedoph; ++k) {
         if (dumstrng.equals(uniquedoph[k])) {
            ematdophid = k + 1;
	    break;
	 }
      }
      if (ematdophid == 0) {
         uniquedoph[nmuniquedoph] = dumstrng;
	 ++nmuniquedoph;
	 ematdophid = nmuniquedoph;
      }

      psematdoph.setString(2, Integer.toString(ematdophid));
      psematdoph.setString(3, dumstrng);
      psematdoph.executeUpdate();

      // Load emat doph-to-emat junction table.

      psematdophemat.setString(1, ematid[i]);
      psematdophemat.setString(2, Integer.toString(dophuid));
      psematdophemat.executeUpdate();

      ++dophuid;
   }
   
   // Load EMAT prepositional phrase (pph) tables.

   for (j = 0; j < nmprepobjs[i]; ++j) {
      nmwrds = prepobjnmwrds[i][j];
      dumstrng = ematprepobj[i][j][0];
      for (k = 1; k < nmwrds; ++k) {
         dumstrng += " " + ematprepobj[i][j][k];
      }
      psematpph.setString(1, ematid[i]);

      // Assign an ID value to each unique pph.

      ematpphid = 0;
      for (k = 0; k < nmuniquepph; ++k) {
         if (dumstrng.equals(uniquepph[k])) {
            ematpphid = k + 1;
	    break;
	 }
      }
      if (ematpphid == 0) {
         uniquepph[nmuniquepph] = dumstrng;
	 ++nmuniquepph;
	 ematpphid = nmuniquepph;
      }

      psematpph.setString(2, Integer.toString(ematpphid));
      psematpph.setString(3, dumstrng);
      psematpph.executeUpdate();

      // Load emat pph-to-emat junction table.

      psematpphemat.setString(1, ematid[i]);
      psematpphemat.setString(2, Integer.toString(pphuid));
      psematpphemat.executeUpdate();

      ++pphuid;
   }
   
}

/* -------------- Read action observations into the database -------------

   Read the previously-parsed stories into the database.
   This method (maintainDB_()) was developed using
   parsedstoriesfle = "parsedjavadbdev.txt" located in polbio/sanparks. */

fleopen_(3, parsedstoriesfle[0], 'r');

psstory = conn.prepareStatement(
   "insert into story (storydate, source, country) values(?, ?, ?)");
pssen = conn.prepareStatement(
   "insert into sen (storyid) values(?)");

psnph = conn.prepareStatement(
   "insert into nph (nph) values(?)");
psnphsen = conn.prepareStatement(
   "insert into nphsen (senid, nphid) values(?, ?)");

psmwvrb = conn.prepareStatement(
   "insert into mwvrb (mwvrb) values(?)");
psmwvrbsen = conn.prepareStatement(
   "insert into mwvrbsen (senid, senvrbid) values(?, ?)");

psdoph = conn.prepareStatement(
   "insert into doph (doph) values(?)");
psdophsen = conn.prepareStatement(
   "insert into dophsen (senid, sendophid) values(?, ?)");

pspph = conn.prepareStatement(
   "insert into pph (pph) values(?)");
pspphsen = conn.prepareStatement(
   "insert into pphsen (senid, senpphid) values(?, ?)");

STRYLOOP: for (;;) {

   if (checkeof_(3) || storyid > 100000) {
      break STRYLOOP;
   }

   dumstrng = fgetstrng_(3);
   if (!dumstrng.equals("articleid")) {
      iderr_("maintainDB: dumstrng= " + dumstrng + " should be articleid");
   }
 
   /* Read and throw away the bogus storyid value.  Then, read the story's
      date, source, country, and number of sentences in this story. */

   dumid1 = fgetint_(3);
   dumdate = fgetdble_(3);
   dumstrng1 = fgetstrng_(3);
   dumstrng2 = fgetstrng_(3);
   nmsens = fgetint_(3);

   printf_("maintainDB: articleid= " + dumid1 + " dumdate= " + dumdate +
      " dumstrng1= " + dumstrng1 + " nmsens= " + nmsens);

   /* Enter storydate, source, country, and assign storyid.  Note that
      javadb float is equivalent to java's double. */

   if (nmsens > 0) {
      psstory.setFloat(1, ((float) dumdate));
      psstory.setString(2, dumstrng1);
      psstory.setString(3, dumstrng2);
      psstory.executeUpdate();
      rs = stmt.executeQuery("values identity_val_local()");
      rs.next();
      storyid = rs.getInt(1);
   }

   // Load sentence m-grams from each of these sentences.

   for (storysen = 1; storysen <= nmsens; ++storysen) {
      pssen.setString(1, Integer.toString(storyid));
      pssen.executeUpdate();

      // Get this sentence's unique identifier value.

      rs = stmt.executeQuery("values identity_val_local()");
      rs.next();
      senid = rs.getInt(1);

      // Read the number of each component present in this sentence.

      nmnphs = fgetint_(3);
      nmmwvrbs = fgetint_(3);
      nmdophs = fgetint_(3);
      nmpphs = fgetint_(3);

      bestvrbval = fgetdble_(3);
      bestobjval = fgetdble_(3);
      bestpphval = fgetdble_(3);

      simscore = bestvrbval + bestobjval + bestpphval;
      if (simscore < 1.9) {
         continue;
      }

      // Noun phrases.
      
      for (j = 1; j <= nmnphs; ++j) {
	 dumstrng = fgetline_(3);
         psnph.setString(1, dumstrng.toLowerCase());
         psnph.executeUpdate();

	 rs = stmt.executeQuery("values identity_val_local()");
         rs.next();
	 dumint = rs.getInt(1);

         psnphsen.setString(1, Integer.toString(senid));
         psnphsen.setString(2, Integer.toString(dumint));
         psnphsen.executeUpdate();
      }
      
      // m-word verbs.
      
      for (j = 1; j <= nmmwvrbs; ++j) {
	 dumstrng = fgetline_(3);
	 // printf_("maintainDB: mwv j= " + j + " dumstrng= " + dumstrng);
         psmwvrb.setString(1, dumstrng.toLowerCase());
         psmwvrb.executeUpdate();

	 rs = stmt.executeQuery("values identity_val_local()");
         rs.next();
	 dumint = rs.getInt(1);

         psmwvrbsen.setString(1, Integer.toString(senid));
         psmwvrbsen.setString(2, Integer.toString(dumint));
         psmwvrbsen.executeUpdate();
      }
      
      // Direct object phrases.
      
      for (j = 1; j <= nmdophs; ++j) {
	 dumstrng = fgetline_(3);
         psdoph.setString(1, dumstrng.toLowerCase());
         psdoph.executeUpdate();

	 rs = stmt.executeQuery("values identity_val_local()");
         rs.next();
	 dumint = rs.getInt(1);

	 /*
	 printf_("sen= " + i + " j= " + j + " dumint= " + dumint +
            " doph= " + dumstrng);
         */

         psdophsen.setString(1, Integer.toString(senid));
         psdophsen.setString(2, Integer.toString(dumint));
         psdophsen.executeUpdate();
      }
      
      // Prepositional phrases.
      
      for (j = 1; j <= nmpphs; ++j) {
	 dumstrng = fgetline_(3);
         pspph.setString(1, dumstrng.toLowerCase());
         pspph.executeUpdate();

	 rs = stmt.executeQuery("values identity_val_local()");
         rs.next();
	 dumint = rs.getInt(1);

         pspphsen.setString(1, Integer.toString(senid));
         pspphsen.setString(2, Integer.toString(dumint));
         pspphsen.executeUpdate();
      }
   }
}
fclose_(3, 'r');

printf_("maintainDB: final storyid= " + storyid);

/* Update the mwvrb, doph, and pph tables to link them to the
   ematvrb, ematdoph, and ematpph tables, respectively. */

updt = "update mwvrb set ematvrbid = (select distinct ematvrbid from ematvrb "
   + " where mwvrb.mwvrb = ematvrb.ematvrb) where exists "
   + " (select distinct * from ematvrb where mwvrb.mwvrb = ematvrb.ematvrb)";
stmt.execute(updt);

updt = "update doph set ematdophid = (select distinct ematdophid from ematdoph "
   + " where doph.doph = ematdoph.ematdoph) where exists "
   + " (select distinct * from ematdoph where doph.doph = ematdoph.ematdoph)";
stmt.execute(updt);

updt = "update pph set ematpphid = (select distinct ematpphid from ematpph "
   + " where pph.pph = ematpph.ematpph) where exists "
   + " (select distinct * from ematpph where pph.pph = ematpph.ematpph)";
stmt.execute(updt);

// Create indices simply to speed up queries.

dumstrng = "CREATE INDEX doph_idx_doph ON doph (doph)";
stmt.execute(dumstrng);
dumstrng = " CREATE INDEX doph_idx_sendophid ON doph (sendophid)";
stmt.execute(dumstrng);
dumstrng = " CREATE INDEX idx_action ON emat (action)";
stmt.execute(dumstrng);
dumstrng = " CREATE INDEX ematdoph_idx_ematdoph ON ematdoph (ematdoph)";
stmt.execute(dumstrng);
dumstrng = " CREATE INDEX ematvrb_idx_ematvrb ON ematvrb (ematvrb)";
stmt.execute(dumstrng);
dumstrng = " CREATE INDEX mwvrb_idx_mwvrb ON mwvrb (mwvrb)";
stmt.execute(dumstrng);
dumstrng = " CREATE INDEX mwvrb_idx_senvrbid ON mwvrb (senvrbid)";
stmt.execute(dumstrng);
dumstrng = " CREATE INDEX sen_idx_senid ON sen (senid)";
stmt.execute(dumstrng);
dumstrng = " CREATE INDEX story_idx_storyid ON story (storyid)";
stmt.execute(dumstrng);

// Dump tables.
/*
rs = stmt.executeQuery("select * from mwvrb");
printquery_(rs);
rs = stmt.executeQuery("select * from doph");
printquery_(rs);
*/

// Execute four setup commands.

printf_("maintainDB: beginning command1 execution.");
stmt.execute(command1);

printf_("maintainDB: beginning command2 execution.");
stmt.execute(command2);

// Show indexes (doesn't work).
//rs = stmt.executeQuery("show indexes from session.v");
//printquery_(rs);

// Dump temporary table.
//rs = stmt.executeQuery("select * from session.v");
//printquery_(rs);

printf_("maintainDB: beginning command3 execution.");
stmt.execute(command3);

printf_("maintainDB: beginning command4 execution.");
stmt.execute(command4);

// Dump temporary table.
//rs = stmt.executeQuery("select * from session.d");
//printquery_(rs);

// Execute a query from the database.

printf_("maintainDB: beginning query execution.");

rs = stmt.executeQuery(query);
printquery_(rs);
stmt.close();

conn.commit();

} catch (SQLException ex) {
System.out.println("in connection" + ex);
}

// Shutdown the database.

printf_("maintainDB: query completed, shutting down database.");

try {
DriverManager.getConnection ("jdbc:derby:;shutdown=true");
} catch (SQLException ex) {
if (((ex.getErrorCode() == 50000) && ("XJ015".equals(ex.getSQLState())))) {
   printf_("Derby shut down normally");

} else {
   System.err.println("Derby did not shut down normally");
   System.err.println(ex.getMessage());
}
}
}

// -----------------------------------------------------------------------

static void printquery_(ResultSet rs) {

// Prints query results.

String dumstrng;

int i, nmrscols;

try {
ResultSetMetaData rsmdat = rs.getMetaData();
nmrscols = rsmdat.getColumnCount();
dumstrng = rsmdat.getColumnName(1);
for (i = 2; i <= nmrscols; ++i) {
   dumstrng += " " + rsmdat.getColumnName(i);
}
printf_(" " + dumstrng);
while (rs.next()) {
   dumstrng = " " + rs.getString(1);
   for (i = 2; i <= nmrscols; ++i) {
      dumstrng += " " + rs.getString(i);
   }
   printf_(dumstrng);
}
} catch (SQLException ex) {
printf_("in printquery");
}
}
/* This query removes duplicate rows.
updt = "delete from mwvrb v1 where v1.senvrbid > "
   + "(select min(v2.senvrbid) from mwvrb v2 where v1.mwvrb = v2.mwvrb)";
stmt.execute(updt);
*/
}
