class Pltnrm extends Surf {
static char singsym[] = new char[DATSZE];

static String legendlbl[] = new String[TNMVALS];
static String plottitle[] = new String[2];
static String nomlab2[] = new String[2];

static int indx[] = new int[DATSZE];
static int linetype[] = new int[TNMVALS];

static double x[] = new double[DATSZE];
static double xabs[] = new double[DATSZE];
static double zscore[] = new double[DATSZE];
static float singleton[][] = new float[DATSZE][2];
static double bars[] = new double[10];

// ---------------------------------------------------------------------

static void pltnrm_() {

/* Writes a device independent graphics file of the normal and half-normal
   plot of the vector x which has n values. */

int i, j, n = 1, tval;

double rn = 0., mean, mindat, maxdat, ressqr, resstd, ksstat, cdfdif,
   empcdf, xval, incrmnt, m, dmax, pval, sfstat, kstd = 0.;

fprintf_(1, "\npltnrm: ------------ Normality Checks ----------------");

// Open standardized residuals file.

fleopen_(3, "stdres.plt", 'r');

// Read in the standardized residuals and also store the absolute values.

i = 0;
while (checkeof_(3) != true) {
   fgetint_(3);
   fgetdble_(3);
   fgetdble_(3);
   fgetdble_(3);
   kstd = fgetdble_(3);
   x[i] = fgetdble_(3);
   indx[i] = i;
   xabs[i] = Math.abs(x[i]);

   if (kstd == .001) {
      continue;
   }

   ++i;

   // Bounds check.

   if (i > DATSZE) iderr_("out-of-bounds in pltnrm_()");
}
fclose_(3, 'r');
n = i;

// First, sort the x values.

Idsort.idsort_(x, indx, 1, n);

// Trim the data set tval at both ends.

tval = 0;
n = n - 2 * tval;
if (n < 2) iderr_("pltnrm: n= " + n);
rn = (double) n;
if (tval > 0) {
   for (i = 0; i < n; ++i) x[i] = x[i + tval];
}

// Find the n zscores using the corrected formula in Blom (1958).

zscores_(n, zscore);

/* Find the mean and standard deviation of the data.  Fill the
   plotting array. */

mean = 0.;
ressqr = 0.;
for (i = 0; i < n; ++i) {
   mean += x[i];
   ressqr += x[i] * x[i];
   singleton[i][0] = (float) zscore[i];
   singleton[i][1] = (float) x[i];
   singsym[i] = '*';
}
mean /= rn;
resstd = (ressqr - (rn * mean * mean)) / (rn - 1.);
resstd = Math.sqrt(resstd);
fprintf_(1, "N= " + n + " Mean= " + mean + " Std. Dev.= " + resstd);

// Set data minimum, maximum.

maxdat = x[n - 1];
if (maxdat < Math.abs(x[0])) maxdat = Math.abs(x[0]);
mindat = -maxdat;

/* Compute the Kolmogorov test statistic by searching for the maximum
   of |F_std.norm.(x) - F_empirical(x)| over 1000 x values between
   2 * mindat and 2 * maxdat. */

incrmnt = (2. * maxdat - 2. * mindat) / 100.;
ksstat = 0.;
xval = 2. * mindat;
for (i = 1; i <= 100; ++i) {

   /* Compute the empirical CDF value.  First find the number of
      observations that are less than or equal to xval. */

   j = 0;
   while(x[j] <= xval) {
      ++j;
      if (j == n) break;
   }
   empcdf = ((double) (j)) / rn;

   // Find CDF difference and search for maximum.

   cdfdif = Math.abs(cump_(xval) - empcdf);
   if (ksstat < cdfdif) ksstat = cdfdif;

   xval += incrmnt;
}
fprintf_(1, "Kolmogorov test statistic = " + ksstat);

// Compute approximate p-value.

if (n < 100) {
   m = (double) n;
   dmax = ksstat;

} else {
   m = 100.;
   dmax = ksstat * Math.pow(m / 100., .49);
}
pval = Math.exp(-7.01256 * dmax * dmax * (m + 2.78019) + 2.99587 *
   dmax * Math.sqrt(m + 2.78019) - .122119 + .974598 / Math.sqrt(m) +
   1.67997 / m);
if (pval > 1.) pval = 1.;
 
fprintf_(1, "Approximate p-value= " + pval);
fprintf_(1, "(from Dallal and Wilkinson (1986), The American" +
   " Statistician,\n40(4): 294-296)");

// Compute the Shapiro and Francia normality test statistic.

sfstat = shapfran_(n, x, mean);
fprintf_(1, "\nShapiro-Francia normality test statistic= " + sfstat);
pval = sfpvalue_(n, sfstat);
fprintf_(1, "p-value= " + pval);

// Open and write out.dig file.

fleopen_(4, "out.dig", 'w');

plottitle[0] = "Normal_Q-Q_Plot";
plottitle[1] = null;
Plotutils.pltscat_(4, n, singleton, singsym, 0, Displayactions.nmpts,
   Displayactions.thread_pt, Displayactions.symbol, plottitle,
   Displayactions.linelbl, "Zscore", "Sorted_std._residual", false,
   Displayactions.nomlab, 1, nomlab2, 1., .5, .01, .51, 0, bars, linetype,
   zscore[0], zscore[n - 1]);

// Compute the half-normal plot.

Idsort.idsort_(xabs, indx, 1, n);

/* Fill zscore with the n half-normal quantiles.  If X is half standard
   normal, and Z is standard normal, then P(X<x) = 2P(Z<x) - 1.  See
   Draper and Smith, 1981, p. 179. */

for (i = 0; i < n; ++i) {
   zscore[i] = icump_((((double) i) + rn + .5) / (2. * rn));
   singleton[i][0] = (float) zscore[i];
   singleton[i][1] = (float) xabs[i];
}

// Plot sorted xabs versus half normal score.

plottitle[0] = "Half-Normal_Q-Q_Plot";
plottitle[1] = null;
Plotutils.pltscat_(4, n, singleton, singsym, 0, Displayactions.nmpts,
   Displayactions.thread_pt, Displayactions.symbol, plottitle,
   Displayactions.linelbl, "Half-zscore", "Sorted_abs[std._residual]", false,
   Displayactions.nomlab, 1, nomlab2, 1., .5, .01, .001, 0, bars, linetype,
   zscore[0], zscore[n - 1]);

fclose_(4, 'w');

// Write PostScript file.

Pltpost.pltpost_("nrm.ps", 1.1); 
fprintf_(1, "PostScript Q-Q plot is written to file nrm.ps.");
}

// ---------------------------------------------------------------------

/*
main() {
int i, n;
double p;
n=10;
for(i=1; i < n; ++i) {
   p = ((double) i) / (double) n;
   gprint("icump_(%lf)=%lf\n",p,icump_(p));
}
} */

static void zscores_(int n, double zscore[]) {

// Finds the n zscores.

int i;
double rn;

rn = (double) n;
for (i = 0; i < n; ++i) {
   zscore[i] = icump_( (((double) (i + 1)) - .375) / (rn + .25) );
}
}

// --------------------------------------------------------------------

static double cump_(double x) {

// Cumulative Distribution Function (CDF) for the standard normal.

double rt = 0.7071067812;

if (x == 0.) return .5;
else if (x > 0.) return (.5 * (1. + berf(x * rt)));
else if (x < 0.) return 1. - (.5 * (1. + berf(-x * rt)));

return 0.;
}

// --------------------------------------------------------------------

static double icump_(double x) {

// Inverse CDF for the standard normal distribution from Baker, p. 139.

double rti = 1.414213562;

return(rti * (ierf( 2. * x - 1.)));
}

// ---------------------------------------------------------------------

static double berf(double x) {

/* Calculates erf function.  From Baker, L. ``More C Tools,'' McGraw-Hill,
   1991. */

double t, z;

t = 1. / (1. + x * .3275911);
z = ((((t * 1.061405429 - 1.453152027) * t + 1.421413741) *
   t - .284496736) * t + .254829592) * t;

return (1. - Math.exp(-x * x) * z);
}

// ---------------------------------------------------------------------

static double ierf(double y) {

// inverse erf function.

int i, maxi = 20;
double test, c, x, dx = 0., f, df;

if (y == 0.) return(0.);
if (y >= 1.) return (1.e10);
if (y < 0.) return (-ierf(-y));
c = 1./ Math.sqrt(Math.sqrt(1. - y));
c = Math.sqrt(Math.sqrt(c)); // for higher power version.

// guess.

x = 1.;
if (y < 1.) x = y * .7;

for (i=0; i <= maxi; i++) {
   f = (((((.0000430638 * x + .0002765672) * x + .0001520143) * x +
       .0092705272) * x + .0422820123) * x + .0705230784) * x + 1. - c;
   df = (((((6. * .0000430638 * x + 5. * .0002765672) * x + 4. *
      .0001520143) * x + 3. * .0092705272) * x + 2. * .0422820123) *
      x + .0705230784);
   dx = -f / df;
   x += dx;
   test = Math.abs(dx);
   if (test < 1.e-8 || test < .0000001*x) break;
   // gprint(" iter= %d x=%lf dx= %lf\n",i,x,dx);
}

if (i == maxi) printf_("ierf max it= " + i + " x= " + x + " dx= " + dx +
   " arg=  " + y);

return x;
}

// -----------------------------------------------------------------------

static double shapfran_(int n, double x[], double mean) {

/* Computes the Shapiro and Francia normality test statistic.
   See Shapiro and Francia, JASA (1972), v. 67, no. 337, p. 215. */

int i, nmsf = 27;

int sfsize[] = {35, 50, 51, 53, 55, 57, 59, 61, 63, 65, 67, 69, 71, 73, 75,
   77, 79, 81, 83, 85, 87, 89, 91, 93, 95, 97, 99};

double invcdf, rn, dif, sum1 = 0., sum2 = 0., sum3 = 0., retval;

double sfcrit[] = {.952, .963, .964, .964, .965, .966, .967, .968, .970,
   .971, .971, .972, .972, .973, .973, .974, .975, .975, .976, .977, .977,
   .977, .978, .979, .979, .979, .980};

if (n < 3) {
   fprintf_(1, "n<3, Shapiro-Francia test not possible");
   return -1.;
}

rn = (double) n;
for (i = 1; i <= n; ++i) {
   dif = x[i - 1] - mean;
   invcdf = icump_((((double) i) - .5) / rn);
   sum1 += dif * invcdf;
   sum2 += dif * dif;
   sum3 += invcdf * invcdf;
}
retval = (sum1 * sum1) / (sum2 * sum3);

/* For 35 < n < 100, use a column in the S-F table (JASA, '72) to
   do the test.
if (35 <= n && n <= 100) {
   for (i = 0; i < nmsf - 1; ++i) {
      if (sfsize[i] <= n && n <= sfsize[i + 1]) break;
   }
   fprintf_(1, "alpha = .1 lower-tail critical value= " + sfcrit[i]);
   if (retval < sfcrit[i]) {
      fprintf_(1, "Reject normality.\n");
   
   } else {
      fprintf_(1, "Do not reject normality.\n");
   }
}
*/

return retval;
}

// ----------------------------------------------------------------------

static double sfpvalue_(int n, double obsstat) {

// Computes the p-value of the Shapiro-Francia normality test.

int i, j, nmmcloops = 1000;

int indx[] = new int[DATSZE];

double mean = 0., statstar, nmlower = 0.;

double xstar[] = new double[DATSZE];

for (i = 0; i < nmmcloops; ++i) {
   
   // Generate a size-n sample.

   for (j = 0; j < n; ++j) {
      xstar[j] = Rndm.stdnrm_(0);
      indx[j] = j + 1;
   }

   // Compute the mean and then the order statistics.

   mean = 0.;
   for (j = 0; j < n; ++j) mean += xstar[j];
   mean /= (double) n;

   Idsort.idsort_(xstar, indx, 1, n);

   // Compute Shapiro-Francia statistic for this simulated sample.

   statstar = shapfran_(n, xstar, mean);
   if (statstar < 0.) {
      printf_("sfpvalue: p-value calculation failed.");
      return 1.;
   }

   // Count number of these statistics that are smaller than the observed.

   if (statstar < obsstat) nmlower += 1.;
}

return (nmlower / ((double) nmmcloops));
}
}
