public class Pltgrph extends Id {
static boolean draw = false;
static boolean donotdraw[] = new boolean[NMDUMNDS];

static String flename, nodetype;

static short grph_pos[][] = new short[NMDUMNDS][2];
static short hierndes[][] = new short[NMPROWS][NMPCOLS];
static short ndetrial[][] = new short[NMDUMNDS][NMDUMNDS];
static short hiermin[][] = new short[NMDUMNDS][NMDUMNDS];
static short hiermax[][] = new short[NMDUMNDS][NMDUMNDS];
static short m[][][] = new short[NMPROWS][NMPCOLS][NMPCOLS];
static short p[] = new short[NMPROWS];
static short grpsze[] = new short[5];
static short grpnde[][] = new short[5][NMPCOLS];
static int x[] = new int[20000];
static int nodnghs[][] = new int[NMDUMNDS][2 + TNMPRTS];

static int nmhierarc = 1, nsize = 0, nzero = 0, ndesum, nprows = 2,
   npcols = 2, sumlngth, oldsum, absdifflngth, oldabsdiff, maxabslngth,
   nmndegrps;

/* Description of "hierndes" array:
   dimension 1:    hierarchy level (row),
   dimension 2:    position in row (the column),
   value of array: node number that is in this row and column.

   Description of array m:
   dimension 1:    row number of parent,
   dimension 2:    column of parent,
   dimension 3:    column of child (assumed to be in the very next row),
   value of array: 0 if no link, 1 if linked.

   Possible Improvement: run 2 optimizations, in the first run, just
   minimize the number of crossings, in the second just minimize line
   length and do not allow node position reversals within a row.

   Note: only Situation root nodes are forced to all be in the same
   row (as are all Scenario root nodes).  Current thinking is that
   terminal nodes are not forced to be all on the same row since the
   plot could have too many nodes in the last row.
*/

// -----------------------------------------------------------------------

public static void pltgrph_() {

/* Writes a PostScript plotting file of the network and its connectivity.
   The format is nprows rows and npcols columns. */

boolean varnm = false, plotgrid = false, forcetwostrings = false;

char dumlabel[] = new char[LBLLTH];
char label[] = new char[STRNGLTH];
char chstrng[][] = new char[2][STRNGLTH];

int i, j, j2, srow, scol, trow, tcol, nmstrngs = 0, lbllngth, maxlngth = 1,
   nmprnts, prnt, nmwrds, xscale, llx, lly, urx, ury;

double xcor, ycor, xshift, bwidth, bheight, xsrc, ysrc, xdec, ydec, radius,
   xmax, ymax;

/* single to double precision test.

float dumm1 = 0.f, dumm2 = 2.f, dumm3 = 3.f;
// double dumm1 = 0.d, dumm2 = 2.d, dumm3 = 3.d;
for (i = 0; i < 1000; ++i) {
   for (j = 0; j < 10000000; ++j) {
      dumm1 = dumm2 * dumm3 + dumm2;
   }
}
iderr_("in pltgrph");
*/

// Load local "nodnghs" array.

for (i = 0; i < nmnds; ++i) {
   nodnghs[i][0] = nodenghs[idnmbrm1][i][0];
   nodnghs[i][1] = nodenghs[idnmbrm1][i][1];
   for (j = 0; j < nodnghs[i][1]; ++j) {
      nodnghs[i][2 + j] = nodenghs[idnmbrm1][i][2 + j];
   }
}

/* Find optimal node ordering within each hierarchy level so as to
   minimize edge crossings and total length of arrows.  Also, discover
   "npcols" and "nprows." */

optedges_();

/* Define width and height of variable boxes.  The plotting region is
   approximately the unit region. */

if (npcols > 5) {
   bwidth = .99 / ((double) npcols); // was .92

} else {
   bwidth = .80 / 5.; // was .92
}

if (nprows > 5) {
   bheight = .99 / ((double) nprows); // was .92

} else {
   bheight = .92 / ((double) nprows);
}

if (bwidth > bheight) {
   bwidth = bheight;

} else {
   bheight = bwidth;
}
printf_("pltgrph: bwidth= " + bwidth + " bheight= " + bheight);

if (npcols > 5) {
   xdec = (1.60 * ((double) npcols) / 9.) * bwidth;
   xshift = .01;

} else {
   xdec = (1.60 * ((double) npcols) / 5.) * bwidth;
   xshift = .00;
}
if (xdec < .1584) {
   xdec = .1584;
}

if (nprows > 5) {
   ydec = 1.45 * bheight;

} else {
   ydec = 2.5 * bheight;
}

radius = .52 * bheight; // was .5

/* Determine the Bounding Box values.  Do this by discounting the 550, 500
   values by the final width and height fractions of the unit region. */

/*
xmax = ((double) npcols) * xdec;
ymax = ((double) nprows) * ydec;
urx = (int) (550. * (xmax / 1.0));
ury = (int) (500. * (ymax / 1.0));
printf_("pltgrph: xmax= " + xmax + " ymax= " + ymax + " urx= " + urx +
   " ury= " + ury);
*/

llx = 120;
lly = 120;
urx = 550;
ury = 500;

/* Open PostScript output file and place PostScript procedures library
   in it.  Scale and translate as necessary. */

fleopen_(2, flename, 'w');
pslib_(2, llx, lly, urx, ury);

if (Math.min(nprows, npcols) > 5) {
   xscale = (int) (250. * ydec / xdec);
   fprintf_(2, xscale + " 250 scale" + "\n.50 .4 translate");

} else {
   xscale = (int) (290. * ydec / xdec);
   fprintf_(2, xscale + " 290 scale" + "\n.00 .3 translate");
}

// Get font.

fprintf_(2, "/Times-Roman findfont");
strng = ".028 scalefont setfont";
fprintf_(2, strng);
fprintf_(2, ".004 setlinewidth"); // was .002.

/* Optionally, print the complete "nprows" by "npcols" grid of
   available boxes. */

if (plotgrid) {
   for (i = 0; i < nprows; ++i) {
      for (j = 0; j < npcols; ++j) {
         xcor = xshift + (xdec * (double) j);
         ycor = ((double) (nprows - i)) * ydec;
         strng = xcor + " " + fdble_(ycor - .5 * bheight, 7, 3) +
            " " + fdble_(xcor + bwidth, 7, 3)
	    + " " + fdble_(ycor + .5 * bheight, 7, 3) + " box";
         fprintf_(2, strng);
      }
   }
   fprintf_(2, "showpage");
   fprintf_(2, "%%Trailer");
   fprintf_(2, "%%EOF");
   fclose_(2, 'w');

   return;
}

// Plot edges.

for (i = 1; i <= ndesum; ++i) {
   trow = grph_pos[i - 1][0];
   tcol = grph_pos[i - 1][1];
   for (j = 1; j <= nodnghs[i - 1][1]; ++j) {
      prnt = nodnghs[i - 1][j + 1];
      srow = grph_pos[prnt - 1][0];

      // Only plot edges that are one hierarchy row long.

      if (trow == srow + 1) {
         scol = grph_pos[prnt - 1][1];
         xsrc = xshift + (.5 * bwidth) + ((double) (scol - 1)) * xdec;
         ysrc = ((double) (nprows + 1 - srow)) * ydec - (.5 * bheight);
	 if (prnt >= nmnds) {
            ysrc += .5 * bheight;
         }

         xcor = xshift + (.5 * bwidth) + ((double) (tcol - 1)) * xdec;
         ycor = ((double) (nprows + 1 - trow)) * ydec + (.5 * bheight);
	 if (nodelbls[idnmbrm1][i - 1][0].equals("dummy")) {
	    ycor -= .5 * bheight;
            strng = fdble_(xsrc, 7, 3) + " " + fdble_(ysrc, 7, 3) + " " +
	            fdble_(xcor, 7, 3) + " " + fdble_(ycor, 7, 3) + " line";

	 } else {
            strng = fdble_(xsrc, 7, 3) + " " + fdble_(ysrc, 7, 3) + " " +
	            fdble_(xcor, 7, 3) + " " + fdble_(ycor, 7, 3) + " arrow";
	 }
         fprintf_(2, strng);
      }
   }
}

// Remove all dummy parent edges.

for (i = 0; i < nmnds; ++i) {
   nmprnts = nodnghs[i][1];
   for (j = 0; j < nmprnts; ++j) {
      prnt = nodnghs[i][j + 2];
      if (nodelbls[idnmbrm1][prnt - 1][0].equals("dummy")) {
	 --nodnghs[i][1];
      }
   }
}

// Plot shapes that represent nodes, labels, and, optionally, node numbers.

for (i = 1; i <= nmnds; ++i) {

   // Skip nodes that are not to be drawn.

   if (donotdraw[i - 1]) {
      printf_("   donotdraw node= " + nodelbls[idnmbrm1][i - 1][0]);
      continue;
   }

   // Set the maximum label length.

   if (nmnds < 40) {
      maxlngth = Math.min(15, STRNGLTH); // was 13

   } else {
      maxlngth = Math.min(10, STRNGLTH);
   }

   /* First, determine node type and compute left, bottom edge of the
      plotting rectangle. */

   xcor = xshift + ((double) (grph_pos[i - 1][1] - 1)) * xdec;
   ycor = ((double) (nprows + 1 - grph_pos[i - 1][0])) * ydec
          - (.5 * bheight);

   if (varinfo_dist[idnmbrm1][i - 1].equals("Determ_Decision") ||
       varinfo_dist[idnmbrm1][i - 1].equals("Determ_Root")) {
      nodetype = "rectangle";

   } else if (varinfo_dist[idnmbrm1][i - 1].equals("Determ_Loss") ||
	      nodelbls[idnmbrm1][i - 1][0].equals(
                 "Overall_Goal_Satisfaction") ||
	      nodelbls[idnmbrm1][i - 1][0].equals(
                 "Overall_Goal_Attainment") ||
	      nodelbls[idnmbrm1][i - 1][0].equals(
                 "Overall_Goal__Attainment") ||
	      nodelbls[idnmbrm1][i - 1][0].equals("Utility")) {
      nodetype = "diamond";
      xcor += .5 * bwidth;
      ycor += .5 * bheight;

   } else if (varinfo_dist[idnmbrm1][i - 1].equals("Determ_Contin") ||
         varinfo_dist[idnmbrm1][i - 1].equals("Determ_Discrete") ||
         varinfo_dist[idnmbrm1][i - 1].equals("Determ_Thrshld") ||
         varinfo_dist[idnmbrm1][i - 1].equals("Determ_Linear") ||
         varinfo_dist[idnmbrm1][i - 1].equals("Determ_Frctn")) {
      nodetype = "double_circle";
      xcor += .5 * bwidth;
      ycor += .5 * bheight;

   } else {
      nodetype = "circle";
      xcor += .5 * bwidth;
      ycor += .5 * bheight;
   }

   /* After re-setting the character string array, load and print first
      label string.  The string ends at the first blank. */

   for (j = 0; j < STRNGLTH; ++j) {
      chstrng[0][j] = ' ';
      chstrng[1][j] = ' ';
      label[j] = ' ';
   }
   dumlabel = nodelbls[idnmbrm1][i - 1][0].toCharArray();
   lbllngth = nodelbls[idnmbrm1][i - 1][0].length();
   if (lbllngth < 1) {
      iderr_("pltgrph: lbllngth= " + lbllngth);
   }
   if (lbllngth > STRNGLTH) {
      lbllngth = STRNGLTH;
   }

   // Figure out line breaks and number of text strings to print.

   forcetwostrings = false;
   nmwrds = 1;
   for (j = 0; j < lbllngth; ++j) {
      if (dumlabel[j] == '_') {
         dumlabel[j] = ' ';
         label[j] = dumlabel[j];
	 if (dumlabel[j + 1] == '_') {
            ++j;
            dumlabel[j] = ' ';
            label[j] = dumlabel[j];
	    forcetwostrings = true;
	 }
	 ++nmwrds;
	 continue;
      }
      label[j] = dumlabel[j];
   }

   if (lbllngth <= maxlngth && !forcetwostrings) {
      nmstrngs = 1;
   
   } else {
      nmstrngs = 2;
   }

   // Fill node label strings.
   
   j2 = 0;
   if (nmstrngs == 1) {
      for (j = 0; j < Math.min(lbllngth, maxlngth); ++j) {
         chstrng[0][j] = label[j];
         ++j2;

      /* Stop adding characters to the first string when a carriage
         return is encountered. */
   
         if ((chstrng[0][j] == '\0')) {
            break;
	 }
      }

   } else {
      if (nodelbls[idnmbrm1][i - 1][0].indexOf("-", 0) >= 0) {
         for (j = 0; j < lbllngth; ++j) {
            chstrng[0][j] = label[j];
            ++j2;
            if (chstrng[0][j] == '-') {
               break;
	    }
	 }

      } else if (nodelbls[idnmbrm1][i - 1][0].indexOf("__", 0) >= 0) {
         for (j = 0; j < lbllngth; ++j) {
            chstrng[0][j] = label[j];
            ++j2;
            if (chstrng[0][j] == ' ' && label[j + 1] == ' ') {
               break;
	    }
	 }

      } else {
         for (j = 0; j < Math.min(lbllngth, maxlngth); ++j) {
            chstrng[0][j] = label[j];
            ++j2;
            if ((nmwrds == 2 && chstrng[0][j] == ' ') || // Two words.
	        (nmwrds == 3 && chstrng[0][j] == ' ' &&
	         2 * lbllngth / 5 <= j &&
	         j < 3 * lbllngth / 5) || // After 2nd word in 3 words.
	        (nmwrds >= 3 &&
	         4 * lbllngth / 7 <= j)) { // More that 2 words.
               break;
	    }
	 }
      }
   }

   // Now, draw the shape with either 1 or 2 strings inside it.

   if (nodetype.equals("rectangle")) {
      strng = fdble_(xcor, 7, 3) + " " + fdble_(ycor, 7, 3) + " " +
	 fdble_(xcor + bwidth, 7, 3) + " " + fdble_(ycor + bheight, 7, 3) +
	 " (" + String.valueOf(chstrng[0]).trim() + ")";
      fprintf_(2, strng);
      if (nmstrngs == 1) {
         fprintf_(2, "box1txt");
      }

   } else if (nodetype.equals("diamond")) {
      strng = fdble_(xcor, 7, 3) + " " + fdble_(ycor, 7, 3) + " " +
	 fdble_(radius, 7, 3) +
         " (" + String.valueOf(chstrng[0]).trim() + ")";
      fprintf_(2, strng);
      if (nmstrngs == 1) {
         fprintf_(2, "dmnd1txt");
      }

   } else if (nodetype.equals("double_circle")) {
      strng = fdble_(xcor, 7, 3) + " " + fdble_(ycor, 7, 3) + " " +
	 fdble_(radius, 7, 3) +
         " (" + String.valueOf(chstrng[0]).trim() + ")";
      fprintf_(2, strng);
      if (nmstrngs == 1) {
         fprintf_(2, "dc1txt");
      }

   } else {
      strng = fdble_(xcor, 7, 3) + " " + fdble_(ycor, 7, 3) + " " +
	 fdble_(radius, 7, 3) +
         " (" + String.valueOf(chstrng[0]).trim() + ")";
      fprintf_(2, strng);
      if (nmstrngs == 1) {
         fprintf_(2, "crc1txt");
      }
   }

   if (nmstrngs == 2) {

      // Load and print second label string.

      if (label[j2] == ' ') {
	 ++j2;
      }
      for (j = 0; j < lbllngth - j2; ++j) {
	 chstrng[1][j] = label[j2 + j];
      }
      strng = " (" + String.valueOf(chstrng[1]).trim() + ") ";
      fprintf_(2, strng);

      // Now draw the shape with the 2 strings.

      if (nodetype.equals("rectangle")) {
         fprintf_(2, "box2txt");

      } else if (nodetype.equals("diamond")) {
         fprintf_(2, "dmnd2txt");

      } else if (nodetype.equals("double_circle")) {
         fprintf_(2, "dc2txt");

      } else {
         fprintf_(2, "crc2txt");
      }
   }

   if (varnm) {
      strng = fdble_(xcor + .18 * bwidth, 7, 3) + " " +
	 fdble_(ycor + 1.25 * bheight, 7, 3)
	 + " moveto " + "(" + i + ") show";
      fprintf_(2, strng);
   }
}

// Show the page.

fprintf_(2, "showpage");
fprintf_(2, "%%Trailer");
fprintf_(2, "%%EOF");

// Close PostScript output file.

fclose_(2, 'w');
}

// --------------------------------------------------------------------

public static void optedges_() {

/* Finds optimal ordering of nodes within each hierarchy level so as to
   minimize edge crossings. */

int i, j, k, row, chlngt;

/* First, discover size of problem.  Do this by finding the
   within-hierarchy ordering implied by the node numbering.   Then, find
   the interconnectivity matrix. */

hierarc_();
intconn_();

// Now find the size of the problem and load initial values of state vector.

printf_("optedges: nmhierarc= " + nmhierarc + " nprows= " + nprows +
   " npcols= " + npcols);

for (i = 0; i < nmhierarc - 1; ++i) {
   printf_("hierarc= " + (i + 1) + " nmnodes= " + p[i]);
   if (p[i] < 1) {
      iderr_("pltgrph: row " + (i + 1) + "= " + p[i]);
   }
   for (j = 0; j < npcols; ++j) {
      for (k = 0; k < npcols; ++k) {
	 if (m[i][j][k] == 1) {
	    x[nsize] = 1;
            
	 } else {
	    x[nsize] = 0;
	    ++nzero;
         }
	 ++nsize;
      }

      /*
      if (hierndes[i][j] > 0) {
         printf_("optedges: node= " +
            nodelbls[idnmbrm1][hierndes[i][j] - 1][0]);

      }
      */

   }
}

/* Compute the initial number of crossings (first load "ndetrial" so
   that "hierndes" is not zeroed-out in "nmcross_").  If there is room for
   improvement, call the Simulated Annealing routine to optimize the
   within-hierarchy node orderings. */

for (i = 0; i < nmhierarc; ++i) {
   for (j = 0; j < npcols; ++j) {
      ndetrial[i][j] = hierndes[i][j];
   }
}
if (nmcross_(false, x) > 2.) {
   
   /* nsize is the length of the vector, nzero is the number of zeroes.
      "chlngt" is the number of solutions reachable in one "move" step. */

   chlngt = nsize * (nsize - nzero);
   Simanel.simanel_(nsize, chlngt, x, 20., .002, 2);

} else {
   printf_("optedges: initial number of crossings= " + nmcross_(false, x) +
	   " no optimization performed.");
}

withinrow_();


// Load "grph_pos" array with the optimal within-hierarchy node orderings.

LOADGRPH: for (i = 0; i < nmhierarc; ++i) {
   for (j = 0; j < npcols; ++j) {
      if (hierndes[i][j] > 0) {

	 /* Set a "do not draw" flag for a node that has no edges into
	    it or out of it.  First, check for edges emanating from the
	    node. */

	 donotdraw[hierndes[i][j] - 1] = true;
         for (k = 0; k < npcols; ++k) {
            if (m[i][j][k] == 1) {
	       donotdraw[hierndes[i][j] - 1] = false;
	       break;
	    }
	 }

	 // Now, check for edges entering the node.

         if (i > 0 && donotdraw[hierndes[i][j] - 1]) {
            for (k = 0; k < npcols; ++k) {
               if (m[i - 1][k][j] == 1) {
	          donotdraw[hierndes[i][j] - 1] = false;
	          break;
	       }
	    }
         }
         grph_pos[hierndes[i][j] - 1][0] = (short) (i + 1);
         grph_pos[hierndes[i][j] - 1][1] = (short) (j + 1);
      }
   }
}

}

// --------------------------------------------------------------------

public static void hierarc_() {

/* Detects directed graph hierarchy and writes initial values to
   "hierndes".

   The "p" array holds the number of nodes in each row. */

int i, j = 0, k = 0, l, m, prnt, nmprnts = 0, chld, prntlvl, chldlvl,
   lastsitrow = 0, beginscenario, hiermax, nmtrys = 0, therow = 0;

// First, find the number of the first node in the Scenario subnetwork.

beginscenario = nmnds + 1;
for (i = 0; i < nmnds; ++i) {
   if (grph_label[idnmbrm1][i].equals("ACTN") ||
       grph_label[idnmbrm1][i].equals("E1")) {
      beginscenario = i + 1;
      break;
   }
}

// Situation root nodes are in the first level of the hierarchy.

for (i = 1; i < beginscenario; ++i) {
   if (nodnghs[i - 1][1] == 0) {
      hierndes[0][p[0]] = (short) i;
      ++ndesum;

      if (nmnds < 50) {
         ++p[0];

      } else {
         p[0] += 2;
      }
   }
}
npcols = p[0] + 1;

// Discover hierarchy.

do {

   // Loop over all nodes in graph.

   nodeloop: for (i = 1; i <= nmnds; ++i) {

      // If this node has already been assigned, skip.

      for (k = 1; k <= nmhierarc; ++k) {
         for (l = 0; l < p[k - 1]; ++l) {
            if (i == hierndes[k - 1][l]) {
	       continue nodeloop;
	    }
	 }
      }

      /* If this is a Scenario node, and not all Situation nodes have
	 been assigned a hierarchy row, quit. */

      if (i >= beginscenario && ndesum < beginscenario - 1) {
         iderr_("hierarc: i= " + i + " ndesum= " + ndesum +
	    " beginscenario= " + beginscenario);
      }

      /* Assign Scenario subID root nodes to the first row after the
	 last Situation subID row. */

      if (nodnghs[i - 1][1] == 0 && i >= beginscenario) {
         hierndes[lastsitrow + 1][p[lastsitrow + 1]] = (short) i;
         ++p[lastsitrow + 1];

	 /* Upon the first Scenario root node, increment the number
	    of hierarchy rows by 1. */

	 if (p[lastsitrow + 1] == 1) {
	    ++nmhierarc;
	 }
	 ++ndesum;
	 continue;
      }

      /* First, find out if all of the node's parents have been assigned
	 a hierarchy row. "hiermax" is the deepest hierarchy level across
	 all of the parents. */

      hiermax = 0;
      nmprnts = 0;
      for (j = 0; j < nodnghs[i - 1][1]; ++j) {
	 for (k = 1; k <= nmhierarc; ++k) {
	    for (l = 0; l < p[k - 1]; ++l) {
	       if (nodnghs[i - 1][j + 2] == hierndes[k - 1][l]) {
                  ++nmprnts;
		  if (hiermax < k) {
		     hiermax = k;
		  }
	       }
	    }
	 }
      }

      // Now, assign this node to a row.

      if (nmprnts == nodnghs[i - 1][1]) {
         if (i >= beginscenario && hiermax <= lastsitrow) {
	    therow = lastsitrow + 1;

	 } else {
            therow = hiermax;
	 }
         hierndes[therow][p[therow]] = (short) i;
         if (nmnds < 50) {
            ++p[therow];

	 } else {
            p[therow] += 2;
         }
	 ++ndesum;
	 if (p[therow] > npcols) {
	    npcols = p[therow] + 1;
         }

	 if (nmhierarc == hiermax) {
	    ++nmhierarc;
         }

	 // Store the last row of the Situation subID.

	 if (i <= beginscenario && lastsitrow < hiermax) {
            lastsitrow = hiermax;
	 }
	 /*
	 if (nodelbls[idnmbrm1][i - 1][0].indexOf("Goal", 0) >= 0 &&
	     i < beginscenario) {
	    goalrow = hiermax;
	 }
         */
      }
   }
   ++nmtrys;
} while (ndesum < nmnds && nmtrys < 10000);
if (nmtrys == 10000) {
   iderr_("hierarc: nmtrys=10000");
}
nprows = nmhierarc + 1;

/*
for (k = 0; k < nmhierarc; ++k) {
   for (l = 0; l < p[k]; ++l) {
      printf_("hierarc: k= " + k + " l= " + l + "hierndes= " +
         hierndes[k][l]);
   }
}

for (k = 0; k < nmhierarc; ++k) {
   printf_("hierarc: hierclevl= " + (k + 1));
   for (l = 0; l < p[k]; ++l) {
      printf_("hierarc: node= " + nodelbls[idnmbrm1][hierndes[k][l] - 1][0]);
   }
}
printf_("hierarc: nmhierarc= " + nmhierarc);
*/

/* Add dummy nodes as necessary so that no two nodes are separated by
   more than one row. */

for (chld = 1; chld <= nmnds; ++chld) {
   prntlvl = 0;
   chldlvl = 0;
   for (j = 0; j < nodnghs[chld - 1][1]; ++j) {
      prnt = nodnghs[chld - 1][j + 2];
      for (k = 0; k < nmhierarc; ++k) {
	 for (l = 0; l < p[k]; ++l) {
	    if (prnt == hierndes[k][l]) prntlvl = k;
	    if (chld == hierndes[k][l]) chldlvl = k;
	 }
      }

      if (prntlvl + 1 < chldlvl) {

         // Add dummy nodes to connect this parent with the child.

         for (m = prntlvl + 1; m < chldlvl; ++m) {
	    ++ndesum;
	    if (ndesum > NMDUMNDS) {
	       iderr_("hierarc: nmnds= " + nmnds + " chld= " + chld +
                  " ndesum= " + ndesum + "> NMDUMNDS= " + NMDUMNDS);
            }

	    ++p[m];
	    if (p[m] > npcols) npcols = p[m] + 1;

	    hierndes[m][p[m] - 1] = (short) ndesum;
	 
	    /* Add this dummy node to the graph database and then make
	       this dummy the parent of the next dummy. */

	    nodelbls[idnmbrm1][ndesum - 1][0] = "dummy";
	    nodnghs[ndesum - 1][1] = 1;
	    nodnghs[ndesum - 1][2] = prnt;
	    prnt = ndesum;
         }

	 // Finally, connect the last dummy node to the real child.

	 ++nodnghs[chld - 1][1];
	 nmprnts = nodnghs[chld - 1][1];

	 if (chld > NMDUMNDS || nmprnts > TNMPRTS + 1) {
	    iderr_("hierarc: chld= " + chld + " nmprnts= " + nmprnts);
	 }

	 nodnghs[chld - 1][nmprnts + 1] = prnt;
      }
   }
}

/*
printf_("hierarc: after dummies");
for (k = 0; k < nmhierarc; ++k) {
   for (l = 0; l < p[k]; ++l) {
      printf_("hierarc: k= " + k + " l= " + l + "hierndes= " +
         hierndes[k][l]);
   }
}
*/

}

// -------------------------------------------------------------------

public static void intconn_() {

/* Creates interconnection matrices in "m" given connectivity in
   "nodnghs" and hierarchy-level orderings in "hierndes".  */

int i, j, k, l, prnt, chld, lftsum = 0, rghtsum = 0, absjminusk;

for (i = 0; i < nmhierarc - 1; ++i) {
   for (j = 0; j < npcols; ++j) {
      for (k = 0; k < npcols; ++k) {
	 m[i][j][k] = 0;
      }
   }
}

sumlngth = 0;
maxabslngth = 0;
for (i = 0; i < nmhierarc - 1; ++i) {
   for (j = 0; j < npcols; ++j) {

      prnt = hierndes[i][j];
      if (prnt > 0) {
         for (k = 0; k < npcols; ++k) {

            chld = hierndes[i + 1][k];
            if (chld > 0) {
               for (l = 0; l < nodnghs[chld - 1][1]; ++l) {
                  if (prnt == nodnghs[chld - 1][l + 2]) {
                     m[i][j][k] = 1;

		     // Compute appearance quality measures.

		     absjminusk = Math.abs(j - k);
		     // sumlngth += 1 + absjminusk;
		     sumlngth += absjminusk;
		     if (j < k) {
			lftsum += absjminusk;
		     
		     } else {
			rghtsum += absjminusk;
		     }

		     // Keep track of maximum difference.

		     if (maxabslngth < absjminusk) {
			maxabslngth = absjminusk;
		     }

                     break;
	          }
	       }
            }
	 }
      }
   }
}
absdifflngth = Math.abs(lftsum - rghtsum);

}

// -------------------------------------------------------------------

public static double nmcross_(boolean pflag, int x[]) {

// Counts total number of crossings in the graph.

int i, j, k, l, nmcross = 0, alp, bet;

double retval;

// Load node hierarchy array and then edge connectivity matrix.

for (i = 0; i < nmhierarc; ++i) {
   for (j = 0; j < npcols; ++j) {
      hierndes[i][j] = ndetrial[i][j];
   }
}

/*
l = 0;
for (i = 0; i < nmhierarc - 1; ++i) {
   for (j = 0; j < npcols; ++j) {
      for (k = 0; k < npcols; ++k) {
	 m[i][j][k] = x[l];
	 ++l;
      }
   }
}
*/
intconn_();

// Compute number of crossings.

for (i = 0; i < nmhierarc - 1; ++i) {
   for (j = 0; j < npcols - 1; ++j) {
      for (k = j + 1; k < npcols; ++k) {
	 // if (pflag) printf_(i + " " + j + " " + k + " " + m[i][j][k]);
	 for (alp = 0; alp < npcols - 1; ++alp) {
	    for (bet = alp + 1; bet < npcols; ++bet) {
	       nmcross += m[i][j][bet] * m[i][k][alp];
	    }
	 }
      }
   }
}

/*
retval = .4 * ((double) nmcross) + .5 * ((double) sumlngth) +
         .1 * ((double) maxabslngth);
*/
retval = .99 * ((double) nmcross) + .01 * ((double) sumlngth);

return retval;
}

// --------------------------------------------------------------------

public static void movenodes_(int n, int x[], int xtrial[]) {

/* For a graph, randomly finds a new state of node positions within each
   node hierarchy.  This is done by first randomly selecting a hierarchy
   row and then randomly selecting two nodes within that row and
   interchanging their positions. */

int i, j, k, l, startrow, row, pos1, pos2, bet, alp, node1;

double rnmhierarc;

/* Randomly select a starting hierarchy row from the first 50% of the
   hierarchy. */

// startrow = 1 + (int) (Rndm.rndm1_(0, 0) * ((double) nmhierarc) * .25);
// startrow = (int) (Rndm.rndm1_(0, 0) * ((double) nmhierarc) * .25);
rnmhierarc = (double) nmhierarc;
startrow = (int) (Rndm.rndm1_(0, 0) * (rnmhierarc + 2.));
if (startrow < 1) {
   startrow = 1;

} else if (startrow > nmhierarc) {
   startrow = nmhierarc;
}

// Randomly interchange two nodes in this row.

pos1 = (int) (Rndm.rndm1_(0, 0) * ((double) npcols));
if (pos1 < 1) pos1 = 1;
i = 0;
for (;;) {
   pos2 = (int) (Rndm.rndm1_(0, 0) * (double) npcols);
   if (pos2 < 1) pos2 = 1;
   if (pos2 != pos1 && (hierndes[startrow - 1][pos1 - 1] > 0 ||
			hierndes[startrow - 1][pos2 - 1] > 0)) break;
   ++i;
   if (i == 400) {
      for (j = 0; j < npcols; ++j) {
	 printf_("hierndes(" + (j + 1) + ")= " + hierndes[startrow - 1][j]);
      }
      iderr_("movenodes: i=400, nmhierarc= " + nmhierarc +
	 " startrow= " + startrow + " pos1= " + pos1 + " pos2= " + pos2);
   }
}
node1 = hierndes[startrow - 1][pos1 - 1];
hierndes[startrow - 1][pos1 - 1] = hierndes[startrow - 1][pos2 - 1];
hierndes[startrow - 1][pos2 - 1] = (short) node1;

// Uncross crossed links in each hierarchy row.

for (row = 1; row < nmhierarc; ++row) {
   for (j = 0; j < npcols - 1; ++j) {
      for (k = j + 1; k < npcols; ++k) {
	 for (alp = 0; alp < npcols - 1; ++alp) {
	    for (bet = alp + 1; bet < npcols; ++bet) {

               // Check for a cross and then decross it.

	       if (m[row - 1][j][bet] == 1 &&
		   m[row - 1][k][alp] == 1) {
		  node1 = hierndes[row][bet];
		  hierndes[row][bet] = hierndes[row][alp];
		  hierndes[row][alp] = (short) node1;
                  intconn_();
               }
	    }
	 }
      }
   }
}

// Load trial node hierarchy array and link state vector.

for (i = 0; i < nmhierarc; ++i) {
   for (j = 0; j < npcols; ++j) {
      ndetrial[i][j] = hierndes[i][j];
   }
}

l = 0;
for (i = 0; i < nmhierarc - 1; ++i) {
   for (j = 0; j < npcols; ++j) {
      ndetrial[i][j] = hierndes[i][j];
      for (k = 0; k < npcols; ++k) {
	 xtrial[l] = m[i][j][k];
	 ++l;
      }
   }
}

return;
}

// ----------------------------------------------------------------------

public static void withinrow_() {

// Performs within-row re-arrangements.

boolean onemove = false, sidebyside = false;

short saveval = 0;

int i, row, j, k, chldnode, prntnode, backj = 0, forwardk = 0,
   nmsidebysides = 0;

/* Move dummy children in the final solution closer to parents.  Try this
   6 times. */

for (i = 0; i < 6; ++i) {
   for (row = 1; row < nmhierarc; ++row) {
      for (j = 0; j < npcols; ++j) {
         for (k = 0; k < npcols; ++k) {

	    // Skip if there is no connection or they are already lined up.

            if (m[row - 1][j][k] == 0 || j == k) {
	       continue;
	    }

	    chldnode = hierndes[row][k];
	    /*
            if (hierndes[row][j] == 0 &&
		nodelbls[idnmbrm1][chldnode - 1][0].equals("dummy")) {
            */
            if (hierndes[row][j] == 0) {
               hierndes[row][j] = hierndes[row][k];
               hierndes[row][k] = 0;
               intconn_();
	    }
	 }
      }
   }
}

/* Move dummy parents in the final solution closer to children.  Try this
   4 times. */

for (i = 0; i < 4; ++i) {
   for (row = 0; row < nmhierarc; ++row) {
      for (j = 0; j < npcols; ++j) {
         prntnode = hierndes[row][j];
         for (k = 0; k < npcols; ++k) {

	    // Skip if there is no connection or they are already lined up.

            if (m[row][j][k] == 0 || j == k) {
	       continue;
	    }
            if (hierndes[row][k] == 0 &&
		nodelbls[idnmbrm1][prntnode - 1][0].equals("dummy")) {
               hierndes[row][k] = hierndes[row][j];
               hierndes[row][j] = 0;
               intconn_();
	    }
	 }
      }
   }
}

if (npcols >= 20) {

   // Force at least one dummy node between every two nodes.

   for (row = 0; row < nmhierarc; ++row) {
      nmsidebysides = 0;
      do {
	 backj = -1;
	 forwardk = -1;
         sidebyside = false;
         for (j = 0; j < npcols - 1; ++j) {
	
	    // Check for two side-by-side dummies behind.

            if (backj == -1 &&
                (hierndes[row][j] > nmnds || hierndes[row][j] == 0) &&
                (hierndes[row][j + 1] > nmnds ||
		 hierndes[row][j + 1] == 0)) {
	       backj = j + 1;
	       j += 2;
	    }
            if ((hierndes[row][j] > 0 && hierndes[row][j] <= nmnds) &&
                (hierndes[row][j + 1] > 0 &&
		 hierndes[row][j + 1] <= nmnds)) {
	       sidebyside = true;
               ++nmsidebysides;

	       // Check for two side-by-side dummies ahead.

               for (k = j + 2; k < npcols - 1; ++k) {
                  if ((hierndes[row][k] > nmnds ||
	               hierndes[row][k] == 0) &&
                      (hierndes[row][k + 1] > nmnds ||
		       hierndes[row][k + 1] == 0)) {
		     forwardk = k;
		     break;
                  }
	       }
	       if (backj != -1) {
		  saveval = hierndes[row][backj];
	          for (k = backj; k < j; ++k) {
                     hierndes[row][k] = hierndes[row][k + 1];
		  }
	          hierndes[row][j] = saveval;
                  intconn_();
	          break;

	       } else if (forwardk != -1) {
		  saveval = hierndes[row][forwardk];
	          for (k = forwardk; k > j + 1; --k) {
                     hierndes[row][k] = hierndes[row][k - 1];
		  }
	          hierndes[row][j + 1] = saveval;
                  intconn_();
	          break;

	       } else {
	          printf_("withinrow: cannot fix row= " + row);
	          break;
	       }
	    }
	 }
      } while (sidebyside && nmsidebysides < npcols);
   } 

   return;
}

/* Reduce the total edge length by trying to move nodes to the
   left or right. */

oldsum = sumlngth;
for (i = 0; i < 2; ++i) {
   for (row = 0; row < nmhierarc; ++row) {
   
      // Try moving nodes to the left.

      do {
	 onemove = false;
         for (j = 1; j < npcols; ++j) {
            if (hierndes[row][j] != 0) {
               if (hierndes[row][j - 1] == 0) {
                  hierndes[row][j - 1] = hierndes[row][j];
	          hierndes[row][j] = 0;
                  intconn_();

	          if (sumlngth > oldsum) {

		     // Move didn't work, replace.
 
	             hierndes[row][j] = hierndes[row][j - 1];
	             hierndes[row][j - 1] = 0;
                     intconn_();

                  } else {
	             oldsum = sumlngth;
	          }
	       }
            }
	 }
      } while (onemove);

      // Try moving nodes to the right.

      do {
	 onemove = false;
         for (j = 0; j < npcols - 1; ++j) {
            if (hierndes[row][j] > 0 && hierndes[row][j + 1] == 0) {
               hierndes[row][j + 1] = hierndes[row][j];
               hierndes[row][j] = 0;
               intconn_();

               if (sumlngth > oldsum) {

                  // Move didn't work, replace.

	          hierndes[row][j] = hierndes[row][j + 1];
	          hierndes[row][j + 1] = 0;
                  intconn_();

               } else {
	          oldsum = sumlngth;
                  onemove = true;
	       }
            }
	 }
      } while (onemove);
   }
}
}

// --------------------------------------------------------------------

public static void pslib_(int flenm, int llx, int lly, int urx, int ury) {

/* Places PostScript procedures library into the Encapsulated PostScript
   file.  For non-Encapsulated PostScript, replace the "!PS" line, below
   with "%!PS-Adobe-2.0."  The BoundingBox was 125 150 375 430. */

String bbstrng;

int i;

// Create Bounding Box string.

bbstrng = "%%BoundingBox: " + llx + " " + lly + " " + urx + " " + ury;

String pslib[] = {
"%!PS-Adobe-3.0 EPSF-3.0",
bbstrng,
"%%EndComments",
"%%BeginProcSet: myprocs",
"/vshowdict 4 dict def",
"/vshow {",
"   % Vertical printing routine.",
"   vshowdict begin",
"      /thestring exch def",
"      /lineskip exch def",
"      thestring {",
"	 /charcode exch def",
"	 /thechar ( ) dup 0 charcode put def",
"	 0 lineskip neg rmoveto",
"	 gsave",
"	 thechar stringwidth pop 3 div neg 0 rmoveto",
"	 thechar show",
"	 grestore",
"      }forall",
"   end",
"}def",
"/center_show {",
"   % Define centered text routine.",
"   currentpoint",
"   3 -1 roll",
"   dup",
"   stringwidth pop 2 div",
"   4 -1 roll exch sub",
"   3 -1 roll moveto",
"   dup",
"   gsave",
"   newpath",
"   0 0 moveto",
"   false charpath flattenpath pathbbox",
"   exch pop exch sub exch pop",
"   grestore",
"   -2 div 0 exch rmoveto",
"   show",
"} def",
"/grid {",
"   % Draws a 20 by 20 grid.",
"   .001 setlinewidth",
"   1 1 21 {",
"      % Draw vertical lines.",
"      -1 add",
"      .05 mul",
"      0 moveto",
"      0 1 rlineto",
"   } for",
"   stroke",
"   1 1 21 {",
"      % Draw horizontal lines.",
"      -1 add",
"      .05 mul",
"      0 exch moveto",
"      1 0 rlineto",
"   } for",
"   stroke",
"} def",
"/line {",
"   % Draws a line from (x1,y1) to (x2,y2).",
"   % Arguments are x1 y1 x2 y2.",
"   4 2 roll",
"   moveto",
"   lineto stroke",
"} def",
"/arrow {",
"   % Draws an arrow from (x1,y1) to (x2,y2).",
"   % Arguments are x1 y1 x2 y2.",
"   4 2 roll",
"   moveto",
"   currentlinewidth currentpoint 5 3 roll",
"   lineto",
"   currentpoint stroke moveto",
"   arrowhead",
"} def",
"/arrowhead {",
"   % Draws a correctly oriented arrow head, from the Green Book.",
"   gsave",
"      currentpoint",
"      4 2 roll exch 4 -1 roll exch",
"      sub 3 1 roll sub",
"      exch atan rotate dup scale",
"      -4 0 rmoveto",
"      -1 2 rlineto",
"      7 -2 rlineto",
"      -7 -2 rlineto",
"      closepath fill",
"   grestore",
"   newpath",
"} def",
"/BoxDict 4 dict def",
"/box {",
"   % Box with no text lines.  Arguments are lower left corner,",
"   % upper right corner.",
"   BoxDict begin",
"      /y2 exch def /x2 exch def",
"      /y1 exch def /x1 exch def",
"      /hght 0 def /wdth 0 def",
"      % Draw Box.",
"      x1 y1 moveto x2 y1 lineto x2 y2 lineto x1 y2 lineto",
"      closepath stroke",
"   end",
"} def",
"/Box1Dict 10 dict def",
"/box1txt {",
"   % Box with 1 line of text.  Arguments are lower left corner,",
"   % upper right corner, text string: x1 y1 x2 y2 (txtstrng)",
"   Box1Dict begin",
"      /txtstrng exch def",
"      /y2 exch def /x2 exch def",
"      /y1 exch def /x1 exch def",
"      /xc 0 def /yc 0 def",
"      % Was .031",
"      /chht .070 def",
"      % Blank Box.",
"      x1 y1 moveto x2 y1 lineto x2 y2 lineto x1 y2 lineto",
"      1 setgray fill 0 setgray",
"      % Draw Box.",
"      x1 y1 moveto x2 y1 lineto x2 y2 lineto x1 y2 lineto",
"      closepath stroke",
"      % Compute Box Center.",
"      y2 y1 add .5 mul",
"      /yc exch store",
"      x2 x1 add .5 mul",
"      /xc exch store",
"      % Blank the text area",
"      /twdth txtstrng stringwidth pop def",
"      /thwdth twdth .5 mul def",
"      xc thwdth sub",
"      yc chht .25 mul sub",
"      moveto",
"      0 chht .5 mul rlineto",
"      twdth 0 rlineto",
"      0 chht -.5 mul rlineto",
"      1 setgray fill 0 setgray",
"      % Find text position.",
"      xc thwdth sub",
"      yc chht .1 mul sub",
"      moveto",
"      txtstrng show",
"   end",
"} def",
"/Box2Dict 11 dict def",
"/box2txt {",
"   % Box with 2 lines of text.  Arguments are lower left corner,",
"   % upper right corner, text string 1, text string 2:",
"   % x1 y1 x2 y2 (txtstrng1) (txtstrng2)",
"   Box3Dict begin",
"      /txt2 exch def",
"      /txt1 exch def",
"      /y2 exch def /x2 exch def",
"      /y1 exch def /x1 exch def",
"      /xc 0 def /yc 0 def",
"      % Define character height.  This value produces characters that",
"      % are about 10 points high as long as the Postscript images has",
"      % been scaled with the command   250 250 scale",
"      /chht .034 def",
"      % Blank Box.",
"      x1 y1 moveto x2 y1 lineto x2 y2 lineto x1 y2 lineto",
"      1 setgray fill 0 setgray",
"      % Draw Box.",
"      x1 y1 moveto x2 y1 lineto x2 y2 lineto x1 y2 lineto",
"      closepath stroke",
"      % Compute Box Center.",
"      y2 y1 add .5 mul",
"      /yc exch store",
"      x2 x1 add .5 mul",
"      /xc exch store",
"      % Blank the first string's text area",
"      /twdth txt1 stringwidth pop def",
"      /thwdth twdth .5 mul def",
"      xc thwdth sub",
"      yc chht .05 mul sub",
"      moveto",
"      0 chht .50 mul rlineto",
"      twdth 0 rlineto",
"      0 chht -.50 mul rlineto",
"      1 setgray fill 0 setgray",
"      % Find text position 1 and write it.",
"      xc thwdth sub",
"      yc chht .10 mul add",
"      moveto",
"      txt1 show",
"      % Blank the second string's text area",
"      /twdth txt2 stringwidth pop def",
"      /thwdth twdth .5 mul def",
"      xc thwdth sub",
"      yc chht .40 mul sub",
"      moveto",
"      0 chht .35 mul rlineto",
"      twdth 0 rlineto",
"      0 chht -.35 mul rlineto",
"      1 setgray fill 0 setgray",
"      % Find text position 2 and write it.",
"      xc thwdth sub",
"      yc chht .60 mul sub",
"      moveto",
"      txt2 show",
"   end",
"} def",
"/Box3Dict 12 dict def",
"/box3txt {",
"   % Box with 3 lines of text.  Arguments are lower left corner,",
"   % upper right corner, text string 1, text string 2:",
"   % x1 y1 x2 y2 (txtstrng1) (txtstrng2) (txtstrng3)",
"   Box3Dict begin",
"      /txtstrng3 exch def",
"      /txtstrng2 exch def",
"      /txtstrng1 exch def",
"      /y2 exch def /x2 exch def",
"      /y1 exch def /x1 exch def",
"      /hght 0 def /wdth 0 def",
"      /chht .031 def",
"      /twdth 2.6 def",
"      /thwdth 1.3 def",
"      % Draw Box.",
"      x1 y1 moveto x2 y1 lineto x2 y2 lineto x1 y2 lineto",
"      closepath stroke",
"      % Find text position.",
"      y2 y1 sub",
"      /hght exch store",
"      x2 x1 sub",
"      /wdth exch store",
"      wdth .05 mul x1 add",
"      hght .72 mul y1 add",
"      moveto",
"      currentpoint",
"      txtstrng1 show",
"      hght .25 mul sub",
"      moveto",
"      currentpoint",
"      txtstrng2 show",
"      hght .25 mul sub",
"      moveto",
"      txtstrng3 show",
"   end",
"} def",
"/ellipse {",
"   % Draws an ellipse.  Arguments are: xc, yc, width, height, angle.",
"   % From McGilton and Campione, p. 223.",
"   matrix currentmatrix",
"   6 1 roll 5 -2 roll translate",
"   rotate",
"   scale",
"   newpath 0 0 1 0 360 arc stroke",
"   closepath",
"   setmatrix",
"} def",
"/normal {",
"   % Evaluates the normal density function.  Arguments are",
"   % x mu sigma.",
"   3 1 roll sub dup mul -2 div",
"   exch dup dup mul 3 2 roll exch div",
"   2.7182818 exch exp",
"   3.14159 2 mul sqrt",
"   3 -1 roll mul 1 exch div mul",
"} def",
"/NrmlDict 4 dict def",
"/nrmldens {",
"   % Draws the normal density curve.  Arguments are x0, y0, mu, sigma.",
"   NrmlDict begin",
"      /sigma exch def",
"      /mu exch def",
"      /y0 exch def",
"      /x0 exch def",
"      matrix currentmatrix",
"      x0 y0 translate",
"      .1667 .6667 scale",
"      newpath",
"      mu 3 sub dup",
"      mu sigma normal moveto",
"      1 1 50 {",
"	 6 mul 50 div 3 sub mu add dup",
"	 mu sigma normal",
"	 lineto",
"      } for",
"      stroke closepath",
"      setmatrix",
"   end",
"} def",
"/BarDict 8 dict def",
"/barplot {",
"   % Draws a barplot.  Arguments are val_1 val_2 ... val_nmbars",
"   % ymax nmbars x0 y0.",
"   BarDict begin",
"      /pltht exch def",
"      /y0 exch def",
"      /x0 exch def",
"      /nmbars exch def",
"      /ymax exch def",
"      /str 10 string def",
"      /oldwdth 0 def",
"      /mtrx matrix def",
"      mtrx currentmatrix pop",
"      x0 y0 translate",
"      pltht pltht scale",
"      % Draw axes",
"      .05 0 1 0 line",
"      .05 0 .05 1 line",
"      % maximum y tic mark and label",
"      .03 1 .07 1 line",
"      0 .97 moveto",
"      ymax 10 str cvrs show",
"      % Set bar width",
"      /oldwdth currentlinewidth store",
"      .7 nmbars div setlinewidth",
"      % Draw bars.",
"      nmbars -1 1 {",
"	 nmbars div .03 add",
"	 dup 0 moveto exch lineto stroke",
"      } for",
"      oldwdth setlinewidth",
"      mtrx setmatrix",
"   end",
"} def",
"/M1pDict 4 dict def",
"/mlplts1p {",
"   % Barplots for a variable with one parent.  Arguments are:",
"   % val_1 ... val_n ymax nmbars ... val_1 ... val_n",
"   % plabel_1 ... plabel_n ymax nmbars nmpvls pltht tmarg",
"   M1pDict begin",
"      /tmarg exch def",
"      /pltht exch def",
"      /nmpvls exch def",
"      /colcen .6 def",
"      % Write parent value labels.",
"      1 1 nmpvls {",
"	 .5 sub 1 tmarg sub mul nmpvls div",
"	 .05 exch moveto show",
"      } for",
"      % Draw barplots.",
"      1 1 nmpvls {",
"	 .5 sub 1 tmarg sub mul nmpvls div",
"	 pltht .5 mul sub",
"	 colcen pltht .5 mul sub",
"	 exch pltht barplot",
"      } for",
"   end",
"} def",
"/crcle {",
"   % Draws a filled-in circle, from the Green Book, p. 46.",
"   % Arguments are linewidth fillgray x y r",
"   gsave",
"      newpath 0 360 arc",
"      gsave setgray fill grestore",
"      setlinewidth stroke",
"      grestore",
"} def",
"/Crc1Dict 7 dict def",
"/crc1txt {",
"   % Circle with 1 line of text.  Arguments are x-center, y-center,",
"   % radius, text string: xc yc r (txtstrng)",
"   Crc1Dict begin",
"      /txtstrng exch def",
"      /r exch def",
"      /yc exch def /xc exch def",
"      % /chht .031 def",
"      % /twdth 2.6 def",
"      % was .8, 1.",
"      /chht r 0.9 mul def",
"      /twdth r 0.9 mul def",
"      /thwdth twdth .5 mul def",
"      % Blank the circle.",
"      newpath xc yc r 0 360 arc closepath",
"      1 setgray fill 0 setgray",
"      % Draw the circle",
"      newpath xc yc r 0 360 arc",
"      stroke",
"      % Blank the text area",
"      /twdth txtstrng stringwidth pop def",
"      /thwdth twdth .5 mul def",
"      xc thwdth sub",
"      yc chht .25 mul sub",
"      moveto",
"      0 chht .5 mul rlineto",
"      twdth 0 rlineto",
"      0 chht -.5 mul rlineto",
"      1 setgray fill 0 setgray",
"      % Find text position.",
"      xc thwdth sub",
"      % was .1 then .3",
"      yc chht .25 mul sub",
"      moveto",
"      txtstrng show",
"   end",
"} def",
"/Crc2Dict 8 dict def",
"/crc2txt {",
"   % Circle with 2 lines of text.  Arguments are x-center, y-center,",
"   % radius, text string 1, text string 2: xc yc r (txtstrng1) (txtstrng2)",
"   Crc2Dict begin",
"      /txt2 exch def",
"      /txt1 exch def",
"      /r exch def",
"      /yc exch def /xc exch def",
"      % Was .031",
"      /chht .034 def",
"      % Blank the circle.",
"      newpath xc yc r 0 360 arc closepath",
"      1 setgray fill 0 setgray",
"      % Draw the circle",
"      newpath xc yc r 0 360 arc",
"      stroke",
"      % Blank the first string's text area",
"      /twdth txt1 stringwidth pop def",
"      /thwdth twdth .5 mul def",
"      xc thwdth sub",
"      yc chht .05 mul sub",
"      moveto",
"      0 chht .65 mul rlineto",
"      twdth 0 rlineto",
"      0 chht -.65 mul rlineto",
"      1 setgray fill 0 setgray",
"      % Find text position 1 and write it.",
"      xc thwdth sub",
"      yc chht .10 mul add",
"      moveto",
"      txt1 show",
"      % Blank the second string's text area",
"      /twdth txt2 stringwidth pop def",
"      /thwdth twdth .5 mul def",
"      xc thwdth sub",
"      yc chht .50 mul sub",
"      moveto",
"      0 chht .40 mul rlineto",
"      twdth 0 rlineto",
"      0 chht -.45 mul rlineto",
"      1 setgray fill 0 setgray",
"      % Find text position 2 and write it.",
"      xc thwdth sub",
"      yc chht .60 mul sub",
"      moveto",
"      txt2 show",
"   end",
"} def",
"/Dc1Dict 7 dict def",
"/dc1txt {",
"   % Double circle with 1 line of text.  Arguments are x-center, y-center,",
"   % radius, text string: xc yc r (txtstrng)",
"   Dc1Dict begin",
"      /txtstrng exch def",
"      /r exch def",
"      /yc exch def /xc exch def",
"      /chht .031 def",
"      /twdth 2.6 def",
"      /thwdth 1.3 def",
"      % Blank the circle.",
"      newpath xc yc r 0 360 arc closepath",
"      1 setgray fill 0 setgray",
"      % Draw the outer circle",
"      newpath xc yc r 0 360 arc",
"      stroke",
"      % Draw the inner circle",
"      newpath xc yc .90 r mul 0 360 arc",
"      stroke",
"      % Blank the text area",
"      /twdth txtstrng stringwidth pop def",
"      /thwdth twdth .5 mul def",
"      xc thwdth sub",
"      yc chht .25 mul sub",
"      moveto",
"      0 chht .5 mul rlineto",
"      twdth 0 rlineto",
"      0 chht -.5 mul rlineto",
"      1 setgray fill 0 setgray",
"      % Find text position.",
"      xc thwdth sub",
"      yc chht .1 mul sub",
"      moveto",
"      txtstrng show",
"   end",
"} def",
"/Dc2Dict 8 dict def",
"/dc2txt {",
"   % Double circle with 2 lines of text.  Arguments are x-center, y-center,",
"   % radius, text string 1, text string 2: xc yc r (txtstrng1) (txtstrng2)",
"   Dc2Dict begin",
"      /txt2 exch def",
"      /txt1 exch def",
"      /r exch def",
"      /yc exch def /xc exch def",
"      /chht .034 def",
"      % Blank the circle.",
"      newpath xc yc r 0 360 arc closepath",
"      1 setgray fill 0 setgray",
"      % Draw the outer circle",
"      newpath xc yc r 0 360 arc",
"      stroke",
"      % Draw the inner circle",
"      newpath xc yc .90 r mul 0 360 arc",
"      stroke",
"      % Blank the first string's text area",
"      /twdth txt1 stringwidth pop def",
"      /thwdth twdth .5 mul def",
"      xc thwdth sub",
"      yc chht .05 mul sub",
"      moveto",
"      0 chht .65 mul rlineto",
"      twdth 0 rlineto",
"      0 chht -.65 mul rlineto",
"      1 setgray fill 0 setgray",
"      % Find text position 1 and write it.",
"      xc thwdth sub",
"      yc chht .10 mul add",
"      moveto",
"      txt1 show",
"      % Blank the second string's text area",
"      /twdth txt2 stringwidth pop def",
"      /thwdth twdth .5 mul def",
"      xc thwdth sub",
"      yc chht .50 mul sub",
"      moveto",
"      0 chht .40 mul rlineto",
"      twdth 0 rlineto",
"      0 chht -.45 mul rlineto",
"      1 setgray fill 0 setgray",
"      % Find text position 2 and write it.",
"      xc thwdth sub",
"      yc chht .60 mul sub",
"      moveto",
"      txt2 show",
"   end",
"} def",
"/Dmd1Dict 7 dict def",
"/dmnd1txt {",
"   % Diamond with 1 line of text.  Arguments are x-center, y-center,",
"   % radius, text string: xc yc r (txtstrng)",
"   Dmd1Dict begin",
"      /txtstrng exch def",
"      /r exch def",
"      /yc exch def /xc exch def",
"      /chht .031 def",
"      /twdth 2.6 def",
"      /thwdth 1.3 def",
"      % Blank the diamond.",
"      newpath xc r sub yc moveto",
"      xc yc r add lineto",
"      xc r add yc lineto",
"      xc yc r sub lineto",
"      xc r sub yc lineto closepath",
"      1 setgray fill 0 setgray",
"      % Draw the diamond.",
"      newpath xc r sub yc moveto",
"      xc yc r add lineto",
"      xc r add yc lineto",
"      xc yc r sub lineto",
"      xc r sub yc lineto closepath",
"      stroke",
"      %Blank the text area.",
"      /twdth txtstrng stringwidth pop def",
"      /thwdth twdth .5 mul def",
"      xc thwdth sub",
"      yc chht .35 mul sub",
"      moveto",
"      0 chht .77 mul rlineto",
"      twdth 0 rlineto",
"      0 chht -.77 mul rlineto",
"      1 setgray fill 0 setgray",
"      % Find text position.",
"      xc thwdth sub",
"      yc chht .1 mul sub",
"      moveto",
"      txtstrng show",
"   end",
"} def",
"/Dmd2Dict 8 dict def",
"/dmnd2txt {",
"   % Diamond with 2 lines of text.  Arguments are x-center, y-center,",
"   % radius, text string 1, text string 2: xc yc r (txtstrng1) (txtstrng2)",
"   Dmd2Dict begin",
"      /txt2 exch def",
"      /txt1 exch def",
"      /r exch def",
"      /yc exch def /xc exch def",
"      % Was .031",
"      /chht .037 def",
"      % Blank the diamond.",
"      newpath xc r sub yc moveto",
"      xc yc r add lineto",
"      xc r add yc lineto",
"      xc yc r sub lineto",
"      xc r sub yc lineto closepath",
"      1 setgray fill 0 setgray",
"      % Draw the diamond.",
"      newpath xc r sub yc moveto",
"      xc yc r add lineto",
"      xc r add yc lineto",
"      xc yc r sub lineto",
"      xc r sub yc lineto closepath",
"      stroke",
"      % Blank the first string's text area,",
"      % (twdth=text width, thwdth=text half width)",
"      /twdth txt1 stringwidth pop def",
"      /thwdth twdth .5 mul def",
"      xc thwdth sub",
"      yc chht .05 mul sub",
"      moveto",
"      0 chht .65 mul rlineto",
"      twdth 0 rlineto",
"      0 chht -.65 mul rlineto",
"      1 setgray fill 0 setgray",
"      % Find text position 1 and write it.",
"      xc thwdth sub",
"      yc chht .10 mul add",
"      moveto",
"      txt1 show",
"      % Blank the second string's text area",
"      /twdth txt2 stringwidth pop def",
"      /thwdth twdth .5 mul def",
"      xc thwdth sub",
"      yc chht .50 mul sub",
"      moveto",
"      0 chht .40 mul rlineto",
"      twdth 0 rlineto",
"      0 chht -.45 mul rlineto",
"      1 setgray fill 0 setgray",
"      % Find text position 2 and write it.",
"      xc thwdth sub",
"      yc chht .60 mul sub",
"      moveto",
"      txt2 show",
"   end",
"} def",
"%%EndProcSet",
"%Example commands",
"%500 500 scale",
"%.01 .01 translate",
"%/Times-Roman findfont",
"%.04 scalefont setfont",
"%grid",
"%.002 setlinewidth",
"%.2 .3 .5 1 3 .5 .5 .2 barplot",
"%.8 .1 .1 1 3",
"%.3 .3 .4 1 3",
"%.2 .3 .5 1 3",
"%(parent lab 1)",
"%(parent lab 2)",
"%(parent lab 3)",
"%3 .25 .1 mlplts1p",
"%showpage",
"%End of example commands",
"%%Trailer",
"%%EOF"
};

/*
fleopen_(3, "pslib.ps", 'r');
fleopen_(4, "dum.ps", 'w');
for (;;) {
   if (fgetline_(3) == null) break;
   fprintf_(4,"\"" + strng + "\",");
}
fclose_(3, 'r');
fclose_(4, 'w');
iderr_("in pslib_()");
*/

i = -1;
do {
   ++i;
   fprintf_(flenm, pslib[i]);
} while (!pslib[i].equals("%%EndProcSet"));
}
}
