class Plotutils extends Plot {
static boolean use_endy = false;

static char plotsymbol[] = new char[10];

static String graphcmds[] = new String[1000];
static String dumstrng[] = new String[NMBARS];

static int nmcmds, smallcharsize = 9, largecharsize = 13;

static int indx[] = new int[NMBARS];
static int nmpts[] = new int[1000];

static double haxisspace = .1, vaxisspace = .075, vaxis = -1.,
   beginy = 0., endy = 0.;

static double xshift[] = new double[TNMIDS];
static double yshift[] = new double[TNMIDS];
static double xmins[] = new double[TNMIDS + MAXNMECO];
static double xmaxs[] = new double[TNMIDS + MAXNMECO];
static double ymins[] = new double[TNMIDS + MAXNMECO];
static double ymaxs[] = new double[TNMIDS + MAXNMECO];
static double bar[] = new double[NMBARS];
static float line_pt[][][] = new float[3][1000][2];

// ------------------------------------------------------------------------

static void pltgrid_(int flenm, double xshft, double yshft, double xscale,
   double yscale) {

/* Creates a labeled grid on the plotting surface of out.dig for subsequent
   identification of annotation string locations. */

int i, nmlnes;
double x, y, inc;

nmlnes = 30;
inc = 1. / (double) nmlnes;

// Plot horizontal lines.

y = 0.;
for (i = 0; i < nmlnes; ++i) {
   x = .05;
   y += inc;
   wrtecmd_(flenm,"GRTEXT " + x + " " + y + " " + ((y - yshft) / yscale));
   wrtecmd_(flenm,"MOVETO " + x + " " + y);
   wrtecmd_(flenm,"LINETO 1. " + y + " s");
}

// Plot vertical lines.

x = 0.;
for (i = 0; i < nmlnes; ++i) {
   x += inc;
   y = .05;
   wrtecmd_(flenm,"GRTEXT " + x + " " + y + " " + ((x - xshft) / xscale));
   wrtecmd_(flenm,"MOVETO " + x + " " + y);
   wrtecmd_(flenm,"LINETO " + x + " 1. s");
}
}

// -----------------------------------------------------------------------

static void pltscat_(int flenm, int nmsingles, float singleton[][],
   char singsym[], int nmlines, int nmpts[], float line_pt[][][],
   char symbol[][], String title[], String linelbl[], String xlab,
   String ylab, boolean nominaly, String nomlab[], int nmticlines,
   String nomlab2[], double xscale, double yscale, double xshift,
   double yshift, int nmbars, double bar[], int linetype[],
   double beginx, double endx) {

/* Writes a .dig file of a plot of the "nmlines" lines defined by the
   "nmpts" points in the array "line_pt" where the j^th point in the
   i^th line is stored in;
   "line_pt[i][j][0]" = x, and
   "line_pt[i][j][1]" = y.
   The plotting region is always 1 by 1.

   Symbols have been assigned to points in the calling program.
*/

boolean firstpoint = false, plottic = true;

char pltsym = 'X';

String ticlab, pltstrng = "nosymbol", symbolcolor = "black";

int i, j, lnetype = 0, nmpoints = 0, ylength, nmout = 0, charpts,
   lbllgth = 120, nmtics = 0, nmskip = 0, nmyskip = 0, nmlinepoints,
   nmskipped = 0;

double xval = 0., yval = 0., xpos, ypos, val, haxis, realval, ri, charsize,
   xmin = 1.e30, xmax = -1.e30, ymin = 1.e30, ymax = -1.e30, ticlbllngth,
   maxlngth = 0., charwidth, ticlngth = 0., lastypos = -1., xval0 = 0.,
   yval0 = 0.;

// Initialize the number of commands in the device-independent file.

nmcmds = 0;

// Draw a box around the entire plot and write Bounding Box information.

wrtecmd_(flenm, "MOVETO " + xshift + " " + yshift);
wrtecmd_(flenm, "LINETO " + (xshift + xscale) + " " + yshift);
wrtecmd_(flenm, "LINETO " + (xshift + xscale) + " " + (yshift + yscale));
wrtecmd_(flenm, "LINETO " + xshift + " " + (yshift + yscale));
wrtecmd_(flenm, "LINETO " + xshift + " " + yshift);

Pltpost.xmin = xshift;
Pltpost.ymin = yshift;
Pltpost.xmax = xshift + xscale;
Pltpost.ymax = yshift + yscale;

// Discover minimums and maximums.

for (i = 0; i < nmsingles; ++i) {
      
   // Quit if any point is too extreme.

   if (Math.abs(singleton[i][1]) > 1.e10) {
      iderr_("pltscat: i= " + i + " singleton yval= " + singleton[i][1]);
   }

   if ((double) singleton[i][0] < xmin) {
      xmin = (double) singleton[i][0];
   }
   if ((double) singleton[i][1] < ymin) {
      ymin = (double) singleton[i][1];
   }
   if (xmax < (double) singleton[i][0]) {
      xmax = (double) singleton[i][0];
   }
   if (ymax < (double) singleton[i][1]) {
      ymax = (double) singleton[i][1];
   }
}

printf_("pltscat: after singletons, ymax= " + ymax);

for (i = 0; i < nmlines; ++i) {
   for (j = 0; j < nmpts[i]; ++j) {

      // Quit if any point is too extreme.

      if (Math.abs(line_pt[i][j][1]) > 1.e10) {
	 iderr_("pltscat: i= " + i + " j= " + j + " line_pty= " +
	    line_pt[i][j][1]);
      }

      if ((double) line_pt[i][j][0] < xmin) {
	 xmin = (double) line_pt[i][j][0];
      }
      if ((double) line_pt[i][j][1] < ymin) {
	 ymin = (double) line_pt[i][j][1];
      }
      if (xmax < (double) line_pt[i][j][0]) {
	 xmax = (double) line_pt[i][j][0];
      }
      if (ymax < (double) line_pt[i][j][1]) {
	 ymax = (double) line_pt[i][j][1];
      }
   }
}

printf_("pltscat: after curves, ymax= " + ymax + " beginy= " + beginy +
   " endy= " + endy);

// Force desired x and/or y-axis limits.

if (beginx < endx) {
   xmin = beginx;
   xmax = endx;
}

if (use_endy && !nominaly && beginy < endy) {
   ymin = beginy;
   ymax = endy;
   printf_("pltscat: !!NEW ymax=endy= " + ymax);
}

if (ymax == 1.0) {
   ymin = 0.;
}

// Quit if minimums and maximums are not valid.

if (Math.abs(xmax - xmin) < 1.e-6) {
   iderr_("pltscat: xmin equals xmax");
}
if (Math.abs(ymax - ymin) < 1.e-6) {
   printf_("pltscat: ymin equals ymax, re-setting...");
   ymax = ymin + 1.e-4;
}
ymax *= 1.1;
printf_("pltscat: Final ymin= " + ymin + " ymax= " + ymax);

if (vaxis < 0.) {

   // Scale character sizes.

   smallcharsize = (int) (1.2 * yscale * ((double) smallcharsize));
   largecharsize = (int) (1.2 * yscale * ((double) largecharsize));
}

// Set small text size just to figure out vertical axis position.

smallcharsize = 8;
largecharsize = 8;
charpts = smallcharsize;
charsize = ((double) charpts) / 450.;
charwidth = .5 * charsize;
haxisspace = 2.1 * charsize;

/* Compute (or retain) vertical axis offset.  Also compute the
   horizontal axis offset. */

if (nominaly) {
   for (i = 0; i < (int) ymax; ++i) {
      if (nomlab[i] != null) {
         nomlab[i] = nomlab[i].trim();
      
      } else {
         nomlab[i] = "noplot";
      }

      ticlbllngth = (double) nomlab[i].length();
      if (maxlngth < ticlbllngth) {
	 maxlngth = ticlbllngth;
      }
   }
   printf_("pltscat: maxlngth= " + maxlngth);

   if (vaxis < 0.) {
      vaxisspace = (maxlngth + 2.) * charwidth;
      vaxis = xshift + vaxisspace;
   }

} else {
   if (vaxis < 0.) {
      vaxis = xshift + vaxisspace * xscale;
   }
}

haxis =  yshift + haxisspace;

// Draw axes.

// wrtecmd_(flenm, "SETLINEWIDTH .004");
wrtecmd_(flenm, "MOVETO " + vaxis + " " + (1.0 * yscale + yshift));
wrtecmd_(flenm, "LINETO " + vaxis + " " + haxis);
wrtecmd_(flenm, "LINETO " + (1.0 * xscale + xshift) + " " + haxis);

// Set large text size.

charpts = largecharsize;
charsize = ((double) charpts) / 450.;
charwidth = .5 * charsize;
wrtecmd_(flenm, "SETCHARSIZE " + charpts);

/* Reduce scales due to the reduction that resulted in the creation of
   haxis, vaxis, above. */

xscale *= ((xshift + xscale) - vaxisspace) / 1.05;
yscale *= (yscale - charsize - haxisspace) / yscale;
yscale /= 1.05;

// Write title(s).

xpos = vaxis + .15 * xscale; // was .35
ypos = Pltpost.ymax - charsize;
if (title[0] != null) {
   wrtecmd_(flenm, "GRTEXT " + xpos + " " + ypos + " " + title[0]);
}

if (title[1] != null) {

   /* Write second line of title as (possibly) two lines each of less
      than 60 characters. */

   xpos = vaxis + .15 * xscale; // was .35
   ypos -= charsize;
   if (title[1].length() <= lbllgth) {
      wrtecmd_(flenm, "GRTEXT " + xpos + " " + ypos + " " + title[1]);

   } else {
      wrtecmd_(flenm, "GRTEXT " + xpos + " " + ypos + " " +
	 title[1].substring(0, lbllgth - 1));

      ypos -= charsize;
      wrtecmd_(flenm, "GRTEXT " + xpos + " " + ypos + " " +
         title[1].substring(lbllgth,
			  Math.min(2 * lbllgth + 1, title[1].length())));
   }
}

// Set text size smaller for rest of plot.

charpts = smallcharsize;
wrtecmd_(flenm, "SETCHARSIZE " + charpts);
charsize = ((double) charpts) / 450.;
charwidth = .5 * charsize;

if (linelbl[0] != null) {

   // Write any line symbol labels.

   realval = (double) nmlines;
   xpos = vaxis + .01 * xscale;
   for (i = 0; i < nmlines; ++i) {
      ypos -= charsize;
      wrtecmd_(flenm, "GRTEXT " + xpos + " " + ypos + " " +
	 symbol[i][0] + ":_" + linelbl[i]);
   }
}

// Write y-axis title.

if (!nominaly && !ylab.equals("noplot")) {
   if (ymax < .01) {
      ylab += "_x1000";
   }
   ylength = ylab.length();
   if (ylength < 6) {
      wrtecmd_(flenm, "GRTEXT " + (xshift + .01 * xscale) + " " +
         (.9 * yscale + yshift) + " " + ylab);

   } else if (ylength >= 6) {

      // Print y-axis label vertically if it is more than 6 characters long.

      xpos = .6 * vaxisspace + charsize;
      wrtecmd_(flenm, "VGRTEXT " + (xpos) + " " +
         (.4 * yscale + yshift) + " " + ylab);
   }
}

// x-axis tic marks and tic labels.

for (i = 0; i <= 4; ++i) {
   ri = (double) i;
   xpos = vaxis + xscale * ri / 4.;
   ypos = haxis;
   wrtecmd_(flenm, "MOVETO " + xpos + " " + ypos);
   ypos = haxis - .75 * charsize;
   wrtecmd_(flenm, "LINETO " + xpos + " " + ypos);

   val = xmin + (xmax - xmin) * ri / 4.;
   if (Math.abs(val) < 1.) {
      ticlab = fdble_(val, 3, 3);

   } else if (1. <= Math.abs(val) && Math.abs(val) < 100.) {
      ticlab = fdble_(val, 4, 2);

   } else {
      ticlab = "_" + fdble_(val, 6, 2);
   }

   ticlbllngth = (double) ticlab.length();

   xpos -= (.6 * ticlbllngth) * charwidth;

   ypos -= 1.0 * charsize;
   ypos = Math.max(ypos, yshift);
   wrtecmd_(flenm, "GRTEXT " + xpos + " " + ypos + " " + ticlab);

   // Write x-axis label to the right of the 2nd x-axis tic.
   
   if (i == 1) {
      xpos += (ticlbllngth + 2.5) * charwidth;
      ypos = haxis - 1.75 * charsize;
      wrtecmd_(flenm, "GRTEXT " + xpos + " " + ypos + " " + xlab);
   }
}

// y-axis tic marks and tic labels.

if (!nominaly) {
   nmtics = 5;

} else {
   nmtics = (int) ymax;
}

if (nmticlines == 2) {
	
   /* For two lines per tic, find "nmyskip" so that at most 15 tics are
      labeled. */

   nmyskip = Math.max((nmtics / 15), 1) - 1;
   if (nmtics / (nmyskip + 1) > 20) {
      ++nmyskip;
   }

} else {
   nmyskip = Math.max((nmtics / 30), 1) - 1;
}

printf_("pltscat: nmticlines= " + nmticlines + " nmtics= " + nmtics +
   " nmyskip= " + nmyskip);

nmskipped = 0;
for (i = 1; i <= nmtics; ++i) {
   ri = (double) (i - 1);
   xpos = vaxis;
   val = ymin + (ymax - ymin) * ri / ((double) (nmtics - 1));
   if (!nominaly) {
      ypos = haxis + yscale * (val - ymin) / (ymax - ymin);

   } else {
      ypos = (haxis + 1.2 * charwidth) + yscale * ri / (ymax - ymin);
   }

   // Write every "nmyskip" labels.
   
   if (nmskipped < nmyskip) {
      ++nmskipped;
      plottic = false;

   } else {
      nmskipped = 0;
      plottic = true;
   }

   // Draw y-axis tic mark.

   if (plottic) {
      wrtecmd_(flenm, "MOVETO " + xpos + " " + ypos);
      ticlngth = Math.max(.004, .002 * Math.min(xscale, yscale));
      xpos = vaxis - ticlngth;

      wrtecmd_(flenm, "LINETO " + xpos + " " + ypos);
   }

   // Create y-axis tic label.
   
   if (!nominaly) {
      if (Math.abs(ymax) < .01) {
         val *= 1000.;
         ticlab = fdble_(val, 2, 1);
         maxlngth = 5;

      } else if (Math.abs(val) < 1.) {
         ticlab = fdble_(val, 2, 2);
         maxlngth = 6;

      } else if (1. <= Math.abs(val) && Math.abs(val) < 100.) {
         ticlab = fdble_(val, 4, 2);
         maxlngth = 7;

      } else {
	 val = Math.rint(val);
         ticlab = fdble_(val, 5, 1);
         maxlngth = 7;
      }
      if (ticlab != null) {
         ticlab = ticlab.trim();
      
      } else {
         ticlab = "noplot";
      }

   } else {
      ticlab = nomlab[i - 1];
   }

   // Draw tic label.
   
   if (nominaly) {
      xpos = vaxis - ticlngth - (maxlngth * charwidth);

   } else {
      xpos = vaxis - ticlngth - ((maxlngth - .5) * charwidth);
   }

   ypos -= charwidth / 2.;
   if (!ticlab.equals("noplot") && plottic) {
      wrtecmd_(flenm, "GRTEXT " + xpos + " " + ypos + " " + ticlab);

      if (nominaly && nmticlines == 2) {
         if (nmtics > 5) {
            ypos -= 0.9 * charsize; // was .9

	 } else {
	    ypos -= 1.8 * charwidth;
	 }
         wrtecmd_(flenm, "GRTEXT " + xpos + " " + ypos + " " +
            nomlab2[i - 1]);
      }
      lastypos = ypos;
   }
}

// Draw any vertical bars.

for (i = 0; i < nmbars; ++i) {
   xpos = xscale * ((bar[i] - xmin) / (xmax - xmin)) + xshift;
   wrtecmd_(flenm, "MOVETO " + xpos + " " + haxis);
   wrtecmd_(flenm, "LINETO " + xpos + " " + (1.0 * yscale + yshift));
}

if (xlab.equals("Zscore") || xlab.equals("Half-zscore")) {

   // Draw the one-to-one line for a normal probability plot. 

   xval = Math.max(xmin, ymin);
   xpos = vaxis + xscale * ((xval - xmin) / (xmax - xmin));

   ypos = haxis + yscale * ((xval - ymin) / (ymax - ymin));
   wrtecmd_(flenm, "MOVETO " + xpos + " " + ypos);

   xval = Math.min(xmax, ymax);
   xpos = vaxis + xscale * ((xval - xmin) / (xmax - xmin));

   ypos = haxis + yscale * ((xval - ymin) / (ymax - ymin));
   wrtecmd_(flenm, "LINETO " + xpos + " " + ypos);
}

// Plot points.

charpts = 8;
wrtecmd_(flenm, "SETCHARSIZE " + charpts);
for (i = 0; i < nmsingles; ++i) {
   pltsym = singsym[i];

   // Convert special characters.
      
   if (pltsym == '#') {
      pltstrng = "numbersign";

   } else if (pltsym == '-') {
      pltstrng = "hyphen";

   } else if (pltsym == '_') {
      pltstrng = "underscore";

   } else if (pltsym == '+') {
      pltstrng = "plus";

   } else if (pltsym == '&') {
      pltstrng = "ampersand";

   } else if (pltsym == '=') {
      pltstrng = "equal";

   } else if (pltsym == '*') {
      pltstrng = "asterisk";

   } else if (pltsym == '@') {
      pltstrng = "at";

   } else {
      pltstrng = Character.toString(pltsym);
   }

   lnetype = 0;
   nmpoints = 1;
   xval = (double) singleton[i][0];
   yval = (double) singleton[i][1];
   if (xval < xmin || xmax < xval || yval < ymin || ymax < yval) {
      printf_("pltscat: ymin= " + ymin + " yval= " + yval + " ymax= " +
         ymax + " skipping this singleton.");
      continue;
   }
   xpos = vaxis + xscale * ((xval - xmin) / (xmax - xmin));
   ypos = (haxis + 1.2 * charwidth) +
	     yscale * ((yval - ymin) / (ymax - ymin));

   wrtecmd_(flenm, "CGRTEXT " + xpos + " " + ypos + " " + pltstrng);
}

/* Draw lines.  First, set the number of points to skip before plotting
   a symbol. */

if (!nominaly) {
   nmskip = 5;
}

printf_("pltscat: nmlines= " + nmlines);
for (i = 0; i < nmlines; ++i) {
   lnetype = linetype[i];
   nmpoints = nmpts[i];

   /*
   printf_("pltscat: i= " + i + " lnetype= " + lnetype + " nmpoints= " +
      nmpoints);
   */

   if (nmpoints <= 0) {
      printf_("pltscat: i= " + i + " nmpoints= " + nmpoints);
      continue;
   }

   // Set line type: 0=none, 1=solid, 2=dashed.

   if (lnetype == 1) {
      wrtecmd_(flenm, "SOLID");
   
   } else if (lnetype == 2) {
      wrtecmd_(flenm, "SETDASH");
   }

   // Draw this line.
 
   firstpoint = true;
   nmlinepoints = nmskip;
   for (j = 0; j < nmpoints; ++j) {
      pltsym = symbol[i][j];

      // Convert special characters.
      
      if (pltsym == '#') {
         pltstrng = "numbersign";

      } else if (pltsym == '-') {
         pltstrng = "hyphen";

      } else if (pltsym == '_') {
         pltstrng = "underscore";

      } else if (pltsym == '+') {
         pltstrng = "plus";

      } else if (pltsym == '&') {
         pltstrng = "ampersand";

      } else if (pltsym == '=') {
         pltstrng = "equal";

      } else if (pltsym == '*') {
         pltstrng = "asterisk";

      } else if (pltsym == '@') {
         pltstrng = "at";

      } else {
         pltstrng = Character.toString(pltsym);
      }

      // Color certain symbols.

      if (pltstrng.indexOf("X") >= 0) {
         symbolcolor = "green";

      } else {
         symbolcolor = "black";
      }

      xval = (double) line_pt[i][j][0];
      yval = (double) line_pt[i][j][1];
 
      // Compute position of point to be plotted.

      if (j > 0 &&
          Math.abs(xval - xval0) < 1.e-6 &&
          Math.abs(yval - yval0) > 1.e-6) {
         printf_("pltscat: xval= " + xval + " yval= " + yval +
            " yval0= " + yval0);
      }

      // Don't plot points that are outside the plotting interval.

      if (yval < ymin || ymax < yval) {
         ++nmout;
         printf_("pltscat: lines ymin= " + ymin + " yval= " + yval +
            " ymax= " + ymax + " skipping.");
	 continue;
      }

      xpos = vaxis + xscale * ((xval - xmin) / (xmax - xmin));
      ypos = (haxis + 1.2 * charwidth) +
	        yscale * ((yval - ymin) / (ymax - ymin));

      if (firstpoint) {
	 xval0 = xval;
	 yval0 = yval;
         wrtecmd_(flenm, "MOVETO " + xpos + " " + ypos);
      }
      firstpoint = false;

      if (lnetype == 1 || lnetype == 2) {

         // Connected dot plot.  First, draw line.

         if (j > 0) {
	    wrtecmd_(flenm, "LINETO " + xpos + " " + ypos);
         }

	 // Draw plot symbol every "nmskip" points.
	 
	 if (j == 0 || j == nmpoints - 1 || nmlinepoints == nmskip) {
            if (symbolcolor.equals("black")) {
               wrtecmd_(flenm, "CGRTEXT " + xpos + " " + ypos + " " +
                  pltstrng);

	    } else {
               wrtecmd_(flenm, "SETCOLOR" + " " + symbolcolor);
               wrtecmd_(flenm, "CGRTEXT " + xpos + " " + ypos + " " +
                  pltstrng);
               wrtecmd_(flenm, "SETCOLOR black");
	    }
            nmlinepoints = 0;

	 } else {
            ++nmlinepoints;
         }

      } else if (lnetype == 0) {
	    
         // Unconnected dot plot.
	    
	 if (Math.abs(xval - xmin) < 1.e-6) {
            xpos += .001;
	 }
	 if (Math.abs(yval - ymin) < 1.e-6) {
            ypos += .001;
	 }

         if (symbolcolor.equals("black")) {
            wrtecmd_(flenm, "CGRTEXT " + xpos + " " + ypos + " " +
               pltstrng);
	    
         } else {
            wrtecmd_(flenm, "SETCOLOR" + " " + symbolcolor);
            wrtecmd_(flenm, "CGRTEXT " + xpos + " " + ypos + " " +
               pltstrng);
            wrtecmd_(flenm, "SETCOLOR black");
         }
      }
   }
}

if (nmout > 0) {

   // Print number of points out of plotting region.

   printf_("pltscat: number of points outside plotting region= " + nmout);
}
}

// -----------------------------------------------------------------------

static void pltbar_(int flenm, int n, String cat[], int intbar[],
   String title1, String title2, String xlab, double xscale,
   double yscale, double xshift, double yshift) {

/* Writes a .dig file of the horizontal bar plot of the n bar heights
   (stored in "bar") against the "cat" categories.  Note, the 
   plotting region is always 1 by 1.  Plots only the first 10 longest
   bars. */

String ticlab, substrng;

int i, j, charpts, ticlbllngth, nmbars;

double xpos, ypos, val, haxis, vaxis, ri, charsize, barmin = 1.e30,
   barmax = -1.e30, ticval, fraction;

// Convert integer bar counts to real numbers.

for (i = 0; i < n; ++i) {
   bar[i] = (double) intbar[i];
}

// Draw a box around the entire plot.

wrtecmd_(flenm, "SOLID");
wrtecmd_(flenm, "MOVETO " + xshift + " " + yshift);
wrtecmd_(flenm, "LINETO " + (xshift + xscale) + " " + yshift);
wrtecmd_(flenm, "LINETO " + (xshift + xscale) + " " + (yshift + yscale));
wrtecmd_(flenm, "LINETO " + xshift + " " + (yshift + yscale));
wrtecmd_(flenm, "LINETO " + xshift + " " + yshift);

// Draw axes.

vaxis = xshift + .3 * xscale;
haxis = yshift + .15 * yscale;
// wrtecmd_(flenm, "SETLINEWIDTH .004");
wrtecmd_(flenm, "MOVETO " + vaxis + " " + (1.0 * yscale + yshift));
wrtecmd_(flenm, "LINETO " + vaxis + " " + haxis);
wrtecmd_(flenm, "LINETO " + (1.0 * xscale + xshift) + " " + haxis);

// Set text size.

charpts = (int) (60. * Math.min(xscale, yscale));
if (charpts > 12) {
   charpts = 12;
}
wrtecmd_(flenm, "SETCHARSIZE " + charpts);
charsize = ((double) charpts) / 450.;

// Write titles.

xpos = vaxis + .20 * xscale;
ypos = (yscale + yshift) - charsize;
if (title1 != null) {
   wrtecmd_(flenm, "GRTEXT " + xpos + " " + ypos + " " + title1);
}

if (title2 != null) {
   xpos = vaxis + .20 * xscale;
   ypos -= charsize;
   wrtecmd_(flenm, "GRTEXT " + xpos + " " + ypos + " " + title2);
}

// Set text size smaller for rest of plot.

charpts = (int) (20. * Math.min(xscale, yscale));
if (charpts > 8) {
   charpts = 8;
}
wrtecmd_(flenm, "SETCHARSIZE " + charpts);
charsize = ((double) charpts) / 450.;

// Write bar length (x-axis) title.

wrtecmd_(flenm, "GRTEXT " + (vaxis + .25 * xscale) + " " +
   (haxis - .1 * yscale) + " " + xlab);

// Give up if n < 1 or > NMBARS.

if (n < 1 || n > NMBARS) {
   iderr_("pltbar: number of bars (n)= " + n);
}

// Sort bars and get max, min.

for (i = 1; i <= n; ++i) {
   indx[i - 1] = i;
}
Idsort.idsort_(bar, indx, 1, n);

// Find the smallest bar height - 1.  Also find the largest bar height.

barmin = bar[0] - 1.;
barmax = bar[n - 1];

if (Math.abs(barmax - barmin) < 1.e-6) {
   barmax = barmin + 1.;
}

// Carry-along bar labels.

for (i = 0; i < n; ++i) {
   cat[i] = strngsub_(cat[i], "-", "xzx");
   cat[i] = strngsub_(cat[i], "_", "yzy");
   dumstrng[i] = cat[i];
}
for (i = 0; i < n; ++i) {
   cat[i] = dumstrng[indx[i] - 1];
}

// Adjust scales.

xscale *= 1. - vaxis / (xshift + xscale);
yscale *= 1. - haxis / (yshift + yscale);

// Draw x-axis labels and tic marks.

for (i = 0; i <= 4; ++i) {
   ri = (double) i;
   fraction = (double) ((int) ((barmax - barmin) * ri / 4.));

   // x-axis tic label.  Don't write tic labels that are less than 1.

   ticval = barmin + fraction;
   ticlab = fdble_(ticval, 5, 2);
   ticlbllngth = ticlab.length();

   // x-axis tic marks and tic labels.

   if (ticval >= 1.) {
      xpos = vaxis + xscale * fraction / (barmax - barmin);
      ypos = haxis;
      wrtecmd_(flenm, "MOVETO " + xpos + " " + ypos);
      ypos = haxis - .03 * yscale;
      wrtecmd_(flenm, "LINETO " + xpos + " " + ypos);

      ypos -= charsize;
      wrtecmd_(flenm, "GRTEXT " + xpos + " " + ypos + " " + ticlab);
   }
}

// Plot no more than the first 10 longest bars.

ticlbllngth = 28;
nmbars = Math.min(10, n);
for (i = 0; i < nmbars; ++i) {

   ri = (double) i;

   // Write bar label to the left of the y-axis.

   xpos = xshift;
   ypos = (haxis + .005 * yscale) +
      (yscale + yshift) * ri / ((double) nmbars);

   if (cat[(n - 1) - i].length() <= ticlbllngth) {
      wrtecmd_(flenm, "GRTEXT " + xpos + " " + ypos + " " +
	 cat[(n - 1) - i]);

   } else {
      wrtecmd_(flenm, "GRTEXT " + xpos + " " + ypos + " " +
	 cat[(n - 1) - i].substring(0, ticlbllngth));

      ypos -= charsize;
      wrtecmd_(flenm, "GRTEXT " + xpos + " " + ypos + " " +
         cat[(n - 1) - i].substring(ticlbllngth,
            Math.min(2 * ticlbllngth + 1, cat[(n - 1) - i].length())));
      ypos += charsize;
   }

   // Plot the bar.

   xpos = vaxis;
   wrtecmd_(flenm, "MOVETO " + xpos + " " + ypos);

   xpos = (bar[(n - 1) - i] - barmin) / (barmax - barmin);

   xpos = xscale * xpos + vaxis;
   wrtecmd_(flenm, "LINETO " + xpos + " " + ypos);
}
}

// -----------------------------------------------------------------------

static void multplt_(int nmrows, int nmcols, int nmline[], int n[],
   double x[][], double y[][][], boolean autoscale, double xmins[],
   double xmaxs[], double ymins[], double ymaxs[], String title1[],
   String title2[], String xtitle[], String ytitle[], String linelbl[],
   int linetype[]) {

/* Writes a device independent graphics file of multiple, multi-line
   plots on one page. */

int i, j, k, l, pltnm = 0;

double xmin = 0., xmax = 0., ymin = 0., ymax = 0., xscale = 1.,
   yscale = 1., psscale, plotwidth, plotheight;

plotsymbol[0] = 'u';
plotsymbol[1] = 'x';
plotsymbol[2] = 'v';

// Open out.dig file.

fleopen_(6, "out.dig", 'w');

// Set xshift(s), yshift(s), xscale, and yscale.

plotwidth = 1. / (double) nmcols;
for (i = 0; i < nmcols; ++i) {
   xshift[i] = plotwidth * ((double) i);
}
xscale = 1. / (double) nmcols;

plotheight = 1. / (double) nmrows;
for (i = 1; i <= nmrows; ++i) {
   yshift[nmrows - i] = plotheight * (((double) i) - 1.);
}
yscale = 1. / (1.0 * ((double) nmrows));

// Loops for multiple plots.

for (i = 0; i < nmcols; ++i) {
   for (j = 0; j < nmrows; ++j) {
      if (autoscale) {
         xmin = x[pltnm][0];
         xmax = xmin;
         ymin = y[pltnm][0][0];
         ymax = ymin;
         for (l = 0; l < n[pltnm]; ++l) {
            if (x[pltnm][l] < xmin) {
	       xmin = x[pltnm][l];
	    }
            if (x[pltnm][l] > xmax) {
	       xmax = x[pltnm][l];
	    }
         }

      } else {
	 xmin = xmins[pltnm];
	 xmax = xmaxs[pltnm];
      }

      // Loop over multiple lines within a plot.

      for (k = 0; k < nmline[pltnm]; ++k) {

         /* Set line type(s) and find y min, max over all lines in the
	    plot. */

         linetype[k] = 1;

	 if (autoscale) {
            for (l = 0; l < n[pltnm]; ++l) {
	       if (y[pltnm][k][l] < ymin) {
		  ymin = y[pltnm][k][l];
	       }
	       if (y[pltnm][k][l] > ymax) {
		  ymax = y[pltnm][k][l];
	       }
            }
      
         } else {
	    ymin = ymins[pltnm];
	    ymax = ymaxs[pltnm];
	 }
      
	 //  Convert to array acceptable to pltscat_.

         for (l = 0; l < n[pltnm]; ++l) {
            line_pt[k][l][0] = (float) x[pltnm][l];
	    line_pt[k][l][1] = (float) y[pltnm][k][l];
	    symbol[k][l] = plotsymbol[k];
         }
	 nmpts[k] = n[pltnm];
      }
      title[0] = title1[pltnm];
      title[1] = title2[pltnm];

      // Write .dig graphics file.

      pltscat_(6, 0, Displayactions.singleton, Displayactions.singsym,
         nmline[pltnm], nmpts, line_pt, symbol, title, linelbl,
	 xtitle[pltnm], ytitle[pltnm], false, Displayactions.nomlab, 1,
	 Displayactions.nomlab2, xscale, yscale, xshift[i], yshift[j], 0,
	 bar, linetype, xmin, xmax);

      ++pltnm;
   }
}
fclose_(6, 'w');
Pltpost.pltpost_(spacetime_psfle, 1.0); 
}

// ---------------------------------------------------------------------

static void wrtecmd_(int flenm, String strng) {

// Write graphics command.

if (flenm < 1) {
   graphcmds[nmcmds] = strng;
   ++nmcmds;

} else {
   fprintf_(flenm, strng);
}
}
}
