public class PlayerEcoImpacts extends SNA {

/* Runs an IntIDs model repeatedly to find a set of traffickers to detain
   in order to minimize negative impacts on the ecosystem. */

static boolean removednode[] = new boolean[TNMNDS];

static final int loopmax = 1000;

static int m, r, nmnodesmm;

static int x[] = new int[TNMNDS];
static int xtrial[] = new int[TNMNDS];
static int inplayer[] = new int[TNMNDS];
static int removedplayer[] = new int[TNMNDS];
static int swapinplayer[] = new int[10];
static int swapoutplayer[] = new int[10];
static int levelsize[] = new int[4];

static double t_remove = 0., tdelay2 = 0., tdelay3 = 0., tdelay4 = 0.;

static double ecodamage[] = new double[TNMNDS];

// ------------------------------------------------------------------

static double playerEcoImpacts_(int nmnodes) {

/* Computes the impact on the ecosystem of each player that is represented
   by an IntIDs submodel.  Do this by first running the model with all
   players in the model and recording the ecosystem damage metric's value.
   This metric, called "ecodamage" might be for instance, the number of
   poached animals over the modeled time interval.  Then, run the model
   with player i temporarily removed and re-record the value of "ecodamage."
   The damage done by player i is:
    
              ecodamage_i = ecodamage_full - ecodamage_not_i

   A social network is a static data structure.  Measures are computed
   that describe aspects of this structure but the network itself does
   not perform any activities.  A submodel in an IntIDs model, however,
   actually implements the submodel's computed output action by posting it
   to the bulletin board for other submodels to potentially react to.
   Intelligence may exist for some of the players in the WTS network.
   and hence, authorship of some of the observed actions can be ascertained.
   The players responsible for such actions can each be explicitly
   represented as player-submodels that are part of the IntIDs model.
   Other actions do not have a known player.  These actions are modeled as
   being authored by an unknown individual who is a member of an aggregate,
   group submodel appropriate to the action-type.

   For example, if it is not known who committed a poaching action, that
   action is modeled as coming from a poacher-group submodel.

   When the author of an action IS known, the following sequence of steps
   is executed by id:

   1. Represent each observable player as an IntIDs submodel.
   2. Within the IntIDs model, compute ecosystem impacts of each
      of these players using the intridslve_() method.
   3. Finally, simply list in the actionable intelligence report,
      each player's total ecosystem impact.

   Future Work: Data on player-to-player phone calls could be added to the
         actions history used to fit the simulator.  But this could be
         a large amount of data, and each communication would need to be
         timestamped.  If this were done, it would be possible for a
         communication action by one player-submodel to be recognized by
         another player-submodel.  Currently, this type of data is contained
         in the data set used to fit the WTS network alone.

   In the Journal of Cybersecurity article, a method is described wherein
   a particular individual from a trafficker group is selected by computing
   selection probabilities based on the relative size of each player's
   eigenvector centrality.  But identifying an individual based on such
   profiling, is not fair to the selected individual -- and hence could be
   litigated.  At a more theoretical level, there is no published support
   for the hypothesis that players with high eigenvector centrality are
   more likely to poach.  Indeed, such players may be able to find
   lesser-known players to poach in their stead.
*/

int i, j, k;

double ecodamagefull, ecodamage_not_i;

/* Find ecosystem impacts with all trafficker submodels active.  Do this
   by running the IntIDs model over the requested time interval.  First,
   force all submodels to run by zeroing-out their stored in-out pairs. */

for (i = 0; i < nmids; ++i) {
   Intridslve.nminoutpairs[i] = 0;
}

/* Next, call intridslve_(): First call is for setup, second to solve
   for an actions history. */

Intridslve.intridslve_(true, true);
Intridslve.intridslve_(false, true);

// "mdlecoave" dimensions: nmcountries, nmmdltimes, ecosystem node.

ecodamagefull = CA.actnshstry_mdlecoave[0][Intridslve.nmmdltimes - 1][0];

/* Temporarily make each player submodel inactive in order to compute
   ecosystem impacts sans that player's actions. */

for (i = 0; i < nmnodes; ++i) {
   for (j = 0; j < nmids; ++j) {
      if (name[0][i].equals(idPlayerID[j])) {

         // Force this player to be inactive at every time step.

         inactivePlayer[j] = true;

         for (k = 0; k < nmids; ++k) {
            Intridslve.nminoutpairs[k] = 0;
         }
         Intridslve.intridslve_(false, false);
         ecodamage_not_i =
            CA.actnshstry_mdlecoave[0][Intridslve.nmmdltimes - 1][0];
         ecodamage[j] = ecodamagefull - ecodamage_not_i;

         inactivePlayer[j] = false;
      }
   }
}

return (ecodamagefull);
}

// ------------------------------------------------------------------

static void removePlayers_() {

// Randomly select m players for removal.

int i, j, l = 0;

nmnodesmm = nmnodes[0] - m;
if (nmnodesmm < 1) {
   iderr_("removePlayers: nmnodesmm= " + nmnodesmm);
}
printf_("removePlayers: nmnodes= " + nmnodes[0] + " m= " + m + " r= " + r +
   " nmnodesmm= " + nmnodesmm);

for (i = 0; i < nmnodes[0]; ++i) {
   innode[i] = true;
}

for (i = 0; i < m; ++i) {
   for (l = 0; l < loopmax; ++l) {
      j = Rndm.unifint_(0, nmnodes[0]);
      if (innode[j]) {
         innode[j] = false;
         break;
      }
   }
   if (l == loopmax) {
      iderr_("removePlayers: loopmax1 hit");
   }
}
}

// ---------------------------------------------------------------------

static void recruitPlayers_(double recruitrate[]) {

/* Recruits level-i players at the rate of "recruitrate[i - 1]."
   (unfinished). */

}

// --------------------------------------------------------------------

static void optimalRemoval_() {

/* Uses Simulated Annealing to find the set of m players to remove from the
   WTS network that causes the largest reduction in the poaching rate.
   x is a binary vector wherein a "1" means the player is in the network
   and a "0" means the player is removed from the network. */

int i, j, k, mchooser, nsize, chlngt;

double eigencentsum = 0.;

// --------------- Initial solution.  First, remove m players. -------------

/* Find a random set of m players to remove. Use "innodes" to delineate
   this set of players. */

removePlayers_();

/* Next, find the number of ways r players can be chosen from the
   size-m set of randomly removed players ("innode"). */

mchooser = Minmax.nchsk_(m, r);

/* Populate the solution vector with this initial solution of
   "in", and "out" players. */

nsize = nmnodes[0];
for (i = 0; i < nsize; ++i) {
   x[i] = innode[i] == true ? 1 : 0;
}

// ---------------- End of initial solution. -----------------

// "chlngt" is the number of solutions reachable in one "move" step.

chlngt = mchooser * mchooser;

fprintf_(1, "\n------ Optimal Removal of WTS network Players -----" +
   " mchooser= " + mchooser + " nsize= " + nsize + " chlngt= " + chlngt);

Simanel.nofslimit = 500;
Simanel.simanel_(nsize, chlngt, x, 20., 1.e-5, 4);
fprintf_(1, "Optimal Removal Solution" +
   "\n    Player      innode: in-network means innode=1");
for (i = 0; i < nsize; ++i) {
   fprintf_(1, "  " + (i + 1) + "  " + x[i]);
}
}

// --------------------------------------------------------------------

static void swapPlayers_(int n, int x[], int xtrial[]) {

// Swaps r out-players for r in-players.

int i, j = 0, k = 0, l;

for (i = 0; i < n; ++i) {
   xtrial[i] = x[i];
   innode[i] = x[i] == 1 ? true : false;
}

// Load the sets of removed-, and in-players.

for (i = 1; i <= nmnodes[0]; ++i) {
   if (!innode[i - 1]) {
      removedplayer[j] = i;
      ++j;

   } else {
      inplayer[k] = i;
      ++k;
   }
}

// Randomly select r players from the set of m removed-players.

for (i = 0; i < r; ++i) {
   SRCHOUT: for (l = 0; l < loopmax; ++l) {
      j = Rndm.unifint_(0, m);

      // Check for previous selection.

      for (k = 0; k < i; ++k) {
         if (removedplayer[j] == swapinplayer[k]) {
            continue SRCHOUT;
         }
      }
      swapinplayer[i] = removedplayer[j];
      break;
   }
   if (l == loopmax) {
      iderr_("swapplayers: l= " + l + " loopmax1 hit");
   }
}

// Randomly select r in-players from the m-reduced WTS network.

for (i = 0; i < r; ++i) {
   SRCHIN: for (l = 0; l < loopmax; ++l) {
      j = Rndm.unifint_(0, nmnodesmm);

      // Check for previous selection.

      for (k = 0; k < i; ++k) {
         if (inplayer[j] == swapoutplayer[k]) {
            continue SRCHIN;
         }
      }
      swapoutplayer[i] = inplayer[j];
      break;
   }
   if (l == loopmax) {
      iderr_("swapplayers: loopmax2 hit");
   }
}

// Swap these two sets of players and load the solution vector.

j = 0;
k = 0;
nodeloop: for (i = 1; i <= nmnodes[0]; ++i) {
   for (j = 0; j < r; ++j) {
      if (i == swapinplayer[j]) {
         innode[i - 1] = true;
         xtrial[i - 1] = 1;
         continue nodeloop;
      }
   }
   for (j = 0; j < r; ++j) {
      if (i == swapoutplayer[j]) {
         innode[i - 1] = false;
         xtrial[i - 1] = 0;
         continue nodeloop;
      }
   }
}
}

// ------------------------------------------------------------

static double objf_(int n, int x[]) {

/* Compute the average poaching rate under this combination of in-players
   and out-players. */

int i;

double avepch = 0.;

/* Force the out-players to refrain from any actions over the simulation
   time interval. */

//??

// Run the IntIDs model over the time interval.

for (i = 0; i < nmids; ++i) {
   Intridslve.nminoutpairs[i] = 0;
}

Intridslve.intridslve_(false, false);

printf_("PlayerEcoImpacts.objf: x= " + x[0] + " " + x[1] + " " + x[2] +
   " " + x[3] + " " + x[4] + " " + x[5] + " " + x[6] + " " + x[7] +
   " " + x[8] + " " + x[9] + " meankilled= " +
   CA.actnshstry_mdlecoave[0][Intridslve.nmmdltimes][1]);

return (CA.actnshstry_mdlecoave[0][Intridslve.nmmdltimes][1]);
}
}
