class PIBMutils extends PIBMcalcs {

static int indx[] = new int[NMPTCHS];

static double risk[] = new double[NMPTCHS];
static double negrisk[] = new double[NMPTCHS];
static double extinctprob[] = new double[NMPTCHS];

// ---------------------------------------------------------------------

public static void ranchSummary_(int dst) {

// Computes summary statistics.

int i, j, k, l, patchid, dstm1 = dst - 1;

/* Find the mean total number of predators that were killed (poached).
   Remember that the prey is in position 0 of the last dimension of the
   "mdlecoave" array, and the predator is in position 1. */

CA.actnshstry_mdlecoave[0][Intridslve.tindex - 1][1] = 0.;
l = 0;
for (j = 0; j < nmthreads; ++j) {
   for (k = 0; k < idenom[j + 1]; ++k) {
      /*
      printf_("ranchSummary: tindex= " + Intridslve.tindex + " j= " + j +
              " k= " + k);
      */
      CA.actnshstry_mdlecoave[0][Intridslve.tindex - 1][1] +=
         (double) totalkilled[j][k][dstm1];
      ++l;
   }
}
CA.actnshstry_mdlecoave[0][Intridslve.tindex - 1][1] /= (double) l;

// Find mean abundance in each patch.

for (i = 0; i < ttlnmpatches; ++i) {
   meanabundance[i] = 0.;
}

l = 0;
for (j = 1; j <= nmthreads; ++j) {
   for (k = 0; k < idenom[j + 1]; ++k) {
      for (i = 0; i < n[j][k][dstm1]; ++i) {
         patchid = individual_patchident[j][k][i][dstm1];
         ++meanabundance[patchid - 1];
	 /*
         printf_("ranchSummary: patch= " +
                 nodelbls[idnmbrm1][regionnodenumber - 1][patchid] +
                 " abundsum= " + meanabundance[patchid - 1]);
         */
      }
      ++l;
   }
}

for (i = 0; i < ttlnmpatches; ++i) {
   meanabundance[i] /= (double) l;
}
}

// -------------------------------------------------------------

static double computerisk_(double extinctyear, int dst) {

/* Compute extinction risks and the largest extinction probablity over
   the first two ranches. */

int n = 0;

double t = 0., lastt = 0., sum1 = 0., sum2 = 0., discountrate = .035,
   beginyear = 2025., risk1 = 0., risk2 = 0., abund = 0., extinctionprob = -1.;

// Open output files generated by PIBMcalcs.step_().

fleopen_(ecorlztnsflenm, ecorlztnsfle, 'r');
fleopen_(10, riskfle, 'w');

// Toss header line.

fgetline_(ecorlztnsflenm);

do {
   t = fgetdble_(ecorlztnsflenm);

   // Input file needs to have been sorted by time.

   if (t - lastt < 0.) {
      iderr_("computerisk: t= " + t + " lastt= " + lastt +
         " input file not sorted by time");
   }

   // Throw away the realization number.

   fgetint_(ecorlztnsflenm);

   /* Update risk values from a valid realization.  Some of the following
      is from Haas and Ferreira (2016):

      "Say that at $t=0$, the non-use value of the non-extinct species is
      $V_0$.  Under the assumption that this value is constant across
      future time, $L(t_e) = V(t_e - \epsilon) = V_0$ for $t_e \ge \epsilon$.
      If however, future value is discounted ({\em time discounting}),
      $L(t_e) = V_0D(t_e)$ where $D(t)$ is a discounting function.  A
      standard approach to discounting the cost of extinction in the future
      is with an exponential discounting function, $D(t) = (1 - d)^t$ (see
      \cite{Evans13}).  Setting $d = 0.035$ is not unusual.

      A typical definition of {\em risk} used in environmental protection
      is the expected value of loss \cite{Regan13}.  Mathematically,
      $R(t) = E\left[L(t)\right]$.  Because $L(t)$ equals zero if the
      species is not extinct, and takes on a positive value otherwise,

      \begin{equation}
      R(t) = L(t)P(t = t_e).
      \end{equation}

      We use $V_0=1$, $d=0.035$, and extinction probabilities computed from
      our economic-ecological model to compute local extinction risks over
      the period "beginyear" through "extinctyear."" */

   if (t > lastt && n > 0) {
      sum1 /= (double) n;
      risk1 = sum1 * Math.pow((1. - discountrate), (t - beginyear));
      sum2 /= (double) n;
      risk2 = sum2 * Math.pow((1. - discountrate), (t - beginyear));
      fprintf_(5, fdble_(lastt, 8, 3) + " " + fdble_(sum1, 5, 3) + " " +
         fdble_(risk1, 5, 3) + " " + fdble_(sum2, 5, 3) + " " +
	 fdble_(risk2, 5, 3));

      // Compute the largest extinction probability in requested year.

      if (Math.abs((lastt - extinctyear) / extinctyear) < 0.001) {
         extinctionprob = Math.max(sum1, sum2);
      }

      // Re-initialize counters.

      sum1 = 0.;
      sum2 = 0.;
      n = 0;
   }

   /* Less than 3 individuals is not a viable population because in
      the best scenario of 2 individuals, all offspring, if any, would
      be genetically compromised. */

   abund = (double) fgetint_(ecorlztnsflenm);

   if (abund <= 2) {
      sum1 += 1.;
   }
   abund = (double) fgetint_(ecorlztnsflenm);
   if (abund <= 2) {
      sum2 += 1.;
   }
   ++n;
   lastt = t;
} while (!checkbuffeof_(ecorlztnsflenm));

fclose_(ecorlztnsflenm, 'r');
fclose_(10, 'w');

return extinctionprob;
}

// -------------------------------------------------------------

static void computePatchRisk_(double extinctyear, int dst) {

/* Compute per-patch extinction risk and extinction probability at the
   last time point.  Some of the following is from Haas and Ferreira (2016):

   Say that at $t=0$, the non-use value of the non-extinct species is
   $V_0$.  Under the assumption that this value is constant across
   future time, $L(t_e) = V(t_e - \epsilon) = V_0$ for $t_e \ge \epsilon$.
   If however, future value is discounted ({\em time discounting}),
   $L(t_e) = V_0D(t_e)$ where $D(t)$ is a discounting function.  A
   standard approach to discounting the cost of extinction in the future
   is with an exponential discounting function, $D(t) = (1 - d)^t$ (see
   \cite{Evans13}).  Setting $d = 0.035$ is not unusual.

   A typical definition of {\em risk} used in environmental protection
   is the expected value of loss \cite{Regan13}.  Mathematically,
   $R(t) = E\left[L(t)\right]$.  Because $L(t)$ equals zero if the
   species is not extinct, and takes on a positive value otherwise,

   \begin{equation}
   R(t) = L(t)P(t = t_e).
   \end{equation}

   We use $V_0=1$, $d=0.035$, and extinction probabilities computed from
   our economic-ecological model to compute local extinction risks over
   the period "beginyear" through "extinctyear." */

int i, j, k;

double t = 0., abund, discountrate = .035, beginyear = 2025.;

// Check for a region-transfer problem.

if (nodenghs[idnmbrm1][regionnodenumber - 1][0] != ttlnmpatches) {
   iderr_("computePatchRisk: nmregions != ttlnmpatches");
}

// Compute extinction probabilities and extinction risks.

t = beltmept[1]; // Use the first compute-thread.

for (i = 0; i < ttlnmpatches; ++i) {
   for (j = 1; j <= nmthreads; ++j) {
      for (k = 0; k < Conddist.nmthrdloops; ++k) {

         /* Less than 3 individuals is not a viable population because in
            the best scenario of 2 individuals, all offspring, if any, would
            be genetically compromised. */

         abund = (double) npatch[j][k][i][dst - 1];

	 /*
	 printf_("computePatchRisk: patch= " +
                 nodelbls[idnmbrm1][regionnodenumber - 1][i + 1] +
		 " thread= " + j + " path= " + k + " abund= " + abund);
         */

         if (abund <= 2.0) {
            extinctprob[i] += 1.0;
         }
      }
   }

   extinctprob[i] /= (double) Beliefs.enmloops;
   risk[i] = extinctprob[i] * Math.pow((1. - discountrate), (t - beginyear));

   /*
   printf_("computePathRisk: i= " + i + " extinctprob= " + extinctprob[i] +
      " risk= " + risk[i]);
   */
}

/* Perform a descending sort of regions by their extinction risk.  Set regions
   with for-certain extinction probability to zero risk so that they don't
   dominate the sort. */

for (i = 1; i <= ttlnmpatches; ++i) {
   if (extinctprob[i - 1] > 0.9999) {
      risk[i - 1] = 0.0;
   }
   indx[i - 1] = i;
   negrisk[i - 1] = -risk[i - 1];
}

Idsort.idsort_(negrisk, indx, 1, ttlnmpatches);

// Print risk by region.  Also, write a file of this information.

fleopen_(11, "riskbyregion.txt", 'w');
fprintf_(1, "Time point= " + t);
fprintf_(11, "Time point= " + t);
fprintf_(1, "  Patch   Extinction_Prob  Extinction_Risk");
fprintf_(11, "  Patch   Extinction_Prob  Extinction_Risk");

for (i = 0; i < ttlnmpatches; ++i) {
   fprintf_(1, " " + nodelbls[idnmbrm1][regionnodenumber - 1][indx[i]] +
      " & " + fdble_(extinctprob[indx[i] - 1], 5, 3) + " & " +
      fdble_(risk[indx[i] - 1], 5, 3) + " \\\\");

   fprintf_(11, " " + nodelbls[idnmbrm1][regionnodenumber - 1][indx[i]] +
      " & " + fdble_(extinctprob[indx[i] - 1], 5, 3) + " & " +
      fdble_(risk[indx[i] - 1], 5, 3) + " \\\\");
}
fclose_(11, 'w');
}
}
