public class PIBMcalcs extends Ecosyscalcs {

/* Predator Individual-Based Model (PIBM).  Each ranch has a particular
   number of patches.  A ranch is a politically-defined subarea within
   a region. */

static boolean readibmfles = false, suppfeed = false, randompatch = false,
   ranchbasedkilling = false;

static boolean individual_dead[][][][] =
   new boolean[NMTHRDS][ISIMSZE][NMINDIV][2];
static boolean patch_denschange[][][][] =
   new boolean[NMTHRDS][ISIMSZE][NMPTCHS][2];
static boolean patch_foodchange[][][][] =
   new boolean[NMTHRDS][ISIMSZE][NMPTCHS][2];

static String ranchname[] = new String[10];
static String individual_gender[][][][] =
   new String[NMTHRDS][ISIMSZE][NMINDIV][2];
static String individual_movestatus[][][][] = 
   new String[NMTHRDS][ISIMSZE][NMINDIV][2];

static int ttlnmpatches = 0, printcounter = 0, flenm = 4, regionnodenumber,
   nmremovalevents = 0, nmranches = 0, femalesexmaturity, realizid, nallpatches;

static int nmsteps[][][] = new int[NMTHRDS][ISIMSZE][2];
static int le[] = new int[2];
static int interbirth[][][][] = new int[NMTHRDS][ISIMSZE][NMPTCHS][2];
static int ma[][][][] = new int[NMTHRDS][ISIMSZE][NMPTCHS][2];
static int n[][][] = new int[NMTHRDS][ISIMSZE][2];
static int totalkilled[][][] = new int[NMTHRDS][ISIMSZE][2];
static int totaldied[][][] = new int[NMTHRDS][ISIMSZE][2];
static int totalborn[][][] = new int[NMTHRDS][ISIMSZE][2];
static int rchpopsze[][][][] = new int[NMTHRDS][ISIMSZE][NMPTCHS][2];
static int indivpatchassign[] = new int[NMINDIV];
static int individual_patchident[][][][] =
   new int[NMTHRDS][ISIMSZE][NMINDIV][2];
static int individual_age[][][][] =
   new int[NMTHRDS][ISIMSZE][NMINDIV][2];
static int individual_lastpreg[][][][] =
   new int[NMTHRDS][ISIMSZE][NMINDIV][2];
static int subgroupid[][][] = new int[NMTHRDS][ISIMSZE][NMINDIV];
static int oldmaleid[][][] = new int[NMTHRDS][ISIMSZE][NMINDIV];
static int index[][][] = new int[NMTHRDS][ISIMSZE][NMINDIV];

static int nmpatches[] = new int[10]; // Up to 10 ranches.
static int patch_abundance[] = new int[NMPTCHS];
static int patch_ranchid[] = new int[NMPTCHS];
static int patch_nmindiv[][][] = new int[NMTHRDS][ISIMSZE][NMPTCHS];
static int patch_nmmales[][][] = new int[NMTHRDS][ISIMSZE][NMPTCHS];
static int patch_nmfemales[][][] = new int[NMTHRDS][ISIMSZE][NMPTCHS];
static int patch_nmstress[][][] = new int[NMTHRDS][ISIMSZE][NMPTCHS];
static int patch_nmadjacent[] = new int[NMPTCHS];
static int patch_adjptch[][] = new int[NMPTCHS][10];
static int killingpatch[] = new int[NMPTCHS];
static int nmremoved[] = new int[20];

static double oldtimept[] = new double[NMTHRDS];

static double pimport, lasttme = 0., totalarea = 0.;

static double meb[] = new double[2];
static double jeb[] = new double[2];
static double meaneb[] = new double[2];
static double wfi[] = new double[2];
static double sortvec[] = new double[2500];

static int nranch[][][][] = new int[NMTHRDS][ISIMSZE][2][2];
static int npatch[][][][] = new int[NMTHRDS][ISIMSZE][NMPTCHS][2];
static double individual_energy[][][][] =
   new double[NMTHRDS][ISIMSZE][NMINDIV][2];

static double patch_area[] = new double[NMPTCHS];
static double rancharea[] = new double[10];
static double patch_density[][][] =
   new double[NMTHRDS][ISIMSZE][NMPTCHS];
static double patch_prey[][][][] =
   new double[NMTHRDS][ISIMSZE][NMPTCHS][2];

static double meanabundance[] = new double[NMPTCHS];
static double removaldate[] = new double[20];

// -------------------------------------------------------------------

public static void step_(int thrd, double nodevals[][][],
   double yn[][], int dst) {

/* Steps an individual-based population of predators forward one time
   step.  This method is called at time intervals equal to the PIBM's
   step size.  For the cheetah model, this time interval is one week.
   These time points are set when "beltmept" values are updated in
   Conddist.java (see lines 238 and 357).

   Calling this method at intervals other than the PIBM's interval makes
   no sense.
  
   When an IBM is run with an SDE, the "delta" computed in settime_()
   is smaller than "ibmdelta."  Hence, before another IBM step is
   taken, "beltmept" needs to catch up and cover an elapsed time of
   one week before another step is taken.

   The "thrd" value runs from 1 to "nmthreads" (set in Id.java).  The
   "pth" value runs from 1 to "nmthrdloops" (set in Conddist.java). */

boolean p1flag = true, notfound = false;

String manoption = "none", inactor = "none", regionstrng;

String trialregion[] = new String[1];
String regionstring[] = new String[1];

int i, j, k, l, patchid, trialpatchid, nmtrys, nmadjacent, ar = 0, rgn = 0,
   pth, indivnm, oldn, nmnewborns = 0, newn, nmkillregions,
   nmconditions, nold = 0, nprivate, nmstressed = 0, maxstressed = 0,
   nmtooyoung = 0, nmnonres = 0, nmnomales = 0, nmnoenergy = 0,
   nmnotready = 0, ranchtoraid = 0, nmwksleftover = 36, nkill = 0,
   dstm1 = dst - 1;

double unif, preyinpatch = 0., preysum, r, dum, meanenergy = 0.,
   meanprey = 0., meanconsumed = 0., maxvegleftover = 0., deathprb = 0.,
   probreserve = .001, vratio = 0., echange = 0., ageinyears = 0.,
   lastpreginyears = 0., killval = 0.,
   stresseffect1 = 1.0,
   stresseffect2 = 1.0;

// Get sample path.

pth = idenom[thrd];
if (pth > ISIMSZE) {
   iderr_("Pstep: pth= " + pth);
}

// Get reserve probability.

probreserve = .999;

// Get region value, if any.

if (!regionnode.equals("none")) {
   rgn = Getmodlutils.getndnm_(regionnode);
   if (rgn < 1) {
      iderr_("step: no region node.");
   }
   rgnval[thrd] = (int) nodevals[thrd][0][rgn - 1];

} else {
   rgnval[thrd] = 1;
}

// At the first time point only, initialize the model.

if (firsttimepoint[thrd] && initialIntridsTime) {
   initialibm_(thrd, pth, nodevals, dst);
   oldtimept[thrd] = beltmept[thrd];

   return;
}

if (nmids > 1) {
   if (!firsttimepoint[thrd]) {

      /* After first time point, return if compute interval has not elapsed
         yet, i.e., wait for beltmept to get to the next compute time.
         The compute interval is one week: 1/52 = 0.019. */

      if (beltmept[thrd] < oldtimept[thrd] + Ecosyscalcs.ibmdelta) {

         return;

      } else {
         /*
         if (thrd == 2) {
         printf_("step: pth= " + pth + " ibmdelta= " + Ecosyscalcs.ibmdelta +
	    " oldtimept+ibmdelta= " + (oldtimept[thrd] + Ecosyscalcs.ibmdelta) +
	    " beltmept= " + beltmept[thrd]);
         }
         */

         oldtimept[thrd] = beltmept[thrd];
      }
  }

} else {

   /* In an ecosystem-only simulation, use "ibmdelta" to set a new compute time
      for all paths. */

   if (oldtimept[thrd] + Ecosyscalcs.ibmdelta <= beltmept[thrd]) {
      oldtimept[thrd] += Ecosyscalcs.ibmdelta;
   }
}

// Get management option.

i = Getmodlutils.getndnm_("ManOp");
manoption = nodelbls[idnmbrm1][i - 1][(int) condvals[1]];

// Get prey abundance.

preyinpatch = yn[thrd][0] / ((double) ttlnmpatches);
for (i = 0; i < ttlnmpatches; ++i) {
   patch_prey[thrd][pth][i][dstm1] = preyinpatch;
}

// Delete dead individuals from the individual objects list.

i = 0;
while (i < n[thrd][pth][dstm1]) {
   if (individual_dead[thrd][pth][i][dstm1]) {

      if (n[thrd][pth][dstm1] > 0) {
         --n[thrd][pth][dstm1];

      } else {
	 break;
      }

      // Ratchet all objects up one array position.

      for (j = i; j < n[thrd][pth][dstm1]; ++j) {
         individual_patchident[thrd][pth][j][dstm1] =
	    individual_patchident[thrd][pth][j + 1][dstm1];
	 individual_gender[thrd][pth][j][dstm1] =
	    individual_gender[thrd][pth][j + 1][dstm1];
	 individual_age[thrd][pth][j][dstm1] =
	    individual_age[thrd][pth][j + 1][dstm1];
	 individual_lastpreg[thrd][pth][j][dstm1] =
	    individual_lastpreg[thrd][pth][j + 1][dstm1];
	 individual_movestatus[thrd][pth][j][dstm1] =
	    individual_movestatus[thrd][pth][j + 1][dstm1];
	 individual_energy[thrd][pth][j][dstm1] =
	    individual_energy[thrd][pth][j + 1][dstm1];
	 individual_dead[thrd][pth][j][dstm1] =
	    individual_dead[thrd][pth][j + 1][dstm1];
      }

   } else {
      ++i;
   }
}

/*
if (thrd == 1) {
   ++printcounter;
}
if (thrd == 1 && printcounter == 1) { // was 10
   printf_("PIBMcalcs.step: thrd= " + thrd + " pth= " + pth +
      " manoption= " + manoption + " beltmept= " + beltmept[thrd] +
    " yn(2)= " + yn[thrd][1]);
   printcounter = 0;
}
*/

/* Find the number of individuals, adult males, and adult females in
   each patch. */

for (i = 0; i < ttlnmpatches; ++i) {
   patch_nmstress[thrd][pth][i] = 0;
   patch_nmindiv[thrd][pth][i] = 0;
   patch_nmmales[thrd][pth][i] = 0;
   patch_nmfemales[thrd][pth][i] = 0;
   for (j = 0; j < n[thrd][pth][dstm1]; ++j) {
      if (individual_patchident[thrd][pth][j][dstm1] == i + 1) {
         ++patch_nmindiv[thrd][pth][i];
	 if (individual_gender[thrd][pth]
			      [j][dstm1].equals("male") &&
             individual_age[thrd][pth][j][dstm1] >=
	     ma[thrd][pth][i][dstm1]) {
            ++patch_nmmales[thrd][pth][i];
	 
	 } else if (individual_gender[thrd][pth]
			             [j][dstm1].equals("female") &&
             individual_age[thrd][pth][j][dstm1] >=
	     ma[thrd][pth][i][dstm1]) {
            ++patch_nmfemales[thrd][pth][i];
         }
      }
   }
   patch_density[thrd][pth][i] =
      ((double) patch_nmindiv[thrd][pth][i]) / patch_area[i];

   /* If a patch has no females, kill-off all individuals younger than
      one year. */

   if (patch_nmfemales[thrd][pth][i] == 0) {
      for (j = 0; j < n[thrd][pth][dstm1]; ++j) {
         if (individual_patchident[thrd][pth][j][dstm1] == i + 1 &&
            individual_age[thrd][pth][j][dstm1] < 52.) {
            individual_dead[thrd][pth][j][dstm1] = true;
	 }
      }
   }

   /* High density increases female maturation age and interbirth
      interval.  Because these parameters may be different across
      realizations AND persist across time, they are indexed by "thrd"
      and "pth" just like other population-realization variables such
      as "individual_age." */

   if (!patch_denschange[thrd][pth][i][dstm1] &&
       patch_density[thrd][pth][i] > 3.2) {
      ma[thrd][pth][i][dstm1] *= stresseffect1;
      interbirth[thrd][pth][i][dstm1] *= stresseffect1;
      patch_denschange[thrd][pth][i][dstm1] = true;
   
      /*
      if (thrd == 1 && pth == 1) {
         printf_("step: beltmept= " + beltmept[thrd] +
            " density stress effect in patch= " + (i + 1));
      }
      */

   } else if (patch_denschange[thrd][pth][i][dstm1] &&
       patch_density[thrd][pth][i] <= 3.2) {
      ma[thrd][pth][i][dstm1] /= stresseffect1;
      interbirth[thrd][pth][i][dstm1] /= stresseffect1;
      patch_denschange[thrd][pth][i][dstm1] = false;
   }
}

// Increment age of each individual.

for (i = 0; i < n[thrd][pth][dstm1]; ++i) {
   ++individual_age[thrd][pth][i][dstm1];
}

// Update individual energy budgets and death events.

for (i = 0; i < nmranches; ++i) {
   nranch[thrd][pth][i][dstm1] = 0;
}

for (i = 0; i < n[thrd][pth][dstm1]; ++i) {
   patchid = individual_patchident[thrd][pth][i][dstm1];
   if (patchid == 0) {
      printf_("step: thrd= " + thrd + " pth= " + pth);
      iderr_("step: patchid=0, i= " + i + " dst= " + dst);
   }
   ++nranch[thrd][pth][patch_ranchid[patchid - 1] - 1][dstm1];
   vratio = patch_prey[thrd][pth][patchid - 1][dstm1] /
       (wfi[dstm1] * patch_nmindiv[thrd][pth][patchid - 1] + 1.) - 1.;
   vratio *= .9; // was .9, then .01
   echange = 1. / (1. + Math.exp(-vratio));
   echange = 2. * echange - 1.;

   /*
   if (thrd == 1 && pth == 1) {
      printf_("step: patch_prey= " +
         patch_prey[thrd][pth][patchid - 1][dstm1] +
         " wfi= " + wfi[dstm1] +
         " patch_nmindiv= " + patch_nmindiv[thrd][pth][patchid - 1]);
   }
   */

   if (patch_prey[thrd][pth][patchid - 1][dstm1] <
       wfi[dstm1] * patch_nmindiv[thrd][pth][patchid - 1]) {

      /* Food stress processing.  Skip this processing when Ranch 2 is
         providing supplementary feed (when "suppfeed" = true).
         In this case, individuals in ranch 2 are never food-stressed. */

      if (!(patch_ranchid[patchid - 1] == 2 && suppfeed)) {
	 unif = Rndm.rndm1_(thrd, 0);
	 if (unif < .4) { // was .4
            individual_energy[thrd][pth][i][dstm1] += echange;
         }

         if (individual_energy[thrd][pth][i][dstm1] < 0.) {
            individual_energy[thrd][pth][i][dstm1] = 0.;
         }

	 /* Count the number of mature females that experience food
	    stress. */

	 if (individual_gender[thrd][pth]
	                      [i][dstm1].equals("female") &&
             individual_age[thrd][pth][i][dstm1] >
	       ma[thrd][pth][patchid - 1][dstm1]) {
            ++patch_nmstress[thrd][pth][patchid - 1];
         }

         if (thrd == 1 && pth == 1) {
            ++nmstressed;
         }
      }

   } else if ((individual_age[thrd][pth][i][dstm1] >
	       ma[thrd][pth][patchid - 1][dstm1] &&
               individual_energy[thrd][pth][i][dstm1] < meb[dstm1]) ||
              (individual_age[thrd][pth][i][dstm1] <
	       ma[thrd][pth][patchid - 1][dstm1] &&
               individual_energy[thrd][pth][i][dstm1] < jeb[dstm1])) {
      individual_energy[thrd][pth][i][dstm1] += echange;
   }

   // Update old-age, and starvation death events.

   if (individual_age[thrd][pth][i][dstm1] >= le[dstm1]) {
      individual_dead[thrd][pth][i][dstm1] = true;
      ++totaldied[thrd][pth][dstm1];

   } else if (individual_energy[thrd][pth][i][dstm1] <= 0.) {

      // Set probability of death due to zero energy.

      if (individual_age[thrd][pth][i][dstm1] <
          ma[thrd][pth][patchid - 1][dstm1]) {
      
         deathprb = .01; // juveniles starve to death more easily, was .4.

      } else if (individual_gender[thrd][pth]
		                  [i][dstm1].equals("female")) {
	 /*
         deathprb = Math.abs(individual_lastpreg[thrd][pth][i][dstm1]
                       - interbirth[thrd][pth][patchid - 1][dstm1]) /
                    interbirth[thrd][pth][patchid - 1][dstm1];
	 deathprb = .1 * Math.pow(deathprb, 2.);
	 */

	 deathprb = .01; // was .1

      } else {
         deathprb = .01; // was .1
      }

      unif = Rndm.rndm1_(thrd, 0);

      if (unif < deathprb) {
         individual_dead[thrd][pth][i][dstm1] = true;
         ++totaldied[thrd][pth][dstm1];
      }

   } else {
      individual_dead[thrd][pth][i][dstm1] = false;
   }

   // Summary statistics.

   if (thrd == 1 && pth == 1 && patch_ranchid[patchid - 1] != 2) {
      meanenergy += individual_energy[thrd][pth][i][dstm1];
      if (i == 0) {
         meanprey += patch_prey[thrd][pth][patchid - 1][dstm1];
         meanconsumed +=
            wfi[dstm1] * patch_nmindiv[thrd][pth][patchid - 1];
      }
   }
}

/*
if (thrd == 1 && pth == 1) {
   meanenergy /= ((double) (nranch[thrd][pth][0][dstm1] + 1));
   meanprey /= ((double) nmpatches[0]);
   meanconsumed /= ((double) nmpatches[0]);
   
   printf_("step: beltmept= " + fdble_(beltmept[thrd], 8, 2) +
      " nranch1= " + nranch[thrd][pth][0][dstm1] + " meanenergy= " +
      meanenergy + "\n   nmstressed= " + nmstressed + " mncnsmd= " +
      meanconsumed + " meanprey= " + meanprey);
}
*/

/* Increase maturation age and interbirth interval in a patch if the
   proportion of mature females experiencing food stress exceeds 50%. */

for (i = 0; i < ttlnmpatches; ++i) {
   if (patch_nmfemales[thrd][pth][i] > 0) {
      dum = ((double) patch_nmstress[thrd][pth][i]) /
	    ((double) patch_nmfemales[thrd][pth][i]);
   
   } else {
      dum = 0.;
   }

   if (!patch_foodchange[thrd][pth][i][dstm1] && dum > .5) {
      ma[thrd][pth][i][dstm1] *= stresseffect2;
      interbirth[thrd][pth][i][dstm1] *= stresseffect2;
      patch_foodchange[thrd][pth][i][dstm1] = true;

   } else if (patch_foodchange[thrd][pth][i][dstm1] && dum <= .5) {
      ma[thrd][pth][i][dstm1] /= stresseffect2;
      interbirth[thrd][pth][i][dstm1] /= stresseffect2;
      patch_foodchange[thrd][pth][i][dstm1] = false;
   }
}

/* Implement ranch-level management actions.
   1. Process any poaching actions. */

if (manoption.equals("poach_for_food") ||
    manoption.equals("poach_for_protection") ||
    manoption.equals("poach_for_cash")) {

   // For an ecosystem-only run, initialize "ecoinput."

   if (nmids == 1) {
      for (i = 0; i < TNMIDS; ++i) {
         Intridslve.actions_ecoinput[i] = 0.;
      }
      for (i = 0; i < TNMVALS; ++i) {
         Intridslve.actions_ecoinputregion[i] = "none";
      }
   }

   /* Read-in number-poached by the group ID that directed an action
      against the ecosystem at this time point.  Only one action is
      recognized.  Even though this actor is not explicitly given
      to the ecosystem submodel, it uses the only nonzero value
      in "ecoinput" -- and this array is initialized to zero at the
      beginning of each time point. */
   
   killval = 0.;
   for (i = 0; i < nmids - 1; ++i) {
      if (Intridslve.actions_ecoinput[i] > 1.e-6) {
         killval = Intridslve.actions_ecoinput[i];
	 inactor = idname[i];
	 break;
      }
   }
   nkill = (int) Math.round(killval);

   /* Get regions where this killing takes place.  If the region is
      not a member of the the ecosystem submodel's "region" node, a
      a zero will be returned and this region will not be used. */

   regionstring[0] = null;
   nmkillregions = 0;
   for (i = 0; i < TNMVALS; ++i) {
      killingpatch[i] = 0;
      if (Intridslve.actions_ecoinputregion[i] == null) {
         continue;
      }
      if (Intridslve.actions_ecoinputregion[i].equals("none")) {
         continue;
      }

      regionstring[0] = Intridslve.actions_ecoinputregion[i];
      ++nmkillregions;

      // Trim front and back whitespace and convert to lowercase.

      regionstring[0] = regionstring[0].toLowerCase();
      regionstring[0] = regionstring[0].trim();

      for (j = 1; j <= nodenghs[idnmbrm1][regionnodenumber - 1][0]; ++j) {
         trialregion[0] = nodelbls[idnmbrm1][regionnodenumber - 1][j];
	       
	 // Remove country tags.

         trialregion[0] = trialregion[0].replaceAll("k_", "");
         trialregion[0] = trialregion[0].replaceAll("t_", "");

	 // See if a region name is close to the ID's region string value.
	
         if (Textutils.similar_(regionstring, 1, trialregion, 1) > .8) {
            killingpatch[i] = j;
            break;
         }
      }
   }
   if (nmkillregions == 0) {
      iderr_("step: nmkillregions=0");
   }

   if (i < nmids - 1 && nkill > 0) {
      printf_("step: thrd= " + thrd + " pth= " + pth + " inactor= " +
         inactor + " nmpoached= " + nkill + " regionstring= " + regionstring[0]);
   }
   
   /*
   if (thrd == 1) {
      printf_("step: manoption= " + manoption + " beltmept= " +
         beltmept[thrd] + " ecoinput= " + Intridslve.actions_ecoinput[0] +
	 " killval= " + killval + " nkill= " + nkill);
   }
   */

} else {
   nkill = 0;
}

// Kill only if there are animals to kill.

if (nkill > 0 && n[thrd][pth][dstm1] > 0) {
   if (nkill > n[thrd][pth][dstm1]) {
      nkill = n[thrd][pth][dstm1];
   }

   if (ranchbasedkilling) {

      /* Randomly select "nkill" live and mature individuals and kill
         them.  Ranch 1 (the reserve) experiences twice the poaching that the
         private ranches (ranch 2) experience.  First select a ranch
         on which to kill a predator. */

      if (nranch[thrd][pth][1][dstm1] == 0) {
         ranchtoraid = 1;

      } else {
         unif = Rndm.rndm1_(thrd, 0);
         if (unif < probreserve) {
            ranchtoraid = 1;

         } else {
            ranchtoraid = 2;
         }
      }

      i = 0;
      k = 0;
      for (j = 0; j < nkill; ++j) {
         do {
            patchid = individual_patchident[thrd][pth][k][dstm1];
            if (patch_ranchid[patchid - 1] == ranchtoraid &&
                !individual_dead[thrd][pth][k][dstm1] &&
                individual_age[thrd][pth][k][dstm1] >=
	        ma[thrd][pth][patchid - 1][dstm1]) {

               individual_dead[thrd][pth][k][dstm1] = true;

	       ++k;
	       ++i;
	       break;
	    }
	    ++k;
         } while (k < n[thrd][pth][dstm1]);
      }

      // Poach animals on other ranch if necessary.
   
      if (i < nkill) {
         if (ranchtoraid == 1) {
            ranchtoraid = 2;

         } else {
            ranchtoraid = 1;
         }
         k = 0;
         for (j = i; j < nkill; ++j) {
            do {
               patchid = individual_patchident[thrd][pth][k][dstm1];
               if (patch_ranchid[patchid - 1] == ranchtoraid &&
                   !individual_dead[thrd][pth][k][dstm1] &&
                   individual_age[thrd][pth][k][dstm1] >=
	           ma[thrd][pth][patchid - 1][dstm1]) {
                  individual_dead[thrd][pth][k][dstm1] = true;
	          ++k;
	          ++i;
	          break;
	       }
	       ++k;
            } while (k < n[thrd][pth][dstm1]);
         }
      }

   } else {

      // Patch (region)-based killing.
      
      i = 0;
      k = 0;
      for (j = 0; j < nkill; ++j) {
         TRIALPATCHLOOP: do {
            trialpatchid = individual_patchident[thrd][pth][k][dstm1];
	    for (l = 0; l < NMPTCHS; ++l) {
               if (trialpatchid == killingpatch[l] &&
                   !individual_dead[thrd][pth][k][dstm1] &&
                   individual_age[thrd][pth][k][dstm1] >=
	           ma[thrd][pth][trialpatchid - 1][dstm1]) {

                  individual_dead[thrd][pth][k][dstm1] = true;
	          ++k;
	          ++i;
	          break TRIALPATCHLOOP;
	       }
	    }
	    ++k;
         } while (k < n[thrd][pth][dstm1]);
      }
   }

   // Keep track of the total number of animals killed.

   totalkilled[thrd][pth][dstm1] += i;
}

/*
if (thrd == 1) {
   printf_("step: after kills: beltmept= " + beltmept[thrd] + " pth= " + pth +
      " n= " + n[thrd][pth][dstm1]);
}
*/

// Update each individual's move status.

for (i = 0; i < n[thrd][pth][dstm1]; ++i) {
   patchid = individual_patchident[thrd][pth][i][dstm1];

   if (individual_age[thrd][pth][i][dstm1] <
       ma[thrd][pth][patchid - 1][dstm1]) {
      individual_movestatus[thrd][pth][i][dstm1] = "resident";

   } else if (individual_age[thrd][pth][i][dstm1] ==
              ma[thrd][pth][patchid - 1][dstm1]) {
      individual_movestatus[thrd][pth][i][dstm1] = "wanderer";

   } else if ((individual_movestatus[thrd][pth]
			            [i][dstm1].equals("wanderer") &&
	       individual_gender[thrd][pth][i][dstm1].equals("female") &&
	       patch_nmfemales[thrd][pth][patchid - 1] <= 1) ||
              (individual_movestatus[thrd][pth]
	                            [i][dstm1].equals("wanderer") &&
	       individual_gender[thrd][pth][i][dstm1].equals("male") &&
	       patch_nmmales[thrd][pth][patchid - 1] <= 1) ||
              (individual_movestatus[thrd][pth]
	                            [i][dstm1].equals("resident") &&
	       patch_prey[thrd][pth][patchid - 1][dstm1] > 1.)) {
      individual_movestatus[thrd][pth][i][dstm1] = "resident";
   
   } else if ((individual_movestatus[thrd][pth]
			            [i][dstm1].equals("wanderer") &&
	       individual_gender[thrd][pth][i][dstm1].equals("female") &&
	       patch_nmfemales[thrd][pth][patchid - 1] > 0) ||
              (individual_movestatus[thrd][pth]
	                            [i][dstm1].equals("wanderer") &&
	       individual_gender[thrd][pth][i][dstm1].equals("male") &&
	       patch_nmmales[thrd][pth][patchid - 1] > 0) ||
              (individual_movestatus[thrd][pth]
	                            [i][dstm1].equals("resident") &&
	       patch_prey[thrd][pth][patchid - 1][dstm1] == 0.)) {
      individual_movestatus[thrd][pth][i][dstm1] = "wanderer";
   }
}

// Update birth events.

for (i = 0; i < n[thrd][pth][dstm1]; ++i) {
   patchid = individual_patchident[thrd][pth][i][dstm1];
   if (patchid == 0) {
      iderr_("step: patchid=0");
   }
   if (individual_gender[thrd][pth][i][dstm1].equals("male")) {
      continue;
   }

   nmconditions = 0;

   if ((individual_age[thrd][pth][i][dstm1] >
       ma[thrd][pth][patchid - 1][dstm1]) &&
       (individual_age[thrd][pth][i][dstm1] > femalesexmaturity)) {
      ++nmconditions;

   } else if (p1flag && thrd == 1 && pth == 1) {
      ++nmtooyoung;
   }

   if (individual_movestatus[thrd][pth][i][dstm1].equals("resident") ||
       individual_movestatus[thrd][pth][i][dstm1].equals("wanderer")) {
      ++nmconditions;

   } else if (p1flag && thrd == 1 && pth == 1) {
      ++nmnonres;
   }

   if (patch_nmmales[thrd][pth][patchid - 1] >= 1) {
      ++nmconditions;

   } else if (p1flag && thrd == 1 && pth == 1) {
      ++nmnomales;
   }

   if (individual_energy[thrd][pth][i][dstm1] > meaneb[dstm1]) {
      ++nmconditions;

   } else if (p1flag && thrd == 1 && pth == 1) {
      ++nmnoenergy;
   }

   if (individual_lastpreg[thrd][pth][i][dstm1] >
      interbirth[thrd][pth][patchid - 1][dstm1]) {
      ++nmconditions;

   } else if (p1flag && thrd == 1 && pth == 1) {
      ++nmnotready;
   }

   if (nmconditions == 5) {
      individual_lastpreg[thrd][pth][i][dstm1] = 0;

      // Create a new individual.

      ++nmnewborns;
      newn = n[thrd][pth][dstm1] + nmnewborns;
      if (newn > NMINDIV) {
         iderr_("step: newn= " + newn + " >NMINDIV");
      }
      individual_age[thrd][pth][newn - 1][dstm1] = 0;
      individual_patchident[thrd][pth][newn - 1][dstm1] = patchid;

      unif = Rndm.rndm1_(thrd, 0);
      if (unif < .5) {
         individual_gender[thrd][pth][newn - 1][dstm1] = "female";

      } else {
         individual_gender[thrd][pth][newn - 1][dstm1] = "male";
      }

      individual_energy[thrd][pth][newn - 1][dstm1] = jeb[dstm1];
      individual_movestatus[thrd][pth][newn - 1][dstm1] = "resident";
      individual_lastpreg[thrd][pth][newn - 1][dstm1] = 0;
      individual_dead[thrd][pth][newn - 1][dstm1] = false;
      ++totalborn[thrd][pth][dstm1];

   } else {
      
      /* All females who have not just given birth, regardless of
         their age, have their "time since last pregnancy" value
	 incremented by one time unit. */

      ++individual_lastpreg[thrd][pth][i][dstm1];
   }
} // End of loop over all individuals.
n[thrd][pth][dstm1] += nmnewborns;

/*
if (thrd == 1) {
   printf_("step: beltmept= " + beltmept[thrd] + " pth= " + pth +
      " nmnewborns= " + nmnewborns + " n= " + n[thrd][pth][dstm1]);
}
*/

// Find number of ranches with nonsustainable populations.

if (Math.abs(beltmept[thrd] - Intridslve.tfinal) < Intridslve.tstep) {
   for (i = 1; i <= nmranches; ++i) {
      rchpopsze[thrd][pth][i - 1][dstm1] = 0;
      for (j = 0; j < ttlnmpatches; ++j) {
         if (patch_ranchid[j] == i) {
            rchpopsze[thrd][pth][i - 1][dstm1] += patch_nmindiv[thrd][pth][j];
         }
      }
   }
}

if (thrd == 1 && pth == 1) {
   if (Math.abs(beltmept[thrd] - Intridslve.tfinal) < .15) {
      fleopen_(11, "finalpop.dat", 'w');

      fprintf_(11, "Gender  Age  Energy  Years_Since_Last_Pregnancy");
      for (i = 0; i < n[thrd][pth][dstm1]; ++i) {
         if (!individual_dead[thrd][pth][i][dstm1]) {
            ageinyears =
               ((double) individual_age[thrd][pth][i][dstm1]) / 52.;
            lastpreginyears =
               ((double) individual_lastpreg[thrd][pth][i][dstm1]) / 52.;

            fprintf_(11, individual_gender[thrd][pth][i][dstm1] + "  " +
               ageinyears + "  " +
               individual_energy[thrd][pth][i][dstm1] + "  " +
               lastpreginyears);
	 }
      }
      fclose_(11, 'w');
   }
}

/* Update each individual's patch membership.  Note that the algorithm
   assumes at least one adjacent patch has prey there. */

for (i = 0; i < n[thrd][pth][dstm1]; ++i) {

   // Sum the prey values of adjacent patches.
   
   patchid = individual_patchident[thrd][pth][i][dstm1];
   nmadjacent = patch_nmadjacent[patchid - 1];
   if (nmadjacent == 0) {
      iderr_("step: nmadjacent=0");
   }
   preysum = 0.;
   for (j = 0; j < nmadjacent; ++j) {
      k = patch_adjptch[patchid - 1][j];
      preysum += patch_prey[thrd][pth][k - 1][dstm1];
   }
   if (preysum < 1.e-6) {
      printf_("step: i= " + i + " preysum=0");
      continue;
   }

   // Randomly select an adjacent patch with nonzero prey.
   
   for (j = 0; j < 10; ++j) {
      k = Rndm.unifint_(thrd, nmadjacent);
      ar = patch_adjptch[patchid - 1][k];
      if (ar == 0) {
         continue;
      }
      if (patch_prey[thrd][pth][ar - 1][dstm1] > 0.) {
         break;
      }
      ar = 0;
   }

   if (ar == 0) {
      for (j = 0; j < nmadjacent; ++j) {
         ar = patch_adjptch[patchid - 1][j];
         if (patch_prey[thrd][pth][ar - 1][dstm1] > 0.) {
            break;
         }
      }
   }

   individual_patchident[thrd][pth][i][dstm1] = ar;
}

// Update ranch and patch abundances.

for (i = 0; i < nmranches; ++i) {
   nranch[thrd][pth][i][dstm1] = 0;
}
for (i = 0; i < ttlnmpatches; ++i) {
   npatch[thrd][pth][i][dstm1] = 0;
}
for (i = 0; i < n[thrd][pth][dstm1]; ++i) {
   patchid = individual_patchident[thrd][pth][i][dstm1];

   if (patchid == 0) {
      printf_("step: thrd= " + thrd + " pth= " + pth);
      iderr_("step: final update: patchid=0, i= " + i + " dst= " + dst);
   }

   ++nranch[thrd][pth][patch_ranchid[patchid - 1] - 1][dstm1];
   ++npatch[thrd][pth][patchid - 1][dstm1];
}

// Update individual abundance to current time point.

yn[thrd][1] = n[thrd][pth][dstm1];

/* Discover the number of realizations and write abundance realization for
   the first two ranches to a plotting file. */

if ((!cacalc && dst == 1) || (CA.runtype.equals("plots_only") && dst == 2)) {
   realizid = ((Beliefs.enmloops / nmthreads) + 1) * thrd + pth;

   fprintf_(ecorlztnsflenm, fdble_(beltmept[thrd], 8, 3) + "  " +
      realizid + "     " + nranch[thrd][pth][0][dstm1] + "  " +
      nranch[thrd][pth][1][dstm1]);
}

/*
if (thrd == 1) {
   printf_("step: beltmept= " + beltmept[thrd] + " yn= " + yn[thrd][1]);
}
*/

}

// -----------------------------------------------------------------

public static void initialibm_(int thrd, int pth,
   double nodevals[][][], int dst) {

/* Initialize.  Note that the parameters of an IBM are not functions
   of the first parent, Time.  Also, parent values are found explicitly. */

int i, k, dstm1 = dst - 1;

double dum;

// Give this realization an identifier.

realizid = ((Beliefs.enmloops / nmthreads) + 1) * thrd + pth;

// Initialize the number of steps.

nmsteps[thrd][pth][dstm1] = 0;

// Zero arrays.

for (i = 0; i < NMINDIV; ++i) {
   individual_dead[thrd][pth][i][dstm1] = true;
   individual_patchident[thrd][pth][i][dstm1] = 0;
   individual_age[thrd][pth][i][dstm1] = 0;
   individual_gender[thrd][pth][i][dstm1] = "none";
   individual_movestatus[thrd][pth][i][dstm1] = "none";
   individual_energy[thrd][pth][i][dstm1] = 0.;
   individual_lastpreg[thrd][pth][i][dstm1] = 0;
   subgroupid[thrd][pth][i] = 0;
   oldmaleid[thrd][pth][i] = 0;
}

// Load initial population array.

for (i = 0; i < n[0][0][dstm1]; ++i) {
   individual_dead[thrd][pth][i][dstm1] = individual_dead[0][0][i][dstm1];
   individual_patchident[thrd][pth][i][dstm1] =
      individual_patchident[0][0][i][dstm1];
   individual_age[thrd][pth][i][dstm1] = individual_age[0][0][i][dstm1];
   individual_gender[thrd][pth][i][dstm1] =
      individual_gender[0][0][i][dstm1];
   individual_movestatus[thrd][pth][i][dstm1] =
      individual_movestatus[0][0][i][dstm1];
   individual_energy[thrd][pth][i][dstm1] = individual_energy[0][0][i][dstm1];
   individual_lastpreg[thrd][pth][i][dstm1] =
      individual_lastpreg[0][0][i][dstm1];
}
n[thrd][pth][dstm1] = n[0][0][dstm1];

/*
if (thrd == 1 && pth == 1) {
   printf_("initialibm: n= " + n[thrd][pth][dstm1]);
}
*/

totalkilled[thrd][pth][dstm1] = 0;
totaldied[thrd][pth][dstm1] = 0;
totalborn[thrd][pth][dstm1] = 0;

for (i = 0; i < ttlnmpatches; ++i) {
   patch_denschange[thrd][pth][i][dstm1] = false;
   patch_foodchange[thrd][pth][i][dstm1] = false;
   patch_density[thrd][pth][i] = 0.;
   ma[thrd][pth][i][dstm1] = ma[0][0][i][dstm1];
   interbirth[thrd][pth][i][dstm1] = interbirth[0][0][i][dstm1];
}
}

// ------------------------------------------------------------------------

public static void ibmreadfles_() {

int i = 0, j, k = 0, l, nmobsm1;

double year = 0., dumtime = 0., dumveg = 0., maxtime = 0.;

nmobsm1 = Math.max(0, nmecoobsttl - 1);
maxtime = Math.max(Intridslve.tfinal, dat2_t[nmobsm1]);
maxtime += 2.;

/* Read-in patch characteristics.  Area is assumed to be kilometers^2
   as animal density is assumed to be in (animal abundance)/km2.
patch_# patchname patch_area_(km2) predator_abundance nm_adjacent adj_patches
nmranches 1
patchsetname #ofpatches
*/

fleopen_(flenm, patchdefflename, 'r');
fgetline_(flenm);
fgetstrng_(flenm);
nmranches = fgetint_(flenm);
for (i = 0; i < nmranches; ++i) {
   ranchname[i] = fgetstrng_(flenm);
   nmpatches[i] = fgetint_(flenm);

   for (j = 0; j < nmpatches[i]; ++j) {
      fgetint_(flenm);
      patch_ranchid[k] = i + 1;
      patch_area[k] = fgetdble_(flenm);
      patch_abundance[k] = fgetint_(flenm);

      rancharea[i] += patch_area[k];
      if (i == 0) {
         totalarea += patch_area[k];
      }

      patch_nmadjacent[k] = fgetint_(flenm);
      for (l = 0; l < patch_nmadjacent[k]; ++l) {
         patch_adjptch[k][l] = (fgetint_(flenm)) + ttlnmpatches;
	 if (patch_adjptch[k][l] <= 0) {
            iderr_("ibmreadfles: adjptch= " + patch_adjptch[k][l]);
	 }
      }
      ++k;
   }
   ttlnmpatches += nmpatches[i];
}
fclose_(flenm, 'r');

// Assign individuals to patches.

nallpatches = 0;
for (i = 1; i <= ttlnmpatches; ++i) {
   for (j = 0; j < patch_abundance[i - 1]; ++j) {
      indivpatchassign[nallpatches] = i;
      ++nallpatches;
   }
}
}

// --------------------------------------------------------------

public static void ibmsetup_(int dst) {

// Initializes patch and individual characteristics in an IBM.

int i = 0, j, k = 0, l, i1, val, dstm1 = dst - 1;

double dum, c, rval, meanage = 0.;

// Initialize arrays.

for (i = 0; i < NMINDIV; ++i) {
   individual_dead[0][0][i][dstm1] = true;
   individual_patchident[0][0][i][dstm1] = 0;
   individual_age[0][0][i][dstm1] = 0;
   individual_gender[0][0][i][dstm1] = "none";
   individual_movestatus[0][0][i][dstm1] = "none";
   individual_energy[0][0][i][dstm1] = 0.;
   individual_lastpreg[0][0][i][dstm1] = 0;
   subgroupid[0][0][i] = 0;
   oldmaleid[0][0][i] = 0;
}

// Read supporting files for IBM node.

if (!readibmfles) {
   ibmreadfles_();
   readibmfles = true;
}

// Get region information.

regionnodenumber = Getmodlutils.getndnm_(regionnode);

/* Load parameter values and initialize population demographics parameters.

   Parameter                          Units
   ----------------------------------------
   le: life expectancy                years
   ma: maturation age                 years
   femalesexmaturity                  years
   interbirth: interbirth interval    years
   wfi: weekly food intake            number of prey individuals
   meb: maximum energy budget         weeks
   meaneb: mean energy budget         weeks
   jeb: juvenile energy budget        weeks

   Note: energy budget values indicate the number of weeks before an
   animal starves to death.  But in reality, animals are eating -- they
   just aren't eating enough.  Therefore, meb, meaneb, jeb should be
   interpreted as the number of weeks of food stress that an individual
   can endure before (s)he dies. */

k = Getmodlutils.getndnm_("CheetahIBM");
dum = 52. * condprb[idnmbrm1][k - 1][0][0][0][0][0][0][0][dstm1];
le[dstm1] = (int) Math.round(dum);

dum = 52. * condprb[idnmbrm1][k - 1][1][0][0][0][0][0][0][dstm1];
for (i = 0; i < ttlnmpatches; ++i) {
   ma[0][0][i][dstm1] = (int) Math.round(dum);
}

dum = 52. * 2.4;
femalesexmaturity = (int) Math.round(dum);

dum = 52. * condprb[idnmbrm1][k - 1][2][0][0][0][0][0][0][dstm1];
for (i = 0; i < ttlnmpatches; ++i) {
   interbirth[0][0][i][dstm1] = (int) Math.round(dum);
}

wfi[dstm1] = condprb[idnmbrm1][k - 1][3][0][0][0][0][0][0][dstm1];

meb[dstm1] = condprb[idnmbrm1][k - 1][4][0][0][0][0][0][0][dstm1];
meaneb[dstm1] = condprb[idnmbrm1][k - 1][5][0][0][0][0][0][0][dstm1];
jeb[dstm1] = condprb[idnmbrm1][k - 1][6][0][0][0][0][0][0][dstm1];

// Reset parameter value during a sensitivity analysis run.

if (ssensanalysis) {
   Ssens.resetparm_();
}

// meaneb cannot be close to or larger than meb.

if (meaneb[dstm1] >= meb[dstm1]) {
   iderr_("ibmsetup: meaneb= " + meaneb[dstm1] + " meb= " + meb[dstm1]);
}

// Create the initial population.

if (randompatch) {
   nranch[0][0][0][dstm1] = 900; // was 800
   nranch[0][0][1][dstm1] = 900;  // was 800

} else {

   // Assumes only one ranch.

   nranch[0][0][0][dstm1] = nallpatches;
}

n[0][0][dstm1] = 0;
meanage = 0.;
i = 0;
for (j = 1; j <= nmranches; ++j) {
   n[0][0][dstm1] += nranch[0][0][j - 1][dstm1];
   for (k = 0; k < nranch[0][0][j - 1][dstm1]; ++k) {

      if (i >= NMINDIV) {
         iderr_("ibmsetup: i= " + i + " = NMINDIV");
      }

      individual_dead[0][0][i][dstm1] = false;
      individual_lastpreg[0][0][i][dstm1] = 0;

      // Select a patch for individual "i."

      if (randompatch) {
         do {
	    val = 1 + Rndm.unifint_(0, ttlnmpatches);
         } while (patch_ranchid[val - 1] != j);

      } else {
         val = indivpatchassign[k];
      }

      individual_patchident[0][0][i][dstm1] = val;

      /* Initial age distribution.  Should be right-skewed and have
         high variance, see "finalpop.dat." */

      val = 1 + Rndm.unifint_(0, le[dstm1]);
      individual_age[0][0][i][dstm1] = val;
      meanage += ((double) val);

      unif = Rndm.rndm1_(0, 0);
      if (unif < .5) {
         individual_gender[0][0][i][dstm1] = "female";

      } else {
         individual_gender[0][0][i][dstm1] = "male";
      }
      
      unif = Rndm.rndm1_(0, 0);
      if (unif < .5 && individual_age[0][0][i][dstm1] > ma[0][0][0][dstm1]) {
         individual_movestatus[0][0][i][dstm1] = "wanderer";

      } else {
         individual_movestatus[0][0][i][dstm1] = "resident";
      }

      /* Initial energy levels.  Should have high variance -- actually,
         the distribution in "finalpop.dat" has all the juveniles with
	 energy=jeb, and all mature individuals with energy=meb. */
      
      if (individual_age[0][0][i][dstm1] > ma[0][0][0][dstm1]) {
         individual_energy[0][0][i][dstm1] =
            (int) (meb[dstm1] * Rndm.rndm1_(0, 0));

      } else {
         individual_energy[0][0][i][dstm1] =
            (int) (jeb[dstm1] * Rndm.rndm1_(0, 0));
      }

      if (individual_age[0][0][i][dstm1] > ma[0][0][0][dstm1] &&
          individual_energy[0][0][i][dstm1] > meb[dstm1]) {
         individual_energy[0][0][i][dstm1] = meb[dstm1];
      }
      if (individual_age[0][0][i][dstm1] < ma[0][0][0][dstm1] &&
          individual_energy[0][0][i][dstm1] > jeb[dstm1]) {
         individual_energy[0][0][i][dstm1] = jeb[dstm1];
      }
      if (individual_energy[0][0][i][dstm1] < 0.) {
         individual_energy[0][0][i][dstm1] = 0.;
      }
      
      // Initial time-since-last-pregnancy.
      
      if (individual_gender[0][0][i][dstm1].equals("female") &&
          individual_age[0][0][i][dstm1] > ma[0][0][0][dstm1]) {
	 val = Rndm.unifint_(0, interbirth[0][0][0][dstm1]);
         individual_lastpreg[0][0][i][dstm1] = val;
      }
      ++i;
   }
}

// Stop if the initial population is tiny.

if (n[0][0][dstm1] < 5) {
   iderr_("ibmsetup: initial n= " + n[0][0][dstm1]);
}

// Stop if patch identifiers are wrong.

for (i = 0; i < n[0][0][dstm1]; ++i) {
   if (individual_patchident[0][0][i][dstm1] == 0) {
      iderr_("ibmsetup: i= " + i + " zero patchid");
   }
}

// Compute average age.

meanage /= ((double) n[0][0][dstm1]);

// Open abundance realizations output file.

if (dst == 1) {
   fleopen_(ecorlztnsflenm, ecorlztnsfle, 'w');
   fprintf_(ecorlztnsflenm, "Time  Realization Ranch_1_Abund  Ranch_2_Abund");
}
}
}
