import org.openspaces.core.GigaSpace;
import org.openspaces.core.GigaSpaceConfigurer;
import org.openspaces.core.space.EmbeddedSpaceConfigurer;
import org.openspaces.core.space.SpaceProxyConfigurer;

class Optimiz extends Id {

static boolean stochobjfcn = false, phasetwo = false, test = true,
   endopt = false;

// Optimization method: "Hooke", "Random", "SA".

static String optmethod = "SA-MDAS";

static int fnm, n, ci, maxnmf = 0, maxnmfsve, maxhookeiter = 0, funevals = 0,
   badecnstrnt = 0, badicnstrnt = 0, stochsamplesize = 0, nmperformers = 3;

static double ftest, fbest, penaltyval = -1.e2, epsilon = 0., rhohooke = 0.;

static double x[] = new double[OPTSIZE];
static double xbest[] = new double[OPTSIZE];
static double xc[] = new double[OPTSIZE];
static double xx[][] = new double[OPTSIZE][OPTSIZE];

/* Note that the "g" and "h" arrays hold the explicit constraint limits
   in positions 1 to n.  The implicit constraint limits are in "gimplicit"
   and "himplicit.  The "cnstrnt" array holds the current implicit
   constraint values. */

static double g[] = new double[OPTSIZE];
static double h[] = new double[OPTSIZE];
static double gimplicit[] = new double[OPTSIZE];
static double cnstrnt[] = new double[OPTSIZE];
static double himplicit[] = new double[OPTSIZE];
static double a[] = new double[OPTSIZE];

static GigaSpace gspace = null;

// ----------------------------------------------------------------------

static void optimiz_(int nmvars, int nmimp, double xsol[], double glimits[],
   double hlimits[], int fnmber) {

/* Constrained optimization routine.  Attempts to find a point, x that
   maximizes "objf_."

   Mui importante!!! always restrict the range over which a parameter
   can be adjusted -- if you don't, this routine will sometimes find a
   complex for which the centroid is not a feasible point!!!

   n:  number of independent variables,
   ci: number of implicit constraints. */

int i, j, retval = 0, nmiter;

double initlf, fratio, width, fsofar;

// Transfer input constants to static class variables.

fnm = fnmber;
n = nmvars;
ci = nmimp;

if (n <= 0 || ci < 0) {
   iderr_("optimiz: n= " + n);
}

if (maxnmf < 2) {
   iderr_("optimiz: maxnmf= " + maxnmf);
}

if (n < 30) {
   test = true;
}

/* Initialize constants that need resetting between multiple calls to
   "optimiz_." */

endopt = false;

// Load initial x vector into x, and load explicit constraints.

if (test) {
   printf_("optimiz: fnm= " + fnm);
   printf_("optimiz: Initial values" +
      "\n i       g        x        h         width");
}

for (i = 0; i < n; ++i) {
   g[i] = glimits[i];
   x[i] = xsol[i];
   h[i] = hlimits[i];
   width = h[i] - g[i];

   if (test) {
      printf_(" " + (i + 1) + "  " + fdble_(g[i], 10, 6) +
         "  " + fdble_(x[i], 10, 6) + "  " + fdble_(h[i], 10, 6) +
         "  " + fdble_(width, 10, 6));
   }

   if (width < 1.e-6) {
      printf_("optimiz: i= " + i + " width= " + width);
      endopt = true;
   }

   if (x[i] < g[i] || x[i] > h[i]) {
      printf_("optimiz: i+1= " + (i + 1) + " g= " + g[i] + " x= " + x[i] +
         " h= " + h[i]);
      printf_("optimiz: explicit constraint " + (i + 1) + " violated");
      endopt = true;
   }
}

/* Set the number of times a stochastic objection function will
   be computed. */

if (stochobjfcn) {
   stochsamplesize = 3;

} else {
   stochsamplesize = 1;
}

// Compute the objective function's initial value.

funevals = 0;
fbest = objf_(x);
++funevals;

// Return if this is a "client" run.

if (client) {

   return;
}

// Start at a feasible initial objective function value.

initlf = fbest;
if (Math.abs(initlf - penaltyval) < 1.e-6) {
   iderr_("optimiz: initlf= " + initlf + " is at the penalty value.");
}

// Check implicit variable constraints.

if (ci > 0) {
   impvarcnstrnts_(x);
   if (test) {
      printf_("\n          Implicit Constraints" +
         "\n Number  gimplicit  cnstrnt  himplicit  width");
   }
   for (i = 0; i < ci; ++i) {
      width = himplicit[i] - gimplicit[i];
      if (test) {
         printf_(" " + (i + 1) + "  " + fdble_(gimplicit[i], 7, 3) +
            "  " + fdble_(cnstrnt[i], 8, 5) +
            "  " + fdble_(himplicit[i], 8, 5) +
            "  " + fdble_(width, 8, 5));
      }
      if (width < 1.e-6) {
	 printf_("optimiz: implicit variable constraint " + (i + 1) +
	    " width= " + width);
         endopt = true;
      }

      if (cnstrnt[i] < gimplicit[i] || himplicit[i] < cnstrnt[i]) {
	 printf_("optimiz: impcnstrntnm= " + (i + 1) + " gimplicit= " +
	    gimplicit[i] + " cnstrnt= " + fdble_(cnstrnt[i], 8, 5) +
	    " himplicit= " + himplicit[i] +
            "\n   initial point violates this implicit constraint");
         endopt = true;
      }
   }
}

if (endopt) {
   if (!interdict) {
      iderr_("optimiz: initial point violates constraints");

   } else {

      return;
   }
}

// Store the best solution so far: the solution at the initial guess.

for (j = 0; j < n; ++j) {
   xbest[j] = x[j];
}

if (test) {
   printf_("optimiz: fbest= " + fbest + ", beginning optimization.");
}

// Find the optimal solution using the chosen algorithm.

if (optmethod.equals("Hooke")) {

   /* Use Hooke and Jeeves routine.  Large values of rhohooke make for a
      more careful search in Hooke that converges slowly. */

   nmiter = Hooke.hooke_(x, xbest, rhohooke, epsilon, maxhookeiter, true);

} else if (optmethod.equals("Random")) {
   Rndmsrch.rndmsrch_(1, x, epsilon);
   for (j = 0; j < n; ++j) {
      xbest[j] = x[j];
   }

} else if (optmethod.equals("SA")) {
   retval = SimAnnealContin.simAnnealContin_(x, epsilon);

   if (retval != 0) {
      printf_("optimiz: SA method retval= " + retval);
   }

   for (j = 0; j < n; ++j) {
      xbest[j] = x[j];
   }

} else if (optmethod.equals("SA-MDAS")) {

   /* Run Simulated Annealing to do a global search for a near-optimal solution.
      Don't run SA all the way to convergence because that usually requires too
      many function evaluations. */

   retval = SimAnnealContin.simAnnealContin_(x, epsilon);
   printf_("optimiz: SimAnnealContin method retval= " + retval + " funevals= " +
      funevals);

   fsofar = objf_(x);
   printf_("optimiz: objf value and solution after Simulated Annealing" +
      " fsofar= " + fsofar +
      "\n i        x");
   for (i = 0; i < n; ++i) {
      printf_(" " + (i + 1) + "  " + fdble_(x[i], 10, 6));
   }

   /* If SimAnnealContin_() made the objective function worse, don't use it
      for Hooke, below. */

   if (fsofar < initlf) {
      printf_("optimiz: fsofar < initlf, using initial solution for hooke_()");
      for (j = 0; j < n; ++j) {
         x[j] = xbest[j];
      }
   }

   /* Run Hooke to find the local solution quickly by using many compute nodes.
      Note that "xbest" in hooke_()'s call statement holds the best solution
      found by hooke_(). */
   
   phasetwo = true;
   funevals = 0;
   nmiter = Hooke.hooke_(x, xbest, rhohooke, epsilon, maxhookeiter, true);
   printf_("optimiz: Hooke nmiter= " + nmiter + " funevals= " + funevals);
}

if (space_in_use) {
   Hooke.terminateClients_(gspace);
}

// Check constraints one final time.

retval = checkcnstrnts_(xbest);
if (retval != 0) {
   iderr_("optimiz: xbest has a constraint violation at: " + retval);
}

for (i = 0; i < n; ++i) {
   x[i] = xbest[i];
   xsol[i] = xbest[i];
}

// Calculate the ratio of final improvement in f_obj to initial f_obj.

fbest = objf_(x);
if (Math.abs(initlf) > 1.e-6) {
   fratio = (fbest - initlf) / Math.abs(initlf);

} else {
   fratio = 0.;
}

if (test) {
   printf_("optimiz: i     g         xsol          h        width");
   for (i = 0; i < n; ++i) {
      printf_("   " + (i + 1) + "   " + fdble_(g[i], 9, 5) +
         "   " + fdble_(xsol[i], 9, 5) + "   " + fdble_(h[i], 9, 5) +
         "   " + fdble_(h[i] - g[i], 9, 5));
   }
}
printf_("optimiz: fnm= " + fnm + " n= " + n + " funevals= " + funevals +
   "\n   initlf= " + initlf + " fbest= " + fbest +
   "\n   (fbest-intlf)/|intlf|= " + fdble_(fratio, 6, 4) +
   " (note: routine tries to maximize f(x))");

// Optionally, compute Hessian.

if (Estimate.computehessian) {
   hessian_(x);
}
return;
}

// ------------------------------------------------------------------

static int checkcnstrnts_(double z[]) {

/* Checks the explicit and implicit variable constraints.  Returns the
   the variable number of an explicit variable constraint
   violation, or, if there are no explicit constraint violations but an
   implicit constraint violation is detected, returns the value of the
   violated implicit variable constraint.  Otherwise, returns 0. */

boolean cpflag = false;

int j, iev1, retval = 0;

badecnstrnt = 0;
badicnstrnt = 0;

// Check explicit constraints.

for (j = 0; j < n; ++j) {
   if ((z[j] < g[j]) || (h[j] < z[j])) {
      badecnstrnt = j + 1;
      if (cpflag) {
         printf_("checkcnstrnts: badecnstrnt= " + badecnstrnt + " val= " +
            z[badecnstrnt - 1] + " g= " + g[j] + " h= " + h[j]);
      }
      retval = badecnstrnt;
   }
}

if (ci == 0 || retval != 0) {

   return retval;
}

// Compute and then check the implicit variable constraints.

impvarcnstrnts_(z);

for (j = 0; j < ci; ++j) {
   if (cnstrnt[j] < gimplicit[j] || himplicit[j] < cnstrnt[j]) {
      badicnstrnt = j + 1;
      if (cpflag) {
         printf_("checkcnstrnts: badicnstrnt= " + badicnstrnt +
            " gimplicit= " + gimplicit[j] + " cnstrnt= " + cnstrnt[j] +
            " himplicit= " + fdble_(himplicit[j], 5, 3));
      }
      retval = badicnstrnt;
   }
}
return retval;
}

// ---------------------------------------------------------------------

static double objf_(double a[]) {

/* Computes objective function value dependent on function number "fnm."
   Hooke.java is trying to minimize -objf_() so if the function below is
   to be maximized and Hooke is the optimization method, return its value
   rather than the negative of its value. */

int i;

double val = 0.;

if (CA.caftest == 1) {

   // f(x) = \sum_0^(n-1) a(i)**2.

   val = 0.;
   for (i = 0; i < n; ++i) {
      val += a[i] * a[i];
   }
   val = 1. - val;
   printf_("Optimiz.objf: caftest=1, val= " + val);

   return val;

} else if (CA.caftest == 2) {
   
   // Bukin's F4 benchmark function.  Solution: f=0 at (-10, 0).

   val = 100. * a[1] * a[1] + .01 * Math.abs(a[0] + 10.);
   val *= -1.;
   //val += Rndm.stdnrm_(0);

   return val;

} else if (CA.caftest == 3) {
   
   // Bukin's F6 benchmark function.  Solution: f=0 at (-10, 1).

   val = 100. * Math.sqrt(Math.abs(a[1] - .01 * a[0] * a[0])) +
         .01 * Math.abs(a[0] + 10.);
   val *= -1.;

   return val;
}

// Compute requested objective function.

if (fnm == 1) {

   // Covariogram fitting.

   val = -Optf.optf_(false, n, a, g, h);

} else if (fnm == 2) {

   // LOMAP/GLOMAP model fitting.

   val = -Mdobjf.mdobjf_(n, a, g, h);

} else if (fnm == 3) {

   // IntIDs model fitting with Consistency Analysis.

   val = CAutils.caf_(a, false);
   //printf_("Optimiz.objf: x[0]= " + a[0] + " val= " + val);

} else if (fnm == 4) {

   /* Find a set of maximally-separated kernel-center locations (or
      "seed locations" to begin the fitting of a GLOMAP model. */

   val = Surfcalcs.sumdiffs_(a);

} else if (fnm == 5) {

   // Approximate a discrete distribution with a Logit.

   val = Fitlogit.objf_(n, a);

} else if (fnm == 6) {

   // Find the MPEMP.

   val = Mpemp.mpempf_(n, a);
   //printf_("Optimiz.objf: x[0]= " + a[0] + " val= " + val);

} else if (fnm == 7) {

   // Maximize the Stackelberg leader-follower game objective function.

   val = Interdict.stcklbrgobjf_(n, a);

} else if (fnm == 8) {

   // Maximize the poachers' evasion-plus-poaching objective function.

   val = Pursuit.poacherobjf_(n, a);

} else if (fnm == 9) {

   // Maximize the pursuit team's objective function.

   val = Pursuit.teamobjf_(n, a);

} else if (fnm == 10) {

   // Map referencing error objective function, see GISwind.java.

   val = GISwind.totalerror_(n, a);

} else {
   iderr_("optimiz: fnm= " + fnm + " is not valid.");
}
return val;
}

// ----------------------------------------------------------------------

static void impvarcnstrnts_(double a[]) {

/* Compute implicit constraint values that are computed as side-effects
   of the objective function's computation. */

int i;

if (fnm <= 2) {

   // Covariogram and LOMAP/GLOMAP fitting.

   Optf.optf_(true, n, a, g, h);

} else if (fnm == 3) {

   // Consistency analysis.  Dummy value needed for initialization.

   cnstrnt[0] = 0.;

} else if (fnm == 4) {

      // Kernel-center separation constraint.

      cnstrnt[0] = Surfcalcs.bdrycnstrnt_(a);

} else if (fnm == 6) {

   // MPEMP constraint is computed inside caf_().

} else if (fnm == 8) {

   /* All Stackelberg game constraints.  Note that the method
      "cnstrnts_" needs to run first in order to compute "prbsum." */

   cnstrnt[ci - 1] = Interdict.stcklbrgcnstrnts_(a);

} else if (fnm == 9) {

   // Poachers' evasion-plus-poaching constraints

   cnstrnt[ci - 1] = Pursuit.poachercnstrnt_(a);

} else if (fnm == 10) {

   // Pursuit team's constraints.

   cnstrnt[ci - 1] = Pursuit.teamcnstrnt_(n, a);
}
}

// ----------------------------------------------------------------------

static void hessian_(double xsol[]) {

// Computes the Hessian matrix using central differences.

int i, j;

double step, fback, fforward, fcenter, cv;

for (i = 0; i < n; ++i) {
   xc[i] = xsol[i];
}

fprintf_(1, " Hessian Diagonal Entries and Approximate CV's" +
   "\n Variable    Hessian   CV");

for (i = 0; i < n; ++i) {
   for (j = 0; j < n; ++j) {

      // Only do diagonal.

      if (i != j) {
	 continue;
      }

      // Compute central value.

      fcenter = objf_(xc);

      // Find step size.

      step = 1.e-3 * (h[i] - g[i]);

      xc[i] += step;
      if (xc[i] > h[i]) {
	 xc[i] = h[i];
      }
      fforward = objf_(xc);

      xc[i] -= 2. * step;
      if (xc[i] < g[i]) {
	 xc[i] = g[i];
      }
      fback = objf_(xc);

      xc[i] += step;

      // Compute second partial derivative.

      xx[i][j] = (fforward - 2. * fcenter + fback) / (step * step);

      if (xx[i][j] < 0.) {
	 if (xc[i] != 0.) {
	    cv = Math.sqrt(-1. / xx[i][j]) / xc[i];
	 
	 } else {
	    cv = Math.sqrt(-1. / xx[i][j]);
         }
         fprintf_(1, (i + 1) + "      " + xx[i][j] + "  " + cv);

      } else {
	 fprintf_(1, (i + 1) + "      " + xx[i][j] + " > 0");
      }
   }
}
}
}
