class Mvsrch extends Surf {
static int j;

static int indx[] = new int[DATSZE];
static int nmseas[] = new int[4];

static double distan[] = new double[DATSZE];
static double tdifs[] = new double[DATSZE];

// --------------------------------------------------------------------

static void mvsrch_(int option, double xcord, double ycord, double tmecord) {
 
/* If local is true, compute the distance from (xcord, ycord) to each
   variable i site.  Sort by this distance and;
   option < 2: use the first ndmin[i1] of these sorted sites.  Set the
               cylinder radius to the largest of these distances.
   option == 2: use all data up to the given cylinder radius.

   spacetime_predoption = 1: spatio-temporal prediction 1 time step forward,
   spacetime_predoption = 2: spatio-temporal estimation using all
                           observations before and after the prediction
                           time, "tmecord" up to a range of
                           "tlngth[i1]" (temporal interpolation).
   If !local, use all data. */

boolean match;

int i = 0, k, inti, i1, i2, start = 0, finish, vnmbr, startk = 0,
   endk = 0, seasnm, stnm;

double dist, difx, dify, dift, distmax, ptlim = 0., ftlim = 0., rnd, ssq,
   std, sm, rn;

// Options check.

if (itrend == 3) {
   iderr_("itrend=3 in mvsrch");
}

if (option == 2) {
   iderr_("option=2 broken in mvsrch");
}

// Loop over each variable.

j = 0;
nd = 0;
finish = 0;
for (i1 = 0; i1 < parm_mvar; ++i1) {
   start = finish;
   vnmbr = dat2_vrble[1][start];
   if (vnmbr == -1) {
      vnmbr = dat2_vrble[1][start + 1];
   }
   finish = start + nmobs[idnmbrm1][lomapnms[vnmbr - 1] - 1];

   if (temporal) {

      // Compute the cylinder temporal bounds for variable vnmbr.

      if (spacetime_predoption == 1) {
         ftlim = tmecord;

      } else if (spacetime_predoption == 2) {
         ftlim = tmecord + .5 * tlngth[vnmbr - 1];
         if (dattmax < ftlim) {
            ftlim = 1.01 * dattmax;
	 }
      }
      ptlim = ftlim - tlngth[vnmbr - 1];
      if (ptlim < dattmin) {
         ptlim = .99 * dattmin;
      }
   }

   if (spatial) {

      // Find the closest sites to (xcord, ycord).

      for (i = 0; i < nmsites[vnmbr - 1]; ++i) {
         difx = xcord - xvals[vnmbr - 1][i];
         dify = ycord - yvals[vnmbr - 1][i];
         distan[i] = Math.sqrt(difx * difx + dify * dify);
         indx[i] = i;
      }

      // Sort these distances.

      Idsort.idsort_(distan, indx, 1, nmsites[vnmbr - 1]);

      if (Estimate.local) {

         // Set the spatial radius of cylinder "vnmbr."

         varmod_radius[vnmbr - 1] = distan[ndmin[vnmbr - 1] - 1];

      } else {

         // For a global model, use the largest intersite distance.
         
         varmod_radius[vnmbr - 1] = varmod_rngelim;
      }
      if (icrval != 1) grdvar_radius = varmod_radius[vnmbr - 1];
   }

   // Set the basic lag and tolerance for variograms.

   if (i1 == 0) {
      if (spatial) {

         if (Estimate.local) {

            /* Use the cylinder diameter of the first variable to set the
               basic lag. */

            pas = 0.8 * (2. * distan[ndmin[vnmbr - 1] - 1]) / (double) kmax;
         
         } else {
            pas = 0.8 * varmod_rngelim / (double) kmax;
         }

      } else {
         pas = varmod_epsln;
      }
      tol = .5 * pas;
   }

   // Check each observation on variable "vnmbr" for inclusion in the cylinder.
 
   nmcylobs[vnmbr - 1] = 0;

   if (!spatial && temporal) {
      startk = start;
      endk = finish;

   } else if (spatial && !temporal) {
      startk = 0;
      endk = nmsites[vnmbr - 1];

   } else if (spatial && temporal) {
      startk = 0;
      endk = 1;
      for (i = 0; i < nmsites[vnmbr - 1]; ++i) {
         if (distan[i] <= varmod_radius[vnmbr - 1]) {
            endk = i + 1;
	 
	 } else {
	    break;
	 }
      }
   }

   kloop: for (k = startk; k < endk; ++k) {
      if (!spatial && temporal) {

         /* Temporal-only rule: Skip if this is a missing value, the
            observation time is at the prediction time, or the
            observation time is not within the temporal bounds of
            cylinder "vnmbr." */

         if (dat2_vrble[1][k] == -1 ||
             (spacetime_predoption == 1 &&
             Math.abs(dat2_t[k] - tmecord) < 1.e-20) ||
             (dat2_t[k] < ptlim) || ( ftlim < dat2_t[k])) {
            continue;
         }

         // Add observation to vardat structure.

         addobs_(vnmbr, k);
         ++nmcylobs[vnmbr - 1];
      }

      // Spatial exclusion rule.

      if (spatial) {
         for (i = start; i < finish; ++i) {
            if (Math.abs(dat2_x[i] - xvals[vnmbr - 1][indx[k]]) < 1.e-20 &&
                Math.abs(dat2_y[i] - yvals[vnmbr - 1][indx[k]]) < 1.e-20) {

               /* A POSSIBLE match has been found.  Skip if this is a
                  missing value or, when the LOMAP variable is
                  spatial-only, the time value is not equal to the
                  prediction time. */
      
               if (dat2_vrble[1][i] == -1 || (spatial && !temporal &&
                  Math.abs(dat2_t[i] - tmecord) > 1.e-20)) {
                  continue;
               }

               // Stop if an unexpected variable number occurs.

               if (dat2_vrble[1][i] != vnmbr) {
                  iderr_("mvsrch: i= " + i + " vrble= " +
                     dat2_vrble[1][i] + " vnmbr= " + vnmbr +
                     " bad variable number");
               }

               if (temporal) {

                  /* Temporal exclusion rules for spatio-temporal data. */

                  if ((spacetime_predoption == 1 &&
                      Math.abs(dat2_t[i] - tmecord) < 1.e-20) ||
                      (dat2_t[i] < ptlim) || ( ftlim < dat2_t[i])) {
                     continue;
                  }

                  if (spacetime_predoption == 2 &&
                      dat2_t[i] < ptlim || ftlim < dat2_t[i]) {
                     continue;
                  }
               }

               // Add observation to vardat structure.

               addobs_(vnmbr, i);
               ++nmcylobs[vnmbr - 1];

               if (spatial && !temporal) {

                  /* For a spatial-only analysis, break if cylinder has an
                     observation at each of the closest sites. */

                  if (nmcylobs[vnmbr - 1] == ndmin[vnmbr - 1]) {
                     break kloop;
                  }
               }
            } // End of site match condition.
         } // End of loop over "vnmbr" observations.
      } // End of "spatial" condition
   } // End of "k" loop.

   // Stop if cylinder is empty.

   if (nmcylobs[vnmbr - 1] == 0) {
      printf_("mvsrch: i1= " + i1 + " vnmbr= " + vnmbr + " nmcylobs= " +
         nmcylobs[vnmbr - 1] + ": increase tlngth(), ptlim= " + ptlim +
         " ftlim= " + ftlim + " tmecord= " + tmecord);
      iderr_("mvsrch: nd=0, step 1");
   }

   // Update the total of all cylinders.

   nd += nmcylobs[vnmbr - 1];
   if (nd >= WLSSZE) {
      iderr_("mvsrch: vnmbr= " + vnmbr + " nd= " + nd +
         " WLSSZE= " + WLSSZE + " nd big.");
   }
}

// Calculate means and data sum of squares for entire data vector.

xmean = 0.;
ymean = 0.;
grdvar_datmn = 0.;
grdvar_datssy = 0.;
for (i = 0; i < parm_mvar; ++i) {
   grdvar_vrblemns[i] = 0.;
   if (seasclc) {
      for (j = 0; j < 4; ++j) {
         grdvar_seasmns[lomapnms[i] - 1][j] = 0.;
         nmseas[j] = 0;
      }
   }
}
for (i = 0; i < nd; ++i) {
   stnm = idtostnm[vardat_vrble[i] - 1];
   xmean += vardat_x[i];
   ymean += vardat_y[i];
   grdvar_datmn += vardat_dat[i];
   grdvar_datssy += vardat_dat[i] * vardat_dat[i];
   grdvar_vrblemns[stnm - 1] += vardat_dat[i];
   if (seasclc) {
      seasnm = Wlstrend.getseas_(vardat_t[i]);
      grdvar_seasmns[stnm - 1][seasnm - 1] += vardat_dat[i];
      ++nmseas[seasnm - 1];
   }
}

rnd = (double) nd;
xmean /= rnd;
ymean /= rnd;
grdvar_datmn /= rnd;
grdvar_datsvar = (grdvar_datssy - ((grdvar_datmn * grdvar_datmn) / rnd)) /
                              (rnd - 1.);

for (i = 0; i < parm_mvar; ++i) {
   grdvar_vrblemns[i] /= (double) nmcylobs[i];
   if (seasclc) {
      for (j = 0; j < 4; ++j) {
         grdvar_seasmns[i][j] /= (double) nmseas[j];
      }
   }
}
}

// ----------------------------------------------------------------------

static void addobs_(int vnmbr, int i) {

// Include this observation in the cylinder.

int i2;

vardat_x[j] = dat2_x[i]; 
vardat_y[j] = dat2_y[i]; 
vardat_t[j] = dat2_t[i]; 
for (i2 = 0; i2 < nmquantvar; ++i2) {
   vardat_quantval[j][i2] = dat2_quantval[i][i2];
}
for (i2 = 0; i2 < nmqualvar; ++i2) {
   vardat_qualval[j][i2] = dat2_qualval[i][i2];
}
vardat_dat[j] = dat2_dat[i]; 
vardat_obs[j] = dat2_dat[i];
vardat_vrble[j] = lomapnms[vnmbr - 1];
vardat_steid[j] = i;
++j;
}

// ---------------------------------------------------------------------

static void sptmsrt_(int nmobs, double distan[], double tdifs[],
   int indx[]) {

/* Assuming indx is already sorted by distan, performs a secondary sort of
   indx by tdifs. */

int i, l, u, inti;

int vsrt[] = new int[DATSZE];

double xsrt[] = new double[DATSZE];
double ysrt[] = new double[DATSZE];
double tsrt[] = new double[DATSZE];
double datsrt[] = new double[DATSZE];

l=1;
u=1;
for (;;) {

   // Search for a change in the distan value.

   do {
      ++u;
      if (u > nmobs) break;
   } while (distan[u - 1] - distan[u - 2] < .0001);
   --u;

   /* Now sort this subset of indx (that have the same distan value) by
      tdifs. */

   Idsort.idsort_(tdifs, indx, l, u);

   if (u == nmobs) break;
   else if (u > nmobs) iderr_("sptmsrt: u= " + u + " nmobs= " + nmobs +
      " mistake in secondary sort.");

   ++u;
   l = u;
}
}
}
