class Multint extends Surf {
static int ptnm = 0, nmsurfs = 3;
static double surfvals[][] = new double[DATSZE][3];
static int    mintgrd_nrow[] = new int[COLLIM];
static double mintgrd_ydim[] = new double[COLLIM];
static double mintgrd_ybegin[] = new double[COLLIM];
 
// ---------------------------------------------------------------------

static void mgrdset_(int sbrgnnm, int jcol, double xcord) {

/* Calculates even number of panels in x dimension and an even number of
   panels in the y dimension at the given xcord. */

boolean test = false;
int i;
double xmin, xmax, ymin, ymax, ymaxc, yminc, mindif, dif, del, epsilon;

if (test) printf_("mgrdset: jcol= " + jcol + " sbrgnnm= " +
   sbrgnnm + " spacetime_nmcols= " + spacetime_nmcols + " nmbdpts= " +
   bdry_nmbdpts[sbrgnnm - 1]);

if (jcol == 0) {

   // Assign the value of epsilon.

   epsilon = (bdry_xmax[sbrgnnm - 1] - bdry_xmin[sbrgnnm - 1]) / 1000.;

   // Check that the number of columns is an odd number.

   if (2 * (spacetime_nmcols / 2) == spacetime_nmcols) {
      ++spacetime_nmcols;
      printf_("mgrdset: ncol= " + (spacetime_nmcols - 1) +
	 " ncol must be an odd number in" +
         " mrgdset, using " + spacetime_nmcols);
   }

   /* Start epsilon in from left border and end epsilon in from right
      border. */
   
   xmin = bdry_xmin[sbrgnnm - 1] + epsilon;
   xmax = bdry_xmax[sbrgnnm - 1] - epsilon;
   spacetime_xdim = (xmax - xmin) / (double) (spacetime_nmcols - 1);
   if (test) printf_("xmin= " + xmin + " xmax= " + xmax);

   return;
}

/* Find smallest and largest y boundary values at this xcord and adjust
   ymin, ymax to these. */

ymin = bdry_ymax[sbrgnnm - 1];
ymax = bdry_ymin[sbrgnnm - 1];
for (i = 1; i < bdry_nmbdpts[sbrgnnm - 1]; ++i) {
   if ((bdry_xbdry[sbrgnnm - 1][i - 1] <= xcord) &&
      (xcord < bdry_xbdry[sbrgnnm - 1][i])) {
      yminc = .5 * (bdry_ybdry[sbrgnnm - 1][i - 1] +
	 bdry_ybdry[sbrgnnm - 1][i]);
      if (yminc < ymin) ymin = yminc;
   }
   if (bdry_xbdry[sbrgnnm - 1][i] <= xcord &&
       xcord < bdry_xbdry[sbrgnnm - 1][i - 1]) {
      ymaxc = .5 * (bdry_ybdry[sbrgnnm - 1][i - 1] +
	 bdry_ybdry[sbrgnnm - 1][i]);
      if (ymaxc > ymax) ymax = ymaxc;
   }
}

if (ymax <= ymin) ymax = ymin + .0001;
mintgrd_ybegin[jcol - 1] = ymin;

/* Find even number of panels in y dimension such that ydim is close to
   xdim. */

mindif = bdry_xmax[sbrgnnm - 1];
for (i = 4; i <= spacetime_nmcols + 50; i += 2) {
   del = (ymax - ymin) / (double) i;
   dif = Math.abs(spacetime_xdim - del);
   if (dif < mindif) {
      mintgrd_ydim[jcol - 1] = del;
      mintgrd_nrow[jcol - 1] = i + 1;
      mindif = dif;
   }
}
if (test) printf_("mindif= " + mindif + " jcol= " + jcol +
   " ymin= " + ymin + " ymax= " + ymax + " mnrow= " +
   mintgrd_nrow[jcol - 1] + " mydim= " + mintgrd_ydim[jcol - 1]);

return;
}

// -----------------------------------------------------------------

static double multint_(boolean first) {

/* Uses the product method with Simpson's Rule to integrate the surface
   that is a function of the LOMAP variable predictions stored in
   "grdvar_est" as formed in the function "estfunc_()."  For the first
   call, calculate the area by integrating the function f = 1. */

boolean test = true;
int it, i, j, iend, jend, ntimes = 1;
double tvol = 1., tmax = 1., tmin = 0., zval, zvale, val, tdim = 1.;
double sumodd[] = new double[MAXTIMES];
double sumeven[] = new double[MAXTIMES];
double intgrl[] = new double[MAXTIMES];
double innrint[][] = new double[COLLIM][MAXTIMES];

jend = spacetime_nmcols;

/* On first call, find the subregion's area. Each ntimes surface is
   assumed to have the same area. */

if (first) {
   if (test) printf_("multint: ntimes= " + ntimes);
   for (j = 1; j <= jend; ++j) {
      iend = mintgrd_nrow[j - 1];
      sumodd[0] = 0.;
      for (i = 2; i <= iend - 1; i += 2) ++sumodd[0];
      sumeven[0] = 0.;
      for (i = 3; i <= iend - 2; i += 2) ++sumeven[0];
      innrint[j - 1][0] = (mintgrd_ydim[j - 1] / 3.) *
	 (2. + 4. * sumodd[0] + 2. * sumeven[0]);
      if (test) printf_("multint: j= " + j + " nrow= " +
	 mintgrd_nrow[j - 1] + " ydim= " + mintgrd_ydim[j - 1] +
	 " jend= " + jend);
   }
   sumodd[0] = 0.;
   for (j = 2; j <= jend - 1; j += 2) sumodd[0] += innrint[j - 1][0];
   sumeven[0] = 0.;
   for (j = 3; j <= jend - 2; j += 2) sumeven[0] += innrint[j - 1][0];
   area = (spacetime_xdim / 3.) *(innrint[0][0] + innrint[jend - 1][0] +
      4. * sumodd[0] + 2. * sumeven[0]);

   // Find areas or volumes.

   if (temporal && ntimes > 1) {

      // Find the unit volume of a prediction.

      tvol = area * (tmax - tmin);
      pvol = tvol / (double) (spacetime_nmrows * spacetime_nmcols * ntimes);
      fprintf_(1, "Total volume= " + tvol +
         "\nVolume of each grid cube= " + pvol);

   } else if (!temporal) {
      tvol = area;
      pvol = tvol / (double) (spacetime_nmrows * spacetime_nmcols);
      fprintf_(1, "Integration area= " + area +
         "\nArea of each grid square= " + pvol);
   }
   if (area < 1.e-5) iderr_("Zero area in multint");

   // Set area to 1. if not finding expected value.

   area = 1.;
}

// Approximate each column's integral.

val = 0.;
ptnm = 0;
for (it = 0; it < ntimes; ++it) {
   for (j = 1; j <= jend; ++j) {

      // Approximate inner integral.

      iend = mintgrd_nrow[j - 1];

      sumodd[it] = 0.;
      for (i = 2; i <= iend - 1; i += 2) {
         zval = estfunc_(i, j);
	 if (test) printf_("multint: i= " + i + " j= " + j + " zval= " +
	    fdble_(zval, 6, 3));
         sumodd[it] += zval;
      }

      sumeven[it] = 0.;
      for (i = 3; i <= iend - 2; i += 2) {
         zval = estfunc_(i, j);
         sumeven[it] += zval;
      }

      zval = estfunc_(1, j);
      zvale = estfunc_(iend, j);
      innrint[j - 1][it] = (mintgrd_ydim[j - 1] / 3.) *
	 (zval + zvale + 4. * sumodd[it] + 2. * sumeven[it]);
      if (test) printf_("multint: j= " + j + " ydim= " + mintgrd_ydim[j - 1]);
   }

   // Approximate outer integral.

   sumodd[it] = 0.;
   for (j = 2; j <= jend - 1; j += 2) sumodd[it] += innrint[j - 1][it];
   sumeven[it] = 0.;
   for (j = 3; j <= jend - 2; j += 2) sumeven[it] += innrint[j - 1][it];

   intgrl[it] = (spacetime_xdim / 3.) * (innrint[0][it] +
      innrint[jend - 1][it] + 4. * sumodd[it] + 2. * sumeven[it]);

   val += intgrl[it] * tdim;
}

// if (!temporal) val /= area;
if (test) printf_("multint: xdim= " + spacetime_xdim + " tdim= " +
   tdim + " val= " + val);

return val;
}

// -------------------------------------------------------------------------

static double estfunc_(int i, int j) {

// Forms the function of the predicted surfaces.

int k;
double val;

// Accumulate statistics on each surface.

for (k = 0; k < nmsurfs; ++k) {
   surfvals[ptnm][k] = grdvar_est[i - 1][j - 1][0][lomapnms[k] - 1];
}
++ptnm;

// Compute composite surface value.

val = .333 * grdvar_est[i - 1][j - 1][0][lomapnms[0] - 1] +
      .333 * grdvar_est[i - 1][j - 1][0][lomapnms[1] - 1] +
      .500 * grdvar_est[i - 1][j - 1][0][lomapnms[2] - 1];

return val;
}
}
