import java.util.*;
class Mpemp extends CA {

// Finds the Most practical Ecosystem Management Plan (MPEMP).

static boolean createplots = false;

static String mpempfle = "none";

static double difflngthbetah = 1., gh_groupbetah = 1., mdlval,
   pure_profit_size, initiald = 0., initgh_groups = 1.;

static double xbest[] = new double[OPTSIZE];

// ------------------------------------------------------------------------

static void findmpemp_() {

/* The MPEMP is an actions history that causes a set of desired or target
   ecosystem state values to be produced by the ecosystem ID at a set of
   desired future time points.  This set of parameter values, referred to
   as beta_MPEMP, is found with the following algorithm:

                           MPEMP Algorithm

   1. Let Q(cbeta) be a vector of ecosystem state variables that are
      modeled by the simulator's ecosystem ID.  For example, Q(.)
      could be cheetah count and herbivore count in the year 2057.
      Set Q(.) to a set of desired values, q, eg 2,000 cheetah and
      10,000 herbivores in 2057.

   2. Update cbeta_H to the most recent cbeta_C and then compute
      q_H = E[Q(cbeta_H)].

   3. Specify q_d, and c_MPEMP.

   4. Compute: cbeta_MPEMP = argmax_cbeta^(Grp){
            g_H(cbeta^(Grp)) - ||E[Q(\cbeta)] - q_d|| / ||q_H - q_d|| }

      under the set of constraints given in c_MPEMP.  Initialize this
      search with the algorithm used in Step 2 of Consistency Analysis.

!Note: If a parameter is being modified in Parlearn.java, do not list this
       parameter as an independent variable in the MPEMP optimization step. */

int i, j, k;

long begintime, soltime;

double fracdiff = 0., dumval, desiredval = 0., divisor = 1.,
   initialmpempf, finalmpempf = 0., psi;

/* Verify that ecosystem ID parameters will not be adjusted.  This
   is necessary because it make no sense to modify the ecosystem's response
   when a desired set of ecosystem states under the fitted ecosystem
   model is the whole reason for finding beta_MPEMP. */

for (i = 0; i < Psens.nmsensids; ++i) {
   if (Psens.id[i].indexOf("eco", 0) >= 0) {
      iderr_("findmpemp: Psens.id(" + (i + 1) + ")= " + Psens.id[i]);
   }
}

// Set up the optimization run.

mpempsetup_();

/* Compute the initial value of "gh_groups" for purposes of computing the
   measure of political feasibility, "psi."  Do this by computing the
   agreement between "x_hyp" and "x_hyp" (very clever!).  First, turn
   on ecosystem calculations. */

Ecosyscalcs.skipeco = false;

for (i = 0; i < nmids - 1; ++i) {
  Intridslve.nminoutpairs[i] = 0;
}

Intridslve.mdlactnsfle = "mpemp_initial.ahs";
Intridslve.ipflag = true;
Beliefs.loadconsdst = false;

begintime = System.currentTimeMillis();
dumval = CAutils.caf_(x_hyp, true);
soltime = System.currentTimeMillis();
soltime = (soltime - begintime) / 1000L;

printf_("mpemp: soltime= " + soltime + " seconds.");

Intridslve.ipflag = false;
Beliefs.loadconsdst = true;

/* Compute the initial normalized distance to the desired ecosystem
   state vector:
   dist = ||E[Q(cbeta)] - q_d|| / ||q_H - q_d|| */

for (i = 0; i < nmcountries; ++i) {
   for (j = 0; j < Intridslve.nmmdltimes; ++j) {
      if (Displayactions.ecoobstime[i][j]) {
         for (k = 0; k < Intridslve.nmecosysnds; ++k) {
            desiredval = actnshstry_obsecoave[i][j][k];
            mdlval = actnshstry_mdlecoave[i][j][k];
	    initiald += Math.abs(mdlval - desiredval);

	    printf_("mpemp: country= " + i + " econode= " + k +
               " desiredval= " + fdble_(desiredval, 6, 3) + " mdlval= "
	       + fdble_(mdlval, 6, 3) + " initialttldiff= "
	       + fdble_(initiald, 6, 3));
         }
      }
   }
}

initgh_groups = gh_groups;
initialgs = gs;
ghdivisor = Math.abs(gh);
if (ghdivisor < 1.e-6) {
   ghdivisor = 1.;
}

// Compute initial MPEMP objective function value.

initialmpempf = initgh_groups - initiald / initiald;

printf_("mpemp: initialmpempf= " + initialmpempf);

// Perform the optimization to find cbeta_MPEMP.

Optimiz.optimiz_(n, m, x_ca, g, h, 6);

if (client) {
   printf_("mpemp: client initialization completed");

   return;
}

/* Print results.  These consist of first, the MPEMP: the sequence of
   all group actions that causes the political-ecological system simulator
   to produce the target ecosystem values.  Also print the differences
   between the target values and the model-computed values, and finally,
   print all group ID parameters that were changed to produce the MPEMP
   and their percent change from their value in the Hypothesis parameter
   vector, vbeta_. */

Intridslve.mdlactnsfle = "mpemp_final.ahs";
fprintf_(1, "\n----------------- MPEMP Solution --------------------" +
   "\n   (actions history is in the file mpemp_final.ahs)" +
   "\n   gs= " + gs + " gh= " + gh + " gca= " + gca +
   "\n   gs_groups= " + gs_groups + " gs_eco= " + gs_eco +
   "\n   gh_groups= " + gh_groups + " gh_eco= " + gh_eco);

/* Reload the solution vector with the distribution found by
   optimization.  This is necessary because of the
   normalization that occurs in pxp_(). */

for (idnmbrm1 = 0; idnmbrm1 < nmids; ++idnmbrm1) {
   for (i = 0; i < Psens.nmsensids; ++i) {
      if (nmids > 1 && !idname[idnmbrm1].equals(Psens.id[i])) {
         continue;
      }
      thisidname = idname[idnmbrm1];
      nmnds = Intridslve.nmndes[idnmbrm1];
      Pxp.pxp_(0, x_ca, g, h, 2, Psens.beginpar[i],
         Psens.begincnstrnt[i], false);
   }
}

/* Print all parameters and indicate those that have changed from their
   consistent value by more than 10%. */

fprintf_(1, "Note: * indicates the parameter has changed by more than 10%" +
"\nParameter#  ID     Node     Hypothesis_value  MPEMP_value   Frac_diff    >10%?");

for (i = 0; i < n; ++i) {

   // Compute a positive divisor.

   divisor = Math.abs(x_hyp[i]);
   if (divisor < 1.e-6) {
      divisor = 1.;
   }

   fracdiff = Math.abs(x_hyp[i] - x_ca[i]) / divisor;
   if (fracdiff > 0.1) {
      strng = "* \\\\";

   } else {
      strng = "   \\\\";
   }
   fprintf_(1, "  " + (i + 1) + " & " + idname[Pxp.idownerm1[i]] +
      " & " + Pxp.nodename[i] + " & " + fdble_(x_hyp[i], 6, 3) +
      " & " + fdble_(x_ca[i], 6, 3) + " & " + fdble_(fracdiff, 6, 3) + " & " + strng);
}

/* Print the desired ecosystem state variable expected values alongside
   those produced under the MPEMP.  (Currently, just for region 1) */

fprintf_(1, "\n   Desired and MPEMP Ecosystem Variable Values:" +
   "\nCountry  Time  Ecosystem_Node  Desired_Value  MPEMP_Value");

for (i = 0; i < nmcountries; ++i) {
   for (j = 0; j < Intridslve.nmmdltimes; ++j) {
      if (Displayactions.ecoobstime[i][j]) {
         for (k = 0; k < Intridslve.nmecosysnds; ++k) {
            desiredval = actnshstry_obsecoave[i][j][k];
            mdlval = actnshstry_mdlecoave[i][j][k];
            fprintf_(1, "   " + (i + 1) + "      " + (j + 1) + "         " +
	       (k + 1) + "       " + fdble_(desiredval, 6, 4) + "        " +
	       fdble_(mdlval, 6, 4));
         }
      }
   }
}

/* Compute the political feasibility measure and create plotting files for
   a subsequent Displayactions run.  The value of "initgh_groups" is
   computed with values in the hypothesis parameter values vector.  The
   value of "gh_groups" at the MPEMP solution, however, should be as large
   as possible while continuing to match the set of required actions.
   Therefore, a measure of political feasibility is the ratio
   
                    "gh_groups" / "initgh_groups." */

Intridslve.ipflag = true;
CAutils.caf_(x_ca, true);

psi = gh_groups / Math.abs(initgh_groups);

printf_("mpemp: initgh_groups= " + fdble_(initgh_groups, 6, 3) +
   " final gh_groups= " + fdble_(gh_groups, 6, 3) + " psi= " +
   fdble_(psi, 8, 3));
}

// -----------------------------------------------------------------------

static void mpempsetup_() {

// Set up a run to find the MPEMP.

int i, j, k;

double desiredval = 0., dumval;

CAutils.caSetup_(true);

/* Turn off the implicit constraint.  This constraint is handled as a
   penalty function in caf_(). */

m = 0;

/* Use a truth table to assign parameter values so that each ID produces
   the in-out pairs contained in "mpempfle." This feasible solution is
   used as the starting solution in the optimization step. */
	 
CAinitialize.cainitialize_("mpemp");

/* Reload the solution vector with the distribution found by
   "cainitialize_()." */

for (i = 0; i < nmids; ++i) {
   for (j = 0; j < Psens.nmsensids; ++j) {
      if (nmids > 1 && !idname[i].equals(Psens.id[j])) {
         continue;
      }
      thisidname = idname[i];
      idnmbrm1 = i;
      nmnds = Intridslve.nmndes[idnmbrm1];
      Pxp.pxp_(0, x_ca, g, h, 2, Psens.beginpar[j],
         Psens.begincnstrnt[j], false);
   }
}

// Compute match fractions.

for (i = 0; i < nmids - 1; ++i) {
  Intridslve.nminoutpairs[i] = 0;
}
Fitactions.actnsagree_(true);
initialgsgroups = gs_groups;

/* Compute the size of the biodiversity premium under
   the pure profit management strategy.  This is the absolute value of the
   biodiversity premium when profit-taking completely outweighs
   biodiversity enhancement.  Use this as a scaling constant in the MPEMP
   objective function, "mpempf_()," below.  It is assumed that the
   parameter values given in the input files represent this pure profit
   management strategy. */

if (Beliefs.isbusinessabm) {
   pure_profit_size = Math.abs(Beliefs.aveprofit);

} else {
   pure_profit_size = 1.;
}

/* Open the raw desired ecosystem data file and compute country-time averages
   and standard deviations. */

Ecosysutils.obsecoave_(nmobsactntimes, actnshstry_obsactntime);

fprintf_(1,
   "\n----------------- MPEMP Computation --------------------" +
   "\n   File of MPEMP actions: " + mpempfle +
   "\n   File of target ecosystem values= " + datafle +
   "\n   t0= " + Intridslve.t0 + " tfinal= " + Intridslve.tfinal +
   " nmmdltimes= " + Intridslve.nmmdltimes +
   "\n   Optimization Problem Degrees of Freedom (n)= " + n +
   "\n   Number of implicit constraints (m)= " + m);

}

// ----------------------------------------------------------------------

static double mpempf_(int n, double x[]) {

// Computes the objective function used to find the MPEMP.

int i, j, k;

double dumval, dval = 0., desiredval, retval, biopremium = 0.;

// Compute "gs_groups" and "gh_groups."

dumval = CAutils.caf_(x, false);

/* Compute the normalized distance to the desired ecosystem state vector:
   dist = ||q_d - E[Q(cbeta)]|| / ||q_H - q_d|| if numerator is positive,
   and 0, otherwise. */

for (i = 0; i < nmcountries; ++i) {
   for (j = 0; j < Intridslve.nmmdltimes; ++j) {
      if (Displayactions.ecoobstime[i][j]) {
         for (k = 0; k < Intridslve.nmecosysnds; ++k) {
            desiredval = actnshstry_obsecoave[i][j][k];
            mdlval = actnshstry_mdlecoave[i][j][k];

            if (desiredval > mdlval) {
               dval += desiredval - mdlval;

            } else {
               dval += 0.;
            }
	    
            /*
            printf_("mpempf: time= " + actnshstry_obsecotime[i][j][k] +
               " desiredval= " + desiredval +
               " mdlval= " + fdble_(mdlval, 8, 2));
            */
         }
      }
   }
}

if (Beliefs.isbusinessabm) {

   /* Use the negative of the in-country operation's average profit over
      the time interval as a proxy for the biodiversity offering's
      biodiversity premium. */

   biopremium = -Beliefs.aveprofit;

} else {
   biopremium = 0.;
}

/* Compute the objective function.  Weighting the ecosystem goal as ten
   times as important as the hypothesis agreement goal and the biodiversity
   premium goals ensures the ecosystem goal is met as close as possible
   with the least impact possible on these other two goals. */

biopremium /= pure_profit_size;
dval /= initiald;
retval = gh_groups - biopremium - 1. * dval;

//" bioprem/pp= " + fdble_(biopremium, 5, 2) +

printf_("mpempf:" +
   " gh_groups= " + fdble_(gh_groups, 6, 3) +
   " mdlecoval= " + fdble_(mdlval, 8, 3) +
   " diffecoval/initdiff= " + fdble_(dval, 6, 3) +
   " f= " + fdble_(retval, 6, 3));

return retval;
}
}
