public class Mdobjf extends Surf {
static boolean gls = false, appchol = false;

static int momobjf = 0;

static int nmdat[] = new int[NUMVAR];
static int indx[] = new int[10 * WLSSZE];

static double sumabsdiff = 0., maxttlvar = 1.;

static double lgsclresids[] = new double[WLSSZE];
static double stdres[] = new double[10 * WLSSZE];
static double y[] = new double[MMXM + 1];
static double fy[] = new double[MMXM + 1];
static double co[] = new double[MMXN + 2];
static double em[] = new double[4];
static double dum1[] = new double[WLSSZE];
static double dum2[] = new double[WLSSZE];
static double mean[] = new double[WLSSZE];
static double stdvec[] = new double[WLSSZE];
static double maxvec[] = new double[WLSSZE];
static double trim[] = new double[WLSSZE];
static double krnlwghts[][] = new double[NUMCNTR][WLSSZE];
static double moments[] = new double[4];

// --------------------------------------------------------------------

public static double mdobjf_(int n, double a[], double g[], double h[]) {

// Evaluate Least Squares or Cramer-vonMises objective function.

boolean test = false, ls = false;

int i, i1, j, k = 0, stnm;

double fp, sum, sse = 0., krnlsum, resmean = 0., rnd = (double) nd,
   mmntpen, diff, m1diff, m2diff, m3diff, m4diff, r2 = 0.;

// First, load trend, transformation, and covariogram matrix parameter values.

if (Estimate.local) {

   // LOMAP: first, load trend parameters.

   k = 0;
   for (i = 0; i < parm_mvar; ++i) {
      for (j = 0; j < nmpars[i]; ++j) {
         grdvar_rparm[i][j] = a[k];
         ++k;
      }
   }

   if (k != nmtrendpars) {
      iderr_("mdobjf: k != nmtrendpars");
   }

   if (trnsfrm) {

      // Load transformation parameters.

      for (i1 = 0; i1 < parm_mvar; ++i1) {
         trnsfrm_tau1[i1] = a[k];
         trnsfrm_tau2[i1] = a[k + 1];
         trnsfrm_invtau1[i1] = 1. / trnsfrm_tau1[i1];
         trnsfrm_invtau2[i1] = 1. / trnsfrm_tau2[i1];
         k += 2;
      }
   }

   /* Load local covariogram parameters. "offset" has been set in the
      call to "vargrm_" in "estimate_." */

   Loadpar.loadpar_(3, 0, a, g, h);

} else if (!Estimate.local) {
   
   /* For the mixture model (GLOMAP), load parameter values for each
      GLOMAP component and variable. */

   k = 0;
   if (nmstmixcntr > 1 && spatial && !temporal) {
      for (i = 1; i <= nmstmixcntr; ++i) {

         // Load ith kernel center and kernel variance.

         stmix_xcntr[i - 1] = a[k];
         stmix_ycntr[i - 1] = a[k + 1];
         stmix_krnlvar[i - 1] = a[k + 2];
         k += 3;
      }
   }

   // Compute and store kernel weights on the observation locations.

   for (i = 0; i < nd; ++i) {
      if (nmstmixcntr > 1) {
         krnlsum = 0.;
         for (j = 0; j < nmstmixcntr; ++j) {
            krnlwghts[j][i] = Trendeval.mixkernel_(j + 1, vardat_x[i],
               vardat_y[i], vardat_t[i]);
            krnlsum += krnlwghts[j][i];
         }
         for (j = 0; j < nmstmixcntr; ++j) krnlwghts[j][i] /= krnlsum;

      } else if (nmstmixcntr == 1) {
         krnlwghts[0][i] = 1.;
      }
   }

   // Load trend parameters.

   for (i = 1; i <= nmstmixcntr; ++i) {
      for (i1 = 0; i1 < parm_mvar; ++i1) {
         for (j = 0; j < nmpars[i1]; ++j) {
	    stmix_rparm[i - 1][i1][j] = a[k];
	    ++k;
         }
      }
   }
}

/* Next, compute the MVN residuals (Z vector in Haas (2000) notation).
   If performing Least Squares, compute the Sum of Squares function. */

fp = 0.;
sum = 0.;
for (i = 0; i < nd; ++i) {

   // Nonmixture or mixture trend model.

   stnm = idtostnm[vardat_vrble[i] - 1];
   if (nmstmixcntr == 0) {
      vardat_trend[i] = Trendeval.trendfcn_(0, true, i, vardat_x[i],
         vardat_y[i], vardat_t[i], vardat_quantval[i], vardat_qualval[i],
         stnm);

   } else {
      vardat_trend[i] = 0.;
      for (j = 0; j < nmstmixcntr; ++j) {
	 vardat_trend[i] += krnlwghts[j][i] * Trendeval.trendfcn_(
            j + 1, true, i, vardat_x[i], vardat_y[i], vardat_t[i],
	    vardat_quantval[i], vardat_qualval[i], stnm);
      }
   }
   if (vardat_trend[i] == -1.e30) {
      iderr_("mdobjf: trend= -infinity");
   }

   if (trnsfrm) {

      // Compute residuals and  sse.

      vardat_dat[i] = vardat_obs[i] - vardat_trend[i];
      resmean += vardat_dat[i];
      sse += vardat_dat[i] * vardat_dat[i];

      // Transform to the gaussian.

      vardat_dat[i] = Trnsfrm.gaus_(stnm, vardat_dat[i]);

      if (Double.isNaN(vardat_dat[i]) || Math.abs(vardat_dat[i]) > 1.e6) {
         printf_("mdobjf: vrble= " + stnm + " obs= " +
            vardat_obs[i] + " trend= " + vardat_trend[i] +
            " res= " + vardat_dat[i] +
            "\ntau1= " + trnsfrm_tau1[stnm - 1] +
            " tau2= " + trnsfrm_tau2[stnm - 1]);
	 vardat_dat[i] *= 1.e30;
      }

   } else {
      vardat_dat[i] = vardat_obs[i] - vardat_trend[i];
      resmean += vardat_dat[i];
      sse += vardat_dat[i] * vardat_dat[i];
      sumabsdiff += Math.abs(vardat_dat[i]);
   }

   if (ls) {
      fp += vardat_dat[i] * vardat_dat[i];
      sum += vardat_dat[i];
   }
   indx[i] = i + 1;
}
resmean /= rnd;
if (grdvar_datssy > 0.) {
   r2 = 1. - (sse / grdvar_datssy);
}

if (ls) {

   // Penalize for a negative r2 and return.

   if (r2 < 0.) {
      return 1.e3 * fp;
   
   } else {
      return fp;
   }
}

// Compute the MD objective function.

fp = 1.e0 * distdist_(nd);

// Penalize for a negative r2.

if (r2 < 0.) {
   fp *= 1.e3;
}

if (true) {
   return fp;
}

// Compute a penalty for deviations from the first 4 moments.

if (Math.abs(moments[0]) > 1.e10) {
   printf_("mean big in mdobjf");
   fp = 1.e20;
   return 0;
}

m1diff = Math.abs(0. - moments[0]);
m2diff = Math.abs(1. - moments[1]);
m3diff = Math.abs(0. - moments[2]);
m4diff = Math.abs(0. - moments[3]);

if (Optimiz.funevals < 3) {
   maxttlvar = varmod_ttlvar[0];
}
fp = .1 * fp + .8 * (m1diff + m2diff) + .1 * varmod_ttlvar[0] / maxttlvar;
return fp;
}

// ---------------------------------------------------------------------

public static double distdist_(int nd) {

/* Computes the distance between the empirical distribution and the
   gaussian distribution for correlated residuals in vardat_dat. */

int i, j, im, in, cvstrct, vari, varj;

double rowsum, maxeig, retval, val, sum, dist = 0., diff = 0., rnt2,
   normcdf, empcdf, maxdiff = 0., maxerr, err, xerr, appval, realval,
   xpower, xval, lngth;

/* Build covariance matrix, and then find its Cholesky decomposition.
   First, form correlated error covariance matrix in form_a. */

for (i = 0; i < nd; ++i) {
   vari = idtostnm[vardat_vrble[i] - 1];
   for (j = 0; j <= i; ++j) {
      varj = idtostnm[vardat_vrble[j] - 1];

      // Find covariance structure to be used.

      if (vari == varj) {
         cvstrct = vari;

      } else {
         cvstrct = crossmap[vari - 1][varj - 1];
      }

      // Compute (possibly nonstationary) covariance and fill in upper half.

      form_a[i][j] = Covmodl.covmodl_(i, j, vardat_x[i], vardat_y[i],
                                            vardat_t[i], vardat_x[j],
                                            vardat_y[j], vardat_t[j],
				            cvstrct);
      if (i != j) {
	 form_a[j][i] = form_a[i][j];
      }
   }

   // Check for exact singularity.

   if (i > 0) {
      exactsg_(form_a, i, "mdobjf");
   }
}

/* Find i.i.d. N(0,1) residuals.  Use Cholesky decomposition if nd is small.
   Otherwise, use the matrix polynomial approximation from Davis (1987). */

if (!appchol) {

   /* Form lower triangular matrix from form_a.  If this decomposition
      fails, quit. */

   retval = Choles.choles_(form_a, s, 1, nd, false);
   if (retval < 0. || Double.isNaN(retval)) {
      Optimiz.cnstrnt[1] = -1.;
      iderr_("mdobjf: Cholesky failed");
      return 1.e30;

   }
   
   // Compute transformed residuals.

   stdres[0] = vardat_dat[0] / s[0][0];
   for (i = 1; i < nd; ++i) {
      sum = 0.;
      for (j = 0; j < i; ++j) {
	 sum += s[i][j] * stdres[j];
      }
      stdres[i] = (vardat_dat[i] - sum) / s[i][i];
   }

} else {

   /* Approximate the standardized residuals.  First, setup
      computations.  First, find the upper bound on the largest
      eigenvalue of the covariance matrix. Use the Power method to
      estimate of the largest eigenvalue. */

   lngth = 0.;
   for (i = 0; i < nd; ++i) {
      dum1[i] = Rndm.rndm1_(0, 0);
      lngth += dum1[i] * dum1[i];
   }
   lngth = Math.sqrt(lngth);

   for (i = 0; i < nd; ++i) {
      dum1[i] /= lngth;
   }

   maxeig = Eigenvec.powerm_(form_a, dum1, 1.e-4, nd, 10);

   /* Now compute the minmax polynomial approximation to the function
      f(y) = y^(-1/2) at several points over the interval (0, maxeig). */

   for (i = 0; i <= 20; ++i) {
      y[i] = 1.05 * maxeig * ((double) (i + 1)) / 21.;
      fy[i] = 1. / Math.sqrt(y[i]);
   }
   em[2] = 10. * (18.) + 5.;
   Minmax.minmax_(18, 20, y, fy, co, em);

   // Check accuracy of approximation.

   maxerr = 0.;
   xerr = 0.;
   for (i = 1; i <= 40; ++i) {
      xval = maxeig * ((double) (i)) / 40.;

      xpower = 1.;
      appval = co[0];
      for (j = 1; j <= 18; ++j)  {
         xpower *= xval;
         appval += co[j] * xpower;
      }

      realval = 1. / Math.sqrt(xval);
      err = (realval - appval) / realval;
      if (Math.abs(err) > maxerr) {
         xerr = xval;
         maxerr = err;
      }
   }
   if (maxerr > .05) {
      iderr_("mdobjf: maxeig= " + maxeig + " em1= " + em[1] +
	 "\n maxerr= " + maxerr + " xerr= " + xerr);
   }

   /* Now compute stdres approx Sigma^(-1/2) * resids using Horner's
      rule similar to how Davis (1987) computes Sigma^(1/2) * resids. */

   Vectr.vzro_(stdres, nd);
   for (i = 0; i < nd; ++i) {
      dum1[i] = dum2[i] = vardat_dat[i];
   }
   Vectr.sxv_(co[0], dum2, nd);
   Vectr.vupdt_(stdres, dum2, nd);
   for (im = 1; im <= 18; ++im) {
      Matrix.mxv_(form_a, dum1, dum2, nd, nd);

      for (in = 0; in < nd; ++in) {
	 dum1[in] = dum2[in];
      }

      Vectr.sxv_(co[im], dum2, nd);
      Vectr.vupdt_(stdres, dum2, nd);
   }
}

// Store the standardized, "whitened" residuals and compute their moments.

for (i = 0; i < nd; ++i) {
   if (Double.isNaN(stdres[i])) {
      
      // Cholesky returned NaN, terminate job.

      iderr_("mdobjf: NaN in stdres on i= " + i);
      return 1.e10;
   }
   vardat_stdres[i] = stdres[i];
   indx[i] = i;
}
Summry.moments_(false, nd, stdres, moments);

// Finally, compute objective function value.

if (gls) {

   // Generalized Least Squares.

   for (i = 0; i < nd; ++i) dist += stdres[i] * stdres[i];
   return dist;

} else if (momobjf == 1) {
   return Math.abs(0. - moments[0]);

} else if (momobjf == 2) {
   return Math.abs(0. - moments[0]) + Math.abs(1. - moments[1]);

} else {
   if (Idsort.idsort_(stdres, indx, 1, nd) == 1) {
      for (i = 0; i < nd; ++i) {
         printf_("mdobjf: i= " + i + " stdres= " + vardat_stdres[i]);
      }
      iderr_("mdobjf: Cramer-vonMises idsort failed");
   }

   rnt2 = 2. * ((double) nd);
   for (i = 1; i <= nd; ++i) {
      empcdf = (2. * ((double) i) - 1.) / rnt2;
      normcdf = Pltnrm.cump_(stdres[i - 1]);

      /* Komogorov-Smirnoff normality test statistic.

      diff = Math.abs(empcdf - normcdf);
      if (diff > maxdiff) {
         maxdiff = diff;
      }
      */

      // Cramer-vonMises distance.

      val = empcdf - normcdf;
      dist += val * val;
   }
}

/* Shapiro-Francia normality test statistic.

dist = -Pltnrm.shapfran_(nd, stdres, moments[0]);
return dist + maxdiff;
*/

return dist;
}

// ------------------------------------------------------------------------

public static double eucdist_(int n, int nmvar, double data[][],
   double xobs[]) {

/* Computes the standardized Euclidean distance between xobs and the
   closest member of "data."  This is a relative form of the nearest
   neighbor density estimator given in Thompson and Tapia 1990, p. 179. */

int i, j, m;

double diff;

// Compute the number of nearest neighbors to use.

m = (int) (.2 * ((double) n));
if (m == 0) m = 1;

for (i = 0; i < nmvar; ++i) {
   nmdat[i] = n;
   trim[i] = 0.;
}
Summry.summry_(false, 1, nmdat, nmvar, trim, data, mean, stdvec, maxvec);

// Find the m^th closest standardized distance between xobs the data.

for (i = 0; i < n; ++i) {
   indx[i] = i + 1;
   stdres[i] = 0.;
   for (j = 0; j < nmvar; ++j) {
      if (stdvec[j] > 1.e-20) diff = (data[i][j] - xobs[j]) / stdvec[j];
      else diff = data[i][j] - xobs[j];
      stdres[i] += diff * diff;
   }
}
Idsort.idsort_(stdres, indx, 1, n);
return stdres[m - 1];
}
}
