import java.rmi.RemoteException;
import java.util.*;
import java.util.concurrent.TimeUnit;

import org.openspaces.core.GigaSpace;
import org.openspaces.core.GigaSpaceConfigurer;
import org.openspaces.core.space.EmbeddedSpaceConfigurer;
import org.openspaces.core.space.SpaceProxyConfigurer;

import java.util.Arrays;
import java.util.Properties;

class Mcpstd extends Surf {
static int m;
static int nmdat[] = new int[NUMVAR];
static int indx[] = new int[DATSZE];
static int nmsim[] = new int[OPTSIZE];

static double trimfrac[] = new double[OPTSIZE];
static double meanvec[] = new double[OPTSIZE];
static double stderrvec[] = new double[OPTSIZE];
static double maxvec[] = new double[OPTSIZE];
static double mcests[][] = new double[DATSZE][OPTSIZE];
static double estimates[] = new double[OPTSIZE];
static double slags[][] = new double[DATSZE][DATSZE];
static double tlags[][] = new double[DATSZE][DATSZE];
static double glblcov[][] = new double[DATSZE][DATSZE];
static double sqmat[][] = new double[DATSZE][DATSZE];
static double sqrtvs[][] = new double[DATSZE][DATSZE];
static double sqrtv[][] = new double[DATSZE][DATSZE];
static double obstrend[] = new double[DATSZE];
static double stdnrms[] = new double[DATSZE];
static double strtau1[] = new double[NUMVAR];
static double strtau2[] = new double[NUMVAR];
static double moments[] = new double[4];
static double mdat[] = new double[DATSZE];

static GigaSpace gspace = null;

// ------------------------------------------------------------------------

static int parstderr_(double xcord, double ycord, double tmecord) {

// Parameter estimate standard errors via Monte Carlo.

int cvstrct, i, i1, j, k, stnmi, stnmj;

double retval;

fprintf_(1,
   "\n------ Parameter Estimate Standard Errors via Monte Carlo ------\n");
// iderr_("in parstderr");

// Store trend values.

for (i = 0; i < nd; ++i) {
   obstrend[i] = vardat_trend[i];
}

if (trnsfrm) {
   for (i = 0; i < parm_mvar; ++i) {
      strtau1[i] = trnsfrm_tau1[i];
      strtau2[i] = trnsfrm_tau2[i];
   }
}

/* Form sigmafull = Sigma_{Z_1,...,Z_n}.  Find the Cholesky decomposition
   of sigmafull.  Apply adjustments if the decomposition fails.  First,
   zero-out covariance matrices. */

for (i = 0; i < nd; ++i) {
   for (j = 0; j < nd; ++j) {
      glblcov[i][j] = 0.;
      sqmat[i][j] = 0.;
   }
}

for (k = 0; k < 4; ++k) {

   for (i = 0; i < nd; ++i) {

      /* Verify that "vardat" coordinates and variables are identical to
	 those of dat2. */

      if (vardat_vrble[i] != idtostnm[dat2_vrble[1][i] - 1]) {
	 iderr_("parstderr: vrble mismatch");
      }

      if (vardat_x[i] != dat2_x[i]) {
	 iderr_("parstderr: x mismatch");
      }

      if (vardat_y[i] != dat2_y[i]) {
	 iderr_("parstderr: y mismatch");
      }

      if (vardat_t[i] != dat2_t[i]) {
	 iderr_("parstderr: t mismatch");
      }

      if (vardat_vrble[i] != idtostnm[dat2_vrble[1][i] - 1]) {
	 iderr_("parstderr: vrble mismatch");
      }

      for (j = 0; j <= i; ++j) {
	 stnmi = idtostnm[vardat_vrble[i] - 1];
	 stnmj = idtostnm[vardat_vrble[j] - 1];
         if (vardat_vrble[i] == vardat_vrble[j]) {
            cvstrct = stnmi;
    
         } else {
            cvstrct = crossmap[stnmi - 1][stnmj - 1];
         }

         glblcov[i][j] = Covmodl.covmodl_(i, j, vardat_x[i], vardat_y[i],
            vardat_t[i], vardat_x[j], vardat_y[j], vardat_t[j], cvstrct);

         if (i != j) glblcov[j][i] = glblcov[i][j];
      }

      // Check for singularity.

      if (i > 0) {
         exactsg_(glblcov, i, "parstderr: glblcov");
      }
   }

   retval = Choles.choles_(glblcov, sqmat, 1, nd, false);
   if (retval < 0.) {
      printf_("parstderr: k= " + k + " cholesky retval= " + retval);
      iderr_("parstderr: invalid model");

   } else {
      break;
   }

   // Adjust covariogram matrix parameters depending on loop counter.

   if (k == 0) {
      for (i = 1; i < parm_mvar; ++i) {
         for (j = 0; j < i; ++j) {
            cvstrct = crossmap[i][j];
            printf_("parstderr: fitted cross-sill= " +
               varmod_sill[0][cvstrct - 1]);
            printf_("setting cross-sills to 0");
            for (i1 = krnlstart; i1 <= krnlend; ++i1) {
               varmod_sill[i1][cvstrct - 1] = 0.;
            }
         }
      }

   } else if (k == 1) {
      for (i = 1; i < parm_mvar; ++i) {
         for (j = 0; j < i; ++j) {
            cvstrct = crossmap[i][j];

            if (varmod_model[cvstrct - 1] == 3) {
               iderr_("parstderr: invalid nuggets");
            }

            printf_("parstderr: fitted cross-nugget= " +
               varmod_nugget[0][cvstrct - 1]);
            printf_("setting cross-nuggets to 0");
            for (i1 = krnlstart; i1 <= krnlend; ++i1) {
               varmod_nugget[i1][cvstrct - 1] = 0.;
            }
         }
      }

   } else if (k == 2) {
      printf_("parstderr: setting direct nuggets to sample variances" +
         " and direct sills to 0.");
      for (i = 0; i < parm_mvar; ++i) {
         printf_("parstderr: Variable " + lomapnms[i] + " smplvr= " +
            varmod_smplvr[i]);
         for (i1 = krnlstart; i1 <= krnlend; ++i1) {
            varmod_nugget[i1][i] = varmod_smplvr[i];
            varmod_sill[i1][i] = 0.;
         }
      }
 
   } else if (k > 2) {
      iderr_("parstderr: cannot fix sigmafull");
   }
}
printf_("parstderr: k= " + k);

/* Simulation loop.  First, open file for writing final objective function
   value and parameter estimates from simulated data and write
   actual-data values to it. */

fleopen_(8, "parests.dat", 'w');
fprintf_(8, parm_mvar + " " + nmmdls);

// Write sample-based parameter estimates to the file.

for (j = 0; j < ttlnmpars; ++j) {
   fprintf_(8, " " + Estimate.a[j]);
}

// Set the number of Monte Carlo samples to be generated.

m = 10 * ttlnmpars; // m=65 for Hess paper.

/* Call either the impresario or the sequential routine to
   perform the "m" Monte Carlo parameter estimates. */

if (!client && space_in_use) {
   impresario_(xcord, ycord, tmecord);

} else {
   sequential_(xcord, ycord, tmecord);
}

fclose_(8, 'w');

if (!client) {

   // Compute parameter estimate standard errors from MC-based estimates.

   fleopen_(8, "parests.dat", 'r');
   fgetint_(8);
   fgetint_(8);
   for (j = 0; j < ttlnmpars; ++j) {
      estimates[j] = fgetdble_(8);
   }
   for (i = 0; i < m; ++i) {
      for (j = 0; j < ttlnmpars; ++j) {
         mcests[i][j] = fgetdble_(8);
      }
   }
   fclose_(8, 'r');

   for (i = 0; i < ttlnmpars; ++i) {
      nmsim[i] = m;
      trimfrac[i] = 0.;
   }
   Summry.summry_(false, 1, nmsim, ttlnmpars, trimfrac, mcests, meanvec,
      stderrvec, maxvec);

   fprintf_(1, "\n Parameter  Estimate   Standard Error" +
      "   Coefficient of Variation\n");
   for (i = 0; i < ttlnmpars; ++i) {
      fprintf_(1, "  " + (i + 1) + "   " + estimates[i] + "  " +
	 stderrvec[i] + "   " + (stderrvec[i] / Math.abs(estimates[i])));
   }
   fprintf_(1, "\n------ End of Monte Carlo Standard Errors ------\n");
}

Hooke.terminateClients_(gspace);

return 0;
}

// ----------------------------------------------------------------------

static void sequential_(double xcord, double ycord, double tmecord) {

// Sequential Monte Carlo standard errors routine.

int i, i1, j, stnm;

// Monte Carlo realization-model estimation loop.

for (i = 1; i <= m; ++i) {
   if (trnsfrm) {

      /* Reload transformation parameter values that were estimated from
         the actual data. */

      for (j = 0; j < parm_mvar; ++j) {
         trnsfrm_tau1[j] = strtau1[j];
         trnsfrm_tau2[j] = strtau2[j];
	 trnsfrm_invtau1[j] = 1. / trnsfrm_tau1[j];
	 trnsfrm_invtau2[j] = 1. / trnsfrm_tau2[j];
      }
   }

   // Generate a realization on (Q_i(x_1), ... , Q_i(x_n))'.

   for (j = 0; j < nd; ++j) {
      stdnrms[j] = Rndm.stdnrm_(0);
   }

   // Compute the gaussian scale realizations.

   for (j = 0; j < nd; ++j) {
      dat2_dat[j] = 0.;
      for (i1 = 0; i1 < nd; ++i1) {
         dat2_dat[j] += sqmat[j][i1] * stdnrms[i1];
      }

      /* Compute observed scale realization. */

      stnm = idtostnm[dat2_vrble[1][j] - 1];
      dat2_dat[j] = Trnsfrm.invgaus_(stnm, dat2_dat[j]);
      dat2_dat[j] += obstrend[j];
   }

   // Estimate parameter values for this simulated sample.

   Estimate.glomapest_(xcord, ycord, tmecord);

   // Write all parameter estimates to the file.

   for (j = 0; j < ttlnmpars; ++j) {
      fprintf_(8, " " + Estimate.a[j]);
   }
}
}

// -----------------------------------------------------------------------

static void impresario_(double xcord, double ycord, double tmecord) {

// JavaSpaces Monte Carlo standard errors calculation.

int i, i1, j, k, vnmbr, stnm;

double ftest;

// Get a new GigaSpace object.

if (space_in_use && gspace == null) {

   // Get a new Space object.

   gspace = new GigaSpaceConfigurer(new SpaceProxyConfigurer(
      spacename)).defaultTakeTimeout(spacetakewaittime).gigaSpace(); 

   if (gspace == null ) {
      iderr_("Mcpstd.impresario: gspace=null");
   }
}

// Monte Carlo realization-model estimation loop.

for (i = 1; i <= m; ++i) {
   if (trnsfrm) {

      /* Reload transformation parameter values that were estimated from
         the actual data. */

      for (j = 0; j < parm_mvar; ++j) {
         trnsfrm_tau1[j] = strtau1[j];
         trnsfrm_tau2[j] = strtau2[j];
	 trnsfrm_invtau1[j] = 1. / trnsfrm_tau1[j];
	 trnsfrm_invtau2[j] = 1. / trnsfrm_tau2[j];
      }
   }

   // Generate a realization on (Q_i(x_1), ... , Q_i(x_n))'.

   for (j = 0; j < nd; ++j) {
      stdnrms[j] = Rndm.stdnrm_(0);
      indx[j] = j;
   }

   // Compute the gaussian scale realizations.

   for (j = 0; j < nd; ++j) {
      dat2_dat[j] = 0.;
      for (i1 = 0; i1 < nd; ++i1) {
         dat2_dat[j] += sqmat[j][i1] * stdnrms[i1];
      }

      // Compute observed scale realization.

      stnm = idtostnm[dat2_vrble[1][j] - 1];
      dat2_dat[j] = Trnsfrm.invgaus_(stnm, dat2_dat[j]);
      dat2_dat[j] += obstrend[j];
   }

   // Print the sample moments of this realization.

   for (i1 = 0; i1 < parm_mvar; ++i1) {
      vnmbr = lomapnms[i1];
      k = 0;
      for (j = 0; j < nmecoobsttl; ++j) {
         if (dat2_vrble[1][j] == i1 + 1) {
            mdat[k] = dat2_dat[j];
            ++k;
         }
      }
      Summry.moments_(false, nmobs[idnmbrm1][vnmbr - 1], mdat, moments);
      fprintf_(1, "vrble= " + (i1 + 1) + " " + moments[2] + " " +
	 moments[3]);
   }

   // Enter this task into the space.

   printf_("writing task " + i);
   Mcpstdtask task = new Mcpstdtask(i, thisidname, nd, dat2_dat);
   gspace.write(task);
}

// Collect task results from space.

ResultEntry template = new ResultEntry();
for (i = 1; i <= m; ++i) {
   ResultEntry result = new ResultEntry();
   result = (ResultEntry)
   gspace.take(template);

   if (Mcpstdresult.class.isInstance(result)) {
      Mcpstdresult mc = (Mcpstdresult) result;

      printf_("reading result of task " + mc.i.intValue() + ", " +
         (m - i) + " to go.");

      // Write objective function value.

      ftest = mc.retftest.doubleValue();

      if (trnsfrm) {

         // Write estimated skew and kurtosis parameters.
         
	 for (j = 0; j < parm_mvar; ++j) {
            trnsfrm_tau1[j] = mc.rettau1[j].doubleValue();
            trnsfrm_tau2[j] = mc.rettau2[j].doubleValue();
	    trnsfrm_invtau1[j] = 1. / trnsfrm_tau1[j];
	    trnsfrm_invtau2[j] = 1. / trnsfrm_tau2[j];

            fprintf_(8, i + " " + ftest + " " +
	       nodelbls[idnmbrm1][lomapnms[j] - 1][0] + " " +
	       trnsfrm_tau1[j] + " " + trnsfrm_tau2[j]);
	 }
      }

      // Write covariogram matrix parameter estimates.

      for (j = 0; j < nmmdls; ++j) {
	 varmod_nugget[0][j] = mc.retnugget[j].doubleValue();
	 varmod_sill[0][j] = mc.retsill[j].doubleValue();
	 varmod_range[0][1][j] = mc.retrange[j].doubleValue();

	 fprintf_(8, j + " " + varmod_nugget[0][j] + " " +
	    varmod_sill[0][j] + " " + varmod_range[0][1][j]);
      }
   }
}

// Terminate clients.

printf_("terminating clients");
MsgEntry msg = new MsgEntry();
msg.message = "terminate";
gspace.write(msg);
}
}
