public class Mcpredict extends Predict {
static int index[] = new int[WLSSZE];
static int ipvtzz[] = new int[WLSSZE];
static int nmsim[] = new int[NUMVAR];

static double condmx = 1.e+25;

static double work[] = new double[WLSSZE];
static double b[] = new double[WLSSZE];
static double krnlwghts[] = new double[NUMCNTR];
static double meanvec[] = new double[NUMVAR];
static double trendvals[] = new double[NUMVAR];
static double trimfrac[] = new double[NUMVAR];
static double stdnrms[] = new double[WLSSZE];
static double mat1[][] = new double[WLSSZE][NUMVAR];
static double sigmazxzx[][] = new double[NUMVAR][NUMVAR];
static double mat2[][] = new double[NUMVAR][NUMVAR];
static double covmat[][] = new double[NUMVAR][NUMVAR];
static double simpreds[][] = new double[SIMSZE][NUMVAR];
static double simwx0[][] = new double[SIMSZE][NUMVAR];
static double simwx0ht[][] = new double[SIMSZE][NUMVAR];
static double simerrs[][] = new double[SIMSZE][NUMVAR];
static double sigmazz[][] = new double[WLSSZE][WLSSZE];
static double sigmazxz[][] = new double[NUMVAR][WLSSZE];
static double sqrtmat[][] = new double[NUMVAR][NUMVAR];
static double wx0[] = new double[NUMVAR];
static double wx0hat[] = new double[NUMVAR];
static double stderrvec[] = new double[NUMVAR];
static double maxvec[] = new double[NUMVAR];

// ----------------------------------------------------------------------

public static int mcpredict_(boolean start, double xcord, double ycord,
   double tmecord, double pred[]) {

/* Monte Carlo approximation of the conditional expected value at the
   prediction location (xcord, ycord, tmecord). */

int i, j, k, i1, m, vrble, nfrac, cvstrct, stnm, stnmi, stnmj;

double cilength, minlength = 1.e30, cilevel = .68, cilow = 0., cihigh = 0.,
   krnlsum, resmean = 0., rnd = (double) nd, bigval = 0.;

m = 50;
if (start) {
   if (m > WLSSZE) {
      iderr_("mcpredict: m= " + m + " > WLSSZE");
   }

   // Find the quantitative and qualtitative node values at (xcord, ycord).

   if (icrval == 0 || icrval == 2) {
      Trendeval.quantqual_(xcord, ycord, tmecord, quantval, qualval);

   } else if (icrval == 1) {
      for (i = 0; i < nmquantvar; ++i) {
         quantval[i] = dat2_quantval[idatcr - 1][i];
      }
      for (i = 0; i < nmqualvar; ++i) {
         qualval[i] = dat2_qualval[idatcr - 1][i];
      }
   }

   /* Compute trend for the nonmixture or mixture trend model at the
      prediction location. */

   if (nmstmixcntr == 0) {
      for (i = 0; i < parm_mvar; ++i) {
         stnm = idtostnm[lomapnms[i] - 1];
         trend[stnm - 1] = Trendeval.trendfcn_(0, true, 0, xcord, ycord,
            tmecord, quantval, qualval, stnm);
      }

   } else {
      Trendeval.mixtrend_(true, 0, xcord, ycord, tmecord, quantval,
         qualval, 0, trend);
   }

   /* Compute the trend values and the gaussian residuals at each
      observation location. */

   resmean = 0.;
   for (i = 0; i < nd; ++i) {
      stnm = idtostnm[vardat_vrble[i] - 1];
      if (nmstmixcntr == 0) {
         vardat_trend[i] = Trendeval.trendfcn_(0, true, 0, vardat_x[i],
            vardat_y[i], vardat_t[i], vardat_quantval[i], vardat_qualval[i],
            stnm);

      } else {
         Trendeval.mixtrend_(true, 0, vardat_x[i], vardat_y[i],
            vardat_t[i], vardat_quantval[i], vardat_qualval[i],
            stnm, trendvals);
         vardat_trend[i] = trendvals[stnm - 1];
      }

      vardat_dat[i] = Trnsfrm.gaus_(stnm,
         (vardat_obs[i] - vardat_trend[i]));

      resmean += vardat_dat[i];
   }
   resmean /= rnd;

   // Form Sigma_{Z(x_0),Z(x_0)}.

   for (j = 0; j < parm_mvar; ++j) {
      for (i = 0; i < parm_mvar; ++i) {

         // Find covariance structure.

         if (i == j) {
            cvstrct = i + 1;
      
         } else {
            cvstrct = crossmap[j][i];
         }
 
         // Assign covariance.

         sigmazxzx[j][i] = Covmodl.covmodl_(1, 1, xcord, ycord,
            tmecord, xcord, ycord, tmecord, cvstrct);
      }
   }

   // Form Sigma_{Z(x_0),Z}.

   for (j = 0; j < parm_mvar; ++j) {
      stnmj = idtostnm[lomapnms[j] - 1];
      for (i = 0; i < nd; ++i) {
	 stnmi = idtostnm[vardat_vrble[i] - 1];
         if (stnmi == stnmj) {
            cvstrct = stnmi;
      
         } else {
            cvstrct = crossmap[stnmj - 1][stnmi - 1];
         }

         sigmazxz[j][i] = Covmodl.covmodl_(1, 2, vardat_x[i], vardat_y[i],
            vardat_t[i], xcord, ycord, tmecord, cvstrct);
      }
   }

   // Form Sigma_{ZZ}.

   for (i = 0; i < nd; ++i) {
      stnmi = idtostnm[vardat_vrble[i] - 1];
      for (j = 0; j <= i; ++j) {
	 stnmj = idtostnm[vardat_vrble[j] - 1];
         if (stnmi == stnmj) {
            cvstrct = stnmi;
	    
         } else {
            cvstrct = crossmap[stnmi - 1][stnmj - 1];
         }

         sigmazz[i][j] = Covmodl.covmodl_(i, j, vardat_x[i], vardat_y[i],
            vardat_t[i], vardat_x[j], vardat_y[j], vardat_t[j], cvstrct);

         if (i != j) sigmazz[j][i] = sigmazz[i][j];
      }

      // Check for singularity.

      if (i > 0) {
	 exactsg_(sigmazz, i, "mcpredict");
      }
   }
 
   /* Compute mean vector: sigmazxz * sigmazz^-1 * z.  Do this by solving
      the system   sigmazz * b = z and then computing   sigmazxz * b. */

   // First, decompose sigmazz.

   cond = Eqslv.decomp_(nd, sigmazz, ipvtzz, work);
   if (cond > condmx) {
      iderr_("mcpredict: cond= " + cond);
   }
}

// Load rhs vector and solve system.

for (i = 0; i < nd; ++i) {
   b[i] = vardat_dat[i];
}
Eqslv.solve_(nd, sigmazz, b, ipvtzz); 

// Compute meanvec = sigmazxz * b.

Matrix.mxv_(sigmazxz, b, meanvec, parm_mvar, nd);

if (start) {

   /* Next, compute covariance matrix:
      sigmazxzx - sigmazxz * sigmazz^-1 * sigmazxz'.
      Do this by solving the system sigmazz * sigmazxz'[.][i] = b_i
      for i = 1, ..., p and then computing   sigmazxzx - sigmazxz * b. */

   // Load dummy vector(s) for solution.

   for (j = 0; j < parm_mvar; ++j) {
      for (i = 0; i < nd; ++i) {
	 b[i] = sigmazxz[j][i];
      }

      // Back solve.

      Eqslv.solve_(nd, sigmazz, b, ipvtzz); 

      for (i = 0; i < nd; ++i) {
	 mat1[i][j] = b[i];
      }
   }

   // Compute covmat = sigmazxzx - sigmazxz * b.

   Matrix.mxm_(sigmazxz, mat1, mat2, parm_mvar, nd, parm_mvar);
   Matrix.mmm_(sigmazxzx, mat2, covmat, parm_mvar, parm_mvar);

   // Give up if any variances are negative.

   for (i = 0; i < parm_mvar; ++i) {
      if (covmat[i][i] < 0.) {
	 printf_("mcpredict: covmat= " + covmat[i][i]);
      }
   }

   // Find the Cholesky decomposition of covmat.

   if (Choles.choles_(covmat, sqrtmat, 1, parm_mvar, false) < 0.) {
      printf_("mcpredict: covmat not positive definite, ");
      
      if (varmod_model[nmmdls - 1] == 3) {
         printf_(" reducing cross-sill and trying again...");
         return -1;

      } else {
         printf_(" setting off-diagonal to zero.");
         for (i = 0; i < parm_mvar; ++i) {
            for (j = 0; j < parm_mvar; ++j) {
               if (i != j) {
                  sqrtmat[i][j] = 0.;
         
               } else {
                  if (covmat[i][j] < 1.e-3) {
                     printf_("covmat variance " + (i + 1) + "= " +
                        covmat[i][j]);
                     covmat[i][j] = 1.e-3;
                  }
                  sqrtmat[i][j] = Math.sqrt(covmat[i][j]);
               }
            }
         }
      }
   }
}

// Generate m Monte Carlo realizations of the conditional distribution.

for (i = 0; i < m; ++i) {
   index[i] = i + 1;

   // Generate a MVN(meanvec, covmat) realization.

   for (j = 0; j < parm_mvar; ++j) {
      stdnrms[j] = Rndm.stdnrm_(0);
   }

   for (j = 0; j < parm_mvar; ++j) {
      simpreds[i][j] = 0.;
      for (i1 = 0; i1 < parm_mvar; ++i1) {
         simpreds[i][j] += sqrtmat[j][i1] * stdnrms[i1];
      }
      simpreds[i][j] += meanvec[j];

      /* Back-transform this parm_mvar-variate realization to the
         original scale. */

      stnm = idtostnm[lomapnms[j] - 1];
      simpreds[i][j] = trend[stnm - 1] +
	               Trnsfrm.invgaus_(stnm, simpreds[i][j]);

      if (trnsfrm && simpreds[i][j] < 0.) {
         printf_("mcpredict: simpred= " + simpreds[i][j]);
      }
   }
}

/* Compute prediction: the trimmed mean of the simulated conditional
   realizations. */

if (start) {
   for (i = 0; i < parm_mvar; ++i) {
      nmsim[i] = m;
      if (!trnsfrm) {
         trimfrac[i] = .1;
      
      } else {
	 trimfrac[i] = .00; // was .03, use .01 for the simulation
      }
   }
}

Summry.summry_(false, 1, nmsim, parm_mvar, trimfrac, simpreds, meanvec,
   stderrvec, maxvec);

for (i = 0; i < parm_mvar; ++i) {
   pred[i] = meanvec[i];
}
return 0;
}

// ------------------------------------------------------------------------

public static int mcstderr_(double xcord, double ycord, double tmecord,
   double errvar[]) {

// Monte Carlo approximation of the plug-in standard error.

int cvstrct, i, i1, j, k, m = 60, stnm, stnmi, stnmj;

double retval;

// Add prediction location to the end of vardat.

for (i = nd; i < nd + parm_mvar; ++i) {
   vardat_vrble[i] = lomapnms[i - nd];
   vardat_x[i] = xcord;
   vardat_y[i] = ycord;
   vardat_t[i] = tmecord;
}

/* Form sigmafull = Sigma_{Z_1,...,Z_n,Z_0}.  Find the Cholesky
   decomposition of sigmafull.  Apply adjustments if the decomposition
   fails. */

for (k = 0; k < 4; ++k) {

   for (i = 0; i < nd + parm_mvar; ++i) {
      for (j = 0; j <= i; ++j) {
	 stnmi = idtostnm[vardat_vrble[i] - 1];
	 stnmj = idtostnm[vardat_vrble[j] - 1];
         if (vardat_vrble[i] == vardat_vrble[j]) {
            cvstrct = stnmi;
	    
         } else {
            cvstrct = crossmap[stnmi - 1][stnmj - 1];
         }

         form_a[i][j] = Covmodl.covmodl_(i, j, vardat_x[i], vardat_y[i],
            vardat_t[i], vardat_x[j], vardat_y[j], vardat_t[j], cvstrct);

         if (i != j) {
            form_a[j][i] = form_a[i][j];
         }
      }

      // Check for singularity.

      if (i > 0) {
         exactsg_(form_a, i, "mcstderr: form_a");
      }
   }

   retval = Choles.choles_(form_a, s, 1, nd + parm_mvar, false);
   if (retval < 0.) {
      printf_("mcstderr: sigmafull not pos. def., retval= " + retval);
      return -1;
 
   } else if (retval >= 0.) {
      break;
   }

   // Adjust covariogram matrix parameters depending on loop counter.

   if (k == 0) {
      for (i = 1; i < parm_mvar; ++i) {
         for (j = 0; j < i; ++j) {
            cvstrct = crossmap[i][j];
            printf_("mcstderr: fitted cross-sill= " +
               varmod_sill[0][cvstrct - 1]);
            printf_("setting cross-sills to 0");
            for (i1 = krnlstart; i1 <= krnlend; ++i1) {
               varmod_sill[i1][cvstrct - 1] = 0.;
            }
         }
      }

   } else if (k == 1) {
      for (i = 1; i < parm_mvar; ++i) {
         for (j = 0; j < i; ++j) {
            cvstrct = crossmap[i][j];

            if (varmod_model[cvstrct - 1] == 3) {
               iderr_("mcstderr: invalid nuggets");
            }
            printf_("mcstderr: fitted cross-nugget= " +
               varmod_nugget[0][cvstrct - 1]);
            printf_("setting cross-nuggets to 0");
            for (i1 = krnlstart; i1 <= krnlend; ++i1) {
               varmod_nugget[i1][cvstrct - 1] = 0.;
            }
         }
      }

   } else if (k == 2) {
      printf_("mcstderr: setting direct nuggets to sample variances" +
         " and direct sills to 0.");
      for (i = 0; i < parm_mvar; ++i) {
         printf_("mcstderr: LOMAP/GLOMAP Variable " + (i + 1) +
	    " smplvr= " + varmod_smplvr[i]);
         for (i1 = krnlstart; i1 <= krnlend; ++i1) {
            varmod_nugget[i1][i] = varmod_smplvr[i];
            varmod_sill[i1][i] = 0.;
         }
      }
 
   } else if (k > 2) {
      iderr_("mcstderr: cannot fix sigmafull");
   }
}

// Simulation loop.

for (i = 0; i < m; ++i) {

   /* Generate a realization on
      (Z_i(x_1), ... , Z_i(x_n), Z_i(x_0), ... , Z_i(x_0))', i.e., use
      the last p deviates to compute the realization of W at x_0 and
      the remaining deviates to compute the realization on whatever
      mix of variables and locations contained in vardat.  Store this
      realization in vardat_dat so that it can be passed to mcpredict_().
   */

   for (j = 0; j < nd + parm_mvar; ++j) {
      stdnrms[j] = Rndm.stdnrm_(0);
   }
   for (j = 0; j < nd + parm_mvar; ++j) {
      vardat_dat[j] = 0.;
      for (i1 = 0; i1 < nd + parm_mvar; ++i1) {
         vardat_dat[j] += s[j][i1] * stdnrms[i1];
      }
   }

   if (trnsfrm) {
   
      // Back-transform Z(x_0) to the "true" value on W(x_0).

      for (j = 0; j < parm_mvar; ++j) {
	 stnm = idtostnm[lomapnms[j] - 1];
         wx0[j] = trend[stnm - 1] +
	          Trnsfrm.invgaus_(stnm, vardat_dat[nd + j]);
      }

   } else if (!trnsfrm) {
      for (j = 0; j < parm_mvar; ++j) {
	 stnm = idtostnm[lomapnms[j] - 1];
         wx0[j] = trend[stnm - 1] + vardat_dat[nd + j];
      }
   }

   /* Using the parameters estimated from the actual data, compute
      a prediction of W(x_0) based on this simulated sample,
      Z_i(x_1), ... , Z_i(x_n).  It is assumed that mcpredict_() was
      called once before mcstderr_().
    
      Note that if the parameters were re-estimated with each
      simulated sample, the resulting standard error would incorporate
      parameter estimate uncertainty -- an advantage much-touted for
      Bayesian methods. */

   if (mcpredict_(false, xcord, ycord, tmecord, wx0hat) == -1) {
      iderr_("mcstderr: mcpredict = -1");
   }

   // Compute and store the residual.

   for (j = 0; j < parm_mvar; ++j) {
      simerrs[i][j] = wx0[j] - wx0hat[j];
      simwx0[i][j] = wx0[j];
      simwx0ht[i][j] = wx0hat[j];
   }
}

/*
Summry.summry_(false, 1, m, parm_mvar, trimfrac, simwx0, meanvec, stderrvec,
   maxvec);
printf_("Standard Deviation of wx0's= " + stderrvec[0]);
Summry.summry_(false, 3, m, parm_mvar, trimfrac, simwx0ht, meanvec, stderrvec,
   maxvec);
printf_("Standard Deviation of wx0hat's= " + stderrvec[0]);
*/

/* Compute standard deviation of these differences which is the desired
   standard error of prediction. */

for (i = 0; i < parm_mvar; ++i) {
   nmsim[i] = m;
   trimfrac[i] = .00;
}

Summry.summry_(false, 1, nmsim, parm_mvar, trimfrac, simerrs, meanvec,
   stderrvec, maxvec);

for (i = 0; i < parm_mvar; ++i) {
   errvar[i] = stderrvec[i] * stderrvec[i];
   if (errvar[i] < 1.e-20) {
      iderr_("mcstderr: zero error variance");
   }
}

// Find minimum length volume C.I..

/*
Idsort.idsort_(vol, index, 1, m);
nfrac = (int) Math.round(cilevel * (double) m);
for (i = 0; i < m - nfrac; ++i) {
   if (i + nfrac > m) break;
   cilength = vol[i + nfrac] - vol[i];
   if (cilength < minlength) {
      minlength = cilength;
      cilow = vol[i];
      cihigh = vol[i + nfrac];
   }
}

// Print C.I.

fprintf_(1, "Volume " + fdble_(100. * cilevel, 5, 1) + "% C.I.= ("
   + fdble_(cilow, 9, 3) + ", " + fdble_(cihigh, 9, 3) + ")");
*/

return 0;
}
}
