public class Mcce extends Surfcalcs {
static final int MAXPTS = 70;

static int hull[] = new int[MAXPTS];
static int inhull[] = new int[MAXPTS];

static double point[][] = new double[MAXPTS][2];
static double ellpsoid[][] = new double[MAXPTS][2];
static double temppts[][] = new double[MAXPTS][2];
static double hpoint[][] = new double[MAXPTS][2];
static double xval[] = new double[MAXPTS];
static double yval[] = new double[MAXPTS];
static double p0[] = new double[2];
static double p1[] = new double[2];
static double p2[] = new double[2];

// ----------------------------------------------------------------------

static void mcce_(String flename) {

/* Finds the least-area 95% confidence ellipsoid by searching all n = 60
   data sets with m = 3 observations removed. */

int m, n, n1, i, j, k, k1, i2, nmhpts = 0, nmhptsmin = 0;
double minarea, area;

fleopen_(2, flename, 'r');
n = 0;
for (;;) {
   if (checkeof_(2)) {
      break;
   }
   point[n][0] = fgetdble_(2);
   point[n][1] = fgetdble_(2);
   ++n;
}
fclose_(2, 'r');

m = 3;
minarea = 1.e30;
n1 = n; // Set to n for complete search.
for (i = 0; i < n1; ++i) {
   printf_("n1= " + n1 + " i= " + i);
   for (j = i + 1; j < n1; ++j) {
      for (k = j + 1; k < n1; ++k) {

	 /* Load the trial data set with this combination of observations
	    removed. */

         k1 = 0;
	 for (i2 = 0; i2 < n; ++i2) {
            if (i2 != i && i2 != j && i2 != k) {
	       temppts[k1][0] = point[i2][0];
	       temppts[k1][1] = point[i2][1];
	       ++k1;
	    }
         }

         nmhpts = jarvis_(k1, temppts, hpoint);
	 for (i2 = 0; i2 < nmhpts; ++i2) {
	    xval[i2] = hpoint[i2][0];
	    yval[i2] = hpoint[i2][1];
	 }
         area = polyarea_(nmhpts - 1, xval, yval);

         if (0. < area && area < minarea) {
	    nmhptsmin = nmhpts;
            for (i2 = 0; i2 < nmhptsmin; ++i2) {
               ellpsoid[i2][0] = hpoint[i2][0];
               ellpsoid[i2][1] = hpoint[i2][1];
            }
            minarea = area;
            printf_("i= " + i + " j= " + j + " k= " + k + " area= " + area);
	 }
      }
   }
}

// Write ellipsoid.

fleopen_(2, "ellpsoid.dat", 'w');
for (i = 0; i < nmhptsmin; ++i) {
   fprintf_(2, ellpsoid[i][0] + " " + ellpsoid[i][1]);
}
fclose_(2, 'w');

}

// --------------------------------------------------------------------- 

static double ptleft_(double p0[], double p1[], double p2[]) {
double det;

det =   p0[0] * (p1[1] * 1. - 1. * p2[1]);
det += -p1[0] * (p0[1] * 1. - 1. * p2[1]);
det +=  p2[0] * (p0[1] * 1. - 1. * p1[1]);

return det;
}

// ---------------------------------------------------------------------

static int jarvis_(int n, double point[][], double hpoint[][]) {

/* Jarvis' March algorithm for finding the convex hull of "points."  First,
   find least point. */

boolean allleft = false;

int i, j, k, l, hullpoint = 0;

double miny;

miny = point[0][1];
for (i = 0; i < n; ++i) {
   hull[i] = 0;
   inhull[i] = 0;
}

hull[0] = 0;
for (i = 1; i < n; ++i) {
   if (point[i][1] < miny) {
      miny = point[i][1];
      hull[0] = i;
   }
}

hpoint[0][0] = point[hull[0]][0];
hpoint[0][1] = point[hull[0]][1];
inhull[hull[0]] = 1;
k = 1;

// Find hull edges.

mloop: for (l = 0; l < n; ++l) {

   // Loop over all points.

   for (i = 0; i < n; ++i) {

      /* If this point is not already in the hull, check it for hull
	 membership. */

      if (inhull[i] == 0 || (k > 1 && i == hull[0])) {
         allleft = true;
	 for (j = 0; j < n; ++j) {
	    if (i != j) {
	       p0[0] = point[hull[k - 1]][0];
	       p0[1] = point[hull[k - 1]][1];

	       p1[0] = point[i][0];
	       p1[1] = point[i][1];

	       p2[0] = point[j][0];
	       p2[1] = point[j][1];
	       if (ptleft_(p0, p1, p2) < 0.) allleft = false;
            }
         }

	 // Add this point to the hull.

         if (allleft) {
	    hullpoint = i;
	    ++k;
	    hull[k - 1] = hullpoint;
	    inhull[i] = 1;
	    hpoint[k - 1][0] = point[i][0];
	    hpoint[k - 1][1] = point[i][1];
            if (k > 2 && hullpoint == hull[0]) {
	       break mloop;
	    }
         }
      }
   }
}

return k;
}

// ----------------------------------------------------------------------

static double polyarea_(int n, double xval[], double yval[]) {

/* Finds the area of the n-point polygon.  It is assumed that the first
   and last points are the same in the vectors "xval" and "yval."
   Therefore, these two vectors have (n + 1) components. */

int i;

double area;

area = 0.;
for (i = 0; i < n; ++i) {
   area += (xval[i] * yval[i + 1]) - (xval[i + 1] * yval[i]);
}
area *= .5;

return Math.abs(area);
}
}
