class Matchpairsdoc {

/* Because it is a .java file, this java source file will be backed-up
   along with all "id" source files.

   Definitions:
   Call an input action, input action actor, and input action subject an
   "in-combination," and an action-target combination an
   "out-combination." An input is an "m"-node combination of conditioning
   values stored in array "incomb," and the associated output is an
   action-target optimal decision that is stored in the array "outcomb."
   Call an in-combination, out-combination pair an "in-out pair."  Call
   nodes in the Situation subID that are parents of nodes in the Scenario
   subID "signal nodes."

   in-comb nodes:  condvals[0] = Time
                   condvals[1] = in-action
                   condvals[2] = in-actor
                   condvals[3] = in-subject
   
   out-comb nodes: condvals[4] = out-action
                   condvals[5] = target

   The classes Matchpairs.java and Promote.java modify the parameters of
   an ID so that "n" desired in-out pairs are matched.
   
   General Notes:
   1. In-out pairs are incompletely observed, only the out-combination
      is directly observed.

   2. IDs that have highly repeatable out-combinations can result in few
      different in-combinations.

   3. Example: If a Military Goal is threatened by the in-combination,
      a militaristic out-combination should be more favorable to the ID
      than a nonmilitaristic one.

               Actions history fitting Algorithm
	       ---------------------------------
   1. Fit the most frequent in-out pairs.
   2. If an observed action-target does not have an antecedent
   action-target, enter it into the IntIDs model "actions_" bulletin
   board.  Force these observed, isolated action-targets to be read
   and responded to within "readactions_" with priority over
   model-generated action-targets.
   3. The match rate should be the same as the maximum match rate.

   Justification For Step 2: Unobserved action-targets led to the
   isolated observed action-target.  The best estimate of the immediate
   consequence of the unobserved action-targets is the observed
   consequence: the observed, isolated action-target.

             Algorithm to Match 2 Different In-Out Pairs
	     -------------------------------------------
   Let A_i be the i^th Situation Goal node.
   
   Step 1. Maximize min(sum_i | P(A_i = satisfied | incomb1)
			  - P(A_i = satisfied | incomb2) | , .1).

   Step 2. Maximize E[OGA | incomb1, outcomb1)] subject to
           E[OGA | incomb1, outcomb1)] - E[OGA | incomb1, outcomb2) > .01.

           If this constraint is not met initially, first maximize
           -E[OGA | incomb1, outcomb2].

   Step 3. Maximize E[OGA | incomb2, outcomb2) subject to
           E[OGA | incomb2, outcomb2)] - E[OGA | incomb2, outcomb1) > .01.

           If this constraint is not met initially, first maximize
           -E[OGA | incomb2, outcomb1].

   NOTES:
   1. For all three of these optimizations, lower parts of the Situation
      and Scenario subnets contain general theory-based parameter values
      which means that the parameter values are the most solid and should
      be changed only if all else fails.  Upper parts of these subnets are
      most dependent on specific actions and targets so that there is lots
      of room for parameter adjustment.

   2. If all other out-combinations have been discounted, this is
      essentially a 2 out-combination problem.

   3. When Step 2's optimization reaches a feasible solution, that solution
      forces outcomb1 to be chosen when conditioned by incomb1.  Likewise
      for Step 3 and in-out pair 2.

   4. This algorithm is fast because it never calls "idsolve_."

   5. The 2 in-out pairs algorithm should be a generalization of a 1
      in-out pairs algorithm.

                     Alternative Algorithms
		     ----------------------
   Alternative #1:
   Enumerate all joint events in the ID that contain the in-out pair's
   conditioning node values.  The conditioning nodes consist of the
   in-combination nodes plus the out-combination nodes.  Make each of the
   associated joint probabilities larger by inflating the values of each
   of the consitutent parameters by a small amount.  After all such joint
   probabilities have been increased, when they are summed to find the
   marginal probability distribution of the OGA node, the mode of the OGA
   node will be close to 1.  This will lead to the out-combination being
   chosen as the optimal decision under the in-combination conditions.

   A joint event has a parameter associated with each node value in the
   event.  A parameter's value is increased if it defines the distribution
   of a node that is the child of a conditioning node or a Situation goal
   node and is associated with the desired conditioning node value or
   Situation goal value for that in-out pair.  All other joint
   probabilities are reduced so that the desired in-out pairs always
   dominated the ID's decision making.

   The Determ_Discrete nodes need exogenous theory to determine what
   values they should take on.  One such theory, used in "promotedemote_"
   is that larger values are better.

   Likewise, a discrete node in the Scenario subID that is a child
   of out-combination nodes has its distribution shifted to the right
   by the method "shiftdist_" only because doing so increases the
   probability of joint events that high OGA values.

   These exogenous facts do not hold for nodes in the Situation subID.

   Alternative #2:
   1. Verify that each in-combination results in a unique pattern of
      Situation Goal modes.  Such uniqueness must be achieved before
      proceeding to Scenario subID parameter modification because if
      the Situation Goal patterns are the same under the 2 different
      in-combinations, it will be difficult to find Scenario parameter
      values that result in 2 different optimal decisions under the 2
      different in-combinations.  To achieve this needed uniqueness, try
      the following:
   
      a. Give each "incomb" a theme, e.g. "conservation disaster" or an
         "economic windfall."  Use these themes to set Situation
	 Determ_Discrete node values that will result in signature
	 patterns of modal values on the Situation Goal nodes.

      b. Make the spread on the Situation Determ-Discrete nodes greater
         between the 2 different "in-comb" sets of the 2 in-out pairs.

   2. Consider the conditional distribution of a node that is a child of
      both a Situation Goal and the out-action node.  Say that this
      distribution's conditioning values are the modal value of the
      Situation Goal under "in-comb," and the desired out-action under
      this "in-comb."  Shift the parameters of this distribution so that
      the preferable values have high probability.  Symbolically:

      Let B be a node in the Scenario subID that has 1 parent
      that is a descendent of a signal node (called node D), and
      1 parent that is the out-action node (called node A).  Let the
      2 different in-combs be labeled i and j.  Let d_i, d_j be the
      different modal values on D produced by conditioning on incombs i
      and j, respectively.  Define a_i and a_j as the desired, different
      out-actions associated with in-combs i and j, respectively.
      Let l be an undesireable value of B and u be a desireable value
      of B.  Let MODE(B | D=d, A=a) be the mode of B conditional on
      D=d and A=a.  Set the parameters of B so that
      u = MODE(B | D=d_i, A=a_i) = MODE(B | D=d_j, A=a_j)
      and equal to l for all other combinations of d_. and a_..

      Say that node C has only node A as a parent.  Set parameters
      of this node that are associated with out-action i to values
      that improve the status of goals that have undesireable modal
      values under in-comb i in the Situation subID.  At the same
      time, set parameters of out-action j to values that do not
      improve these goals.
   
   Alternative #3:
   "matchpairs_" is given a "target" set of in-out pairs to match.  This
   set can come from a variety of sources including observations.  With
   observations, fit the "nminoutpairs" most-frequent in-out pair within
   each in-combination.  Do this by running the IntIDs model to fill-in
   the nodes that are not observed, e.g. "Herbivore Prevalence."  After
   the IDs have been fitted to these completed observed in-out pairs, run
   "actnsagree_" to assess agreement with the observed actions history.

   Alternative #4:
   Compute node correlation matrix and promote distributions that are
   positively correlated with OGA and demote distributions that are
   negatively correlated.
*/

// ---------------------------------------------------------------------

/* Documentation for Promote.java.

   This class modifies parameters in the Scenario subID so as to
   match the out-combination of the desired in-out pair.  This class also
   finds the inherited conditioning value of a node that has one of the
   conditioning nodes as a parent under this parent's conditioning value
   and promotes this conditional distribution.  This idea applies best
   to a Determ_Discrete node wherein once a value has been promoted, this
   value can be stored and whatever value in the child node that has high
   probability given the Determ_Discrete node's value is the "inherited"
   value.
*/
}
