class Loadvec extends Loadpar {

// ----------------------------------------------------------------------

static void loadvec_(double a[], double g[], double h[]) {

/* Load parameter vector with the initial values.  Also discover the
   number of covariogram matrix parameters (varmod_nmpars) and load
   constraint vectors. */

int i, j, k;

i = 0;
for (j = 0; j < parm_mvar; ++j) {

   // Load initial nugget and set lower and upper limits.

   // g[i] = llimit;
   // h[i] = 2. * varmod_smplvr[j];
   g[i] = 0.;
   h[i] = smallintrvl;
   if (Surf.simdat) h[i] = 2. * llimit;
   if (!spatial && temporal) h[i] = 1.5 * itnug[j];

   g[i] = 0.;

   if (spatial) {
      if (isnug[j] < g[i]) isnug[j] = g[i];
      if (isnug[j] > h[i]) isnug[j] = h[i];
      a[i] = isnug[j];
 
   } else {
      if (itnug[j] < g[i]) itnug[j] = g[i];
      if (itnug[j] > h[i]) itnug[j] = h[i];
      a[i] = itnug[j];
   }
   ++i;

   if (varmod_model[j] > 0) {

      // Load sill and set sill limits.

      g[i] = 1.e-2 * varmod_smplvr[j]; // was 1.e-2
      h[i] = 1.5 * varmod_smplvr[j];   // was 1.e1
      if (spatial) {
         if (issill[j] < g[i]) issill[j] = g[i];
         if (issill[j] > h[i]) issill[j] = h[i];
         a[i] = issill[j];
      
      } else {
         if (itsill[j] < g[i]) itsill[j] = g[i];
         if (itsill[j] > h[i]) itsill[j] = h[i];
         a[i] = itsill[j];
      }
      ++i;

      // Load range(s) and set limits.

      if (spatial) {
         g[i] = minlags;
         h[i] = minlags + .9 * varmod_rngelim;
         if (isrnge[j] < g[i]) isrnge[j] = g[i];
         if (isrnge[j] > h[i]) isrnge[j] = h[i];
         a[i] = isrnge[j];
         ++i;
      }
      if (temporal) {
         g[i] = minlagt;
         h[i] = minlagt + 3. * past;
         if (itrnge[j] < g[i]) itrnge[j] = g[i];
         if (itrnge[j] > h[i]) itrnge[j] = h[i];
         a[i] = itrnge[j];
         ++i;
         if (lngmem) {

            // Load long memory model and limits.

            a[i] = ilma[j];
            a[i + 1] = ilmb[j];
            a[i + 2] = ilmc[j];

            g[i] = llimit;
            h[i] = 1.e5;
            g[i + 1] = 1.;
            h[i + 1] = 1.e5;
            g[i + 2] = .1;
            h[i + 2] = .5;
            i += 3;
         }
      }
   }
}

// Cross-covariogram(s).

for (j = 1; j < parm_mvar; ++j) {
   for (k = 0; k < j; ++k) {
      d1 = j + 1;
      d2 = k + 1;
      cvstrct = crossmap[j][k];

      if (varmod_model[cvstrct - 1] < 3) {

         /* Symmetric cross-covariogram.  First, load nugget.  To ensure
            a feasible model, start all cross-nuggets at zero. */
    
         if (spatial) {
            g[i] = 0.;
            // h[i] = isnug[cvstrct - 1] + 2. * Math.abs(isnug[cvstrct - 1]);
            h[i] = smallintrvl;

            // 0-width bounds don't work in "optimiz_:"

	    h[i] = Math.max(h[i], smallintrvl);

            if (isnug[cvstrct - 1] < g[i]) isnug[cvstrct - 1] = g[i];
            if (isnug[cvstrct - 1] > h[i]) isnug[cvstrct - 1] = h[i];
            a[i] = isnug[cvstrct - 1];
         
         } else {
            g[i] = 0.;
	    h[i] = itnug[cvstrct - 1] + 2. * Math.abs(itnug[cvstrct - 1]);
	    h[i] = Math.max(h[i], smallintrvl);
 
	    if (itnug[cvstrct - 1] < g[i]) itnug[cvstrct - 1] = g[i];
	    if (itnug[cvstrct - 1] > h[i]) itnug[cvstrct - 1] = h[i];
            a[i] = itnug[cvstrct - 1];
         }
         ++i;
         
         if (varmod_model[cvstrct - 1] > 0) {
	    
            // Load sill and set limits.  Below, was 2. * Math...

            ulimit = 20. * Math.min(varmod_smplvr[j],
                                    varmod_smplvr[k]);
	    if (spatial) {
	       g[i] = 0.;
	       h[i] = ulimit;
	       h[i] = Math.max(h[i], smallintrvl);

	       if (issill[cvstrct - 1] < g[i]) issill[cvstrct - 1] = g[i];
	       if (issill[cvstrct - 1] > h[i]) issill[cvstrct - 1] = h[i];
	       a[i] = issill[cvstrct - 1];
         
	    } else {
	       g[i] = 0.;
	       h[i] = ulimit;
	       h[i] = Math.max(h[i], smallintrvl);

	       if (itsill[cvstrct - 1] < g[i]) itsill[cvstrct - 1] = g[i];
	       if (itsill[cvstrct - 1] > h[i]) itsill[cvstrct - 1] = h[i];
               a[i] = itsill[cvstrct - 1];
            }
            ++i;

	    // Load range(s) and set limits.

	    if (spatial) {
	       g[i] = minlags;
               h[i] = .95 * Math.min(isrnge[d1 - 1], isrnge[d2 - 1]);
	       h[i] = Math.max(h[i], g[i] + smallintrvl);
             
               if (isrnge[cvstrct - 1] < g[i]) isrnge[cvstrct - 1] = g[i];
               if (isrnge[cvstrct - 1] > h[i]) isrnge[cvstrct - 1] = h[i];
               a[i] = isrnge[cvstrct - 1];
               ++i;
            }

            if (temporal) {
               g[i] = 0.;
               h[i] = .95 * Math.min(itrnge[d1 - 1], itrnge[d2 - 1]);
	       h[i] = Math.max(h[i], smallintrvl);

               if (itrnge[cvstrct - 1] < g[i]) itrnge[cvstrct - 1] = g[i];
	       if (itrnge[cvstrct - 1] > h[i]) itrnge[cvstrct - 1] = h[i];
	       a[i] = itrnge[cvstrct - 1];
	       ++i;
            }
         }

      } else if (varmod_model[cvstrct - 1] == 3) {

         // Asymmetric cross-covariogram.

         // Even nugget.

         g[i] = llimit;
         h[i] = 1.e2 * itnug[cvstrct - 1];
         if (itnug[cvstrct - 1] < g[i]) itnug[cvstrct - 1] = g[i];
         if (itnug[cvstrct - 1] > h[i]) itnug[cvstrct - 1] = h[i];
         a[i] = itnug[cvstrct - 1];
         ++i;

         // Even sill.

         g[i] = .7 * Math.abs(itsill[cvstrct - 1]);
         h[i] = 2. * Math.abs(itsill[cvstrct - 1]);
         if (itsill[cvstrct - 1] < g[i]) itsill[cvstrct - 1] = g[i];
         if (itsill[cvstrct - 1] > h[i]) itsill[cvstrct - 1] = h[i];
         a[i] = .8 * itsill[cvstrct - 1];
         ++i;

         // Even range.

/*
         g[i] = .1 * lagt[0][1];
         h[i] = 1.e1 * lagt[0][kmaxt];
*/
         g[i] = .7 * itrnge[cvstrct - 1];
         h[i] = 2. * itrnge[cvstrct - 1];
         if (itrnge[cvstrct - 1] < g[i]) itrnge[cvstrct - 1] = g[i];
         if (itrnge[cvstrct - 1] > h[i]) itrnge[cvstrct - 1] = h[i];
         a[i] = itrnge[cvstrct - 1];
         ++i;

         // Odd nugget.

         g[i] = llimit;
         h[i] = 1.e2 * itoddnug[cvstrct - 1];
         if (itoddnug[cvstrct - 1] < g[i]) itoddnug[cvstrct - 1] = g[i];
         if (itoddnug[cvstrct - 1] > h[i]) itoddnug[cvstrct - 1] = h[i];
         a[i] = itoddnug[cvstrct - 1];
         ++i;

         // Odd sill.

         g[i] = -10. * Math.abs(itoddsill[cvstrct - 1]);
         h[i] = 10. * Math.abs(itoddsill[cvstrct - 1]);
         if (itoddsill[cvstrct - 1] < g[i]) itoddsill[cvstrct - 1] = g[i];
         if (itoddsill[cvstrct - 1] > h[i]) itoddsill[cvstrct - 1] = h[i];
         a[i] = .8 * itoddsill[cvstrct - 1];
         ++i;

         // Odd range.

         g[i] = .1 * lagt[0][1];
         h[i] = 1.e1 * lagt[0][kmaxt];

         if (itoddrnge[cvstrct - 1] < g[i]) itoddrnge[cvstrct - 1] = g[i];
         if (itoddrnge[cvstrct - 1] > h[i]) itoddrnge[cvstrct - 1] = h[i];
         a[i] = itoddrnge[cvstrct - 1];
         ++i;
      }
   }
}

// Covariance nonstationarity model.

if (covnonstatmdl == 1) {
   g[i] = 0.;
   h[i] = 10.;
   a[i] = varmod_nonstat[0];
   ++i;
   g[i] = -1.;
   h[i] = 1.;
   a[i] = varmod_nonstat[1];
   ++i;
   g[i] = -1.;
   h[i] = 1.;
   a[i] = varmod_nonstat[2];
   ++i;

} else if (covnonstatmdl == 2) {
}

varmod_nmpars = i;
if (varmod_nmpars > NMTTLPAR) iderr_("loadvec: varmod_nmpars too big");
if (test) {
   printf_("loadvec: parameter limits and initial values:");
   for (j = 0; j < varmod_nmpars; ++j) {
      printf_("j= " + j + " g= " + g[j] + " a= " + a[j] + " h= " + h[j]);
   }
}

// Load initial parameter values.

Loadpar.loadinit_(0);
if (test) {
   fprintf_(1,"\nLoadpar: Initial, Feasible Covariogram Matrix Model");
   prntinitl_();
}

/* Now that the number of covariogram matrix parameters are known, offset
   a[], g[], and h[] to provide room for the trend and transform
   parameters.  First, compute the offset value and the total number
   of parameters to be estimated. */

ttlnmpars = nmtrendpars + trnsfrm_nmpars + varmod_nmpars;
if (ttlnmpars > NMTTLPAR) iderr_("loadvec: ttlnmpars too big");

offset = nmtrendpars + trnsfrm_nmpars;

if (test) {
   printf_("loadvec: nmtrendpars= " + nmtrendpars +
           " trnsfrm_nmpars= " + trnsfrm_nmpars +
           " varmod_nmpars= " + varmod_nmpars +
           "\n   ttlnmpars= " + ttlnmpars + " offset= " + offset);
}

for (i = 0; i < varmod_nmpars; ++i) {
   duma[i] = a[i];
   dumg[i] = g[i];
   dumh[i] = h[i];
}

for (i = 0; i < varmod_nmpars; ++i) {
   a[offset + i] = duma[i];
   g[offset + i] = dumg[i];
   h[offset + i] = dumh[i];
}
}
}
