class Loadpar extends Surf {
static boolean test = false;
static int trylim = 10, offset = 0, mednm, cvstrct, d1, d2;
static double minlags, minlagt, minsrng, mintrng, ccoddmx, ccodlim, fractn,
   val, dumval, smplcrs, smallintrvl = 1.e-1; // was 1.e-3
static double llimit, ulimit;
static double isnug[] = new double[NUMMDLS];
static double itnug[] = new double[NUMMDLS];
static double itoddnug[] = new double[NUMMDLS];
static double issill[] = new double[NUMMDLS];
static double itsill[] = new double[NUMMDLS];
static double itoddsill[] = new double[NUMMDLS];
static double isrnge[] = new double[NUMMDLS];
static double itrnge[] = new double[NUMMDLS];
static double itoddrnge[] = new double[NUMMDLS];
static double ilma[] = new double[NUMMDLS];
static double ilmb[] = new double[NUMMDLS];
static double ilmc[] = new double[NUMMDLS];
static double meddat[] = new double[10];
static double incrmnt[] = new double[NMWRPAR];
static double duma[] = new double[NMTTLPAR];
static double dumg[] = new double[NMTTLPAR];
static double dumh[] = new double[NMTTLPAR];

// -----------------------------------------------------------------------

static int loadpar_(int option, int cntr, double a[], double g[],
   double h[]) {

/* Finds initial values and loads covariogram matrix parameter vector, a[]
   needed by either the Method of Moments estimator, varfit_() or the
   MD estimator, mdest_().
   Option values:
   1: initialize values and load into parameter vector and varmod.
   2: load initial values into varmod;
   3: load parameter vector into varmod
   4: load parameter vector into grdvar.
   5: Load parameter vector with current covariogram matrix parameter
      values.
*/

int i, j, k;

if (option == 1) {

   // Compute initial values.

   Initvals.initvals_();

   // Load initial values into optimization vector.

   Loadvec.loadvec_(a, g, h);

} else if (option == 2) {
   Loadpar.loadinit_(cntr);

} else if (option == 3) {

   // Figure out offset.

   if (cntr > 0) {
      offset = Estimate.begincov + (cntr - 1) * varmod_nmpars;
   }

   /* Load parameter vector values into varmod or stmix structure and
      enforce hard limits.  First, check for NaN's. */

   for (j = offset; j < offset + varmod_nmpars; ++j) {
      if (Double.isNaN(a[j])) {
         for (i = 0; i < ttlnmpars; ++i) {
            fprintf_(1, "i= " + i + " g= " + g[i] + " a= " + a[i] +
               " h= " + h[i]);
         }
	 iderr_("j= " + j + " isnan prob in loadpar");
      }
   }

   i = offset;

   for (j = 0; j < parm_mvar; ++j) {
      varmod_nugget[cntr][j] = a[i];
      varmod_sill[cntr][j]   = a[i + 1];
      i += 2;
      if (spatial) {
         varmod_range[cntr][0][j] = a[i];
         ++i;
      }
      if (temporal) {
         varmod_range[cntr][1][j] = a[i];
         ++i;
      
         if (lngmem) {
            varmod_lma[j] = a[i];
            varmod_lmb[j] = a[i + 1];
            varmod_lmc[j] = a[i + 2];
            i += 3;
         }
      }

      /* If a variable has zero model variance, set the nugget to that
         variable's sample variance and the sill to zero. */

      if (Covmodl.sttnrycov_(0., 0., j + 1) == 0.) {
         varmod_nugget[cntr][j] = varmod_smplvr[lomapnms[j] - 1];
         varmod_sill[cntr][j] = 0.;
      }
   }

   /* Load parameters for cross-covariogram(s) and adjust cross-range
      upper limits as functions of the associated direct-ranges. */

   for (j = 1; j < parm_mvar; ++j) {
      for (k = 0; k < j; ++k) {
         d1 = j + 1;
         d2 = k + 1;
         cvstrct = crossmap[j][k];
         varmod_nugget[cntr][cvstrct - 1] = a[i];

         ++i; 

         if (varmod_model[cvstrct - 1] > 0) {
            varmod_sill[cntr][cvstrct - 1] = a[i];
            ++i;

            if (spatial) {
               varmod_range[cntr][0][cvstrct - 1] = a[i];

	       /*
               // For a symmetric model, cross-range is always smaller than
               // the minimum of the associated direct-ranges.
               if (varmod_model[cvstrct - 1] != 3) {
                  h[i] = .99 * Math.min(varmod_range[cntr][0][d1 - 1],
                                        varmod_range[cntr][0][d2 - 1]);
                  if (h[i] < varmod_range[cntr][0][cvstrct - 1]) {
                     varmod_range[cntr][0][cvstrct - 1] = h[i];
                  }

                  // 0-width bounds don't work in "optimiz_:"
 
		  g[i] = Math.max(g[i], 0.);
                  if (h[i] - g[i] < smallintrvl) {
		     h[i] = g[i] + smallintrvl;
		  }
               }
	       */

               ++i;
            }

            if (temporal) {
               varmod_range[cntr][1][cvstrct - 1] = a[i];

	       /*
               // For a symmetric model, cross-range is always smaller than
               // the minimum of the associated direct-ranges.
               if (varmod_model[cvstrct - 1] != 3) {
                  h[i] = .99 * Math.min(varmod_range[cntr][1][d1 - 1],
                                        varmod_range[cntr][1][d2 - 1]);
                  if (h[i] < varmod_range[cntr][1][cvstrct - 1]) {
                     varmod_range[cntr][1][cvstrct - 1] = h[i];
                  }

                  if (h[i] - g[i] < smallintrvl) g[i] = h[i] - smallintrvl;
                  if (g[i] < 0.) g[i] = 0.;
               }
	       */

               ++i;
            }
         }

         if (varmod_model[cvstrct - 1] == 3) {

	    // Asymmetric: odd model.

            varmod_oddnug[cntr][cvstrct - 1] = a[i];
            varmod_oddsill[cntr][cvstrct - 1] = a[i + 1];
            varmod_oddrnge[cntr][cvstrct - 1] = a[i + 2];
            i += 3;
         }
      }
   }

   // Variance nonstationarity model.

   if (covnonstatmdl == 1) {
      varmod_nonstat[0] = a[i];
      varmod_nonstat[0] = a[i + 1];
      varmod_nonstat[0] = a[i + 2];
      i += 3;
   }

} else if (option == 4) {

   /* Place this model in the memory for later use in network optimization,
      Monte Carlo hypothesis testing, or GLOMAP estimation. */

   for (i = 0; i < nmmdls; ++i) {
      grdvar_nug[grow-1][gcol-1][jtime-1][i] = varmod_nugget[0][i]; 
      grdvar_sill[grow-1][gcol-1][jtime-1][i] = varmod_sill[0][i];
      if (spatial) {
         grdvar_rnge[grow-1][gcol-1][jtime-1][0][i] = varmod_range[0][0][i];
      }
      if (temporal) {
         grdvar_rnge[grow-1][gcol-1][jtime-1][1][i] = varmod_range[0][1][i];
      }
   }

   for (i = 0; i <= kmax; ++i) {
      grdvar_g[i] = gama_g[i][0][0][0];
   }

} else if (option == 5) {

   /* Load parameter vector with current covariogram matrix parameter
      values. */

   // Figure out offset.

   if (cntr > 0) {
      offset = Estimate.begincov + (cntr - 1) * varmod_nmpars;
   }

   i = offset;

   // Load direct covariogram parameters.

   for (j = 0; j < parm_mvar; ++j) {

      a[i] = varmod_nugget[cntr][j];
      ++i;

      if (varmod_model[j] != 0) {
         a[i] = varmod_sill[cntr][j];
         ++i;

         if (spatial) {
            a[i] = varmod_range[cntr][0][j];
            ++i;
         }
         if (temporal) {
            a[i] = varmod_range[cntr][1][j];
            ++i;
            if (lngmem) {
               a[i] = varmod_lma[j];
               a[i + 1] = varmod_lmb[j];
               a[i + 2] = varmod_lmc[j];
               i += 3;
            }
         }
      }
   }

   // Load cross-covariogram parameters.

   for (j = 1; j < parm_mvar; ++j) {
      for (k = 0; k < j; ++k) {
         cvstrct = crossmap[j][k];

         a[i] = varmod_nugget[cntr][cvstrct - 1];
         ++i;

         if (varmod_model[cvstrct - 1] > 0) {
            a[i] = varmod_sill[cntr][cvstrct - 1];
            ++i;

            if (spatial) {
               a[i] = varmod_range[cntr][0][cvstrct - 1];
               ++i;
            }
            if (temporal) {
               a[i] = varmod_range[cntr][1][cvstrct - 1];
               ++i;
            }
         }

         if (varmod_model[cvstrct - 1] == 3) {

	    // Asymmetric: odd component.

            a[i] = varmod_oddnug[cntr][cvstrct - 1];
            a[i + 1] = varmod_oddsill[cntr][cvstrct - 1];
            a[i + 2] = varmod_oddrnge[cntr][cvstrct - 1];
            i += 3;
         }
      }
   }
}

return offset;
}

// --------------------------------------------------------------------

static void loadinit_(int cntr) {

// Loads initial parameter values into varmod structure.

int i, j, cvstrct;

for (j = 0; j < parm_mvar; ++j) {
   if (spatial) {
      varmod_nugget[cntr][j] = isnug[j];
      varmod_sill[cntr][j] = issill[j];
      varmod_range[cntr][0][j] = isrnge[j];
      if (temporal) varmod_range[cntr][1][j] = itrnge[j];
   }

   if (temporal) {
      varmod_nugget[cntr][j] = itnug[j];
      varmod_sill[cntr][j] = itsill[j];
      varmod_range[cntr][1][j] = itrnge[j];

      if (lngmem) {
         varmod_lma[j] = ilma[j];
         varmod_lmb[j] = ilmb[j];
         varmod_lmc[j] = ilmc[j];
      }
   }
}

// Load initial cross-covariogram values.

for (i = 1; i < parm_mvar; ++i) {
   for (j = 0; j < i; ++j) {
      cvstrct = crossmap[i][j];

      if (varmod_model[cvstrct - 1] <= 3) {
         if (spatial) {
            varmod_nugget[cntr][cvstrct - 1] = isnug[cvstrct - 1];
         
         } else {
            varmod_nugget[cntr][cvstrct - 1] = itnug[cvstrct - 1];
         }
         if (varmod_model[cvstrct - 1] > 0) {
            if (spatial && !temporal) {
               varmod_sill[cntr][cvstrct - 1] = issill[cvstrct - 1];
               varmod_range[cntr][0][cvstrct - 1] = isrnge[cvstrct - 1];

            } else if (!spatial && temporal) {
               varmod_sill[cntr][cvstrct - 1] = itsill[cvstrct - 1];
               varmod_range[cntr][1][cvstrct - 1] = itrnge[cvstrct - 1];

            } else if (spatial && temporal) {
               varmod_sill[cntr][cvstrct - 1] = 0.;
               varmod_range[cntr][0][cvstrct - 1] = 0.;
            }
         }

         if (varmod_model[cvstrct - 1] == 3) {
            varmod_oddnug[cntr][cvstrct - 1] = itoddnug[cvstrct - 1];
            varmod_oddsill[cntr][cvstrct - 1] = itoddsill[cvstrct - 1];
            varmod_oddrnge[cntr][cvstrct - 1] = itoddrnge[cvstrct - 1];
         }

      } else if (varmod_model[cvstrct - 1] == 5) {
         /*
         varmod_nugget[cntr][cvstrct - 1] = itnug[cvstrct - 1];
         varmod_nugget[cntr][3] = itoddnug[cvstrct - 1];
         varmod_sill[cntr][cvstrct - 1] = itsill[cvstrct - 1];
         varmod_sill[cntr][3] = itoddsill[cvstrct - 1];
         varmod_range[cntr][0][cvstrct - 1] = itrnge[cvstrct - 1];
         varmod_range[cntr][0][3] = itoddrnge[cvstrct - 1];
         varmod_range[cntr][1][cvstrct - 1] = isrnge[cvstrct - 1];
         */
      }
   }
}
}

// --------------------------------------------------------------------

static double median_(int n, double dat[]) {
 
// Finds the median value of the first n values in array dat.
 
bubsrt_(n, dat);
if ((n - 1) / 2 == n / 2) {
   return dat[((n + 1) / 2) - 1];

} else {
   return .5 * (dat[(n / 2) - 1] + dat[n / 2]);
}
}

// --------------------------------------------------------------------

static void bubsrt_(int n, double dat[]) {
 
// Bubble sorts the array dat.
 
double dum;
int i, iflg;

L10:
do {
   iflg = 0;
   for (i = 1; i <= n-1; ++i) {
      if (dat[i-1] > dat[i]) {
         dum = dat[i];
         dat[i] = dat[i-1];
         dat[i-1] = dum;
         iflg = 1;
      }
   }
} while (iflg == 1);
}

// ---------------------------------------------------------------------

static void prntinitl_() {

// Print initial parameter values.

int i, j, cvstrct;

fprintf_(1, "----- Direct-Covariograms -----");
fprintf_(1, " Variable  Nugget   Sill   Spatial Range   Temporal Range");
for (j = 0; j < parm_mvar; ++j) {
   if (spatial) {
      fprintf_(1, lomapnms[j] + " " + fdble_(isnug[j], 9, 5) + " " +
         fdble_(issill[j], 9, 5) + " " + fdble_(isrnge[j], 9, 5) + " " +
         fdble_(itrnge[j], 9, 5));

   } else {
      fprintf_(1, lomapnms[j] + " " + fdble_(itnug[j], 9, 5) + " " +
        fdble_(itsill[j], 9, 5) + " " + fdble_(isrnge[j], 9, 5) + " " +
        fdble_(itrnge[j], 9, 5));
   }
   if (lngmem) {
      fprintf_(1, "   Long memory: lma= " + fdble_(ilma[j], 9, 5) +
         " lmb= " + fdble_(ilmb[j], 9, 5) + " lmc= " + fdble_(ilmc[j], 9, 5));
   }
}

if (parm_mvar == 1) return;

fprintf_(1, "----- Cross-Covariograms -----");
fprintf_(1,
   " Variable_1 Variable_2  Nugget   Sill   Spatial Range   Temporal Range");
for (i = 1; i < parm_mvar; ++i) {
   for (j = 0; j < i; ++j) {
      cvstrct = crossmap[i][j];
      if (spatial) {
         fprintf_(1, "   " + lomapnms[i] + "    " + lomapnms[j] + " " +
            fdble_(isnug[cvstrct - 1], 9, 5) + " " +
            fdble_(issill[cvstrct - 1], 9, 5) + " " +
            fdble_(isrnge[cvstrct - 1], 9, 5) + " " +
            fdble_(itrnge[cvstrct - 1], 9, 5));

      } else {
         fprintf_(1, lomapnms[i] + " " + lomapnms[j] + " " +
            fdble_(itnug[cvstrct - 1], 9, 5) + " " +
            fdble_(itsill[cvstrct - 1], 9, 5) + " " +
            fdble_(isrnge[cvstrct - 1], 9, 5) + " " +
            fdble_(itrnge[cvstrct - 1], 9, 5));
      }
      if (varmod_model[cvstrct - 1] == 3) {
         fprintf_(1, "Odd: " + fdble_(itoddnug[cvstrct - 1], 9, 5) + " " +
            fdble_(itoddsill[cvstrct - 1], 9, 5) + " " +
            fdble_(itoddrnge[cvstrct - 1], 9, 5));
      }
   }
}
}
}
