class Kmedcls extends Trendeval {

static int indx[] = new int[MAXN];
static int dumsort[] = new int[MAXN];
static int cluster[] = new int[MAXN];
static int medoidobj[] = new int[MAXCLS];

static double distmat[][] = new double[MAXN][MAXN];
static double v[] = new double[MAXN];
static double avedisssim[] = new double[MAXCLS];
static double disstomedoid[][] = new double[MAXCLS][MAXN];

// -------------------------------------------------------------------

static double kmedcontinvars_(int nmobjs, int nmprd, double prds[][],
   int nmclus, int clussol[][], int clussize[]) {

/* Performs K-Medoids clustering on continous predictor variables as
   implemented in Park and Jun (2009). */

int i, j;

double db = 0.;

if (nmclus > MAXCLS) {
   iderr_("kmedcls: nmclus= " + nmclus + " MAXCLS= " + MAXCLS);

} else if (nmobjs > MAXN) {
   iderr_("kmedcls: nmobjs>MAXN");
}

// Compute inter-object distance matrix.

for (i = 0; i < nmobjs; ++i) {
   for (j = 0; j < nmobjs; ++j) {
      distmat[i][j] = dist_(nmprd, prds[i], prds[j]);
   }
}

// Call actual clustering algorithm.

db = kmedcls_(nmobjs, nmclus, clussol, clussize);

return (db);
}

// -------------------------------------------------------------------

static double kmedphrases_(int nmobjs, String phrs[][], int nmwrds[],
   int nmclus, int clussol[][], int clussize[]) {

/* Performs K-Medoids clustering on phrases as implemented in
   Park and Jun (2009).  Returns the Davies-Bouldin index of clustering
   solution quality.  Lower values indicate higher quality. */

int i, j, k;

double db = 0.;

if (nmclus > MAXCLS) {
   iderr_("kmedphrases: nmclus= " + nmclus + " MAXCLS= " + MAXCLS);

} else if (nmobjs > MAXN) {
   iderr_("kmedphrases: nmobjs>MAXN");
}

// Compute inter-object distance matrix.

fleopen_(5,"distdat.dat",'w');
for (i = 0; i < nmobjs; ++i) {
   for (j = 0; j < nmobjs; ++j) {
      distmat[i][j] = 1. - Textutils.similar_(phrs[i], nmwrds[i],
         phrs[j], nmwrds[j]);

      /*
      if (distmat[i][j] < 1. && nmwrds[i] > 2 && i != j) {
         for (k = 0; k < nmwrds[i]; ++k) {
            printf_(phrs[i][k] + " " + phrs[j][k]);
	 }
	 printf_("dist= " + distmat[i][j] + "\n");
      }
      if (i < j) {
         fprintf_(5," " + distmat[i][j]);
      }
      */
   }
}
fclose_(5, 'w');

// Call actual clustering algorithm.

db = kmedcls_(nmobjs, nmclus, clussol, clussize);

return (db);
}

// -------------------------------------------------------------------

static double kmedcls_(int nmobjs, int nmclus, int clussol[][],
   int clussize[]) {

// Performs K-Medoids clustering as implemented in Park and Jun (2009).

int i, j, k, l, itmax = 100, iter;

double mindist, dist, lsum = 0., oldobjmedsum = 0., objmedsum = 0.,
   minsum = 0., interclussum = 0., concrit = 0., db = 0., dbval = 0.,
   dbratio = 0., maxratio = 0.;

if (nmclus > MAXCLS || nmclus > nmobjs) {
   iderr_("kmedcls: nmclus= " + nmclus + " MAXCLS= " + MAXCLS + " nmobjs= " +
      nmobjs);
}
if (nmobjs > MAXN) {
   iderr_("kmedcls: nmobjs>MAXN");
}

// Find initial cluster medoids.

for (j = 0; j < nmobjs; ++j) {
   v[j] = 0.;
   for (i = 0; i < nmobjs; ++i) {
      lsum = 0.;
      for (l = 0; l < nmobjs; ++l) {
         lsum += distmat[i][l];
      }
      v[j] += distmat[i][j] / lsum;
   }
   indx[j] = j + 1;
}

Idsort.idsort_(v, indx, 1, nmobjs);

for (i = 0; i < nmclus; ++i) {
   medoidobj[i] = indx[i];
}

// Compute initial cluster assignments.

for (i = 0; i < nmobjs; ++i) {
   mindist = 1.e6;
   for (j = 1; j <= nmclus; ++j) {
      dist = distmat[i][medoidobj[j - 1] - 1];
      if (dist < mindist || i == medoidobj[j - 1] - 1) {
         mindist = dist;
         cluster[i] = j;
      }
   }
   ++clussize[cluster[i] - 1];
}

// Check for zero cluster sizes and itmax exceedance.

for (i = 0; i < nmclus; ++i) {
   if (clussize[i] < 1) {
      iderr_("kmedcls1: i= " + i + " clussize=0");
   }
}

// Find the sum of objects-to-their-medoids.

oldobjmedsum = 0.;
for (i = 1; i <= nmclus; ++i) {
   for (j = 0; j < nmobjs; ++j) {
      if (cluster[j] != i) {
         continue;
      }
      oldobjmedsum += distmat[medoidobj[i - 1] - 1][j];
   }   
}

/* Clustering loop: continue to pass through the data until the sum of
   objects-to-their-medoids stops changing. */

iter = 0;
do {

   /* Find each cluster's new medioid object which is the cluster object
      that has the smallest sum of distances to all other cluster objects. */

   for (i = 1; i <= nmclus; ++i) {
      clussize[i - 1] = 0;
      minsum = 1.e6;
      for (j = 0; j < nmobjs; ++j) { // Loop over candidate medoid objects.
	 if (cluster[j] != i) {
            continue;
	 }
         interclussum = 0.;
         for (k = 0; k < nmobjs; ++k) { // Loop over all other cluster objects.
            if (cluster[k] != i) {
               continue;
	    }
	    interclussum += distmat[j][k];
	 }
         if (interclussum < minsum) {
            minsum = interclussum;
	    medoidobj[i - 1] = j + 1;
         }
      }
   }

   // Assign objects to clusters.

   for (i = 0; i < nmobjs; ++i) {
      mindist = 1.e6;
      for (j = 1; j <= nmclus; ++j) {
         dist = distmat[i][medoidobj[j - 1] - 1];
         if (dist < mindist || i == medoidobj[j - 1] - 1) {
            mindist = dist;
            cluster[i] = j;
         }
      }
      ++clussize[cluster[i] - 1];
   }

   // Check for zero cluster sizes and itmax exceedance.

   for (i = 0; i < nmclus; ++i) {
      if (clussize[i] < 1) {
         iderr_("kmedcls2: i= " + i + " clussize=0");
      }
   }

   // Store this solution and find the sum of objects-to-their-medoids.

   objmedsum = 0.;
   for (i = 1; i <= nmclus; ++i) {
      avedisssim[i - 1] = 0.;
      k = 0;
      for (j = 0; j < nmobjs; ++j) {
         if (cluster[j] != i) {
            continue;
         }
         disstomedoid[i - 1][k] = distmat[medoidobj[i - 1] - 1][j];
         objmedsum += disstomedoid[i - 1][k];
         avedisssim[i - 1] += disstomedoid[i - 1][k];
	 clussol[i - 1][k] = j + 1;
	 ++k;
      }   
      avedisssim[i - 1] /= ((double) clussize[i - 1]);
   }

   // Compute convergence criterion.

   concrit = Math.abs(objmedsum - oldobjmedsum) / oldobjmedsum;

   oldobjmedsum = objmedsum;
   ++iter;
} while (concrit > 1.e-4 && iter < itmax);

// Check for zero cluster sizes and itmax exceedance.

for (i = 0; i < nmclus; ++i) {
   if (clussize[i] < 1) {
      iderr_("kmedcls: i= " + i + " clussize=0");
   // printf_("kmedcls: clus= " + (i + 1) + " clussize= " + clussize[i] +
   //   " medoidobj= " + medoidobj[i]);
   }
}
if (iter >= itmax) {
   iderr_("kmedcls: hit itmax");

} else {
   // printf_("kmedcls: iter= " + iter);
}

// Compute the Davies-Bouldin index of clustering solution quality.

for (i = 1; i < nmclus; ++i) {
   maxratio = 0.;
   for (j = 0; j < nmclus; ++j) {
      if (j == i) {
         continue;
      }
      dbratio = distmat[medoidobj[i] - 1][medoidobj[j] - 1];
      if (dbratio > 0.) {
         dbratio = (avedisssim[i] + avedisssim[j]) / dbratio;
      }

      if (maxratio < dbratio) {
         maxratio = dbratio;
      }
   }
   db += maxratio;
}
db /= (double) nmclus;

if (db == 0.) {
   db = 1000.;
}

// Sort the solution by dissimilarity to the respective medoid.

for (i = 0; i < nmclus; ++i) {
   for (j = 0; j < clussize[i]; ++j) {
      dumsort[j] = clussol[i][j];
      indx[j] = j;
   }
   Idsort.idsort_(disstomedoid[i], indx, 1, clussize[i]);
   for (j = 0; j < clussize[i]; ++j) {
      clussol[i][j] = dumsort[indx[j]];
   }
}

return (db);
}

// ------------------------------------------------------------------

static double dist_(int nmprd, double x1[], double x2[]) {

// Returns the Euclidean distance between x1 and x2.

int i, nmwrdsx1 = 0, nmwrdsx2 = 0;

double dist, dif;

dist = 0.;
for (i = 0; i < nmprd; ++i) {
   dif = x1[i] - x2[i];
   dist += dif * dif;
}
dist = Math.sqrt(dist);

return dist;
}
}
