public class Interdict extends GISwind {

/* Interdiction patrol route tool.  Solves a Stackelberg game to
   find route recommendations. */

static boolean generate_routes = false, update = false;

static String strng = "none", bdryflenme, carcassflenme, obstargetflenme,
   attrtesflenme, intrrtesflenme, latlngbdryflenme = "none",
   genrtesflenme = "none";

static String featuretype[] = new String[Id.NMRTEPTS];

static int nmintrrtes = 0, nmtypes = 0, nmattrtes = 0, nmobstargets = 0,
   nmtargets = 0, nmrhino = 0, nmcarcasses = 0, nmfeatures = 0,
   starttimei = 0, endtimei = 0, nmsveattrtes;

static int nmattrtepts[] = new int[Id.NMRTES];
static int nmsveattrtepts[] = new int[Id.NMRTES];
static int rndmrte[] = new int[Id.NMRTES];
static int rte[] = new int[Id.NMRTES];
static int cmprrte[] = new int[Id.NMRTES];
static int nmintrrtepts[] = new int[Id.NMRTES];
static int nmthwrtrtes[] = new int[Id.NMRTES];
static int chosenattrte[] = new int[Id.NMTYPES];
static int thwartrte[][] = new int[Id.MAXTIMES][Id.NMRTEPTS];
static int index[] = new int[Id.NMRTEPTS];
static int nmmmbrs[] = new int[Id.NMTYPES];
static int clusmem[][] = new int[Id.NMTYPES][Id.NMRTES];

static double m, lng0 = 0., lat0 = 0., lngscle = 1., latscle = 1.,
   defendersensrange = 0., attackersensrange = 0., prbsum,
   map_unit_per_meter;

static double bdrypt[] = new double[2];
static double clstrcntr[][] = new double[Id.NMTYPES][2];
static double typepriorprb[] = new double[Id.NMTYPES];
static double entrypoint[][] = new double[Id.NMRTEPTS][2];
static double a[] = new double[Id.NMTYPES];
static double alpha[] = new double[Id.NMRTEPTS];
static double beta[] = new double[Id.NMRTEPTS];
static double boxx[] = new double[Id.NMRTES + 2];
static double xbest[] = new double[Id.NMRTES + 2];
static double g[] = new double[Id.NMRTES + 2];
static double h[] = new double[Id.NMRTES + 2];

static double attrte[][][] = new double[Id.NMRTES][Id.NMRTEPTS][2];
static double attrtetime[] = new double[Id.NMRTES];
static double sveattrte[][][] = new double[Id.NMRTES][Id.NMRTEPTS][2];
static double sveattrtetime[] = new double[Id.NMRTES];
static double attrtestrt[][] = new double[Id.NMRTES][2];

static double intrrteprb[] = new double[Id.NMRTES];
static double intrrte[][][] = new double[Id.NMRTES][Id.NMRTEPTS][2];
static double intrrtetime[] = new double[Id.NMRTES];

static double featureloc[][] = new double[Id.NMRTEPTS][2];
static double featuretime[] = new double[Id.NMRTEPTS];

static double obstargettime[] = new double[Id.NMRTEPTS];
static double obstarget[][] = new double[Id.NMRTEPTS][2];
static double target[][][] = new double[Id.MAXTIMES][Id.NMRTEPTS][2];
static double targettime[] = new double[Id.NMRTEPTS];

static double sortvec[] = new double[Id.NMRTEPTS];
static double carcassloc[][] = new double[Id.NMRTEPTS][2];
static double dummat[][] = new double[Id.NMRTEPTS][2];
static double shottime[] = new double[Id.MAXTIMES];
static double patroltime[] = new double[Id.MAXTIMES];

static double reward[][][] = new double[Id.NMTYPES][Id.NMRTES][Id.NMRTES];
static double cost[][][] = new double[Id.NMTYPES][Id.NMRTES][Id.NMRTES];

static double interdictdist[] = new double[Id.MAXTIMES];
static double cmprdist[] = new double[Id.MAXTIMES];

// ------------------------------------------------------------

static void interdictpatrol_() {

// Finds an interdiction patrol.

boolean assess = true;

int i, j, nmgenrtes, nmpatroltimes, bdryptindx = 0;

double solution_time = 0., timeinterval, lasttraintime = 0., mindist = 0.,
   dist = 0.;

/* Read shot and alive rhino space-time data sets.  The first data
   set is of poached rhinos (a.k.a. "carcasses"), and the second
   data set consists of space-time rhino sitings
   ("observed targets").

   Because this second data set is more the purvue of a reserve's
   scientific staff rather than the reserve's security staff, it
   does not seem likely that these two data sets will be
   maintained in the same database.  Hence here, they are read-in
   as separate files. */

Id.fleopen_(7, carcassflenme, 'r');
Id.fgetline_(7);
Id.fgetline_(7);
Id.fgetint_(7);
Id.fgetstrng_(7);
do {
   shottime[nmcarcasses] = Id.fgetdble_(7);
   carcassloc[nmcarcasses][0] = Id.fgetdble_(7);
   carcassloc[nmcarcasses][1] = Id.fgetdble_(7);
   ++nmcarcasses;
} while (!Id.checkeof_(7));
Id.fclose_(7, 'r');

Id.fleopen_(7, obstargetflenme, 'r');
Id.fgetline_(7);
Id.fgetline_(7);
Id.fgetint_(7);
Id.fgetstrng_(7);
do {
   obstargettime[nmobstargets] = Id.fgetdble_(7);
   obstarget[nmobstargets][0] = Id.fgetdble_(7);
   obstarget[nmobstargets][1] = Id.fgetdble_(7);
   ++nmobstargets;
} while (!Id.checkeof_(7));
Id.fclose_(7, 'r');

/* Read attacker routes and commander-specified potential interdiction
   patrol routes. */

nmsveattrtes = Interdictutils.readroutes_(attrtesflenme, "a", nmsveattrtepts,
               sveattrte, sveattrtetime);
nmintrrtes = Interdictutils.readroutes_(intrrtesflenme, "i", nmintrrtepts,
                intrrte, intrrtetime);

Id.printf_("interdictpatrol: nmcarcasses= " + nmcarcasses +
   " nmattrtes= " + nmsveattrtes + " nmintrrtes= " + nmintrrtes);

// Set sensor ranges to both be 1000 meters.

map_unit_per_meter = 9.96097447e-6;
defendersensrange = 1000. * map_unit_per_meter;
attackersensrange = 1000. * map_unit_per_meter;

if (assess) {

   // Set constants.

   nmtargets = nmobstargets;
   solution_time = 2016.0;

   /* Set the total number of patrol times.
      First, make sure the shot-times are sorted. */
  
   for (i = 0; i < nmcarcasses; ++i) {
      index[i] = i;
      sortvec[i] = shottime[i];
      dummat[i][0] = carcassloc[i][0];
      dummat[i][1] = carcassloc[i][1];
   }
   Idsort.idsort_(sortvec, index, 1, nmcarcasses);
   for (i = 0; i < nmcarcasses; ++i) {
      shottime[i] = sortvec[i];
      carcassloc[i][0] = dummat[index[i]][0];
      carcassloc[i][1] = dummat[index[i]][1];
   }

   patroltime[0] = shottime[0];
   // lasttraintime = .5 * (shottime[0] + shottime[nmcarcasses - 1]);
   lasttraintime = shottime[nmcarcasses - 1];

   /* Run a patrol every month (time units are in years, i.e.,
      1.0 = 1 year so 1/12 = 1 month). */

   timeinterval = 1. / 12.;

   for (i = 0; i < nmcarcasses; ++i) {
      patroltime[i] = (i * timeinterval) + patroltime[0];
      if (patroltime[i] >= shottime[nmcarcasses - 1]) {
         break;
      }
   }
   nmpatroltimes = i + 1;

} else {

   // Set constants.

   nmtargets = 100;
   nmpatroltimes = 1;
   solution_time = 2016.0;
   
   // Set patrol time(s).
  
   patroltime[0] = solution_time; 
}

/* Impute the locations of the reserve's rhinos at each time
   point.  Rhinos move according to an individual-based model of
   animal movement.  If a live animal is observed (called an
   "observed target"), the nearest simulated animal at the
   associated observed time is moved to that observed location
   and the simulation is continued from these new locations for
   the population.
   
   This method also reads-in the reserve's boundary points file. */

SMScalcs.impute_animal_locations_(nmobstargets, obstarget,
   obstargettime, nmpatroltimes, patroltime, nmtargets, target);

if (generate_routes) {

   /* Generate area-covering interdiction patrol routes.  After
      inspecting these routes, combine them with any
      commander-specified routes into one file, and re-run the
      "find_interdiction_patrol_route" relation to produce
      recommended interdiction patrol routes. */

   nmgenrtes = Routegen.routegen_(solution_time);

   /* Use the rhino location information to create rhino-shadowing
      interdiction patrol routes. */

   // Interdictutils.gen_shadow_routes_(solt);

   Id.fprintf_(1, "Number of Commander-generated routes= " + nmintrrtes +
      " Number of generated routes= " + nmgenrtes);
   
   return;
}

/* ----- Begin interdiction patrol route computation. ------ */

/* Specify number of attacker types, their prior probabilities, and
   their the locations that they prefer to enter the reserve on
   poaching raids ("entrypoint").  Make this latter compuations as
   follows.
   1. Perform a cluster analysis of attacker route entry points.
   2. The "entrypoint" for the i^th attacker type is the boundary point
      that is closest to the i^th cluster centroid. */

nmtypes = 5;
for (i = 0; i < nmtypes; ++i) {
   typepriorprb[i] = 1. / ((double) nmtypes);
   bdryptindx = (int) (((double) Id.bdry_nmbdpts[0]) *
      ((double) (i + 1)) / ((double) nmtypes));
   bdryptindx = Math.max(1, bdryptindx);
   bdryptindx = Math.min(Id.bdry_nmbdpts[0], bdryptindx);

   entrypoint[i][0] = Id.bdry_xbdry[0][bdryptindx - 1];
   entrypoint[i][1] = Id.bdry_ybdry[0][bdryptindx - 1];
}

// Specify initial values of interdiction patrol route probabilities.

for (i = 0; i < nmintrrtes; ++i) {
   intrrteprb[i] = 1. / ((double) nmintrrtes);
}

/* Specify values of utility parameters.  Relatively high alpha0
   value means attacker is afraid of being caught. */

alpha[0] = .49;
alpha[1] = .01;
alpha[2] = .50;

beta[0] = .99;
beta[1] = .01;

/* Optionally, assess the performance of the update-then-solve-game
   approach to identifying interdiction patrol routes. */

if (assess) {
   assess_(lasttraintime, nmpatroltimes);
   return;
}

/* Optionally, update the attackers' utility matrix before solving
   the game. */

if (update) {
   starttimei = 1;
   endtimei = nmpatroltimes;
   updateutilities_();

} else {
   patroltime[0] = solution_time;
}

solvegame_(starttimei, alpha);

Interdictutils.writeroute_(solution_time, lng0, lat0, lngscle, latscle);
}

// ---------------------------------------------------------

static void assess_(double lasttraintime, int nmpatroltimes) {

/* Assesses the performance of the update-then-solve-game approach to
   identifying interdiction patrol routes.  This is done in two
   steps:
   1. Update the follower's utility matrix using a training data set
      that consists of a set of poacher routes and a set of
      carcasses.
   2. Simulate how an anti-poaching force would use this tool by
      having the tool recommend a route every "patroltime" but with
      an update being executed two or more poaching events happen
      between patrol times.
 
   Performance is assessed during Step 2 by counting the number of
   times a recommended interdiction patrol route, when walked,
   results in the patrol having contact with a poaching party at
   their kill.  When such contact happens, the associated carcass
   is not removed from the carcass data set even though in reality,
   such contact might have resulted in the rhino not being killed.

   Such removals, being counterfactuals, are not simulated here due
   to their poorly-understood chances of happening, e.g. what
   percentage of the time does a successful interdiction patrol
   encounter the poaching party before the party shoots an animal?
   But to be consistent, the other counterfactual should be
   considered: the removal of the contacted poaching party from the
   landscape.  Again, assessing such a counterfactual is
   poorly-understood, e.g. what effect on the recruitment and
   experience of future poaching parties does the removal of a
   particular poaching party have?  Therefore, because the
   deliniation of the chances and effects of such counterfactuals
   is difficult to justify, we have chosen to avoid the simulation
   of them and hence simply assume that successful patrols do not
   alter the poaching event record nor remove contacted poaching
   parties from the landscape.
 
   The attackers' chosen route at each time point needs to usually be
   different because otherwise, the solution will place most of the
   probability on interdiction routes that cover this chosen route
   and hence will end up only protecting a small percentage of the
   area (and rhinos) over time.  This would not be a problem if
   rhinos were always poached at the same location over time.  But
   the data indicates that rhinos are poached through time over a
   large area. */

boolean contact = false;

int i, nmtraintimes = 0, nmcontacts = 0, nmpoachingevents = 0;

/* First, update the follower's utility matrix with a training data
   set. */

starttimei = 1;

do {
   ++nmtraintimes;
} while (patroltime[nmtraintimes] < lasttraintime);
endtimei = nmtraintimes;

updateutilities_();

/* Now, find a recommended patrol route at each "patroltime."  If two or
   more poaching events happen between "patroltime" values, update the
   follower's utility matrix before solving for an interdiction patrol
   route. */

starttimei = nmtraintimes + 1;
for (i = nmtraintimes + 1; i <= nmpatroltimes; ++i) {
   if (nmpoachingevents >= 2) {
      endtimei = i;
      updateutilities_();
   }
   solvegame_(i, alpha);

   /* Simulate the anti-poaching team actually walking this recommended
      interdiction patrol route.  Keep track of how many times rangers
      walking this route encounter a poaching party at their kill. */

   if (contact) {
      ++nmcontacts;
   }
}
Id.printf_("assess: nmcontacts= " + nmcontacts);
}

// ---------------------------------------------------------

static void updateutilities_() {

/* Updates the attackers' utility matrix by solving the NLP given by
   equation 7 in optrtes.tex. */

int i, ii, j, k, l, nmupdatevars;

double dist, timeinterval, leftmidpoint, rightmidpoint;

/* Define a "poaching event" as a carcass location and associated
   shooting time estimate.  Select interdiction patrol routes that
   would have stopped poaching events.  Do this as follows.  For each
   patrol time interval and route combination, search over all route
   segments for the route segment and poaching event that are
   spatially closest to each other.  The route that contains this
   segment is the "thwart route" for that time point.  Note that
   there may be no thwart route at a particular time point either
   because there was no poaching event in that time interval or no
   interdiction patrol route was spatially close enough to the carcass.
*/

for (i = starttimei; i <= endtimei; ++i) {
   nmthwrtrtes[i - 1] = 0;
   for (j = 0; j < nmintrrtes; ++j) {
      PTSLOOP: for (k = 0; k < nmintrrtepts[j] - 1; ++k) {
         for (l = 0; l < nmcarcasses; ++l) {

            /* Check if the shot-time of this carcass is close enough
	       to the patrol time being considered. */

            if (i == starttimei) {
               if ((shottime[l] - patroltime[starttimei - 1]) > 
                   (.5 * (patroltime[starttimei] -
			  patroltime[starttimei - 1]))) {
                  continue;
               }

	    } else if (i == endtimei) {
               if ((patroltime[endtimei - 1] - shottime[l]) >
                   (.5 * (patroltime[endtimei - 1] -
		          patroltime[endtimei - 2]))) {
                  continue;
               }

	    } else {
	       leftmidpoint = .5 * (patroltime[i] + patroltime[i - 1]);
	       rightmidpoint = .5 * (patroltime[i + 1] + patroltime[i]);
	       if (shottime[l] < leftmidpoint ||
                   rightmidpoint <= shottime[l]) {
                  continue;
	       }
	    }

            /* Compute the distance between a carcass location and a
	       a route segment. */

            dist = Interdictutils.distptline_(carcassloc[l], intrrte[j][k],
               intrrte[j][k + 1]);
            if (dist < defendersensrange) {
               thwartrte[i - 1][nmthwrtrtes[i - 1]] = j + 1;
	       ++nmthwrtrtes[i - 1];
	       break PTSLOOP;
            }
         }
      }
   }
}

/* Update the attackers' utility matrix, C by solving the NLP of
   equation 7 in "optrtes.tex."  Use Rndmsrch.java rather than Hooke
   and Jeeves because the latter is used to solve the m Stackelberg
   games at each evaluation of this method's objective function.

   The alpha vector holds the weights for the linear function that
   determines utility values to the attacker of different attacker routes. */

nmupdatevars = 3;

// Next, set parameter value limits before running the optimizer.

for (i = 0; i < nmupdatevars; ++i) {
   Rndmsrch.g[i] = .0001;
   Rndmsrch.h[i] = .9999;
}

// Run the random search optimization routine.

Optimiz.n = nmupdatevars;
Rndmsrch.rndmsrch_(3, alpha, .00001);

Id.printf_("updateutilities: alpha0= " + alpha[0] + " alpha1= " +
   alpha[1] + "\n   alpha2= " + alpha[2]);
}

// ---------------------------------------------------------

static double updateobjf_(int n, double point[]) {

/* Computes the objective function in the NLP update of the poachers'
   utility matrix. */

int i, j, k, l, tindx, nmopportunities = 0, nmcmpropps = 0, maxprbintrrte = 0;

double sum = 0., retval = 0., maxdist = 1., dist = 0., mindist = 0.,
   maxprb = 0., medinterdictdist = 0., medcmprdist = 0., objfcncomp = 0.;

// Convert the solution vector to normalized weights.

for (k = 0; k < n; ++k) {
   sum += point[k];
}
for (k = 0; k < n; ++k) {
   alpha[k] = point[k] / sum;
}

// Compute the objective function value.

for (i = 0; i < nmtypes; ++i) {
   rte[i] = 1;
   cmprrte[i] = 1;
}

for (tindx = starttimei; tindx <= endtimei; ++tindx) {
   for (i = 0; i < nmtypes; ++i) {
	      
      // Make the (i+1)^th attacker type the most probable.

      for (j = 0; j < nmtypes; ++j) {
         if (j == i) {
            typepriorprb[j] = .4;

         } else {
            typepriorprb[j] = .6 / ((double) (nmtypes - 1));
         }
      }

      // Solve the Stackelberg game at this patrol time.

      solvegame_(tindx, alpha);

      rte[i] = Rndm.discrte_(0, intrrteprb);
      
      maxprbintrrte = 0;
      maxprb = 0.;
      for (j = 0; j < nmintrrtes; ++j) {
         if (intrrteprb[j] > maxprb) {
            maxprbintrrte = j + 1;
            maxprb = intrrteprb[j];
         }
	 Id.printf_("j= " + (j + 1) + " intrrteprb= " + intrrteprb[j]);
      }
      Id.printf_("updateobjf: tindx= " + tindx + " type= " + (i + 1) +
         " maxprbintrrte= " + maxprbintrrte + " rte= " + rte[i] +
         " cmprrte= " + cmprrte[i]);
      Id.iderr_("in updateobjf");

      /* The interdiction patrol route selection strategy that
         the game-theoretic one is compared to is to send patrols
         in the direction of
         the most recent kill.  This is a standard strategy in
         anti-poaching work and is manifest in several forms most
         notably sending out a patrol in the direction of a gunshot.
         Here, for comparability, the same number of patrols, "nmtypes"
         is executed but now, those "nmtypes" interdiction patrol
         routes are walked that are closest to the most recent
         carcass.  Note that randomly selecting patrol routes is not a
         realistic comparison strategy because a real-world anti-poaching
         commander would not seriously consider such a strategy. */

      if (tindx < 2) {
	 cmprrte[i] = nmintrrtes / 2;
         continue;
      }
      mindist = 1.e10;
      for (j = 0; j < nmcarcasses; ++j) {
         if (patroltime[tindx - 2] < shottime[j] &&
            shottime[j] <= patroltime[tindx - 1]) {
            for (k = 0; k < nmintrrtes; ++k) {
               for (l = 0; l < nmintrrtepts[k] - 1; ++l) {
                  dist = Interdictutils.distptline_(carcassloc[j],
                     intrrte[k][l], intrrte[k][l + 1]);
                  if (dist < mindist) {
                     mindist = dist;
		     cmprrte[i] = k + 1;
                  }
               }
            }
         }
      }
   }

   // Form the sum of the thwart route probabilities.
   
   for (i = 0; i < nmthwrtrtes[tindx - 1]; ++i) {
      if (thwartrte[tindx - 1][i] > 0) {
         retval += intrrteprb[thwartrte[tindx - 1][i] - 1];
      }
   }

   // Find the smallest interdiction distance to next period's kills.
   
   if (tindx == endtimei) {
      continue;
   }
   mindist = 1.e10;
   for (j = 0; j < nmcarcasses; ++j) {
      if (patroltime[tindx - 1] < shottime[j] &&
          shottime[j] <= patroltime[tindx]) {
         for (i = 0; i < nmtypes; ++i) {
            for (k = 0; k < nmintrrtepts[rte[i] - 1] - 1; ++k) {
               dist = Interdictutils.distptline_(carcassloc[j],
                  intrrte[rte[i] - 1][k], intrrte[rte[i] - 1][k + 1]);
               if (dist < mindist) {
                  mindist = dist;
               }
            }
         }
         interdictdist[nmopportunities] = mindist;
         ++nmopportunities;
      }
   }

   /* Now, the smallest interdiction distance to next period's kills
      using the comparison strategy's interdiction patrol route
      distribution. */

   mindist = 1.e10;
   for (j = 0; j < nmcarcasses; ++j) {
      if (patroltime[tindx - 1] < shottime[j] &&
          shottime[j] <= patroltime[tindx]) {
         for (i = 0; i < nmtypes; ++i) {
            for (k = 0; k < nmintrrtepts[cmprrte[i] - 1] - 1; ++k) {
               dist = Interdictutils.distptline_(carcassloc[j],
                  intrrte[cmprrte[i] - 1][k], intrrte[cmprrte[i] - 1][k + 1]);
               if (dist < mindist) {
                  mindist = dist;
               }
            }
         }
         cmprdist[nmcmpropps] = mindist;
         ++nmcmpropps;
      }
   }
}

if (nmopportunities == 0) {
   Id.iderr_("updateobjf: nmopportunies=0");
}

if (nmcmpropps == 0) {
   Id.iderr_("updateobjf: nmcmpropps=0");
}

medinterdictdist = Loadpar.median_(nmopportunities, interdictdist);
medinterdictdist /= (1000. * map_unit_per_meter);
Id.printf_("updateobjf: medinterdictdist= " + medinterdictdist + " km" +
   "\n   thwart-route-prob-sum= " + retval + " nmopportunities= " +
   nmopportunities);

medcmprdist = Loadpar.median_(nmcmpropps, cmprdist);
medcmprdist /= (1000. * map_unit_per_meter);
Id.printf_("updateobjf: medcmprdist= " + medcmprdist + " km" +
   " nmcmpropps= " + nmcmpropps);

Id.iderr_("in updateobjf");
return retval;
}

// ---------------------------------------------------------

static void computeutilities_(int tindx, double alpha[]) {

/* Computes all utilities to the defender across the different types
   of followers (attackers).  */

int l, i, j;

double sum = 0.;

// Compute utility matrix entries.

for (l = 1; l <= nmtypes; ++l) {
   for (i = 0; i < nmintrrtes; ++i) {
      for (j = 0; j < nmattrtes; ++j) {
         reward[l - 1][i][j] = reward_(tindx, l, i, j);
	 cost[l - 1][i][j] = cost_(tindx, alpha, l, i, j);
      }
   }
}

/* Specify initial values of routes chosen by attacker types and the
   initial upper bounds on attacker utility sums. */

for (l = 0; l < nmtypes; ++l) {
   chosenattrte[l] = 0;

   /* Set the "a" value to the maximum reward this attacker type
      can obtain against this initial interdiction patrol route
      policy. */

   a[l] = 0.;
   for (j = 0; j < nmattrtes; ++j) {
      sum = 0.;
      for (i = 0; i < nmintrrtes; ++i) {
         sum += cost[l][i][j] * intrrteprb[i];
      }
      if (sum > a[l]) {
         a[l] = sum;
         chosenattrte[l] = j + 1;
      }

      if (chosenattrte[l] == 0) {

         for (i = 0; i < nmintrrtes; ++i) {
            Id.printf_("computeutilities: intrrte= " + (i + 1) +
               " cost= " + cost[l][i][j] + " prb= " + intrrteprb[i]);
         }
         Id.iderr_("computeutilities: j= " + j + " chosenattrte" + l +
            "=0");
      }
   }
}
}

// ----------------------------------------------------------

static double reward_(int tindx, int type, int i, int j) {

/* Compute the reward (utility) to the leader (defender) for
   implementing route (strategy) i against the follower's
   (attacker's) route (strategy) j. */

boolean crosschk;

int k, l;

double dist = 0., mindist = 0., nmcross = 0., nmclosetrgts = 0., contactscr,
   maxnmcross = 5., maxnmtrgts = nmobstargets, trgtsscr, reward, dens = 0.,
   maxdens = 0.;

/* Count the number of patrol route-attacker route crossings and the
   number of waypoint pairs that are within sensor radius. */

for (k = 0; k < nmintrrtepts[i] - 1; ++k) {
   for (l = 0; l < nmattrtepts[j] - 1; ++l) {
      crosschk = Interdictutils.cross_(intrrte[i][k][0], intrrte[i][k][1],
                        intrrte[i][k + 1][0], intrrte[i][k + 1][1],
                        attrte[j][l][0], attrte[j][l][1],
                        attrte[j][l + 1][0], attrte[j][l + 1][1]);
      if (crosschk) {
         nmcross += 1.;
	 crosschk = false;
      }

      dist = Clstr.dist_(2, intrrte[i][k], attrte[j][l]);
      if (dist < defendersensrange) {
         nmcross += 1.;
      }
   }
}

/* See if any targets are within sensor range of the defender's route.
for (k = 0; k < nmtargets; ++k) {
   mindist = 1.e20;
   for (l = 0; l < nmintrrtepts[i] - 1; ++l) {
      dist = Interdictutils.distptline_(target[tindx - 1][k], intrrte[i][l],
		         intrrte[i][l + 1]);
      if (dist < mindist) {
         mindist = dist;
      }
   }
   if (mindist < 5. * defendersensrange) {
      nmclosetrgts += 1.;
   }
}
*/

/* Compute the highest spatial point density of targets across all
   waypoints of this interdiction route. */

maxdens = 0.;
for (k = 0; k < nmintrrtepts[i] - 1; ++k) {
   dens = Interdictutils.spatialdensest_(nmtargets, target[tindx - 1],
          intrrte[i][k]);
   if (dens > maxdens) {
      maxdens = dens;
   }
}

/* The defender's priorities are:
   (1) crossing routes of attackers,
   (2) running interdiction patrol routes that take them close to
       many of the targets that they are defending.

   The "beta" values form a weighted average. */

contactscr = nmcross / maxnmcross;
contactscr *= contactscr;
trgtsscr = maxdens;
reward = beta[0] * contactscr + beta[1] * trgtsscr;
return reward;
}

// -----------------------------------------------------------

static double cost_(int tindx, double alpha[], int type, int i, int j) {

/* Compute the utility to the follower (cost to the leader since this
   is a zero-sum game) if the leader implements route (strategy) i
   against the follower's (attacker's) route (strategy) j.
*/

boolean crosschk;

int k, l, l1, bestrhino = -1;

double dist = 0., nmcross = 0., nmclosetrgts = 0., nmclosekills = 0.,
   evadescr, maxnmcross = nmintrrtes, maxnmtrgts = nmobstargets,
   maxkills = 5.,
   trgtsscr, killscr, trialscr = 0., borderscr = 0., cost, sum = 0.,
   maxdist = 0., mindist = 0., attmindist = 0., difx = 0., dify = 0.,
   dens = 0., maxdens = 0.;

/* See if this attack route crosses this interdiction patrol route.
INTRLOOP: for (k = 0; k < nmintrrtepts[i] - 1; ++k) {
   crosschk = false;
   for (l = 0; l < nmattrtepts[j] - 1; ++l) {
      crosschk = Interdictutils.cross_(intrrte[i][k][0], intrrte[i][k][1],
                        intrrte[i][k + 1][0], intrrte[i][k + 1][1],
                        attrte[j][l][0], attrte[j][l][1],
                        attrte[j][l + 1][0], attrte[j][l + 1][1]);
      if (crosschk) {
         nmcross += 1.;
	 break INTRLOOP;
      }
   }
}
*/

// Compute attacker route length.

evadescr = 0.;
/*
for (l = 0; l < nmattrtepts[j] - 1; ++l) {
   evadescr += Clstr.dist_(2, attrte[j][l], attrte[j][l + 1]);
}
evadescr = 10. / (evadescr + .001);
*/

/* See if any targets are within the attacker's sensor range along this
   j^th attacker route.
for (l = 0; l < nmtargets; ++l) {
   mindist = 1.e20;
   for (k = 0; k < nmattrtepts[j] - 1; ++k) {
      dist = Interdictutils.distptline_(target[tindx - 1][l], attrte[j][k],
		         attrte[j][k + 1]);
      if (dist < mindist) {
         mindist = dist;
      }
   }
   if (mindist < 5. * attackersensrange) { // was 5., 1. isn't very good
      nmclosetrgts += 1.;
   }
}
*/

/* Compute the highest spatial point density of targets across all
   waypoints of this attacker route. */

maxdens = 0.;
for (k = 0; k < nmattrtepts[j] - 1; ++k) {
   dens = Interdictutils.spatialdensest_(nmtargets, target[tindx - 1],
          attrte[j][k]);
   if (dens > maxdens) {
      maxdens = dens;
   }
}

/* Compute the smallest distance between this route and the kill two
   kills back. This dimension is suggested by looking at the
   sequence plot of shot times.  It may be that poachers return to
   a location only after killing at one distance location.
mindist = 1.e10;
if (tindx > 1) {
   for (l = 0; l < nmcarcasses; ++l) {
      if (patroltime[tindx - 2] <= shottime[l] &&
          shottime[l] < patroltime[tindx - 1]) {
	 l1 = Math.max(0, l - 1);
         for (k = 0; k < nmattrtepts[j] - 1; ++k) {
            dist = Interdictutils.distptline_(carcassloc[l1], attrte[j][k],
		               attrte[j][k + 1]);
            if (dist < mindist) {
               mindist = dist;
            }
         }
      }
   }

} else {
   mindist = 1.;
}
killscr = 1. - mindist;
*/

/* Every carcass was a live rhino (target) in the time interval
   preceding their shot-time.  Assume these targets do not move
   over this interval.  Compute the distance of such a live
   rhino to the border.  Poachers value targets more as their distance
   to the border decreases.  The value of "mindist" lies between 0
   and 1. */

killscr = 0.;
for (l = 0; l < nmcarcasses; ++l) {
   if (patroltime[tindx - 1] < shottime[l]) {

      /* See if this rhino is close to the attacker's route.  Exclude
         those rhinos that generated "carcass" attacker routes. */

      attmindist = 1.e30;
      for (k = 0; k < nmattrtepts[j] - 1; ++k) {
         dist = Clstr.dist_(2, carcassloc[l], attrte[j][k]);
         if (dist < attmindist) {
            attmindist = dist;
         }
      }

      if (attmindist > attackersensrange || attmindist < 1.e-6) {
         continue;
      }

      // Find this rhino's distance to the border.

      mindist = 1.e30;
      for (k = 0; k < Id.bdry_nmbdpts[0] - 1; ++k) {
         difx = carcassloc[l][0] - Id.bdry_xbdry[0][k];
         dify = carcassloc[l][1] - Id.bdry_ybdry[0][k];
         dist = Math.sqrt(difx * difx + dify * dify);
         if (dist < mindist) {
            mindist = dist;
         }
      }
      trialscr = 1. - mindist;
      if (trialscr > killscr) {
         killscr = trialscr;
	 bestrhino = l;
      }
   }
}

borderscr = 1. - Clstr.dist_(2, entrypoint[type - 1], attrte[j][0]);

/* Compute the maximum distance between the attacker route and the
   border.  Attackers prefer routes for which this distance is small.

   Attackers place high utility on a route that
   (1) has few crossings with the associated defender route,
   (2) is close to many targets, and
   (3) inexperienced attackers prefer short routes.

   The "alpha" values form a weighted average.

   The set of interdiction patrol routes is a proxy for the cost that
   attackers place on being detected.  Therefore, in the case where
   attackers are not aware of the grid of square interdiction
   patrol routes, the cost of crossing an interdiction patrol route
   can be viewed as the cost that attackers perceive of walking an
   attack route that exposes them to detection. */

evadescr = 1. - nmcross / maxnmcross;
trgtsscr = maxdens;

cost = alpha[0] * killscr + alpha[1] * trgtsscr + alpha[2] * borderscr;
return cost;
}

// ----------------------------------------------------------

static void solvegame_(int tindx, double alpha[]) {

/* Solves the Stackelberg leader-follower game for the optimal
   probability distribution over the set of potential interdiction
   patrol routes.  The integer part of the solution space consists
   of "nmtypes" variables, each taking on the discrete values,
   1, 2, ..., "nmattrtes." */

int i, n, nmimplicit = 1, nmiter;

double sum = 0.;

// First, randomly draw some number of attacker routes.

rndmattrtes_();

// Next, compute attacker and defender utility matrices.

computeutilities_(tindx, alpha);

/* The variable "m" is a fixed upper bound on "a[.]" and is set to the
   largest value that attacker utilities can take on. */

m = ((double) nmintrrtes) * 10.;

/* Maximize the Stackelberg game objective function at a fixed set of
   attacker routes, one route per attacker type.  This objective
   function is maximized subject to the problem's constraints.  The
   decision variables in this optimization problem is the vector of
   defender route probabilities.  Note that the "a" values -- one for
   each attacker type are functions of x. */

n = nmintrrtes;

/* Set initial solution and bounds.  (.4, .6) works when nmintrrtes= 2.
   But with a large number of interdiction patrol routes, it is better to
   start all routes at very low probabilities. */

for (i = 0; i < n; ++i) {
   boxx[i] = 1. / ((double) n);
   g[i] = .0001;
   Optimiz.g[i] = g[i];

   h[i] = .9999;
   Optimiz.h[i] = h[i];
}

// Stackelberg game implicit constraint limits.

Optimiz.gimplicit[0] = 0.;
Optimiz.himplicit[0] = 1.;

// Sum-to-one constraint on the "intrrteprb" distribution.

Optimiz.gimplicit[1] = .000001;
Optimiz.himplicit[1] = .999999;

// Dummy "vartype" values.

for (i = 0; i < n; ++i) {
   Pxp.vartype[i] = "Determ_Contin";
   Pxp.nodename[i] = "Interdict";
}

// Minimize the objective function.

Optimiz.n = n;
Optimiz.ci = nmimplicit;
Optimiz.fnm = 7;
nmiter = Hooke.hooke_(boxx, xbest, Optimiz.rhohooke, Optimiz.epsilon,
   Optimiz.maxhookeiter, true);

if (Optimiz.endopt) {
   Id.iderr_("solvegame: endopt=true");
}

/* Load this new best solution into the defender route probability
   distribution. */

sum = 0.;
for (i = 0; i < n; ++i) {
   sum += xbest[i];
}
if (sum < 1.e-6) {
   Id.iderr_("solvegame: sum= " + sum);
}
for (i = 0; i < n; ++i) {
   intrrteprb[i] = xbest[i] / sum;
}
return;
}

// ----------------------------------------------------------

static double stcklbrgobjf_(int n, double x[]) {

// Evaluates the Stackelberg game objective function.

int l, i, j;

double sum = 0., retval = 0.;

for (i = 0; i < nmintrrtes; ++i) {
   sum += x[i];
}
for (i = 0; i < nmintrrtes; ++i) {
   intrrteprb[i] = x[i] / sum;
}

for (l = 0; l < nmtypes; ++l) {
   for (i = 0; i < nmintrrtes; ++i) {
      for (j = 0; j < nmattrtes; ++j) {
         if ((j + 1) == chosenattrte[l]) {
            retval += typepriorprb[l] * reward[l][i][j] * intrrteprb[i];
	 }
      }
   }
}
return (retval);
}

// ----------------------------------------------------------

static double stcklbrgcnstrnts_(double point[]) {

/* Computes all constraints and returns the value -1. if any violations
   are found.  Otherwise, returns the value 1.0.

   Note that a valid probability distribution in "intrrteprb" is
   maintained by the combination of explicit and implicit constraints
   specified in "solvegame_()," above. */


int l, i, j;

double sum = 0., upperlimit = 0.;

// Load candidate solution point.

for (i = 0; i < nmintrrtes; ++i) {
   sum += point[i];
}
for (i = 0; i < nmintrrtes; ++i) {
   intrrteprb[i] = point[i] / sum;
}

/* Check for a valid relationship between costs, "a," and "m."
   First, find the attacker's optimal route and set the "a" value to
   the maximum reward this attacker type can obtain against the
   current interdiction patrol route policy ("intrrteprb"). */

for (l = 0; l < nmtypes; ++l) {
   chosenattrte[l] = 0;
   a[l] = 0.;
   for (j = 0; j < nmattrtes; ++j) {
      sum = 0.;
      for (i = 0; i < nmintrrtes; ++i) {
         sum += cost[l][i][j] * intrrteprb[i];
      }
      if (sum > a[l]) {
         a[l] = sum;
	 chosenattrte[l] = j + 1;
      }
   }
   if (chosenattrte[l] == 0) {
      Id.iderr_("cnstrnts: chosenattrte" + l + "=0");
   }
}

// Now, compute the constraints.
   
for (l = 0; l < nmtypes; ++l) {
   for (j = 0; j < nmattrtes; ++j) {
      if ((j + 1) == chosenattrte[l]) {
         upperlimit = 0.;

      } else {
         upperlimit = m;
      }
      sum = 0.;
      for (i = 0; i < nmintrrtes; ++i) {
         sum += cost[l][i][j] * intrrteprb[i];
      }
      sum = a[l] - sum;
      if (sum < 0. || sum > upperlimit) {
         return -1.;
      }
   }
}
return 1.;
}

// -------------------------------------------------------

static void rndmattrtes_() {

// Randomly samples m attacker routes.

int i, j, trialrte = 0, nmfound = 1, m = 20;

rndmrte[0] = Rndm.dscrtunif_(0, 1, nmsveattrtes);
MAINLOOP: for (i = 0; i < 1000; ++i) {
   trialrte = Rndm.dscrtunif_(0, 1, nmsveattrtes);
   for (j = 0; j < nmfound; ++j) {
      if (trialrte == rndmrte[j]) {
         continue MAINLOOP;

      } else {
	 rndmrte[nmfound] = trialrte;
	 ++nmfound;
	 break;
      }
   }
   if (nmfound == m) {
      break;
   }
}

if (nmfound < m) {
   Id.iderr_("rndmattrtes: nmfound= " + nmfound);
}

// Load these routes from attacker route storage.

nmattrtes = m;
for (i = 0; i < m; ++i) {
   nmattrtepts[i] = nmsveattrtepts[rndmrte[i] - 1];
   attrtetime[i] = sveattrtetime[rndmrte[i] - 1];
   for (j = 0; j < nmattrtepts[i]; ++j) {
      attrte[i][j][0] = sveattrte[rndmrte[i] - 1][j][0];
      attrte[i][j][1] = sveattrte[rndmrte[i] - 1][j][1];
   }
}
}

// -------------------------------------------------------

static void move_(int n, int x[], int xtrial[]) {

/* Move function for the Simulated Annealing search algorithm.  Each
   attacker type will implement exactly one route.  The function is:

      1. Randomly select an attacker type.
      2. For this selected attacker type, randomly select one of the
         attacker routes that is different than the one in "x" and
	 assign it to this attacker. */

int i, rtype, currentroute = 1, newroute = 1;

for (i = 0; i < n; ++i) {
   xtrial[i] = x[i];
}

rtype = Rndm.dscrtunif_(0, 1, nmtypes);
currentroute = x[rtype - 1];
newroute = currentroute;
for (i = 0; i < 100; ++i) {
   newroute = Rndm.dscrtunif_(0, 1, nmattrtes);
   if (newroute != currentroute) {
      break;
   }
}
xtrial[rtype - 1] = newroute; 
}
}
