class Initvals extends Loadpar {

//-------------------------------------------------------------------------

static void initvals_() {

/* Computes initial values.  First, compute hard limits on nuggets,
   sills, and ranges. */

boolean samesign;
int i, j, k, ksve = 0, cvstrct;

llimit = 1.e30;
ulimit = 0.;
for (i = 0; i < parm_mvar; ++i) {
   if (llimit > 1.e-4 * varmod_smplvr[i]) {
      llimit = 1.e-4 * varmod_smplvr[i];
   }
   if (ulimit < 1.e1 * varmod_smplvr[i]) {
      ulimit = 1.e1 * varmod_smplvr[i];
   }
}
if (spatial && temporal) ulimit = Math.sqrt(ulimit);

if (test) printf_("llimit= " + llimit + " ulimit= " + ulimit +
   " epsln= " + varmod_epsln);

minlags = 1.e-1 * varmod_epsln;
minlagt = 1.e-1;
if (test) printf_("minlags= " + minlags + " minlagt= " + minlagt);

// Set semivariogram sample size for median calculation.

if (spatial) mednm = 3;
else mednm = 1;

// Direct-covariogram starting values.

for (j = 0; j < parm_mvar; ++j) {
   
   // Nugget(s).

   if (!spatial && temporal) {
      isnug[j] = 0.;
      // itnug[j] = 1.e-3 * Math.sqrt(varmod_smplvr[j]);
      itnug[j] = 1.e-1 * Math.sqrt(varmod_smplvr[j]);

   } else if (spatial && !temporal) {
      i = 0;
      for (k = 0; k <= kmax; k++) {
         if (gama_g[k][0][0][j] != -1.e30) {
            meddat[i] = gama_g[k][0][0][j];
            ++i;
            if (i >= 9) iderr_("initvals: i too big");
            if (i == mednm) break;
         }
      }
      isnug[j] = .5 * median_(mednm,meddat); // was .5
      itnug[j] = 0.;

   } else if (spatial && temporal) {
      mednm = 4;
      meddat[0] = gama_g[0][0][0][j];
      meddat[1] = gama_g[0][0][1][j];
      meddat[2] = gama_g[1][0][0][j];
      meddat[3] = gama_g[1][0][1][j];
      for (i = 0; i < 4; ++i) {
         if (test) printf_("initvals: i= " + i + " med= " + meddat[i]);
         if (meddat[i] == -1.e30) meddat[i] = 0.;
      }
      isnug[j] = .5 * Math.sqrt(median_(mednm, meddat));
      itnug[j] = isnug[j];
   } 
   if (isnug[j] < 0.) isnug[j] = 0.;
   if (itnug[j] < 0.) itnug[j] = 0.;

   // Sill(s).

   if (spatial && !temporal) {
      issill[j] = varmod_smplvr[j] - isnug[j];
      itsill[j] = 0.;

   } else if (!spatial && temporal) {
      issill[j] = 0.;
      itsill[j] = 2. * (varmod_smplvr[j] - itnug[j]);

   } else if (spatial && temporal) {
      issill[j] = Math.sqrt(varmod_smplvr[j]);
      itsill[j] = issill[j];
   }
   if (issill[j] < 0.) issill[j] = 0.;
   if (itsill[j] < 0.) itsill[j] = 0.;

   // Range(s).

   isrnge[j] = 0.;
   itrnge[j] = 0.;
   if (spatial) isrnge[j] = lags[kmax - 1] / 2.0;
   if (isrnge[j] < 1.e-2) {
      isrnge[j] = .1 * varmod_rngelim;
   }
   if (temporal) {
      if (varmod_model[j] < 3) {
         itrnge[j] = .5 * lagt[0][kmaxt];

      } else {
         itrnge[j] = 2. * lagt[0][kmaxt];
      }
      if (lngmem) {
	 
         /* Initial long temporal memory model coefficients for variable
            (j + 1). */

         ilma[j] = .1 * varmod_smplvr[j];
         ilmb[j] = 1.;
         ilmc[j] = .25;
      }
   }
}

// Cross-covariogram(s).

for (i = 1; i < parm_mvar; ++i) {
   for (j = 0; j < i; ++j) {

      // Get direct- and cross-covariogram number.

      d1 = i + 1;
      d2 = j + 1;
      cvstrct = crossmap[i][j];

      if (varmod_model[cvstrct - 1] == 0) {

         // Nugget-only cross-covariogram.

         isnug[cvstrct - 1] = 0.;
         if (!spatial && temporal) {
            itnug[cvstrct - 1] = gama_g[0][0][kmaxt][cvstrct - 1];
         }
         issill[cvstrct - 1] = 0.;
         itsill[cvstrct - 1] = 0.;
         isrnge[cvstrct - 1] = 0.;
         itrnge[cvstrct - 1] = 0.;

      } else if (varmod_model[cvstrct - 1] < 3) {

         /* Symmetric cross-covariogram.  Set initial cross-nugget to a
            feasible value. */

         if (spatial && !temporal) {

            // Spatial-only.

            isnug[cvstrct - 1] =
               .1 * Math.sqrt(isnug[d1 - 1] * isnug[d2 - 1]);
            if (isnug[cvstrct - 1] < llimit) isnug[cvstrct - 1] = llimit;
            itnug[cvstrct - 1] = 0.;

            issill[cvstrct - 1] =
               .8 * Math.sqrt(issill[d1 - 1] * issill[d2 - 1]);
            // issill[cvstrct - 1] = 0.;
            itsill[cvstrct - 1] = 0.;

            /* A cross-range that is close t0 the direct-ranges results
               in maximum correlation. */

            isrnge[cvstrct - 1] =
               .9 * Math.min(isrnge[d1 - 1], isrnge[d2 - 1]); // was .5
            itrnge[cvstrct - 1] = 0.;

         } else if (!spatial && temporal) {

            // Temporal-only.

            isnug[cvstrct - 1] = 0.;
            itnug[cvstrct - 1] = 0.;

            issill[cvstrct - 1] = 0.;
            itsill[cvstrct - 1] = 
               .8 * Math.sqrt(itsill[d1 - 1] * itsill[d2 - 1]);

            isrnge[cvstrct - 1] = 0.;
            itrnge[cvstrct - 1] = Math.max(1.1 * past,
               .9 * Math.min(itrnge[d1 - 1], itrnge[d2 - 1]));

         } else if (spatial && temporal) {

            // Spatio-Temporal Analysis. (were .95)

            isnug[cvstrct - 1] =
               .05 * Math.sqrt(isnug[d1 - 1] * isnug[d2 - 1]);
            itnug[cvstrct - 1] =
               .05 * Math.sqrt(itnug[d1 - 1] * itnug[d2 - 1]);

            issill[cvstrct - 1] =
               .8 * Math.sqrt(issill[d1 - 1] * issill[d2 - 1]);
            itsill[cvstrct - 1] = issill[cvstrct - 1];

            isrnge[cvstrct - 1] =
               .9 * Math.min(isrnge[d1 - 1], isrnge[d2 - 1]);
            itrnge[cvstrct - 1] =
               .9 * Math.min(itrnge[d1 - 1], itrnge[d2 - 1]);
         }
         if (issill[cvstrct - 1] < 0.) issill[cvstrct - 1] = 0.;
         if (itsill[cvstrct - 1] < 0.) itsill[cvstrct - 1] = 0.;

      } else if (varmod_model[cvstrct - 1] == 3) {

         /* Asymmetric cross-covariogram (multivariate time series).

            First, set initial values for the even term of the
            cross-covariogram.

            Start even term's range at 4 * hzero where hzero is the
            lag at which the sample even covariogram either changes
            sign or, for a even covariogram of all the same sign,
            goes through a minimum.

            Start even sill at the lag zero sample even covariogram,
            gama_geven[0][0][kmaxt][cvstrct - 1] (since this is the
            even sill value at h = 0).
 
            Using this initial even sill value, start even nugget
            (the "a" parameter, see covmodl_()) at the average of the
            a-values over the first i positive lags for which the
            gamma value is positive using the equation:
            a = -lagt / ln[C_even(lagt) /
                (sill_even cos(2 Pi lagt / itrnge))]
            which is the even covariogram model solved for a.  */

         samesign = true;
         for (k = 0; k < kmaxt - 1; ++k) {
	    if ((gama_geven[0][0][k + kmaxt][cvstrct - 1] > 0. &&
	         gama_geven[0][0][k + 1 + kmaxt][cvstrct - 1] < 0.) ||

	        (gama_geven[0][0][k + kmaxt][cvstrct - 1] < 0. &&
	         gama_geven[0][0][k + 1 + kmaxt][cvstrct - 1] > 0.)) {
               samesign = false;
	       break;
	    }
	 }
	 if (k < 1) {
	    printf_("initvals: k= " + k + ", setting to 1");
	    k = 1;
	 }
         if (samesign) {
            for (k = 0; k < kmaxt - 1; ++k) {
               if (gama_geven[0][0][k + kmaxt][cvstrct - 1] <
                   gama_geven[0][0][k + 1 + kmaxt][cvstrct - 1]) {
                  break;
               }
            }
         }
         if (test) {
	    fprintf_(1, "initvals: k= " + k + " hzero= " +
               lagt[1][k + kmaxt]);
	 }

         // Set initial even ranges.

	 isrnge[cvstrct - 1] = 0.;
         itrnge[cvstrct - 1] = 2. * lagt[1][k + kmaxt]; // was 4.
	 if (itrnge[cvstrct - 1] < 1.e-6) itrnge[cvstrct - 1] = lagt[0][1];

         // Set initial even sills.

	 issill[cvstrct - 1] = 0.;
	 itsill[cvstrct - 1] = .5 * gama_geven[0][0][kmaxt][cvstrct - 1];
         if (itsill[cvstrct - 1] < 1.e-10) {
	    fprintf_(1, "initvals: itsill2= " + itsill[cvstrct - 1] +
               ", dumping gama:");
	    Covmodl.covprt_(0);
	 }

         // Set initial even nuggets.

	 isnug[cvstrct - 1] = 0.;
	 itnug[cvstrct - 1] = 0.;

	 for (k = 1; k < 2; ++k) {
            dumval = Math.abs(gama_geven[0][0][kmaxt + k][cvstrct - 1]) /
	             (Math.abs(itsill[cvstrct - 1]) *
	              Math.cos(2. * PI * lagt[1][kmaxt + i] /
                              itrnge[cvstrct - 1]));
	    if (dumval < 1.e-10) dumval = 1.e-10;
	    itnug[cvstrct - 1] += -lagt[1][kmaxt + k] / Math.log(dumval);
	 } 
         itnug[cvstrct - 1] /= ((double) (k + 1));

         /* Perhaps damping coefficients should be set to somewhere close
            to the basic lag?? */

         if (itnug[cvstrct - 1] < 1.e+0) {
            itnug[cvstrct - 1] = lagt[0][1];
         }

         /* Start odd term's range at 4 * hmax where ccoddmx = CC_o(hmax)
            is the maximum absolute value of the odd cross-covariogram
            over positive temporal lags.

         Let imax be the lag number of hmax.  Let h1 = lagt[0][imax - 2]
         and h2 = lagt[1][imax + 2].  Then it can be shown that
         a = (h2 - h1) / ln[C_odd(h1) / (C_odd(h2) K1 K2)] where
         K1 = cos((r/4 -h1)2Pi/r) and K2 = cos((r/4 - h2)2Pi/r).
         Use this result to start the odd nugget, "a."

         Start odd sill at ccoddmx /
                     exp(-hmax / itoddnug[cvstrct - 1]). */

         isrnge[cvstrct - 1] = 0.;
         itoddrnge[cvstrct - 1] = 0.;
         ccoddmx = 0.;
         for (k = 0; k <= kmaxt; ++k) {
            if (gama_godd[0][0][k + kmaxt][cvstrct - 1] != -1.e30 &&
	        Math.abs(ccoddmx) <
                Math.abs(gama_godd[0][0][k + kmaxt][cvstrct - 1])) {
	       ccoddmx = gama_godd[0][0][k + kmaxt][cvstrct - 1];
	       itoddrnge[cvstrct - 1] = 4. * lagt[0][k]; // was 4
	       ksve = k;
	    }
	 }

         // Validity checks.

         if (ccoddmx < 1.e-10) {
            fprintf_(1, "initvals: ccoddmx= " + ccoddmx + ", dumping gama");
            Covmodl.covprt_(0);
         }
         if (ksve < 1) iderr_("initvals: ksve= " + ksve + " < 1 (odd)");
         if (itoddrnge[cvstrct - 1] < 1.e-6) itoddrnge[cvstrct - 1] = 2.;

         // Use ksve to set initial odd nugget.

         itoddnug[cvstrct - 1] =
             gama_godd[0][0][ksve + kmaxt + 2][cvstrct - 1]
             * Math.cos((itoddrnge[cvstrct - 1] / 4. - lagt[0][ksve - 2])
             * 2. * PI / itoddrnge[cvstrct - 1])
             * Math.cos((itoddrnge[cvstrct - 1] / 4.
             - lagt[0][ksve + 2]) * 2. * PI / itoddrnge[cvstrct - 1]);

         if (itoddnug[cvstrct - 1] < 1.e-10) {
            itoddnug[cvstrct - 1] = 1.e-10;
         }

         itoddnug[cvstrct - 1] =
            gama_godd[0][0][ksve + kmaxt - 2][cvstrct - 1] /
                                 itoddnug[cvstrct - 1];
         if (itoddnug[cvstrct - 1] < 1.e-10) itoddnug[cvstrct - 1] = 1.e-10;

         itoddnug[cvstrct - 1] = Math.log(itoddnug[cvstrct - 1]);
         if (itoddnug[cvstrct - 1] < 1.e-10) itoddnug[cvstrct - 1] = 10.;

         itoddnug[cvstrct - 1] = (lagt[0][ksve + 2] - lagt[0][ksve - 2]) /
                                          itoddnug[cvstrct - 1];
         if (itoddnug[cvstrct - 1] < 1.e+0) {
            itoddnug[cvstrct - 1] = lagt[0][1]; // was 1.0
         }

         // Set initial odd sills.

         issill[cvstrct - 1] = 0.;
         itoddsill[cvstrct - 1] = .5 * ccoddmx /
            Math.exp(-(itoddrnge[cvstrct - 1] / 4.) /
            itoddnug[cvstrct - 1]);
 
         /* Check for a wild odd sill.
         smplcrs = Math.sqrt(varmod_smplvr[0] * varmod_smplvr[1]);
         if (itoddsill[cvstrct - 1] < -100. * smplcrs) {
            itoddsill[cvstrct - 1] = -smplcrs;
         }
         if (itoddsill[cvstrct - 1] > 100. * smplcrs) {
            itoddsill[cvstrct - 1] = smplcrs;
         }
         */

      } // End of different cross-covariogram models.
   }
}

// Covariance nonstationarity parameters.

if (covnonstatmdl == 1) {
   varmod_nonstat[0] = 1.;
   varmod_nonstat[1] = 0.;
   varmod_nonstat[2] = 0.;

} else if (covnonstatmdl == 2) {

   // Mixture model.
}

if (test) {
   fprintf_(1, "\nInitial values before feasibility checking");
   prntinitl_();
}

/* Place code to force zero cross-covariance, zero temporal covariance
   here. */
}
}
